/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.costexplorer.CostExplorerClient;
import software.amazon.awssdk.services.costexplorer.internal.UserAgentUtils;
import software.amazon.awssdk.services.costexplorer.model.AnalysisSummary;
import software.amazon.awssdk.services.costexplorer.model.ListCommitmentPurchaseAnalysesRequest;
import software.amazon.awssdk.services.costexplorer.model.ListCommitmentPurchaseAnalysesResponse;

public class ListCommitmentPurchaseAnalysesIterable
implements SdkIterable<ListCommitmentPurchaseAnalysesResponse> {
    private final CostExplorerClient client;
    private final ListCommitmentPurchaseAnalysesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListCommitmentPurchaseAnalysesIterable(CostExplorerClient client, ListCommitmentPurchaseAnalysesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListCommitmentPurchaseAnalysesResponseFetcher();
    }

    public Iterator<ListCommitmentPurchaseAnalysesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<AnalysisSummary> analysisSummaryList() {
        Function<ListCommitmentPurchaseAnalysesResponse, Iterator> getIterator = response -> {
            if (response != null && response.analysisSummaryList() != null) {
                return response.analysisSummaryList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListCommitmentPurchaseAnalysesResponseFetcher
    implements SyncPageFetcher<ListCommitmentPurchaseAnalysesResponse> {
        private ListCommitmentPurchaseAnalysesResponseFetcher() {
        }

        public boolean hasNextPage(ListCommitmentPurchaseAnalysesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextPageToken());
        }

        public ListCommitmentPurchaseAnalysesResponse nextPage(ListCommitmentPurchaseAnalysesResponse previousPage) {
            if (previousPage == null) {
                return ListCommitmentPurchaseAnalysesIterable.this.client.listCommitmentPurchaseAnalyses(ListCommitmentPurchaseAnalysesIterable.this.firstRequest);
            }
            return ListCommitmentPurchaseAnalysesIterable.this.client.listCommitmentPurchaseAnalyses((ListCommitmentPurchaseAnalysesRequest)((Object)ListCommitmentPurchaseAnalysesIterable.this.firstRequest.toBuilder().nextPageToken(previousPage.nextPageToken()).build()));
        }
    }
}

