/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum Granularity {
    DAILY("DAILY"),
    MONTHLY("MONTHLY"),
    HOURLY("HOURLY"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private Granularity(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static Granularity fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(Granularity.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<Granularity> knownValues() {
        return Stream.of(Granularity.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

