/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.costexplorer.model.ComparisonMetricValue;
import software.amazon.awssdk.services.costexplorer.model.ComparisonMetricsCopier;
import software.amazon.awssdk.services.costexplorer.model.CostDriver;
import software.amazon.awssdk.services.costexplorer.model.CostDriversCopier;
import software.amazon.awssdk.services.costexplorer.model.Expression;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CostComparisonDriver
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CostComparisonDriver> {
    private static final SdkField<Expression> COST_SELECTOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CostSelector").getter(CostComparisonDriver.getter(CostComparisonDriver::costSelector)).setter(CostComparisonDriver.setter(Builder::costSelector)).constructor(Expression::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CostSelector").build()}).build();
    private static final SdkField<Map<String, ComparisonMetricValue>> METRICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Metrics").getter(CostComparisonDriver.getter(CostComparisonDriver::metrics)).setter(CostComparisonDriver.setter(Builder::metrics)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Metrics").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ComparisonMetricValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<List<CostDriver>> COST_DRIVERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CostDrivers").getter(CostComparisonDriver.getter(CostComparisonDriver::costDrivers)).setter(CostComparisonDriver.setter(Builder::costDrivers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CostDrivers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CostDriver::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COST_SELECTOR_FIELD, METRICS_FIELD, COST_DRIVERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CostComparisonDriver.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Expression costSelector;
    private final Map<String, ComparisonMetricValue> metrics;
    private final List<CostDriver> costDrivers;

    private CostComparisonDriver(BuilderImpl builder) {
        this.costSelector = builder.costSelector;
        this.metrics = builder.metrics;
        this.costDrivers = builder.costDrivers;
    }

    public final Expression costSelector() {
        return this.costSelector;
    }

    public final boolean hasMetrics() {
        return this.metrics != null && !(this.metrics instanceof SdkAutoConstructMap);
    }

    public final Map<String, ComparisonMetricValue> metrics() {
        return this.metrics;
    }

    public final boolean hasCostDrivers() {
        return this.costDrivers != null && !(this.costDrivers instanceof SdkAutoConstructList);
    }

    public final List<CostDriver> costDrivers() {
        return this.costDrivers;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.costSelector());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMetrics() ? this.metrics() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCostDrivers() ? this.costDrivers() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CostComparisonDriver)) {
            return false;
        }
        CostComparisonDriver other = (CostComparisonDriver)obj;
        return Objects.equals(this.costSelector(), other.costSelector()) && this.hasMetrics() == other.hasMetrics() && Objects.equals(this.metrics(), other.metrics()) && this.hasCostDrivers() == other.hasCostDrivers() && Objects.equals(this.costDrivers(), other.costDrivers());
    }

    public final String toString() {
        return ToString.builder((String)"CostComparisonDriver").add("CostSelector", (Object)this.costSelector()).add("Metrics", this.hasMetrics() ? this.metrics() : null).add("CostDrivers", this.hasCostDrivers() ? this.costDrivers() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CostSelector": {
                return Optional.ofNullable(clazz.cast(this.costSelector()));
            }
            case "Metrics": {
                return Optional.ofNullable(clazz.cast(this.metrics()));
            }
            case "CostDrivers": {
                return Optional.ofNullable(clazz.cast(this.costDrivers()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("CostSelector", COST_SELECTOR_FIELD);
        map.put("Metrics", METRICS_FIELD);
        map.put("CostDrivers", COST_DRIVERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CostComparisonDriver, T> g) {
        return obj -> g.apply((CostComparisonDriver)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Expression costSelector;
        private Map<String, ComparisonMetricValue> metrics = DefaultSdkAutoConstructMap.getInstance();
        private List<CostDriver> costDrivers = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CostComparisonDriver model) {
            this.costSelector(model.costSelector);
            this.metrics(model.metrics);
            this.costDrivers(model.costDrivers);
        }

        public final Expression.Builder getCostSelector() {
            return this.costSelector != null ? this.costSelector.toBuilder() : null;
        }

        public final void setCostSelector(Expression.BuilderImpl costSelector) {
            this.costSelector = costSelector != null ? costSelector.build() : null;
        }

        @Override
        public final Builder costSelector(Expression costSelector) {
            this.costSelector = costSelector;
            return this;
        }

        public final Map<String, ComparisonMetricValue.Builder> getMetrics() {
            Map<String, ComparisonMetricValue.Builder> result = ComparisonMetricsCopier.copyToBuilder(this.metrics);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setMetrics(Map<String, ComparisonMetricValue.BuilderImpl> metrics) {
            this.metrics = ComparisonMetricsCopier.copyFromBuilder(metrics);
        }

        @Override
        public final Builder metrics(Map<String, ComparisonMetricValue> metrics) {
            this.metrics = ComparisonMetricsCopier.copy(metrics);
            return this;
        }

        public final List<CostDriver.Builder> getCostDrivers() {
            List<CostDriver.Builder> result = CostDriversCopier.copyToBuilder(this.costDrivers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCostDrivers(Collection<CostDriver.BuilderImpl> costDrivers) {
            this.costDrivers = CostDriversCopier.copyFromBuilder(costDrivers);
        }

        @Override
        public final Builder costDrivers(Collection<CostDriver> costDrivers) {
            this.costDrivers = CostDriversCopier.copy(costDrivers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder costDrivers(CostDriver ... costDrivers) {
            this.costDrivers(Arrays.asList(costDrivers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder costDrivers(Consumer<CostDriver.Builder> ... costDrivers) {
            this.costDrivers(Stream.of(costDrivers).map(c -> (CostDriver)((CostDriver.Builder)CostDriver.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public CostComparisonDriver build() {
            return new CostComparisonDriver(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CostComparisonDriver> {
        public Builder costSelector(Expression var1);

        default public Builder costSelector(Consumer<Expression.Builder> costSelector) {
            return this.costSelector((Expression)((Expression.Builder)Expression.builder().applyMutation(costSelector)).build());
        }

        public Builder metrics(Map<String, ComparisonMetricValue> var1);

        public Builder costDrivers(Collection<CostDriver> var1);

        public Builder costDrivers(CostDriver ... var1);

        public Builder costDrivers(Consumer<CostDriver.Builder> ... var1);
    }
}

