/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkProtocolMetadata;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.costexplorer.CostExplorerAsyncClient;
import software.amazon.awssdk.services.costexplorer.CostExplorerServiceClientConfiguration;
import software.amazon.awssdk.services.costexplorer.internal.CostExplorerServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.costexplorer.model.AnalysisNotFoundException;
import software.amazon.awssdk.services.costexplorer.model.BackfillLimitExceededException;
import software.amazon.awssdk.services.costexplorer.model.BillExpirationException;
import software.amazon.awssdk.services.costexplorer.model.CostExplorerException;
import software.amazon.awssdk.services.costexplorer.model.CreateAnomalyMonitorRequest;
import software.amazon.awssdk.services.costexplorer.model.CreateAnomalyMonitorResponse;
import software.amazon.awssdk.services.costexplorer.model.CreateAnomalySubscriptionRequest;
import software.amazon.awssdk.services.costexplorer.model.CreateAnomalySubscriptionResponse;
import software.amazon.awssdk.services.costexplorer.model.CreateCostCategoryDefinitionRequest;
import software.amazon.awssdk.services.costexplorer.model.CreateCostCategoryDefinitionResponse;
import software.amazon.awssdk.services.costexplorer.model.DataUnavailableException;
import software.amazon.awssdk.services.costexplorer.model.DeleteAnomalyMonitorRequest;
import software.amazon.awssdk.services.costexplorer.model.DeleteAnomalyMonitorResponse;
import software.amazon.awssdk.services.costexplorer.model.DeleteAnomalySubscriptionRequest;
import software.amazon.awssdk.services.costexplorer.model.DeleteAnomalySubscriptionResponse;
import software.amazon.awssdk.services.costexplorer.model.DeleteCostCategoryDefinitionRequest;
import software.amazon.awssdk.services.costexplorer.model.DeleteCostCategoryDefinitionResponse;
import software.amazon.awssdk.services.costexplorer.model.DescribeCostCategoryDefinitionRequest;
import software.amazon.awssdk.services.costexplorer.model.DescribeCostCategoryDefinitionResponse;
import software.amazon.awssdk.services.costexplorer.model.GenerationExistsException;
import software.amazon.awssdk.services.costexplorer.model.GetAnomaliesRequest;
import software.amazon.awssdk.services.costexplorer.model.GetAnomaliesResponse;
import software.amazon.awssdk.services.costexplorer.model.GetAnomalyMonitorsRequest;
import software.amazon.awssdk.services.costexplorer.model.GetAnomalyMonitorsResponse;
import software.amazon.awssdk.services.costexplorer.model.GetAnomalySubscriptionsRequest;
import software.amazon.awssdk.services.costexplorer.model.GetAnomalySubscriptionsResponse;
import software.amazon.awssdk.services.costexplorer.model.GetApproximateUsageRecordsRequest;
import software.amazon.awssdk.services.costexplorer.model.GetApproximateUsageRecordsResponse;
import software.amazon.awssdk.services.costexplorer.model.GetCommitmentPurchaseAnalysisRequest;
import software.amazon.awssdk.services.costexplorer.model.GetCommitmentPurchaseAnalysisResponse;
import software.amazon.awssdk.services.costexplorer.model.GetCostAndUsageRequest;
import software.amazon.awssdk.services.costexplorer.model.GetCostAndUsageResponse;
import software.amazon.awssdk.services.costexplorer.model.GetCostAndUsageWithResourcesRequest;
import software.amazon.awssdk.services.costexplorer.model.GetCostAndUsageWithResourcesResponse;
import software.amazon.awssdk.services.costexplorer.model.GetCostCategoriesRequest;
import software.amazon.awssdk.services.costexplorer.model.GetCostCategoriesResponse;
import software.amazon.awssdk.services.costexplorer.model.GetCostForecastRequest;
import software.amazon.awssdk.services.costexplorer.model.GetCostForecastResponse;
import software.amazon.awssdk.services.costexplorer.model.GetDimensionValuesRequest;
import software.amazon.awssdk.services.costexplorer.model.GetDimensionValuesResponse;
import software.amazon.awssdk.services.costexplorer.model.GetReservationCoverageRequest;
import software.amazon.awssdk.services.costexplorer.model.GetReservationCoverageResponse;
import software.amazon.awssdk.services.costexplorer.model.GetReservationPurchaseRecommendationRequest;
import software.amazon.awssdk.services.costexplorer.model.GetReservationPurchaseRecommendationResponse;
import software.amazon.awssdk.services.costexplorer.model.GetReservationUtilizationRequest;
import software.amazon.awssdk.services.costexplorer.model.GetReservationUtilizationResponse;
import software.amazon.awssdk.services.costexplorer.model.GetRightsizingRecommendationRequest;
import software.amazon.awssdk.services.costexplorer.model.GetRightsizingRecommendationResponse;
import software.amazon.awssdk.services.costexplorer.model.GetSavingsPlanPurchaseRecommendationDetailsRequest;
import software.amazon.awssdk.services.costexplorer.model.GetSavingsPlanPurchaseRecommendationDetailsResponse;
import software.amazon.awssdk.services.costexplorer.model.GetSavingsPlansCoverageRequest;
import software.amazon.awssdk.services.costexplorer.model.GetSavingsPlansCoverageResponse;
import software.amazon.awssdk.services.costexplorer.model.GetSavingsPlansPurchaseRecommendationRequest;
import software.amazon.awssdk.services.costexplorer.model.GetSavingsPlansPurchaseRecommendationResponse;
import software.amazon.awssdk.services.costexplorer.model.GetSavingsPlansUtilizationDetailsRequest;
import software.amazon.awssdk.services.costexplorer.model.GetSavingsPlansUtilizationDetailsResponse;
import software.amazon.awssdk.services.costexplorer.model.GetSavingsPlansUtilizationRequest;
import software.amazon.awssdk.services.costexplorer.model.GetSavingsPlansUtilizationResponse;
import software.amazon.awssdk.services.costexplorer.model.GetTagsRequest;
import software.amazon.awssdk.services.costexplorer.model.GetTagsResponse;
import software.amazon.awssdk.services.costexplorer.model.GetUsageForecastRequest;
import software.amazon.awssdk.services.costexplorer.model.GetUsageForecastResponse;
import software.amazon.awssdk.services.costexplorer.model.InvalidNextTokenException;
import software.amazon.awssdk.services.costexplorer.model.LimitExceededException;
import software.amazon.awssdk.services.costexplorer.model.ListCommitmentPurchaseAnalysesRequest;
import software.amazon.awssdk.services.costexplorer.model.ListCommitmentPurchaseAnalysesResponse;
import software.amazon.awssdk.services.costexplorer.model.ListCostAllocationTagBackfillHistoryRequest;
import software.amazon.awssdk.services.costexplorer.model.ListCostAllocationTagBackfillHistoryResponse;
import software.amazon.awssdk.services.costexplorer.model.ListCostAllocationTagsRequest;
import software.amazon.awssdk.services.costexplorer.model.ListCostAllocationTagsResponse;
import software.amazon.awssdk.services.costexplorer.model.ListCostCategoryDefinitionsRequest;
import software.amazon.awssdk.services.costexplorer.model.ListCostCategoryDefinitionsResponse;
import software.amazon.awssdk.services.costexplorer.model.ListSavingsPlansPurchaseRecommendationGenerationRequest;
import software.amazon.awssdk.services.costexplorer.model.ListSavingsPlansPurchaseRecommendationGenerationResponse;
import software.amazon.awssdk.services.costexplorer.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.costexplorer.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.costexplorer.model.ProvideAnomalyFeedbackRequest;
import software.amazon.awssdk.services.costexplorer.model.ProvideAnomalyFeedbackResponse;
import software.amazon.awssdk.services.costexplorer.model.RequestChangedException;
import software.amazon.awssdk.services.costexplorer.model.ResourceNotFoundException;
import software.amazon.awssdk.services.costexplorer.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.costexplorer.model.StartCommitmentPurchaseAnalysisRequest;
import software.amazon.awssdk.services.costexplorer.model.StartCommitmentPurchaseAnalysisResponse;
import software.amazon.awssdk.services.costexplorer.model.StartCostAllocationTagBackfillRequest;
import software.amazon.awssdk.services.costexplorer.model.StartCostAllocationTagBackfillResponse;
import software.amazon.awssdk.services.costexplorer.model.StartSavingsPlansPurchaseRecommendationGenerationRequest;
import software.amazon.awssdk.services.costexplorer.model.StartSavingsPlansPurchaseRecommendationGenerationResponse;
import software.amazon.awssdk.services.costexplorer.model.TagResourceRequest;
import software.amazon.awssdk.services.costexplorer.model.TagResourceResponse;
import software.amazon.awssdk.services.costexplorer.model.TooManyTagsException;
import software.amazon.awssdk.services.costexplorer.model.UnknownMonitorException;
import software.amazon.awssdk.services.costexplorer.model.UnknownSubscriptionException;
import software.amazon.awssdk.services.costexplorer.model.UnresolvableUsageUnitException;
import software.amazon.awssdk.services.costexplorer.model.UntagResourceRequest;
import software.amazon.awssdk.services.costexplorer.model.UntagResourceResponse;
import software.amazon.awssdk.services.costexplorer.model.UpdateAnomalyMonitorRequest;
import software.amazon.awssdk.services.costexplorer.model.UpdateAnomalyMonitorResponse;
import software.amazon.awssdk.services.costexplorer.model.UpdateAnomalySubscriptionRequest;
import software.amazon.awssdk.services.costexplorer.model.UpdateAnomalySubscriptionResponse;
import software.amazon.awssdk.services.costexplorer.model.UpdateCostAllocationTagsStatusRequest;
import software.amazon.awssdk.services.costexplorer.model.UpdateCostAllocationTagsStatusResponse;
import software.amazon.awssdk.services.costexplorer.model.UpdateCostCategoryDefinitionRequest;
import software.amazon.awssdk.services.costexplorer.model.UpdateCostCategoryDefinitionResponse;
import software.amazon.awssdk.services.costexplorer.transform.CreateAnomalyMonitorRequestMarshaller;
import software.amazon.awssdk.services.costexplorer.transform.CreateAnomalySubscriptionRequestMarshaller;
import software.amazon.awssdk.services.costexplorer.transform.CreateCostCategoryDefinitionRequestMarshaller;
import software.amazon.awssdk.services.costexplorer.transform.DeleteAnomalyMonitorRequestMarshaller;
import software.amazon.awssdk.services.costexplorer.transform.DeleteAnomalySubscriptionRequestMarshaller;
import software.amazon.awssdk.services.costexplorer.transform.DeleteCostCategoryDefinitionRequestMarshaller;
import software.amazon.awssdk.services.costexplorer.transform.DescribeCostCategoryDefinitionRequestMarshaller;
import software.amazon.awssdk.services.costexplorer.transform.GetAnomaliesRequestMarshaller;
import software.amazon.awssdk.services.costexplorer.transform.GetAnomalyMonitorsRequestMarshaller;
import software.amazon.awssdk.services.costexplorer.transform.GetAnomalySubscriptionsRequestMarshaller;
import software.amazon.awssdk.services.costexplorer.transform.GetApproximateUsageRecordsRequestMarshaller;
import software.amazon.awssdk.services.costexplorer.transform.GetCommitmentPurchaseAnalysisRequestMarshaller;
import software.amazon.awssdk.services.costexplorer.transform.GetCostAndUsageRequestMarshaller;
import software.amazon.awssdk.services.costexplorer.transform.GetCostAndUsageWithResourcesRequestMarshaller;
import software.amazon.awssdk.services.costexplorer.transform.GetCostCategoriesRequestMarshaller;
import software.amazon.awssdk.services.costexplorer.transform.GetCostForecastRequestMarshaller;
import software.amazon.awssdk.services.costexplorer.transform.GetDimensionValuesRequestMarshaller;
import software.amazon.awssdk.services.costexplorer.transform.GetReservationCoverageRequestMarshaller;
import software.amazon.awssdk.services.costexplorer.transform.GetReservationPurchaseRecommendationRequestMarshaller;
import software.amazon.awssdk.services.costexplorer.transform.GetReservationUtilizationRequestMarshaller;
import software.amazon.awssdk.services.costexplorer.transform.GetRightsizingRecommendationRequestMarshaller;
import software.amazon.awssdk.services.costexplorer.transform.GetSavingsPlanPurchaseRecommendationDetailsRequestMarshaller;
import software.amazon.awssdk.services.costexplorer.transform.GetSavingsPlansCoverageRequestMarshaller;
import software.amazon.awssdk.services.costexplorer.transform.GetSavingsPlansPurchaseRecommendationRequestMarshaller;
import software.amazon.awssdk.services.costexplorer.transform.GetSavingsPlansUtilizationDetailsRequestMarshaller;
import software.amazon.awssdk.services.costexplorer.transform.GetSavingsPlansUtilizationRequestMarshaller;
import software.amazon.awssdk.services.costexplorer.transform.GetTagsRequestMarshaller;
import software.amazon.awssdk.services.costexplorer.transform.GetUsageForecastRequestMarshaller;
import software.amazon.awssdk.services.costexplorer.transform.ListCommitmentPurchaseAnalysesRequestMarshaller;
import software.amazon.awssdk.services.costexplorer.transform.ListCostAllocationTagBackfillHistoryRequestMarshaller;
import software.amazon.awssdk.services.costexplorer.transform.ListCostAllocationTagsRequestMarshaller;
import software.amazon.awssdk.services.costexplorer.transform.ListCostCategoryDefinitionsRequestMarshaller;
import software.amazon.awssdk.services.costexplorer.transform.ListSavingsPlansPurchaseRecommendationGenerationRequestMarshaller;
import software.amazon.awssdk.services.costexplorer.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.costexplorer.transform.ProvideAnomalyFeedbackRequestMarshaller;
import software.amazon.awssdk.services.costexplorer.transform.StartCommitmentPurchaseAnalysisRequestMarshaller;
import software.amazon.awssdk.services.costexplorer.transform.StartCostAllocationTagBackfillRequestMarshaller;
import software.amazon.awssdk.services.costexplorer.transform.StartSavingsPlansPurchaseRecommendationGenerationRequestMarshaller;
import software.amazon.awssdk.services.costexplorer.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.costexplorer.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.costexplorer.transform.UpdateAnomalyMonitorRequestMarshaller;
import software.amazon.awssdk.services.costexplorer.transform.UpdateAnomalySubscriptionRequestMarshaller;
import software.amazon.awssdk.services.costexplorer.transform.UpdateCostAllocationTagsStatusRequestMarshaller;
import software.amazon.awssdk.services.costexplorer.transform.UpdateCostCategoryDefinitionRequestMarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

@SdkInternalApi
final class DefaultCostExplorerAsyncClient
implements CostExplorerAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultCostExplorerAsyncClient.class);
    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder().serviceProtocol(AwsServiceProtocol.AWS_JSON).build();
    private final AsyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultCostExplorerAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option((ClientOption)SdkClientOption.SDK_CLIENT, (Object)this).build();
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    @Override
    public CompletableFuture<CreateAnomalyMonitorResponse> createAnomalyMonitor(CreateAnomalyMonitorRequest createAnomalyMonitorRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createAnomalyMonitorRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCostExplorerAsyncClient.resolveMetricPublishers(clientConfiguration, createAnomalyMonitorRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cost Explorer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateAnomalyMonitor");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateAnomalyMonitorResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "GenerationExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GenerationExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GenerationExistsException::builder).build());
                    }
                    case "UnresolvableUsageUnitException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnresolvableUsageUnitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnresolvableUsageUnitException::builder).build());
                    }
                    case "UnknownSubscriptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnknownSubscriptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownSubscriptionException::builder).build());
                    }
                    case "RequestChangedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestChangedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestChangedException::builder).build());
                    }
                    case "DataUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataUnavailableException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "BackfillLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackfillLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackfillLimitExceededException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "UnknownMonitorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnknownMonitorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownMonitorException::builder).build());
                    }
                    case "AnalysisNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AnalysisNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AnalysisNotFoundException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "BillExpirationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BillExpirationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BillExpirationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateAnomalyMonitor").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateAnomalyMonitorRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createAnomalyMonitorRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCostExplorerAsyncClient.lambda$createAnomalyMonitor$2(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCostExplorerAsyncClient.lambda$createAnomalyMonitor$3((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateAnomalySubscriptionResponse> createAnomalySubscription(CreateAnomalySubscriptionRequest createAnomalySubscriptionRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createAnomalySubscriptionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCostExplorerAsyncClient.resolveMetricPublishers(clientConfiguration, createAnomalySubscriptionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cost Explorer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateAnomalySubscription");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateAnomalySubscriptionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "GenerationExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GenerationExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GenerationExistsException::builder).build());
                    }
                    case "UnresolvableUsageUnitException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnresolvableUsageUnitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnresolvableUsageUnitException::builder).build());
                    }
                    case "UnknownSubscriptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnknownSubscriptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownSubscriptionException::builder).build());
                    }
                    case "RequestChangedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestChangedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestChangedException::builder).build());
                    }
                    case "DataUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataUnavailableException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "BackfillLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackfillLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackfillLimitExceededException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "UnknownMonitorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnknownMonitorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownMonitorException::builder).build());
                    }
                    case "AnalysisNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AnalysisNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AnalysisNotFoundException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "BillExpirationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BillExpirationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BillExpirationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateAnomalySubscription").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateAnomalySubscriptionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createAnomalySubscriptionRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCostExplorerAsyncClient.lambda$createAnomalySubscription$6(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCostExplorerAsyncClient.lambda$createAnomalySubscription$7((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<CreateCostCategoryDefinitionResponse> createCostCategoryDefinition(CreateCostCategoryDefinitionRequest createCostCategoryDefinitionRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createCostCategoryDefinitionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCostExplorerAsyncClient.resolveMetricPublishers(clientConfiguration, createCostCategoryDefinitionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cost Explorer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateCostCategoryDefinition");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateCostCategoryDefinitionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "GenerationExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GenerationExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GenerationExistsException::builder).build());
                    }
                    case "UnresolvableUsageUnitException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnresolvableUsageUnitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnresolvableUsageUnitException::builder).build());
                    }
                    case "UnknownSubscriptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnknownSubscriptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownSubscriptionException::builder).build());
                    }
                    case "RequestChangedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestChangedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestChangedException::builder).build());
                    }
                    case "DataUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataUnavailableException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "BackfillLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackfillLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackfillLimitExceededException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "UnknownMonitorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnknownMonitorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownMonitorException::builder).build());
                    }
                    case "AnalysisNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AnalysisNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AnalysisNotFoundException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "BillExpirationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BillExpirationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BillExpirationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateCostCategoryDefinition").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new CreateCostCategoryDefinitionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)createCostCategoryDefinitionRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCostExplorerAsyncClient.lambda$createCostCategoryDefinition$10(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCostExplorerAsyncClient.lambda$createCostCategoryDefinition$11((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteAnomalyMonitorResponse> deleteAnomalyMonitor(DeleteAnomalyMonitorRequest deleteAnomalyMonitorRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteAnomalyMonitorRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCostExplorerAsyncClient.resolveMetricPublishers(clientConfiguration, deleteAnomalyMonitorRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cost Explorer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteAnomalyMonitor");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteAnomalyMonitorResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "GenerationExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GenerationExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GenerationExistsException::builder).build());
                    }
                    case "UnresolvableUsageUnitException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnresolvableUsageUnitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnresolvableUsageUnitException::builder).build());
                    }
                    case "UnknownSubscriptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnknownSubscriptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownSubscriptionException::builder).build());
                    }
                    case "RequestChangedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestChangedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestChangedException::builder).build());
                    }
                    case "DataUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataUnavailableException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "BackfillLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackfillLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackfillLimitExceededException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "UnknownMonitorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnknownMonitorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownMonitorException::builder).build());
                    }
                    case "AnalysisNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AnalysisNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AnalysisNotFoundException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "BillExpirationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BillExpirationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BillExpirationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteAnomalyMonitor").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteAnomalyMonitorRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteAnomalyMonitorRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCostExplorerAsyncClient.lambda$deleteAnomalyMonitor$14(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCostExplorerAsyncClient.lambda$deleteAnomalyMonitor$15((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteAnomalySubscriptionResponse> deleteAnomalySubscription(DeleteAnomalySubscriptionRequest deleteAnomalySubscriptionRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteAnomalySubscriptionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCostExplorerAsyncClient.resolveMetricPublishers(clientConfiguration, deleteAnomalySubscriptionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cost Explorer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteAnomalySubscription");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteAnomalySubscriptionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "GenerationExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GenerationExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GenerationExistsException::builder).build());
                    }
                    case "UnresolvableUsageUnitException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnresolvableUsageUnitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnresolvableUsageUnitException::builder).build());
                    }
                    case "UnknownSubscriptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnknownSubscriptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownSubscriptionException::builder).build());
                    }
                    case "RequestChangedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestChangedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestChangedException::builder).build());
                    }
                    case "DataUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataUnavailableException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "BackfillLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackfillLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackfillLimitExceededException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "UnknownMonitorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnknownMonitorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownMonitorException::builder).build());
                    }
                    case "AnalysisNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AnalysisNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AnalysisNotFoundException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "BillExpirationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BillExpirationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BillExpirationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteAnomalySubscription").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteAnomalySubscriptionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteAnomalySubscriptionRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCostExplorerAsyncClient.lambda$deleteAnomalySubscription$18(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCostExplorerAsyncClient.lambda$deleteAnomalySubscription$19((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteCostCategoryDefinitionResponse> deleteCostCategoryDefinition(DeleteCostCategoryDefinitionRequest deleteCostCategoryDefinitionRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteCostCategoryDefinitionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCostExplorerAsyncClient.resolveMetricPublishers(clientConfiguration, deleteCostCategoryDefinitionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cost Explorer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteCostCategoryDefinition");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteCostCategoryDefinitionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "GenerationExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GenerationExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GenerationExistsException::builder).build());
                    }
                    case "UnresolvableUsageUnitException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnresolvableUsageUnitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnresolvableUsageUnitException::builder).build());
                    }
                    case "UnknownSubscriptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnknownSubscriptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownSubscriptionException::builder).build());
                    }
                    case "RequestChangedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestChangedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestChangedException::builder).build());
                    }
                    case "DataUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataUnavailableException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "BackfillLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackfillLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackfillLimitExceededException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "UnknownMonitorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnknownMonitorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownMonitorException::builder).build());
                    }
                    case "AnalysisNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AnalysisNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AnalysisNotFoundException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "BillExpirationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BillExpirationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BillExpirationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteCostCategoryDefinition").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DeleteCostCategoryDefinitionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteCostCategoryDefinitionRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCostExplorerAsyncClient.lambda$deleteCostCategoryDefinition$22(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCostExplorerAsyncClient.lambda$deleteCostCategoryDefinition$23((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeCostCategoryDefinitionResponse> describeCostCategoryDefinition(DescribeCostCategoryDefinitionRequest describeCostCategoryDefinitionRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeCostCategoryDefinitionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCostExplorerAsyncClient.resolveMetricPublishers(clientConfiguration, describeCostCategoryDefinitionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cost Explorer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeCostCategoryDefinition");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeCostCategoryDefinitionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "GenerationExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GenerationExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GenerationExistsException::builder).build());
                    }
                    case "UnresolvableUsageUnitException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnresolvableUsageUnitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnresolvableUsageUnitException::builder).build());
                    }
                    case "UnknownSubscriptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnknownSubscriptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownSubscriptionException::builder).build());
                    }
                    case "RequestChangedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestChangedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestChangedException::builder).build());
                    }
                    case "DataUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataUnavailableException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "BackfillLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackfillLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackfillLimitExceededException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "UnknownMonitorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnknownMonitorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownMonitorException::builder).build());
                    }
                    case "AnalysisNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AnalysisNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AnalysisNotFoundException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "BillExpirationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BillExpirationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BillExpirationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeCostCategoryDefinition").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new DescribeCostCategoryDefinitionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeCostCategoryDefinitionRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCostExplorerAsyncClient.lambda$describeCostCategoryDefinition$26(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCostExplorerAsyncClient.lambda$describeCostCategoryDefinition$27((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetAnomaliesResponse> getAnomalies(GetAnomaliesRequest getAnomaliesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getAnomaliesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCostExplorerAsyncClient.resolveMetricPublishers(clientConfiguration, getAnomaliesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cost Explorer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetAnomalies");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetAnomaliesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "GenerationExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GenerationExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GenerationExistsException::builder).build());
                    }
                    case "UnresolvableUsageUnitException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnresolvableUsageUnitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnresolvableUsageUnitException::builder).build());
                    }
                    case "UnknownSubscriptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnknownSubscriptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownSubscriptionException::builder).build());
                    }
                    case "RequestChangedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestChangedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestChangedException::builder).build());
                    }
                    case "DataUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataUnavailableException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "BackfillLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackfillLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackfillLimitExceededException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "UnknownMonitorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnknownMonitorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownMonitorException::builder).build());
                    }
                    case "AnalysisNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AnalysisNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AnalysisNotFoundException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "BillExpirationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BillExpirationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BillExpirationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetAnomalies").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetAnomaliesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getAnomaliesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCostExplorerAsyncClient.lambda$getAnomalies$30(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCostExplorerAsyncClient.lambda$getAnomalies$31((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetAnomalyMonitorsResponse> getAnomalyMonitors(GetAnomalyMonitorsRequest getAnomalyMonitorsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getAnomalyMonitorsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCostExplorerAsyncClient.resolveMetricPublishers(clientConfiguration, getAnomalyMonitorsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cost Explorer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetAnomalyMonitors");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetAnomalyMonitorsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "GenerationExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GenerationExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GenerationExistsException::builder).build());
                    }
                    case "UnresolvableUsageUnitException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnresolvableUsageUnitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnresolvableUsageUnitException::builder).build());
                    }
                    case "UnknownSubscriptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnknownSubscriptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownSubscriptionException::builder).build());
                    }
                    case "RequestChangedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestChangedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestChangedException::builder).build());
                    }
                    case "DataUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataUnavailableException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "BackfillLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackfillLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackfillLimitExceededException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "UnknownMonitorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnknownMonitorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownMonitorException::builder).build());
                    }
                    case "AnalysisNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AnalysisNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AnalysisNotFoundException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "BillExpirationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BillExpirationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BillExpirationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetAnomalyMonitors").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetAnomalyMonitorsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getAnomalyMonitorsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCostExplorerAsyncClient.lambda$getAnomalyMonitors$34(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCostExplorerAsyncClient.lambda$getAnomalyMonitors$35((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetAnomalySubscriptionsResponse> getAnomalySubscriptions(GetAnomalySubscriptionsRequest getAnomalySubscriptionsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getAnomalySubscriptionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCostExplorerAsyncClient.resolveMetricPublishers(clientConfiguration, getAnomalySubscriptionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cost Explorer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetAnomalySubscriptions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetAnomalySubscriptionsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "GenerationExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GenerationExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GenerationExistsException::builder).build());
                    }
                    case "UnresolvableUsageUnitException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnresolvableUsageUnitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnresolvableUsageUnitException::builder).build());
                    }
                    case "UnknownSubscriptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnknownSubscriptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownSubscriptionException::builder).build());
                    }
                    case "RequestChangedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestChangedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestChangedException::builder).build());
                    }
                    case "DataUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataUnavailableException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "BackfillLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackfillLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackfillLimitExceededException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "UnknownMonitorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnknownMonitorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownMonitorException::builder).build());
                    }
                    case "AnalysisNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AnalysisNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AnalysisNotFoundException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "BillExpirationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BillExpirationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BillExpirationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetAnomalySubscriptions").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetAnomalySubscriptionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getAnomalySubscriptionsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCostExplorerAsyncClient.lambda$getAnomalySubscriptions$38(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCostExplorerAsyncClient.lambda$getAnomalySubscriptions$39((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetApproximateUsageRecordsResponse> getApproximateUsageRecords(GetApproximateUsageRecordsRequest getApproximateUsageRecordsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getApproximateUsageRecordsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCostExplorerAsyncClient.resolveMetricPublishers(clientConfiguration, getApproximateUsageRecordsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cost Explorer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetApproximateUsageRecords");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetApproximateUsageRecordsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "GenerationExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GenerationExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GenerationExistsException::builder).build());
                    }
                    case "UnresolvableUsageUnitException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnresolvableUsageUnitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnresolvableUsageUnitException::builder).build());
                    }
                    case "UnknownSubscriptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnknownSubscriptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownSubscriptionException::builder).build());
                    }
                    case "RequestChangedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestChangedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestChangedException::builder).build());
                    }
                    case "DataUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataUnavailableException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "BackfillLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackfillLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackfillLimitExceededException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "UnknownMonitorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnknownMonitorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownMonitorException::builder).build());
                    }
                    case "AnalysisNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AnalysisNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AnalysisNotFoundException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "BillExpirationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BillExpirationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BillExpirationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetApproximateUsageRecords").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetApproximateUsageRecordsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getApproximateUsageRecordsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCostExplorerAsyncClient.lambda$getApproximateUsageRecords$42(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCostExplorerAsyncClient.lambda$getApproximateUsageRecords$43((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetCommitmentPurchaseAnalysisResponse> getCommitmentPurchaseAnalysis(GetCommitmentPurchaseAnalysisRequest getCommitmentPurchaseAnalysisRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getCommitmentPurchaseAnalysisRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCostExplorerAsyncClient.resolveMetricPublishers(clientConfiguration, getCommitmentPurchaseAnalysisRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cost Explorer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetCommitmentPurchaseAnalysis");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetCommitmentPurchaseAnalysisResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "GenerationExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GenerationExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GenerationExistsException::builder).build());
                    }
                    case "UnresolvableUsageUnitException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnresolvableUsageUnitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnresolvableUsageUnitException::builder).build());
                    }
                    case "UnknownSubscriptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnknownSubscriptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownSubscriptionException::builder).build());
                    }
                    case "RequestChangedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestChangedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestChangedException::builder).build());
                    }
                    case "DataUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataUnavailableException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "BackfillLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackfillLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackfillLimitExceededException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "UnknownMonitorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnknownMonitorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownMonitorException::builder).build());
                    }
                    case "AnalysisNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AnalysisNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AnalysisNotFoundException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "BillExpirationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BillExpirationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BillExpirationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetCommitmentPurchaseAnalysis").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetCommitmentPurchaseAnalysisRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getCommitmentPurchaseAnalysisRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCostExplorerAsyncClient.lambda$getCommitmentPurchaseAnalysis$46(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCostExplorerAsyncClient.lambda$getCommitmentPurchaseAnalysis$47((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetCostAndUsageResponse> getCostAndUsage(GetCostAndUsageRequest getCostAndUsageRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getCostAndUsageRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCostExplorerAsyncClient.resolveMetricPublishers(clientConfiguration, getCostAndUsageRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cost Explorer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetCostAndUsage");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetCostAndUsageResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "GenerationExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GenerationExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GenerationExistsException::builder).build());
                    }
                    case "UnresolvableUsageUnitException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnresolvableUsageUnitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnresolvableUsageUnitException::builder).build());
                    }
                    case "UnknownSubscriptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnknownSubscriptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownSubscriptionException::builder).build());
                    }
                    case "RequestChangedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestChangedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestChangedException::builder).build());
                    }
                    case "DataUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataUnavailableException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "BackfillLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackfillLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackfillLimitExceededException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "UnknownMonitorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnknownMonitorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownMonitorException::builder).build());
                    }
                    case "AnalysisNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AnalysisNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AnalysisNotFoundException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "BillExpirationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BillExpirationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BillExpirationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetCostAndUsage").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetCostAndUsageRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getCostAndUsageRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCostExplorerAsyncClient.lambda$getCostAndUsage$50(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCostExplorerAsyncClient.lambda$getCostAndUsage$51((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetCostAndUsageWithResourcesResponse> getCostAndUsageWithResources(GetCostAndUsageWithResourcesRequest getCostAndUsageWithResourcesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getCostAndUsageWithResourcesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCostExplorerAsyncClient.resolveMetricPublishers(clientConfiguration, getCostAndUsageWithResourcesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cost Explorer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetCostAndUsageWithResources");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetCostAndUsageWithResourcesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "GenerationExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GenerationExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GenerationExistsException::builder).build());
                    }
                    case "UnresolvableUsageUnitException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnresolvableUsageUnitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnresolvableUsageUnitException::builder).build());
                    }
                    case "UnknownSubscriptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnknownSubscriptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownSubscriptionException::builder).build());
                    }
                    case "RequestChangedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestChangedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestChangedException::builder).build());
                    }
                    case "DataUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataUnavailableException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "BackfillLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackfillLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackfillLimitExceededException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "UnknownMonitorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnknownMonitorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownMonitorException::builder).build());
                    }
                    case "AnalysisNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AnalysisNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AnalysisNotFoundException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "BillExpirationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BillExpirationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BillExpirationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetCostAndUsageWithResources").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetCostAndUsageWithResourcesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getCostAndUsageWithResourcesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCostExplorerAsyncClient.lambda$getCostAndUsageWithResources$54(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCostExplorerAsyncClient.lambda$getCostAndUsageWithResources$55((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetCostCategoriesResponse> getCostCategories(GetCostCategoriesRequest getCostCategoriesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getCostCategoriesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCostExplorerAsyncClient.resolveMetricPublishers(clientConfiguration, getCostCategoriesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cost Explorer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetCostCategories");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetCostCategoriesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "GenerationExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GenerationExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GenerationExistsException::builder).build());
                    }
                    case "UnresolvableUsageUnitException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnresolvableUsageUnitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnresolvableUsageUnitException::builder).build());
                    }
                    case "UnknownSubscriptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnknownSubscriptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownSubscriptionException::builder).build());
                    }
                    case "RequestChangedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestChangedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestChangedException::builder).build());
                    }
                    case "DataUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataUnavailableException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "BackfillLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackfillLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackfillLimitExceededException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "UnknownMonitorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnknownMonitorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownMonitorException::builder).build());
                    }
                    case "AnalysisNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AnalysisNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AnalysisNotFoundException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "BillExpirationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BillExpirationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BillExpirationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetCostCategories").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetCostCategoriesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getCostCategoriesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCostExplorerAsyncClient.lambda$getCostCategories$58(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCostExplorerAsyncClient.lambda$getCostCategories$59((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetCostForecastResponse> getCostForecast(GetCostForecastRequest getCostForecastRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getCostForecastRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCostExplorerAsyncClient.resolveMetricPublishers(clientConfiguration, getCostForecastRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cost Explorer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetCostForecast");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetCostForecastResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "GenerationExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GenerationExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GenerationExistsException::builder).build());
                    }
                    case "UnresolvableUsageUnitException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnresolvableUsageUnitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnresolvableUsageUnitException::builder).build());
                    }
                    case "UnknownSubscriptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnknownSubscriptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownSubscriptionException::builder).build());
                    }
                    case "RequestChangedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestChangedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestChangedException::builder).build());
                    }
                    case "DataUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataUnavailableException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "BackfillLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackfillLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackfillLimitExceededException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "UnknownMonitorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnknownMonitorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownMonitorException::builder).build());
                    }
                    case "AnalysisNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AnalysisNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AnalysisNotFoundException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "BillExpirationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BillExpirationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BillExpirationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetCostForecast").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetCostForecastRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getCostForecastRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCostExplorerAsyncClient.lambda$getCostForecast$62(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCostExplorerAsyncClient.lambda$getCostForecast$63((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetDimensionValuesResponse> getDimensionValues(GetDimensionValuesRequest getDimensionValuesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getDimensionValuesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCostExplorerAsyncClient.resolveMetricPublishers(clientConfiguration, getDimensionValuesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cost Explorer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetDimensionValues");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetDimensionValuesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "GenerationExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GenerationExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GenerationExistsException::builder).build());
                    }
                    case "UnresolvableUsageUnitException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnresolvableUsageUnitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnresolvableUsageUnitException::builder).build());
                    }
                    case "UnknownSubscriptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnknownSubscriptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownSubscriptionException::builder).build());
                    }
                    case "RequestChangedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestChangedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestChangedException::builder).build());
                    }
                    case "DataUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataUnavailableException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "BackfillLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackfillLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackfillLimitExceededException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "UnknownMonitorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnknownMonitorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownMonitorException::builder).build());
                    }
                    case "AnalysisNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AnalysisNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AnalysisNotFoundException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "BillExpirationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BillExpirationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BillExpirationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetDimensionValues").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetDimensionValuesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getDimensionValuesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCostExplorerAsyncClient.lambda$getDimensionValues$66(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCostExplorerAsyncClient.lambda$getDimensionValues$67((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetReservationCoverageResponse> getReservationCoverage(GetReservationCoverageRequest getReservationCoverageRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getReservationCoverageRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCostExplorerAsyncClient.resolveMetricPublishers(clientConfiguration, getReservationCoverageRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cost Explorer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetReservationCoverage");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetReservationCoverageResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "GenerationExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GenerationExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GenerationExistsException::builder).build());
                    }
                    case "UnresolvableUsageUnitException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnresolvableUsageUnitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnresolvableUsageUnitException::builder).build());
                    }
                    case "UnknownSubscriptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnknownSubscriptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownSubscriptionException::builder).build());
                    }
                    case "RequestChangedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestChangedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestChangedException::builder).build());
                    }
                    case "DataUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataUnavailableException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "BackfillLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackfillLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackfillLimitExceededException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "UnknownMonitorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnknownMonitorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownMonitorException::builder).build());
                    }
                    case "AnalysisNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AnalysisNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AnalysisNotFoundException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "BillExpirationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BillExpirationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BillExpirationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetReservationCoverage").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetReservationCoverageRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getReservationCoverageRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCostExplorerAsyncClient.lambda$getReservationCoverage$70(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCostExplorerAsyncClient.lambda$getReservationCoverage$71((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetReservationPurchaseRecommendationResponse> getReservationPurchaseRecommendation(GetReservationPurchaseRecommendationRequest getReservationPurchaseRecommendationRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getReservationPurchaseRecommendationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCostExplorerAsyncClient.resolveMetricPublishers(clientConfiguration, getReservationPurchaseRecommendationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cost Explorer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetReservationPurchaseRecommendation");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetReservationPurchaseRecommendationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "GenerationExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GenerationExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GenerationExistsException::builder).build());
                    }
                    case "UnresolvableUsageUnitException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnresolvableUsageUnitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnresolvableUsageUnitException::builder).build());
                    }
                    case "UnknownSubscriptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnknownSubscriptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownSubscriptionException::builder).build());
                    }
                    case "RequestChangedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestChangedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestChangedException::builder).build());
                    }
                    case "DataUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataUnavailableException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "BackfillLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackfillLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackfillLimitExceededException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "UnknownMonitorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnknownMonitorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownMonitorException::builder).build());
                    }
                    case "AnalysisNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AnalysisNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AnalysisNotFoundException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "BillExpirationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BillExpirationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BillExpirationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetReservationPurchaseRecommendation").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetReservationPurchaseRecommendationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getReservationPurchaseRecommendationRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCostExplorerAsyncClient.lambda$getReservationPurchaseRecommendation$74(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCostExplorerAsyncClient.lambda$getReservationPurchaseRecommendation$75((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetReservationUtilizationResponse> getReservationUtilization(GetReservationUtilizationRequest getReservationUtilizationRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getReservationUtilizationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCostExplorerAsyncClient.resolveMetricPublishers(clientConfiguration, getReservationUtilizationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cost Explorer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetReservationUtilization");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetReservationUtilizationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "GenerationExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GenerationExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GenerationExistsException::builder).build());
                    }
                    case "UnresolvableUsageUnitException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnresolvableUsageUnitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnresolvableUsageUnitException::builder).build());
                    }
                    case "UnknownSubscriptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnknownSubscriptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownSubscriptionException::builder).build());
                    }
                    case "RequestChangedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestChangedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestChangedException::builder).build());
                    }
                    case "DataUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataUnavailableException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "BackfillLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackfillLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackfillLimitExceededException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "UnknownMonitorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnknownMonitorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownMonitorException::builder).build());
                    }
                    case "AnalysisNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AnalysisNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AnalysisNotFoundException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "BillExpirationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BillExpirationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BillExpirationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetReservationUtilization").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetReservationUtilizationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getReservationUtilizationRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCostExplorerAsyncClient.lambda$getReservationUtilization$78(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCostExplorerAsyncClient.lambda$getReservationUtilization$79((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetRightsizingRecommendationResponse> getRightsizingRecommendation(GetRightsizingRecommendationRequest getRightsizingRecommendationRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getRightsizingRecommendationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCostExplorerAsyncClient.resolveMetricPublishers(clientConfiguration, getRightsizingRecommendationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cost Explorer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetRightsizingRecommendation");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetRightsizingRecommendationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "GenerationExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GenerationExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GenerationExistsException::builder).build());
                    }
                    case "UnresolvableUsageUnitException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnresolvableUsageUnitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnresolvableUsageUnitException::builder).build());
                    }
                    case "UnknownSubscriptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnknownSubscriptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownSubscriptionException::builder).build());
                    }
                    case "RequestChangedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestChangedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestChangedException::builder).build());
                    }
                    case "DataUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataUnavailableException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "BackfillLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackfillLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackfillLimitExceededException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "UnknownMonitorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnknownMonitorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownMonitorException::builder).build());
                    }
                    case "AnalysisNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AnalysisNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AnalysisNotFoundException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "BillExpirationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BillExpirationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BillExpirationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetRightsizingRecommendation").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetRightsizingRecommendationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getRightsizingRecommendationRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCostExplorerAsyncClient.lambda$getRightsizingRecommendation$82(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCostExplorerAsyncClient.lambda$getRightsizingRecommendation$83((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetSavingsPlanPurchaseRecommendationDetailsResponse> getSavingsPlanPurchaseRecommendationDetails(GetSavingsPlanPurchaseRecommendationDetailsRequest getSavingsPlanPurchaseRecommendationDetailsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getSavingsPlanPurchaseRecommendationDetailsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCostExplorerAsyncClient.resolveMetricPublishers(clientConfiguration, getSavingsPlanPurchaseRecommendationDetailsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cost Explorer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetSavingsPlanPurchaseRecommendationDetails");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetSavingsPlanPurchaseRecommendationDetailsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "GenerationExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GenerationExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GenerationExistsException::builder).build());
                    }
                    case "UnresolvableUsageUnitException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnresolvableUsageUnitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnresolvableUsageUnitException::builder).build());
                    }
                    case "UnknownSubscriptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnknownSubscriptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownSubscriptionException::builder).build());
                    }
                    case "RequestChangedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestChangedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestChangedException::builder).build());
                    }
                    case "DataUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataUnavailableException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "BackfillLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackfillLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackfillLimitExceededException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "UnknownMonitorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnknownMonitorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownMonitorException::builder).build());
                    }
                    case "AnalysisNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AnalysisNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AnalysisNotFoundException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "BillExpirationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BillExpirationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BillExpirationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetSavingsPlanPurchaseRecommendationDetails").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetSavingsPlanPurchaseRecommendationDetailsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getSavingsPlanPurchaseRecommendationDetailsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCostExplorerAsyncClient.lambda$getSavingsPlanPurchaseRecommendationDetails$86(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCostExplorerAsyncClient.lambda$getSavingsPlanPurchaseRecommendationDetails$87((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetSavingsPlansCoverageResponse> getSavingsPlansCoverage(GetSavingsPlansCoverageRequest getSavingsPlansCoverageRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getSavingsPlansCoverageRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCostExplorerAsyncClient.resolveMetricPublishers(clientConfiguration, getSavingsPlansCoverageRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cost Explorer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetSavingsPlansCoverage");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetSavingsPlansCoverageResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "GenerationExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GenerationExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GenerationExistsException::builder).build());
                    }
                    case "UnresolvableUsageUnitException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnresolvableUsageUnitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnresolvableUsageUnitException::builder).build());
                    }
                    case "UnknownSubscriptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnknownSubscriptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownSubscriptionException::builder).build());
                    }
                    case "RequestChangedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestChangedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestChangedException::builder).build());
                    }
                    case "DataUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataUnavailableException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "BackfillLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackfillLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackfillLimitExceededException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "UnknownMonitorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnknownMonitorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownMonitorException::builder).build());
                    }
                    case "AnalysisNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AnalysisNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AnalysisNotFoundException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "BillExpirationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BillExpirationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BillExpirationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetSavingsPlansCoverage").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetSavingsPlansCoverageRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getSavingsPlansCoverageRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCostExplorerAsyncClient.lambda$getSavingsPlansCoverage$90(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCostExplorerAsyncClient.lambda$getSavingsPlansCoverage$91((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetSavingsPlansPurchaseRecommendationResponse> getSavingsPlansPurchaseRecommendation(GetSavingsPlansPurchaseRecommendationRequest getSavingsPlansPurchaseRecommendationRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getSavingsPlansPurchaseRecommendationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCostExplorerAsyncClient.resolveMetricPublishers(clientConfiguration, getSavingsPlansPurchaseRecommendationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cost Explorer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetSavingsPlansPurchaseRecommendation");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetSavingsPlansPurchaseRecommendationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "GenerationExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GenerationExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GenerationExistsException::builder).build());
                    }
                    case "UnresolvableUsageUnitException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnresolvableUsageUnitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnresolvableUsageUnitException::builder).build());
                    }
                    case "UnknownSubscriptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnknownSubscriptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownSubscriptionException::builder).build());
                    }
                    case "RequestChangedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestChangedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestChangedException::builder).build());
                    }
                    case "DataUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataUnavailableException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "BackfillLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackfillLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackfillLimitExceededException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "UnknownMonitorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnknownMonitorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownMonitorException::builder).build());
                    }
                    case "AnalysisNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AnalysisNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AnalysisNotFoundException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "BillExpirationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BillExpirationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BillExpirationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetSavingsPlansPurchaseRecommendation").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetSavingsPlansPurchaseRecommendationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getSavingsPlansPurchaseRecommendationRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCostExplorerAsyncClient.lambda$getSavingsPlansPurchaseRecommendation$94(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCostExplorerAsyncClient.lambda$getSavingsPlansPurchaseRecommendation$95((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetSavingsPlansUtilizationResponse> getSavingsPlansUtilization(GetSavingsPlansUtilizationRequest getSavingsPlansUtilizationRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getSavingsPlansUtilizationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCostExplorerAsyncClient.resolveMetricPublishers(clientConfiguration, getSavingsPlansUtilizationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cost Explorer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetSavingsPlansUtilization");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetSavingsPlansUtilizationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "GenerationExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GenerationExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GenerationExistsException::builder).build());
                    }
                    case "UnresolvableUsageUnitException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnresolvableUsageUnitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnresolvableUsageUnitException::builder).build());
                    }
                    case "UnknownSubscriptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnknownSubscriptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownSubscriptionException::builder).build());
                    }
                    case "RequestChangedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestChangedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestChangedException::builder).build());
                    }
                    case "DataUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataUnavailableException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "BackfillLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackfillLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackfillLimitExceededException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "UnknownMonitorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnknownMonitorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownMonitorException::builder).build());
                    }
                    case "AnalysisNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AnalysisNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AnalysisNotFoundException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "BillExpirationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BillExpirationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BillExpirationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetSavingsPlansUtilization").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetSavingsPlansUtilizationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getSavingsPlansUtilizationRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCostExplorerAsyncClient.lambda$getSavingsPlansUtilization$98(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCostExplorerAsyncClient.lambda$getSavingsPlansUtilization$99((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetSavingsPlansUtilizationDetailsResponse> getSavingsPlansUtilizationDetails(GetSavingsPlansUtilizationDetailsRequest getSavingsPlansUtilizationDetailsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getSavingsPlansUtilizationDetailsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCostExplorerAsyncClient.resolveMetricPublishers(clientConfiguration, getSavingsPlansUtilizationDetailsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cost Explorer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetSavingsPlansUtilizationDetails");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetSavingsPlansUtilizationDetailsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "GenerationExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GenerationExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GenerationExistsException::builder).build());
                    }
                    case "UnresolvableUsageUnitException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnresolvableUsageUnitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnresolvableUsageUnitException::builder).build());
                    }
                    case "UnknownSubscriptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnknownSubscriptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownSubscriptionException::builder).build());
                    }
                    case "RequestChangedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestChangedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestChangedException::builder).build());
                    }
                    case "DataUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataUnavailableException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "BackfillLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackfillLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackfillLimitExceededException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "UnknownMonitorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnknownMonitorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownMonitorException::builder).build());
                    }
                    case "AnalysisNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AnalysisNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AnalysisNotFoundException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "BillExpirationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BillExpirationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BillExpirationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetSavingsPlansUtilizationDetails").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetSavingsPlansUtilizationDetailsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getSavingsPlansUtilizationDetailsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCostExplorerAsyncClient.lambda$getSavingsPlansUtilizationDetails$102(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCostExplorerAsyncClient.lambda$getSavingsPlansUtilizationDetails$103((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetTagsResponse> getTags(GetTagsRequest getTagsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getTagsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCostExplorerAsyncClient.resolveMetricPublishers(clientConfiguration, getTagsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cost Explorer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetTags");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetTagsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "GenerationExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GenerationExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GenerationExistsException::builder).build());
                    }
                    case "UnresolvableUsageUnitException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnresolvableUsageUnitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnresolvableUsageUnitException::builder).build());
                    }
                    case "UnknownSubscriptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnknownSubscriptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownSubscriptionException::builder).build());
                    }
                    case "RequestChangedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestChangedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestChangedException::builder).build());
                    }
                    case "DataUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataUnavailableException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "BackfillLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackfillLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackfillLimitExceededException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "UnknownMonitorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnknownMonitorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownMonitorException::builder).build());
                    }
                    case "AnalysisNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AnalysisNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AnalysisNotFoundException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "BillExpirationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BillExpirationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BillExpirationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetTags").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetTagsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getTagsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCostExplorerAsyncClient.lambda$getTags$106(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCostExplorerAsyncClient.lambda$getTags$107((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetUsageForecastResponse> getUsageForecast(GetUsageForecastRequest getUsageForecastRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getUsageForecastRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCostExplorerAsyncClient.resolveMetricPublishers(clientConfiguration, getUsageForecastRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cost Explorer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetUsageForecast");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetUsageForecastResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "GenerationExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GenerationExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GenerationExistsException::builder).build());
                    }
                    case "UnresolvableUsageUnitException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnresolvableUsageUnitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnresolvableUsageUnitException::builder).build());
                    }
                    case "UnknownSubscriptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnknownSubscriptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownSubscriptionException::builder).build());
                    }
                    case "RequestChangedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestChangedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestChangedException::builder).build());
                    }
                    case "DataUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataUnavailableException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "BackfillLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackfillLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackfillLimitExceededException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "UnknownMonitorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnknownMonitorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownMonitorException::builder).build());
                    }
                    case "AnalysisNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AnalysisNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AnalysisNotFoundException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "BillExpirationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BillExpirationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BillExpirationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetUsageForecast").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new GetUsageForecastRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getUsageForecastRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCostExplorerAsyncClient.lambda$getUsageForecast$110(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCostExplorerAsyncClient.lambda$getUsageForecast$111((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListCommitmentPurchaseAnalysesResponse> listCommitmentPurchaseAnalyses(ListCommitmentPurchaseAnalysesRequest listCommitmentPurchaseAnalysesRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listCommitmentPurchaseAnalysesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCostExplorerAsyncClient.resolveMetricPublishers(clientConfiguration, listCommitmentPurchaseAnalysesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cost Explorer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListCommitmentPurchaseAnalyses");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListCommitmentPurchaseAnalysesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "GenerationExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GenerationExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GenerationExistsException::builder).build());
                    }
                    case "UnresolvableUsageUnitException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnresolvableUsageUnitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnresolvableUsageUnitException::builder).build());
                    }
                    case "UnknownSubscriptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnknownSubscriptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownSubscriptionException::builder).build());
                    }
                    case "RequestChangedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestChangedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestChangedException::builder).build());
                    }
                    case "DataUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataUnavailableException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "BackfillLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackfillLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackfillLimitExceededException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "UnknownMonitorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnknownMonitorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownMonitorException::builder).build());
                    }
                    case "AnalysisNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AnalysisNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AnalysisNotFoundException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "BillExpirationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BillExpirationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BillExpirationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListCommitmentPurchaseAnalyses").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListCommitmentPurchaseAnalysesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listCommitmentPurchaseAnalysesRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCostExplorerAsyncClient.lambda$listCommitmentPurchaseAnalyses$114(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCostExplorerAsyncClient.lambda$listCommitmentPurchaseAnalyses$115((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListCostAllocationTagBackfillHistoryResponse> listCostAllocationTagBackfillHistory(ListCostAllocationTagBackfillHistoryRequest listCostAllocationTagBackfillHistoryRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listCostAllocationTagBackfillHistoryRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCostExplorerAsyncClient.resolveMetricPublishers(clientConfiguration, listCostAllocationTagBackfillHistoryRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cost Explorer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListCostAllocationTagBackfillHistory");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListCostAllocationTagBackfillHistoryResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "GenerationExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GenerationExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GenerationExistsException::builder).build());
                    }
                    case "UnresolvableUsageUnitException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnresolvableUsageUnitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnresolvableUsageUnitException::builder).build());
                    }
                    case "UnknownSubscriptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnknownSubscriptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownSubscriptionException::builder).build());
                    }
                    case "RequestChangedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestChangedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestChangedException::builder).build());
                    }
                    case "DataUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataUnavailableException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "BackfillLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackfillLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackfillLimitExceededException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "UnknownMonitorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnknownMonitorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownMonitorException::builder).build());
                    }
                    case "AnalysisNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AnalysisNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AnalysisNotFoundException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "BillExpirationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BillExpirationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BillExpirationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListCostAllocationTagBackfillHistory").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListCostAllocationTagBackfillHistoryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listCostAllocationTagBackfillHistoryRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCostExplorerAsyncClient.lambda$listCostAllocationTagBackfillHistory$118(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCostExplorerAsyncClient.lambda$listCostAllocationTagBackfillHistory$119((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListCostAllocationTagsResponse> listCostAllocationTags(ListCostAllocationTagsRequest listCostAllocationTagsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listCostAllocationTagsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCostExplorerAsyncClient.resolveMetricPublishers(clientConfiguration, listCostAllocationTagsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cost Explorer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListCostAllocationTags");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListCostAllocationTagsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "GenerationExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GenerationExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GenerationExistsException::builder).build());
                    }
                    case "UnresolvableUsageUnitException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnresolvableUsageUnitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnresolvableUsageUnitException::builder).build());
                    }
                    case "UnknownSubscriptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnknownSubscriptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownSubscriptionException::builder).build());
                    }
                    case "RequestChangedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestChangedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestChangedException::builder).build());
                    }
                    case "DataUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataUnavailableException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "BackfillLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackfillLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackfillLimitExceededException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "UnknownMonitorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnknownMonitorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownMonitorException::builder).build());
                    }
                    case "AnalysisNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AnalysisNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AnalysisNotFoundException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "BillExpirationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BillExpirationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BillExpirationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListCostAllocationTags").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListCostAllocationTagsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listCostAllocationTagsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCostExplorerAsyncClient.lambda$listCostAllocationTags$122(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCostExplorerAsyncClient.lambda$listCostAllocationTags$123((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListCostCategoryDefinitionsResponse> listCostCategoryDefinitions(ListCostCategoryDefinitionsRequest listCostCategoryDefinitionsRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listCostCategoryDefinitionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCostExplorerAsyncClient.resolveMetricPublishers(clientConfiguration, listCostCategoryDefinitionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cost Explorer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListCostCategoryDefinitions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListCostCategoryDefinitionsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "GenerationExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GenerationExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GenerationExistsException::builder).build());
                    }
                    case "UnresolvableUsageUnitException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnresolvableUsageUnitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnresolvableUsageUnitException::builder).build());
                    }
                    case "UnknownSubscriptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnknownSubscriptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownSubscriptionException::builder).build());
                    }
                    case "RequestChangedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestChangedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestChangedException::builder).build());
                    }
                    case "DataUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataUnavailableException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "BackfillLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackfillLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackfillLimitExceededException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "UnknownMonitorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnknownMonitorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownMonitorException::builder).build());
                    }
                    case "AnalysisNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AnalysisNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AnalysisNotFoundException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "BillExpirationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BillExpirationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BillExpirationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListCostCategoryDefinitions").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListCostCategoryDefinitionsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listCostCategoryDefinitionsRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCostExplorerAsyncClient.lambda$listCostCategoryDefinitions$126(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCostExplorerAsyncClient.lambda$listCostCategoryDefinitions$127((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListSavingsPlansPurchaseRecommendationGenerationResponse> listSavingsPlansPurchaseRecommendationGeneration(ListSavingsPlansPurchaseRecommendationGenerationRequest listSavingsPlansPurchaseRecommendationGenerationRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listSavingsPlansPurchaseRecommendationGenerationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCostExplorerAsyncClient.resolveMetricPublishers(clientConfiguration, listSavingsPlansPurchaseRecommendationGenerationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cost Explorer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListSavingsPlansPurchaseRecommendationGeneration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListSavingsPlansPurchaseRecommendationGenerationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "GenerationExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GenerationExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GenerationExistsException::builder).build());
                    }
                    case "UnresolvableUsageUnitException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnresolvableUsageUnitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnresolvableUsageUnitException::builder).build());
                    }
                    case "UnknownSubscriptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnknownSubscriptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownSubscriptionException::builder).build());
                    }
                    case "RequestChangedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestChangedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestChangedException::builder).build());
                    }
                    case "DataUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataUnavailableException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "BackfillLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackfillLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackfillLimitExceededException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "UnknownMonitorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnknownMonitorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownMonitorException::builder).build());
                    }
                    case "AnalysisNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AnalysisNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AnalysisNotFoundException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "BillExpirationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BillExpirationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BillExpirationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListSavingsPlansPurchaseRecommendationGeneration").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListSavingsPlansPurchaseRecommendationGenerationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listSavingsPlansPurchaseRecommendationGenerationRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCostExplorerAsyncClient.lambda$listSavingsPlansPurchaseRecommendationGeneration$130(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCostExplorerAsyncClient.lambda$listSavingsPlansPurchaseRecommendationGeneration$131((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListTagsForResourceResponse> listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listTagsForResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCostExplorerAsyncClient.resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cost Explorer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsForResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForResourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "GenerationExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GenerationExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GenerationExistsException::builder).build());
                    }
                    case "UnresolvableUsageUnitException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnresolvableUsageUnitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnresolvableUsageUnitException::builder).build());
                    }
                    case "UnknownSubscriptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnknownSubscriptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownSubscriptionException::builder).build());
                    }
                    case "RequestChangedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestChangedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestChangedException::builder).build());
                    }
                    case "DataUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataUnavailableException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "BackfillLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackfillLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackfillLimitExceededException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "UnknownMonitorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnknownMonitorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownMonitorException::builder).build());
                    }
                    case "AnalysisNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AnalysisNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AnalysisNotFoundException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "BillExpirationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BillExpirationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BillExpirationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listTagsForResourceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCostExplorerAsyncClient.lambda$listTagsForResource$134(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCostExplorerAsyncClient.lambda$listTagsForResource$135((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ProvideAnomalyFeedbackResponse> provideAnomalyFeedback(ProvideAnomalyFeedbackRequest provideAnomalyFeedbackRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)provideAnomalyFeedbackRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCostExplorerAsyncClient.resolveMetricPublishers(clientConfiguration, provideAnomalyFeedbackRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cost Explorer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ProvideAnomalyFeedback");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ProvideAnomalyFeedbackResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "GenerationExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GenerationExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GenerationExistsException::builder).build());
                    }
                    case "UnresolvableUsageUnitException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnresolvableUsageUnitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnresolvableUsageUnitException::builder).build());
                    }
                    case "UnknownSubscriptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnknownSubscriptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownSubscriptionException::builder).build());
                    }
                    case "RequestChangedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestChangedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestChangedException::builder).build());
                    }
                    case "DataUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataUnavailableException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "BackfillLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackfillLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackfillLimitExceededException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "UnknownMonitorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnknownMonitorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownMonitorException::builder).build());
                    }
                    case "AnalysisNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AnalysisNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AnalysisNotFoundException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "BillExpirationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BillExpirationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BillExpirationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ProvideAnomalyFeedback").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new ProvideAnomalyFeedbackRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)provideAnomalyFeedbackRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCostExplorerAsyncClient.lambda$provideAnomalyFeedback$138(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCostExplorerAsyncClient.lambda$provideAnomalyFeedback$139((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<StartCommitmentPurchaseAnalysisResponse> startCommitmentPurchaseAnalysis(StartCommitmentPurchaseAnalysisRequest startCommitmentPurchaseAnalysisRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)startCommitmentPurchaseAnalysisRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCostExplorerAsyncClient.resolveMetricPublishers(clientConfiguration, startCommitmentPurchaseAnalysisRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cost Explorer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartCommitmentPurchaseAnalysis");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartCommitmentPurchaseAnalysisResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "GenerationExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GenerationExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GenerationExistsException::builder).build());
                    }
                    case "UnresolvableUsageUnitException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnresolvableUsageUnitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnresolvableUsageUnitException::builder).build());
                    }
                    case "UnknownSubscriptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnknownSubscriptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownSubscriptionException::builder).build());
                    }
                    case "RequestChangedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestChangedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestChangedException::builder).build());
                    }
                    case "DataUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataUnavailableException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "BackfillLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackfillLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackfillLimitExceededException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "UnknownMonitorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnknownMonitorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownMonitorException::builder).build());
                    }
                    case "AnalysisNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AnalysisNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AnalysisNotFoundException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "BillExpirationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BillExpirationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BillExpirationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartCommitmentPurchaseAnalysis").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new StartCommitmentPurchaseAnalysisRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)startCommitmentPurchaseAnalysisRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCostExplorerAsyncClient.lambda$startCommitmentPurchaseAnalysis$142(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCostExplorerAsyncClient.lambda$startCommitmentPurchaseAnalysis$143((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<StartCostAllocationTagBackfillResponse> startCostAllocationTagBackfill(StartCostAllocationTagBackfillRequest startCostAllocationTagBackfillRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)startCostAllocationTagBackfillRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCostExplorerAsyncClient.resolveMetricPublishers(clientConfiguration, startCostAllocationTagBackfillRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cost Explorer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartCostAllocationTagBackfill");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartCostAllocationTagBackfillResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "GenerationExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GenerationExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GenerationExistsException::builder).build());
                    }
                    case "UnresolvableUsageUnitException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnresolvableUsageUnitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnresolvableUsageUnitException::builder).build());
                    }
                    case "UnknownSubscriptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnknownSubscriptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownSubscriptionException::builder).build());
                    }
                    case "RequestChangedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestChangedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestChangedException::builder).build());
                    }
                    case "DataUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataUnavailableException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "BackfillLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackfillLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackfillLimitExceededException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "UnknownMonitorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnknownMonitorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownMonitorException::builder).build());
                    }
                    case "AnalysisNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AnalysisNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AnalysisNotFoundException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "BillExpirationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BillExpirationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BillExpirationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartCostAllocationTagBackfill").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new StartCostAllocationTagBackfillRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)startCostAllocationTagBackfillRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCostExplorerAsyncClient.lambda$startCostAllocationTagBackfill$146(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCostExplorerAsyncClient.lambda$startCostAllocationTagBackfill$147((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<StartSavingsPlansPurchaseRecommendationGenerationResponse> startSavingsPlansPurchaseRecommendationGeneration(StartSavingsPlansPurchaseRecommendationGenerationRequest startSavingsPlansPurchaseRecommendationGenerationRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)startSavingsPlansPurchaseRecommendationGenerationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCostExplorerAsyncClient.resolveMetricPublishers(clientConfiguration, startSavingsPlansPurchaseRecommendationGenerationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cost Explorer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartSavingsPlansPurchaseRecommendationGeneration");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartSavingsPlansPurchaseRecommendationGenerationResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "GenerationExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GenerationExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GenerationExistsException::builder).build());
                    }
                    case "UnresolvableUsageUnitException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnresolvableUsageUnitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnresolvableUsageUnitException::builder).build());
                    }
                    case "UnknownSubscriptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnknownSubscriptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownSubscriptionException::builder).build());
                    }
                    case "RequestChangedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestChangedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestChangedException::builder).build());
                    }
                    case "DataUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataUnavailableException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "BackfillLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackfillLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackfillLimitExceededException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "UnknownMonitorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnknownMonitorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownMonitorException::builder).build());
                    }
                    case "AnalysisNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AnalysisNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AnalysisNotFoundException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "BillExpirationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BillExpirationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BillExpirationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartSavingsPlansPurchaseRecommendationGeneration").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new StartSavingsPlansPurchaseRecommendationGenerationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)startSavingsPlansPurchaseRecommendationGenerationRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCostExplorerAsyncClient.lambda$startSavingsPlansPurchaseRecommendationGeneration$150(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCostExplorerAsyncClient.lambda$startSavingsPlansPurchaseRecommendationGeneration$151((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)tagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCostExplorerAsyncClient.resolveMetricPublishers(clientConfiguration, tagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cost Explorer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "GenerationExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GenerationExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GenerationExistsException::builder).build());
                    }
                    case "UnresolvableUsageUnitException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnresolvableUsageUnitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnresolvableUsageUnitException::builder).build());
                    }
                    case "UnknownSubscriptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnknownSubscriptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownSubscriptionException::builder).build());
                    }
                    case "RequestChangedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestChangedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestChangedException::builder).build());
                    }
                    case "DataUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataUnavailableException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "BackfillLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackfillLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackfillLimitExceededException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "UnknownMonitorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnknownMonitorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownMonitorException::builder).build());
                    }
                    case "AnalysisNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AnalysisNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AnalysisNotFoundException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "BillExpirationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BillExpirationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BillExpirationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)tagResourceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCostExplorerAsyncClient.lambda$tagResource$154(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCostExplorerAsyncClient.lambda$tagResource$155((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)untagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCostExplorerAsyncClient.resolveMetricPublishers(clientConfiguration, untagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cost Explorer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "GenerationExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GenerationExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GenerationExistsException::builder).build());
                    }
                    case "UnresolvableUsageUnitException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnresolvableUsageUnitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnresolvableUsageUnitException::builder).build());
                    }
                    case "UnknownSubscriptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnknownSubscriptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownSubscriptionException::builder).build());
                    }
                    case "RequestChangedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestChangedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestChangedException::builder).build());
                    }
                    case "DataUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataUnavailableException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "BackfillLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackfillLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackfillLimitExceededException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "UnknownMonitorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnknownMonitorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownMonitorException::builder).build());
                    }
                    case "AnalysisNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AnalysisNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AnalysisNotFoundException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "BillExpirationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BillExpirationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BillExpirationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)untagResourceRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCostExplorerAsyncClient.lambda$untagResource$158(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCostExplorerAsyncClient.lambda$untagResource$159((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateAnomalyMonitorResponse> updateAnomalyMonitor(UpdateAnomalyMonitorRequest updateAnomalyMonitorRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateAnomalyMonitorRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCostExplorerAsyncClient.resolveMetricPublishers(clientConfiguration, updateAnomalyMonitorRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cost Explorer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateAnomalyMonitor");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateAnomalyMonitorResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "GenerationExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GenerationExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GenerationExistsException::builder).build());
                    }
                    case "UnresolvableUsageUnitException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnresolvableUsageUnitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnresolvableUsageUnitException::builder).build());
                    }
                    case "UnknownSubscriptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnknownSubscriptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownSubscriptionException::builder).build());
                    }
                    case "RequestChangedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestChangedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestChangedException::builder).build());
                    }
                    case "DataUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataUnavailableException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "BackfillLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackfillLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackfillLimitExceededException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "UnknownMonitorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnknownMonitorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownMonitorException::builder).build());
                    }
                    case "AnalysisNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AnalysisNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AnalysisNotFoundException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "BillExpirationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BillExpirationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BillExpirationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateAnomalyMonitor").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateAnomalyMonitorRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateAnomalyMonitorRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCostExplorerAsyncClient.lambda$updateAnomalyMonitor$162(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCostExplorerAsyncClient.lambda$updateAnomalyMonitor$163((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateAnomalySubscriptionResponse> updateAnomalySubscription(UpdateAnomalySubscriptionRequest updateAnomalySubscriptionRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateAnomalySubscriptionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCostExplorerAsyncClient.resolveMetricPublishers(clientConfiguration, updateAnomalySubscriptionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cost Explorer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateAnomalySubscription");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateAnomalySubscriptionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "GenerationExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GenerationExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GenerationExistsException::builder).build());
                    }
                    case "UnresolvableUsageUnitException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnresolvableUsageUnitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnresolvableUsageUnitException::builder).build());
                    }
                    case "UnknownSubscriptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnknownSubscriptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownSubscriptionException::builder).build());
                    }
                    case "RequestChangedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestChangedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestChangedException::builder).build());
                    }
                    case "DataUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataUnavailableException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "BackfillLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackfillLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackfillLimitExceededException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "UnknownMonitorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnknownMonitorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownMonitorException::builder).build());
                    }
                    case "AnalysisNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AnalysisNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AnalysisNotFoundException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "BillExpirationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BillExpirationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BillExpirationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateAnomalySubscription").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateAnomalySubscriptionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateAnomalySubscriptionRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCostExplorerAsyncClient.lambda$updateAnomalySubscription$166(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCostExplorerAsyncClient.lambda$updateAnomalySubscription$167((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateCostAllocationTagsStatusResponse> updateCostAllocationTagsStatus(UpdateCostAllocationTagsStatusRequest updateCostAllocationTagsStatusRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateCostAllocationTagsStatusRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCostExplorerAsyncClient.resolveMetricPublishers(clientConfiguration, updateCostAllocationTagsStatusRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cost Explorer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateCostAllocationTagsStatus");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateCostAllocationTagsStatusResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "GenerationExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GenerationExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GenerationExistsException::builder).build());
                    }
                    case "UnresolvableUsageUnitException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnresolvableUsageUnitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnresolvableUsageUnitException::builder).build());
                    }
                    case "UnknownSubscriptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnknownSubscriptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownSubscriptionException::builder).build());
                    }
                    case "RequestChangedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestChangedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestChangedException::builder).build());
                    }
                    case "DataUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataUnavailableException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "BackfillLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackfillLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackfillLimitExceededException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "UnknownMonitorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnknownMonitorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownMonitorException::builder).build());
                    }
                    case "AnalysisNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AnalysisNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AnalysisNotFoundException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "BillExpirationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BillExpirationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BillExpirationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateCostAllocationTagsStatus").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateCostAllocationTagsStatusRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateCostAllocationTagsStatusRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCostExplorerAsyncClient.lambda$updateCostAllocationTagsStatus$170(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCostExplorerAsyncClient.lambda$updateCostAllocationTagsStatus$171((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UpdateCostCategoryDefinitionResponse> updateCostCategoryDefinition(UpdateCostCategoryDefinitionRequest updateCostCategoryDefinitionRequest) {
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateCostCategoryDefinitionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCostExplorerAsyncClient.resolveMetricPublishers(clientConfiguration, updateCostCategoryDefinitionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Cost Explorer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateCostCategoryDefinition");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateCostCategoryDefinitionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                    case "GenerationExistsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("GenerationExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GenerationExistsException::builder).build());
                    }
                    case "UnresolvableUsageUnitException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnresolvableUsageUnitException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnresolvableUsageUnitException::builder).build());
                    }
                    case "UnknownSubscriptionException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnknownSubscriptionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownSubscriptionException::builder).build());
                    }
                    case "RequestChangedException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("RequestChangedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(RequestChangedException::builder).build());
                    }
                    case "DataUnavailableException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("DataUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DataUnavailableException::builder).build());
                    }
                    case "ServiceQuotaExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                    }
                    case "BackfillLimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BackfillLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BackfillLimitExceededException::builder).build());
                    }
                    case "InvalidNextTokenException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                    }
                    case "LimitExceededException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("LimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(LimitExceededException::builder).build());
                    }
                    case "ResourceNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                    }
                    case "UnknownMonitorException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("UnknownMonitorException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnknownMonitorException::builder).build());
                    }
                    case "AnalysisNotFoundException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("AnalysisNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AnalysisNotFoundException::builder).build());
                    }
                    case "TooManyTagsException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("TooManyTagsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TooManyTagsException::builder).build());
                    }
                    case "BillExpirationException": {
                        return Optional.of(ExceptionMetadata.builder().errorCode("BillExpirationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(BillExpirationException::builder).build());
                    }
                }
                return Optional.empty();
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateCostCategoryDefinition").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withMarshaller((Marshaller)new UpdateCostCategoryDefinitionRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)updateCostCategoryDefinitionRequest));
            CompletionStage whenCompleted = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCostExplorerAsyncClient.lambda$updateCostCategoryDefinition$174(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            executeFuture = CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleted, (CompletableFuture)executeFuture);
            return executeFuture;
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCostExplorerAsyncClient.lambda$updateCostCategoryDefinition$175((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public final CostExplorerServiceClientConfiguration serviceClientConfiguration() {
        return new CostExplorerServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    public final String serviceName() {
        return "ce";
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(CostExplorerException::builder).protocol(AwsJsonProtocol.AWS_JSON).protocolVersion("1.1");
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)AwsRetryStrategy.forRetryMode((RetryMode)retryMode));
        } else {
            Consumer configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)retryStrategy);
                }
            }
        }
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        if (plugins.isEmpty()) {
            return configuration.build();
        }
        CostExplorerServiceClientConfigurationBuilder serviceConfigBuilder = new CostExplorerServiceClientConfigurationBuilder(configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient((SdkServiceClientConfiguration.Builder)serviceConfigBuilder);
        }
        this.updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata, Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper) {
        return protocolFactory.createErrorResponseHandler(operationMetadata, exceptionMetadataMapper);
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$updateCostCategoryDefinition$175(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateCostCategoryDefinition$174(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateCostCategoryDefinitionResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateCostAllocationTagsStatus$171(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateCostAllocationTagsStatus$170(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateCostAllocationTagsStatusResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateAnomalySubscription$167(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateAnomalySubscription$166(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateAnomalySubscriptionResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$updateAnomalyMonitor$163(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateAnomalyMonitor$162(List metricPublishers, MetricCollector apiCallMetricCollector, UpdateAnomalyMonitorResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$untagResource$159(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$untagResource$158(List metricPublishers, MetricCollector apiCallMetricCollector, UntagResourceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$tagResource$155(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$tagResource$154(List metricPublishers, MetricCollector apiCallMetricCollector, TagResourceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$startSavingsPlansPurchaseRecommendationGeneration$151(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startSavingsPlansPurchaseRecommendationGeneration$150(List metricPublishers, MetricCollector apiCallMetricCollector, StartSavingsPlansPurchaseRecommendationGenerationResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$startCostAllocationTagBackfill$147(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startCostAllocationTagBackfill$146(List metricPublishers, MetricCollector apiCallMetricCollector, StartCostAllocationTagBackfillResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$startCommitmentPurchaseAnalysis$143(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startCommitmentPurchaseAnalysis$142(List metricPublishers, MetricCollector apiCallMetricCollector, StartCommitmentPurchaseAnalysisResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$provideAnomalyFeedback$139(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$provideAnomalyFeedback$138(List metricPublishers, MetricCollector apiCallMetricCollector, ProvideAnomalyFeedbackResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listTagsForResource$135(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTagsForResource$134(List metricPublishers, MetricCollector apiCallMetricCollector, ListTagsForResourceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listSavingsPlansPurchaseRecommendationGeneration$131(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listSavingsPlansPurchaseRecommendationGeneration$130(List metricPublishers, MetricCollector apiCallMetricCollector, ListSavingsPlansPurchaseRecommendationGenerationResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listCostCategoryDefinitions$127(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listCostCategoryDefinitions$126(List metricPublishers, MetricCollector apiCallMetricCollector, ListCostCategoryDefinitionsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listCostAllocationTags$123(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listCostAllocationTags$122(List metricPublishers, MetricCollector apiCallMetricCollector, ListCostAllocationTagsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listCostAllocationTagBackfillHistory$119(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listCostAllocationTagBackfillHistory$118(List metricPublishers, MetricCollector apiCallMetricCollector, ListCostAllocationTagBackfillHistoryResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listCommitmentPurchaseAnalyses$115(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listCommitmentPurchaseAnalyses$114(List metricPublishers, MetricCollector apiCallMetricCollector, ListCommitmentPurchaseAnalysesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getUsageForecast$111(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getUsageForecast$110(List metricPublishers, MetricCollector apiCallMetricCollector, GetUsageForecastResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getTags$107(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getTags$106(List metricPublishers, MetricCollector apiCallMetricCollector, GetTagsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getSavingsPlansUtilizationDetails$103(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getSavingsPlansUtilizationDetails$102(List metricPublishers, MetricCollector apiCallMetricCollector, GetSavingsPlansUtilizationDetailsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getSavingsPlansUtilization$99(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getSavingsPlansUtilization$98(List metricPublishers, MetricCollector apiCallMetricCollector, GetSavingsPlansUtilizationResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getSavingsPlansPurchaseRecommendation$95(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getSavingsPlansPurchaseRecommendation$94(List metricPublishers, MetricCollector apiCallMetricCollector, GetSavingsPlansPurchaseRecommendationResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getSavingsPlansCoverage$91(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getSavingsPlansCoverage$90(List metricPublishers, MetricCollector apiCallMetricCollector, GetSavingsPlansCoverageResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getSavingsPlanPurchaseRecommendationDetails$87(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getSavingsPlanPurchaseRecommendationDetails$86(List metricPublishers, MetricCollector apiCallMetricCollector, GetSavingsPlanPurchaseRecommendationDetailsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getRightsizingRecommendation$83(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getRightsizingRecommendation$82(List metricPublishers, MetricCollector apiCallMetricCollector, GetRightsizingRecommendationResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getReservationUtilization$79(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getReservationUtilization$78(List metricPublishers, MetricCollector apiCallMetricCollector, GetReservationUtilizationResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getReservationPurchaseRecommendation$75(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getReservationPurchaseRecommendation$74(List metricPublishers, MetricCollector apiCallMetricCollector, GetReservationPurchaseRecommendationResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getReservationCoverage$71(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getReservationCoverage$70(List metricPublishers, MetricCollector apiCallMetricCollector, GetReservationCoverageResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getDimensionValues$67(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getDimensionValues$66(List metricPublishers, MetricCollector apiCallMetricCollector, GetDimensionValuesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getCostForecast$63(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getCostForecast$62(List metricPublishers, MetricCollector apiCallMetricCollector, GetCostForecastResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getCostCategories$59(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getCostCategories$58(List metricPublishers, MetricCollector apiCallMetricCollector, GetCostCategoriesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getCostAndUsageWithResources$55(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getCostAndUsageWithResources$54(List metricPublishers, MetricCollector apiCallMetricCollector, GetCostAndUsageWithResourcesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getCostAndUsage$51(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getCostAndUsage$50(List metricPublishers, MetricCollector apiCallMetricCollector, GetCostAndUsageResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getCommitmentPurchaseAnalysis$47(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getCommitmentPurchaseAnalysis$46(List metricPublishers, MetricCollector apiCallMetricCollector, GetCommitmentPurchaseAnalysisResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getApproximateUsageRecords$43(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getApproximateUsageRecords$42(List metricPublishers, MetricCollector apiCallMetricCollector, GetApproximateUsageRecordsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getAnomalySubscriptions$39(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getAnomalySubscriptions$38(List metricPublishers, MetricCollector apiCallMetricCollector, GetAnomalySubscriptionsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getAnomalyMonitors$35(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getAnomalyMonitors$34(List metricPublishers, MetricCollector apiCallMetricCollector, GetAnomalyMonitorsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getAnomalies$31(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getAnomalies$30(List metricPublishers, MetricCollector apiCallMetricCollector, GetAnomaliesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeCostCategoryDefinition$27(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeCostCategoryDefinition$26(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeCostCategoryDefinitionResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteCostCategoryDefinition$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteCostCategoryDefinition$22(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteCostCategoryDefinitionResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteAnomalySubscription$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteAnomalySubscription$18(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteAnomalySubscriptionResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteAnomalyMonitor$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteAnomalyMonitor$14(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteAnomalyMonitorResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createCostCategoryDefinition$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createCostCategoryDefinition$10(List metricPublishers, MetricCollector apiCallMetricCollector, CreateCostCategoryDefinitionResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createAnomalySubscription$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createAnomalySubscription$6(List metricPublishers, MetricCollector apiCallMetricCollector, CreateAnomalySubscriptionResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$createAnomalyMonitor$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createAnomalyMonitor$2(List metricPublishers, MetricCollector apiCallMetricCollector, CreateAnomalyMonitorResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }
}

