/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.costexplorer.CostExplorerClient;
import software.amazon.awssdk.services.costexplorer.internal.UserAgentUtils;
import software.amazon.awssdk.services.costexplorer.model.ListCostCategoryDefinitionsRequest;
import software.amazon.awssdk.services.costexplorer.model.ListCostCategoryDefinitionsResponse;

public class ListCostCategoryDefinitionsIterable
implements SdkIterable<ListCostCategoryDefinitionsResponse> {
    private final CostExplorerClient client;
    private final ListCostCategoryDefinitionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListCostCategoryDefinitionsIterable(CostExplorerClient client, ListCostCategoryDefinitionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListCostCategoryDefinitionsResponseFetcher();
    }

    public Iterator<ListCostCategoryDefinitionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListCostCategoryDefinitionsResponseFetcher
    implements SyncPageFetcher<ListCostCategoryDefinitionsResponse> {
        private ListCostCategoryDefinitionsResponseFetcher() {
        }

        public boolean hasNextPage(ListCostCategoryDefinitionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListCostCategoryDefinitionsResponse nextPage(ListCostCategoryDefinitionsResponse previousPage) {
            if (previousPage == null) {
                return ListCostCategoryDefinitionsIterable.this.client.listCostCategoryDefinitions(ListCostCategoryDefinitionsIterable.this.firstRequest);
            }
            return ListCostCategoryDefinitionsIterable.this.client.listCostCategoryDefinitions((ListCostCategoryDefinitionsRequest)((Object)ListCostCategoryDefinitionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

