/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.costexplorer.model.CostExplorerRequest;
import software.amazon.awssdk.services.costexplorer.model.DateInterval;
import software.amazon.awssdk.services.costexplorer.model.Expression;
import software.amazon.awssdk.services.costexplorer.model.Granularity;
import software.amazon.awssdk.services.costexplorer.model.Metric;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetCostForecastRequest
extends CostExplorerRequest
implements ToCopyableBuilder<Builder, GetCostForecastRequest> {
    private static final SdkField<DateInterval> TIME_PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TimePeriod").getter(GetCostForecastRequest.getter(GetCostForecastRequest::timePeriod)).setter(GetCostForecastRequest.setter(Builder::timePeriod)).constructor(DateInterval::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimePeriod").build()}).build();
    private static final SdkField<String> METRIC_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Metric").getter(GetCostForecastRequest.getter(GetCostForecastRequest::metricAsString)).setter(GetCostForecastRequest.setter(Builder::metric)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Metric").build()}).build();
    private static final SdkField<String> GRANULARITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Granularity").getter(GetCostForecastRequest.getter(GetCostForecastRequest::granularityAsString)).setter(GetCostForecastRequest.setter(Builder::granularity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Granularity").build()}).build();
    private static final SdkField<Expression> FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Filter").getter(GetCostForecastRequest.getter(GetCostForecastRequest::filter)).setter(GetCostForecastRequest.setter(Builder::filter)).constructor(Expression::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter").build()}).build();
    private static final SdkField<String> BILLING_VIEW_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BillingViewArn").getter(GetCostForecastRequest.getter(GetCostForecastRequest::billingViewArn)).setter(GetCostForecastRequest.setter(Builder::billingViewArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BillingViewArn").build()}).build();
    private static final SdkField<Integer> PREDICTION_INTERVAL_LEVEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("PredictionIntervalLevel").getter(GetCostForecastRequest.getter(GetCostForecastRequest::predictionIntervalLevel)).setter(GetCostForecastRequest.setter(Builder::predictionIntervalLevel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PredictionIntervalLevel").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TIME_PERIOD_FIELD, METRIC_FIELD, GRANULARITY_FIELD, FILTER_FIELD, BILLING_VIEW_ARN_FIELD, PREDICTION_INTERVAL_LEVEL_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetCostForecastRequest.memberNameToFieldInitializer();
    private final DateInterval timePeriod;
    private final String metric;
    private final String granularity;
    private final Expression filter;
    private final String billingViewArn;
    private final Integer predictionIntervalLevel;

    private GetCostForecastRequest(BuilderImpl builder) {
        super(builder);
        this.timePeriod = builder.timePeriod;
        this.metric = builder.metric;
        this.granularity = builder.granularity;
        this.filter = builder.filter;
        this.billingViewArn = builder.billingViewArn;
        this.predictionIntervalLevel = builder.predictionIntervalLevel;
    }

    public final DateInterval timePeriod() {
        return this.timePeriod;
    }

    public final Metric metric() {
        return Metric.fromValue(this.metric);
    }

    public final String metricAsString() {
        return this.metric;
    }

    public final Granularity granularity() {
        return Granularity.fromValue(this.granularity);
    }

    public final String granularityAsString() {
        return this.granularity;
    }

    public final Expression filter() {
        return this.filter;
    }

    public final String billingViewArn() {
        return this.billingViewArn;
    }

    public final Integer predictionIntervalLevel() {
        return this.predictionIntervalLevel;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.timePeriod());
        hashCode = 31 * hashCode + Objects.hashCode(this.metricAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.granularityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.filter());
        hashCode = 31 * hashCode + Objects.hashCode(this.billingViewArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.predictionIntervalLevel());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCostForecastRequest)) {
            return false;
        }
        GetCostForecastRequest other = (GetCostForecastRequest)((Object)obj);
        return Objects.equals(this.timePeriod(), other.timePeriod()) && Objects.equals(this.metricAsString(), other.metricAsString()) && Objects.equals(this.granularityAsString(), other.granularityAsString()) && Objects.equals(this.filter(), other.filter()) && Objects.equals(this.billingViewArn(), other.billingViewArn()) && Objects.equals(this.predictionIntervalLevel(), other.predictionIntervalLevel());
    }

    public final String toString() {
        return ToString.builder((String)"GetCostForecastRequest").add("TimePeriod", (Object)this.timePeriod()).add("Metric", (Object)this.metricAsString()).add("Granularity", (Object)this.granularityAsString()).add("Filter", (Object)this.filter()).add("BillingViewArn", (Object)this.billingViewArn()).add("PredictionIntervalLevel", (Object)this.predictionIntervalLevel()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TimePeriod": {
                return Optional.ofNullable(clazz.cast(this.timePeriod()));
            }
            case "Metric": {
                return Optional.ofNullable(clazz.cast(this.metricAsString()));
            }
            case "Granularity": {
                return Optional.ofNullable(clazz.cast(this.granularityAsString()));
            }
            case "Filter": {
                return Optional.ofNullable(clazz.cast(this.filter()));
            }
            case "BillingViewArn": {
                return Optional.ofNullable(clazz.cast(this.billingViewArn()));
            }
            case "PredictionIntervalLevel": {
                return Optional.ofNullable(clazz.cast(this.predictionIntervalLevel()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("TimePeriod", TIME_PERIOD_FIELD);
        map.put("Metric", METRIC_FIELD);
        map.put("Granularity", GRANULARITY_FIELD);
        map.put("Filter", FILTER_FIELD);
        map.put("BillingViewArn", BILLING_VIEW_ARN_FIELD);
        map.put("PredictionIntervalLevel", PREDICTION_INTERVAL_LEVEL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetCostForecastRequest, T> g) {
        return obj -> g.apply((GetCostForecastRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CostExplorerRequest.BuilderImpl
    implements Builder {
        private DateInterval timePeriod;
        private String metric;
        private String granularity;
        private Expression filter;
        private String billingViewArn;
        private Integer predictionIntervalLevel;

        private BuilderImpl() {
        }

        private BuilderImpl(GetCostForecastRequest model) {
            super(model);
            this.timePeriod(model.timePeriod);
            this.metric(model.metric);
            this.granularity(model.granularity);
            this.filter(model.filter);
            this.billingViewArn(model.billingViewArn);
            this.predictionIntervalLevel(model.predictionIntervalLevel);
        }

        public final DateInterval.Builder getTimePeriod() {
            return this.timePeriod != null ? this.timePeriod.toBuilder() : null;
        }

        public final void setTimePeriod(DateInterval.BuilderImpl timePeriod) {
            this.timePeriod = timePeriod != null ? timePeriod.build() : null;
        }

        @Override
        public final Builder timePeriod(DateInterval timePeriod) {
            this.timePeriod = timePeriod;
            return this;
        }

        public final String getMetric() {
            return this.metric;
        }

        public final void setMetric(String metric) {
            this.metric = metric;
        }

        @Override
        public final Builder metric(String metric) {
            this.metric = metric;
            return this;
        }

        @Override
        public final Builder metric(Metric metric) {
            this.metric(metric == null ? null : metric.toString());
            return this;
        }

        public final String getGranularity() {
            return this.granularity;
        }

        public final void setGranularity(String granularity) {
            this.granularity = granularity;
        }

        @Override
        public final Builder granularity(String granularity) {
            this.granularity = granularity;
            return this;
        }

        @Override
        public final Builder granularity(Granularity granularity) {
            this.granularity(granularity == null ? null : granularity.toString());
            return this;
        }

        public final Expression.Builder getFilter() {
            return this.filter != null ? this.filter.toBuilder() : null;
        }

        public final void setFilter(Expression.BuilderImpl filter) {
            this.filter = filter != null ? filter.build() : null;
        }

        @Override
        public final Builder filter(Expression filter) {
            this.filter = filter;
            return this;
        }

        public final String getBillingViewArn() {
            return this.billingViewArn;
        }

        public final void setBillingViewArn(String billingViewArn) {
            this.billingViewArn = billingViewArn;
        }

        @Override
        public final Builder billingViewArn(String billingViewArn) {
            this.billingViewArn = billingViewArn;
            return this;
        }

        public final Integer getPredictionIntervalLevel() {
            return this.predictionIntervalLevel;
        }

        public final void setPredictionIntervalLevel(Integer predictionIntervalLevel) {
            this.predictionIntervalLevel = predictionIntervalLevel;
        }

        @Override
        public final Builder predictionIntervalLevel(Integer predictionIntervalLevel) {
            this.predictionIntervalLevel = predictionIntervalLevel;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetCostForecastRequest build() {
            return new GetCostForecastRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CostExplorerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetCostForecastRequest> {
        public Builder timePeriod(DateInterval var1);

        default public Builder timePeriod(Consumer<DateInterval.Builder> timePeriod) {
            return this.timePeriod((DateInterval)((DateInterval.Builder)DateInterval.builder().applyMutation(timePeriod)).build());
        }

        public Builder metric(String var1);

        public Builder metric(Metric var1);

        public Builder granularity(String var1);

        public Builder granularity(Granularity var1);

        public Builder filter(Expression var1);

        default public Builder filter(Consumer<Expression.Builder> filter) {
            return this.filter((Expression)((Expression.Builder)Expression.builder().applyMutation(filter)).build());
        }

        public Builder billingViewArn(String var1);

        public Builder predictionIntervalLevel(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

