/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.costexplorer.model.AnalysisStatus;
import software.amazon.awssdk.services.costexplorer.model.CommitmentPurchaseAnalysisConfiguration;
import software.amazon.awssdk.services.costexplorer.model.ErrorCode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AnalysisSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AnalysisSummary> {
    private static final SdkField<String> ESTIMATED_COMPLETION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EstimatedCompletionTime").getter(AnalysisSummary.getter(AnalysisSummary::estimatedCompletionTime)).setter(AnalysisSummary.setter(Builder::estimatedCompletionTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EstimatedCompletionTime").build()}).build();
    private static final SdkField<String> ANALYSIS_COMPLETION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AnalysisCompletionTime").getter(AnalysisSummary.getter(AnalysisSummary::analysisCompletionTime)).setter(AnalysisSummary.setter(Builder::analysisCompletionTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnalysisCompletionTime").build()}).build();
    private static final SdkField<String> ANALYSIS_STARTED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AnalysisStartedTime").getter(AnalysisSummary.getter(AnalysisSummary::analysisStartedTime)).setter(AnalysisSummary.setter(Builder::analysisStartedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnalysisStartedTime").build()}).build();
    private static final SdkField<String> ANALYSIS_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AnalysisStatus").getter(AnalysisSummary.getter(AnalysisSummary::analysisStatusAsString)).setter(AnalysisSummary.setter(Builder::analysisStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnalysisStatus").build()}).build();
    private static final SdkField<String> ERROR_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ErrorCode").getter(AnalysisSummary.getter(AnalysisSummary::errorCodeAsString)).setter(AnalysisSummary.setter(Builder::errorCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorCode").build()}).build();
    private static final SdkField<String> ANALYSIS_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AnalysisId").getter(AnalysisSummary.getter(AnalysisSummary::analysisId)).setter(AnalysisSummary.setter(Builder::analysisId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnalysisId").build()}).build();
    private static final SdkField<CommitmentPurchaseAnalysisConfiguration> COMMITMENT_PURCHASE_ANALYSIS_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CommitmentPurchaseAnalysisConfiguration").getter(AnalysisSummary.getter(AnalysisSummary::commitmentPurchaseAnalysisConfiguration)).setter(AnalysisSummary.setter(Builder::commitmentPurchaseAnalysisConfiguration)).constructor(CommitmentPurchaseAnalysisConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CommitmentPurchaseAnalysisConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ESTIMATED_COMPLETION_TIME_FIELD, ANALYSIS_COMPLETION_TIME_FIELD, ANALYSIS_STARTED_TIME_FIELD, ANALYSIS_STATUS_FIELD, ERROR_CODE_FIELD, ANALYSIS_ID_FIELD, COMMITMENT_PURCHASE_ANALYSIS_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("EstimatedCompletionTime", ESTIMATED_COMPLETION_TIME_FIELD);
            this.put("AnalysisCompletionTime", ANALYSIS_COMPLETION_TIME_FIELD);
            this.put("AnalysisStartedTime", ANALYSIS_STARTED_TIME_FIELD);
            this.put("AnalysisStatus", ANALYSIS_STATUS_FIELD);
            this.put("ErrorCode", ERROR_CODE_FIELD);
            this.put("AnalysisId", ANALYSIS_ID_FIELD);
            this.put("CommitmentPurchaseAnalysisConfiguration", COMMITMENT_PURCHASE_ANALYSIS_CONFIGURATION_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String estimatedCompletionTime;
    private final String analysisCompletionTime;
    private final String analysisStartedTime;
    private final String analysisStatus;
    private final String errorCode;
    private final String analysisId;
    private final CommitmentPurchaseAnalysisConfiguration commitmentPurchaseAnalysisConfiguration;

    private AnalysisSummary(BuilderImpl builder) {
        this.estimatedCompletionTime = builder.estimatedCompletionTime;
        this.analysisCompletionTime = builder.analysisCompletionTime;
        this.analysisStartedTime = builder.analysisStartedTime;
        this.analysisStatus = builder.analysisStatus;
        this.errorCode = builder.errorCode;
        this.analysisId = builder.analysisId;
        this.commitmentPurchaseAnalysisConfiguration = builder.commitmentPurchaseAnalysisConfiguration;
    }

    public final String estimatedCompletionTime() {
        return this.estimatedCompletionTime;
    }

    public final String analysisCompletionTime() {
        return this.analysisCompletionTime;
    }

    public final String analysisStartedTime() {
        return this.analysisStartedTime;
    }

    public final AnalysisStatus analysisStatus() {
        return AnalysisStatus.fromValue(this.analysisStatus);
    }

    public final String analysisStatusAsString() {
        return this.analysisStatus;
    }

    public final ErrorCode errorCode() {
        return ErrorCode.fromValue(this.errorCode);
    }

    public final String errorCodeAsString() {
        return this.errorCode;
    }

    public final String analysisId() {
        return this.analysisId;
    }

    public final CommitmentPurchaseAnalysisConfiguration commitmentPurchaseAnalysisConfiguration() {
        return this.commitmentPurchaseAnalysisConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.estimatedCompletionTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.analysisCompletionTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.analysisStartedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.analysisStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.analysisId());
        hashCode = 31 * hashCode + Objects.hashCode(this.commitmentPurchaseAnalysisConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnalysisSummary)) {
            return false;
        }
        AnalysisSummary other = (AnalysisSummary)obj;
        return Objects.equals(this.estimatedCompletionTime(), other.estimatedCompletionTime()) && Objects.equals(this.analysisCompletionTime(), other.analysisCompletionTime()) && Objects.equals(this.analysisStartedTime(), other.analysisStartedTime()) && Objects.equals(this.analysisStatusAsString(), other.analysisStatusAsString()) && Objects.equals(this.errorCodeAsString(), other.errorCodeAsString()) && Objects.equals(this.analysisId(), other.analysisId()) && Objects.equals(this.commitmentPurchaseAnalysisConfiguration(), other.commitmentPurchaseAnalysisConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"AnalysisSummary").add("EstimatedCompletionTime", (Object)this.estimatedCompletionTime()).add("AnalysisCompletionTime", (Object)this.analysisCompletionTime()).add("AnalysisStartedTime", (Object)this.analysisStartedTime()).add("AnalysisStatus", (Object)this.analysisStatusAsString()).add("ErrorCode", (Object)this.errorCodeAsString()).add("AnalysisId", (Object)this.analysisId()).add("CommitmentPurchaseAnalysisConfiguration", (Object)this.commitmentPurchaseAnalysisConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EstimatedCompletionTime": {
                return Optional.ofNullable(clazz.cast(this.estimatedCompletionTime()));
            }
            case "AnalysisCompletionTime": {
                return Optional.ofNullable(clazz.cast(this.analysisCompletionTime()));
            }
            case "AnalysisStartedTime": {
                return Optional.ofNullable(clazz.cast(this.analysisStartedTime()));
            }
            case "AnalysisStatus": {
                return Optional.ofNullable(clazz.cast(this.analysisStatusAsString()));
            }
            case "ErrorCode": {
                return Optional.ofNullable(clazz.cast(this.errorCodeAsString()));
            }
            case "AnalysisId": {
                return Optional.ofNullable(clazz.cast(this.analysisId()));
            }
            case "CommitmentPurchaseAnalysisConfiguration": {
                return Optional.ofNullable(clazz.cast(this.commitmentPurchaseAnalysisConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AnalysisSummary, T> g) {
        return obj -> g.apply((AnalysisSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String estimatedCompletionTime;
        private String analysisCompletionTime;
        private String analysisStartedTime;
        private String analysisStatus;
        private String errorCode;
        private String analysisId;
        private CommitmentPurchaseAnalysisConfiguration commitmentPurchaseAnalysisConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(AnalysisSummary model) {
            this.estimatedCompletionTime(model.estimatedCompletionTime);
            this.analysisCompletionTime(model.analysisCompletionTime);
            this.analysisStartedTime(model.analysisStartedTime);
            this.analysisStatus(model.analysisStatus);
            this.errorCode(model.errorCode);
            this.analysisId(model.analysisId);
            this.commitmentPurchaseAnalysisConfiguration(model.commitmentPurchaseAnalysisConfiguration);
        }

        public final String getEstimatedCompletionTime() {
            return this.estimatedCompletionTime;
        }

        public final void setEstimatedCompletionTime(String estimatedCompletionTime) {
            this.estimatedCompletionTime = estimatedCompletionTime;
        }

        @Override
        public final Builder estimatedCompletionTime(String estimatedCompletionTime) {
            this.estimatedCompletionTime = estimatedCompletionTime;
            return this;
        }

        public final String getAnalysisCompletionTime() {
            return this.analysisCompletionTime;
        }

        public final void setAnalysisCompletionTime(String analysisCompletionTime) {
            this.analysisCompletionTime = analysisCompletionTime;
        }

        @Override
        public final Builder analysisCompletionTime(String analysisCompletionTime) {
            this.analysisCompletionTime = analysisCompletionTime;
            return this;
        }

        public final String getAnalysisStartedTime() {
            return this.analysisStartedTime;
        }

        public final void setAnalysisStartedTime(String analysisStartedTime) {
            this.analysisStartedTime = analysisStartedTime;
        }

        @Override
        public final Builder analysisStartedTime(String analysisStartedTime) {
            this.analysisStartedTime = analysisStartedTime;
            return this;
        }

        public final String getAnalysisStatus() {
            return this.analysisStatus;
        }

        public final void setAnalysisStatus(String analysisStatus) {
            this.analysisStatus = analysisStatus;
        }

        @Override
        public final Builder analysisStatus(String analysisStatus) {
            this.analysisStatus = analysisStatus;
            return this;
        }

        @Override
        public final Builder analysisStatus(AnalysisStatus analysisStatus) {
            this.analysisStatus(analysisStatus == null ? null : analysisStatus.toString());
            return this;
        }

        public final String getErrorCode() {
            return this.errorCode;
        }

        public final void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        @Override
        public final Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        @Override
        public final Builder errorCode(ErrorCode errorCode) {
            this.errorCode(errorCode == null ? null : errorCode.toString());
            return this;
        }

        public final String getAnalysisId() {
            return this.analysisId;
        }

        public final void setAnalysisId(String analysisId) {
            this.analysisId = analysisId;
        }

        @Override
        public final Builder analysisId(String analysisId) {
            this.analysisId = analysisId;
            return this;
        }

        public final CommitmentPurchaseAnalysisConfiguration.Builder getCommitmentPurchaseAnalysisConfiguration() {
            return this.commitmentPurchaseAnalysisConfiguration != null ? this.commitmentPurchaseAnalysisConfiguration.toBuilder() : null;
        }

        public final void setCommitmentPurchaseAnalysisConfiguration(CommitmentPurchaseAnalysisConfiguration.BuilderImpl commitmentPurchaseAnalysisConfiguration) {
            this.commitmentPurchaseAnalysisConfiguration = commitmentPurchaseAnalysisConfiguration != null ? commitmentPurchaseAnalysisConfiguration.build() : null;
        }

        @Override
        public final Builder commitmentPurchaseAnalysisConfiguration(CommitmentPurchaseAnalysisConfiguration commitmentPurchaseAnalysisConfiguration) {
            this.commitmentPurchaseAnalysisConfiguration = commitmentPurchaseAnalysisConfiguration;
            return this;
        }

        public AnalysisSummary build() {
            return new AnalysisSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AnalysisSummary> {
        public Builder estimatedCompletionTime(String var1);

        public Builder analysisCompletionTime(String var1);

        public Builder analysisStartedTime(String var1);

        public Builder analysisStatus(String var1);

        public Builder analysisStatus(AnalysisStatus var1);

        public Builder errorCode(String var1);

        public Builder errorCode(ErrorCode var1);

        public Builder analysisId(String var1);

        public Builder commitmentPurchaseAnalysisConfiguration(CommitmentPurchaseAnalysisConfiguration var1);

        default public Builder commitmentPurchaseAnalysisConfiguration(Consumer<CommitmentPurchaseAnalysisConfiguration.Builder> commitmentPurchaseAnalysisConfiguration) {
            return this.commitmentPurchaseAnalysisConfiguration((CommitmentPurchaseAnalysisConfiguration)((CommitmentPurchaseAnalysisConfiguration.Builder)CommitmentPurchaseAnalysisConfiguration.builder().applyMutation(commitmentPurchaseAnalysisConfiguration)).build());
        }
    }
}

