/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costexplorer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about the reservations that Amazon Web Services recommends that you purchase.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InstanceDetails implements SdkPojo, Serializable, ToCopyableBuilder<InstanceDetails.Builder, InstanceDetails> {
    private static final SdkField<EC2InstanceDetails> EC2_INSTANCE_DETAILS_FIELD = SdkField
            .<EC2InstanceDetails> builder(MarshallingType.SDK_POJO).memberName("EC2InstanceDetails")
            .getter(getter(InstanceDetails::ec2InstanceDetails)).setter(setter(Builder::ec2InstanceDetails))
            .constructor(EC2InstanceDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EC2InstanceDetails").build())
            .build();

    private static final SdkField<RDSInstanceDetails> RDS_INSTANCE_DETAILS_FIELD = SdkField
            .<RDSInstanceDetails> builder(MarshallingType.SDK_POJO).memberName("RDSInstanceDetails")
            .getter(getter(InstanceDetails::rdsInstanceDetails)).setter(setter(Builder::rdsInstanceDetails))
            .constructor(RDSInstanceDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RDSInstanceDetails").build())
            .build();

    private static final SdkField<RedshiftInstanceDetails> REDSHIFT_INSTANCE_DETAILS_FIELD = SdkField
            .<RedshiftInstanceDetails> builder(MarshallingType.SDK_POJO).memberName("RedshiftInstanceDetails")
            .getter(getter(InstanceDetails::redshiftInstanceDetails)).setter(setter(Builder::redshiftInstanceDetails))
            .constructor(RedshiftInstanceDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RedshiftInstanceDetails").build())
            .build();

    private static final SdkField<ElastiCacheInstanceDetails> ELASTI_CACHE_INSTANCE_DETAILS_FIELD = SdkField
            .<ElastiCacheInstanceDetails> builder(MarshallingType.SDK_POJO)
            .memberName("ElastiCacheInstanceDetails")
            .getter(getter(InstanceDetails::elastiCacheInstanceDetails))
            .setter(setter(Builder::elastiCacheInstanceDetails))
            .constructor(ElastiCacheInstanceDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ElastiCacheInstanceDetails").build())
            .build();

    private static final SdkField<ESInstanceDetails> ES_INSTANCE_DETAILS_FIELD = SdkField
            .<ESInstanceDetails> builder(MarshallingType.SDK_POJO).memberName("ESInstanceDetails")
            .getter(getter(InstanceDetails::esInstanceDetails)).setter(setter(Builder::esInstanceDetails))
            .constructor(ESInstanceDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ESInstanceDetails").build()).build();

    private static final SdkField<MemoryDBInstanceDetails> MEMORY_DB_INSTANCE_DETAILS_FIELD = SdkField
            .<MemoryDBInstanceDetails> builder(MarshallingType.SDK_POJO).memberName("MemoryDBInstanceDetails")
            .getter(getter(InstanceDetails::memoryDBInstanceDetails)).setter(setter(Builder::memoryDBInstanceDetails))
            .constructor(MemoryDBInstanceDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MemoryDBInstanceDetails").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EC2_INSTANCE_DETAILS_FIELD,
            RDS_INSTANCE_DETAILS_FIELD, REDSHIFT_INSTANCE_DETAILS_FIELD, ELASTI_CACHE_INSTANCE_DETAILS_FIELD,
            ES_INSTANCE_DETAILS_FIELD, MEMORY_DB_INSTANCE_DETAILS_FIELD));

    private static final long serialVersionUID = 1L;

    private final EC2InstanceDetails ec2InstanceDetails;

    private final RDSInstanceDetails rdsInstanceDetails;

    private final RedshiftInstanceDetails redshiftInstanceDetails;

    private final ElastiCacheInstanceDetails elastiCacheInstanceDetails;

    private final ESInstanceDetails esInstanceDetails;

    private final MemoryDBInstanceDetails memoryDBInstanceDetails;

    private InstanceDetails(BuilderImpl builder) {
        this.ec2InstanceDetails = builder.ec2InstanceDetails;
        this.rdsInstanceDetails = builder.rdsInstanceDetails;
        this.redshiftInstanceDetails = builder.redshiftInstanceDetails;
        this.elastiCacheInstanceDetails = builder.elastiCacheInstanceDetails;
        this.esInstanceDetails = builder.esInstanceDetails;
        this.memoryDBInstanceDetails = builder.memoryDBInstanceDetails;
    }

    /**
     * <p>
     * The Amazon EC2 reservations that Amazon Web Services recommends that you purchase.
     * </p>
     * 
     * @return The Amazon EC2 reservations that Amazon Web Services recommends that you purchase.
     */
    public final EC2InstanceDetails ec2InstanceDetails() {
        return ec2InstanceDetails;
    }

    /**
     * <p>
     * The Amazon RDS reservations that Amazon Web Services recommends that you purchase.
     * </p>
     * 
     * @return The Amazon RDS reservations that Amazon Web Services recommends that you purchase.
     */
    public final RDSInstanceDetails rdsInstanceDetails() {
        return rdsInstanceDetails;
    }

    /**
     * <p>
     * The Amazon Redshift reservations that Amazon Web Services recommends that you purchase.
     * </p>
     * 
     * @return The Amazon Redshift reservations that Amazon Web Services recommends that you purchase.
     */
    public final RedshiftInstanceDetails redshiftInstanceDetails() {
        return redshiftInstanceDetails;
    }

    /**
     * <p>
     * The ElastiCache reservations that Amazon Web Services recommends that you purchase.
     * </p>
     * 
     * @return The ElastiCache reservations that Amazon Web Services recommends that you purchase.
     */
    public final ElastiCacheInstanceDetails elastiCacheInstanceDetails() {
        return elastiCacheInstanceDetails;
    }

    /**
     * <p>
     * The Amazon OpenSearch Service reservations that Amazon Web Services recommends that you purchase.
     * </p>
     * 
     * @return The Amazon OpenSearch Service reservations that Amazon Web Services recommends that you purchase.
     */
    public final ESInstanceDetails esInstanceDetails() {
        return esInstanceDetails;
    }

    /**
     * <p>
     * The MemoryDB reservations that Amazon Web Services recommends that you purchase.
     * </p>
     * 
     * @return The MemoryDB reservations that Amazon Web Services recommends that you purchase.
     */
    public final MemoryDBInstanceDetails memoryDBInstanceDetails() {
        return memoryDBInstanceDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ec2InstanceDetails());
        hashCode = 31 * hashCode + Objects.hashCode(rdsInstanceDetails());
        hashCode = 31 * hashCode + Objects.hashCode(redshiftInstanceDetails());
        hashCode = 31 * hashCode + Objects.hashCode(elastiCacheInstanceDetails());
        hashCode = 31 * hashCode + Objects.hashCode(esInstanceDetails());
        hashCode = 31 * hashCode + Objects.hashCode(memoryDBInstanceDetails());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceDetails)) {
            return false;
        }
        InstanceDetails other = (InstanceDetails) obj;
        return Objects.equals(ec2InstanceDetails(), other.ec2InstanceDetails())
                && Objects.equals(rdsInstanceDetails(), other.rdsInstanceDetails())
                && Objects.equals(redshiftInstanceDetails(), other.redshiftInstanceDetails())
                && Objects.equals(elastiCacheInstanceDetails(), other.elastiCacheInstanceDetails())
                && Objects.equals(esInstanceDetails(), other.esInstanceDetails())
                && Objects.equals(memoryDBInstanceDetails(), other.memoryDBInstanceDetails());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InstanceDetails").add("EC2InstanceDetails", ec2InstanceDetails())
                .add("RDSInstanceDetails", rdsInstanceDetails()).add("RedshiftInstanceDetails", redshiftInstanceDetails())
                .add("ElastiCacheInstanceDetails", elastiCacheInstanceDetails()).add("ESInstanceDetails", esInstanceDetails())
                .add("MemoryDBInstanceDetails", memoryDBInstanceDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EC2InstanceDetails":
            return Optional.ofNullable(clazz.cast(ec2InstanceDetails()));
        case "RDSInstanceDetails":
            return Optional.ofNullable(clazz.cast(rdsInstanceDetails()));
        case "RedshiftInstanceDetails":
            return Optional.ofNullable(clazz.cast(redshiftInstanceDetails()));
        case "ElastiCacheInstanceDetails":
            return Optional.ofNullable(clazz.cast(elastiCacheInstanceDetails()));
        case "ESInstanceDetails":
            return Optional.ofNullable(clazz.cast(esInstanceDetails()));
        case "MemoryDBInstanceDetails":
            return Optional.ofNullable(clazz.cast(memoryDBInstanceDetails()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InstanceDetails, T> g) {
        return obj -> g.apply((InstanceDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InstanceDetails> {
        /**
         * <p>
         * The Amazon EC2 reservations that Amazon Web Services recommends that you purchase.
         * </p>
         * 
         * @param ec2InstanceDetails
         *        The Amazon EC2 reservations that Amazon Web Services recommends that you purchase.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ec2InstanceDetails(EC2InstanceDetails ec2InstanceDetails);

        /**
         * <p>
         * The Amazon EC2 reservations that Amazon Web Services recommends that you purchase.
         * </p>
         * This is a convenience method that creates an instance of the {@link EC2InstanceDetails.Builder} avoiding the
         * need to create one manually via {@link EC2InstanceDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EC2InstanceDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #ec2InstanceDetails(EC2InstanceDetails)}.
         * 
         * @param ec2InstanceDetails
         *        a consumer that will call methods on {@link EC2InstanceDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ec2InstanceDetails(EC2InstanceDetails)
         */
        default Builder ec2InstanceDetails(Consumer<EC2InstanceDetails.Builder> ec2InstanceDetails) {
            return ec2InstanceDetails(EC2InstanceDetails.builder().applyMutation(ec2InstanceDetails).build());
        }

        /**
         * <p>
         * The Amazon RDS reservations that Amazon Web Services recommends that you purchase.
         * </p>
         * 
         * @param rdsInstanceDetails
         *        The Amazon RDS reservations that Amazon Web Services recommends that you purchase.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rdsInstanceDetails(RDSInstanceDetails rdsInstanceDetails);

        /**
         * <p>
         * The Amazon RDS reservations that Amazon Web Services recommends that you purchase.
         * </p>
         * This is a convenience method that creates an instance of the {@link RDSInstanceDetails.Builder} avoiding the
         * need to create one manually via {@link RDSInstanceDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RDSInstanceDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #rdsInstanceDetails(RDSInstanceDetails)}.
         * 
         * @param rdsInstanceDetails
         *        a consumer that will call methods on {@link RDSInstanceDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rdsInstanceDetails(RDSInstanceDetails)
         */
        default Builder rdsInstanceDetails(Consumer<RDSInstanceDetails.Builder> rdsInstanceDetails) {
            return rdsInstanceDetails(RDSInstanceDetails.builder().applyMutation(rdsInstanceDetails).build());
        }

        /**
         * <p>
         * The Amazon Redshift reservations that Amazon Web Services recommends that you purchase.
         * </p>
         * 
         * @param redshiftInstanceDetails
         *        The Amazon Redshift reservations that Amazon Web Services recommends that you purchase.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder redshiftInstanceDetails(RedshiftInstanceDetails redshiftInstanceDetails);

        /**
         * <p>
         * The Amazon Redshift reservations that Amazon Web Services recommends that you purchase.
         * </p>
         * This is a convenience method that creates an instance of the {@link RedshiftInstanceDetails.Builder} avoiding
         * the need to create one manually via {@link RedshiftInstanceDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RedshiftInstanceDetails.Builder#build()} is called immediately
         * and its result is passed to {@link #redshiftInstanceDetails(RedshiftInstanceDetails)}.
         * 
         * @param redshiftInstanceDetails
         *        a consumer that will call methods on {@link RedshiftInstanceDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #redshiftInstanceDetails(RedshiftInstanceDetails)
         */
        default Builder redshiftInstanceDetails(Consumer<RedshiftInstanceDetails.Builder> redshiftInstanceDetails) {
            return redshiftInstanceDetails(RedshiftInstanceDetails.builder().applyMutation(redshiftInstanceDetails).build());
        }

        /**
         * <p>
         * The ElastiCache reservations that Amazon Web Services recommends that you purchase.
         * </p>
         * 
         * @param elastiCacheInstanceDetails
         *        The ElastiCache reservations that Amazon Web Services recommends that you purchase.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder elastiCacheInstanceDetails(ElastiCacheInstanceDetails elastiCacheInstanceDetails);

        /**
         * <p>
         * The ElastiCache reservations that Amazon Web Services recommends that you purchase.
         * </p>
         * This is a convenience method that creates an instance of the {@link ElastiCacheInstanceDetails.Builder}
         * avoiding the need to create one manually via {@link ElastiCacheInstanceDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ElastiCacheInstanceDetails.Builder#build()} is called immediately
         * and its result is passed to {@link #elastiCacheInstanceDetails(ElastiCacheInstanceDetails)}.
         * 
         * @param elastiCacheInstanceDetails
         *        a consumer that will call methods on {@link ElastiCacheInstanceDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #elastiCacheInstanceDetails(ElastiCacheInstanceDetails)
         */
        default Builder elastiCacheInstanceDetails(Consumer<ElastiCacheInstanceDetails.Builder> elastiCacheInstanceDetails) {
            return elastiCacheInstanceDetails(ElastiCacheInstanceDetails.builder().applyMutation(elastiCacheInstanceDetails)
                    .build());
        }

        /**
         * <p>
         * The Amazon OpenSearch Service reservations that Amazon Web Services recommends that you purchase.
         * </p>
         * 
         * @param esInstanceDetails
         *        The Amazon OpenSearch Service reservations that Amazon Web Services recommends that you purchase.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder esInstanceDetails(ESInstanceDetails esInstanceDetails);

        /**
         * <p>
         * The Amazon OpenSearch Service reservations that Amazon Web Services recommends that you purchase.
         * </p>
         * This is a convenience method that creates an instance of the {@link ESInstanceDetails.Builder} avoiding the
         * need to create one manually via {@link ESInstanceDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ESInstanceDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #esInstanceDetails(ESInstanceDetails)}.
         * 
         * @param esInstanceDetails
         *        a consumer that will call methods on {@link ESInstanceDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #esInstanceDetails(ESInstanceDetails)
         */
        default Builder esInstanceDetails(Consumer<ESInstanceDetails.Builder> esInstanceDetails) {
            return esInstanceDetails(ESInstanceDetails.builder().applyMutation(esInstanceDetails).build());
        }

        /**
         * <p>
         * The MemoryDB reservations that Amazon Web Services recommends that you purchase.
         * </p>
         * 
         * @param memoryDBInstanceDetails
         *        The MemoryDB reservations that Amazon Web Services recommends that you purchase.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memoryDBInstanceDetails(MemoryDBInstanceDetails memoryDBInstanceDetails);

        /**
         * <p>
         * The MemoryDB reservations that Amazon Web Services recommends that you purchase.
         * </p>
         * This is a convenience method that creates an instance of the {@link MemoryDBInstanceDetails.Builder} avoiding
         * the need to create one manually via {@link MemoryDBInstanceDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MemoryDBInstanceDetails.Builder#build()} is called immediately
         * and its result is passed to {@link #memoryDBInstanceDetails(MemoryDBInstanceDetails)}.
         * 
         * @param memoryDBInstanceDetails
         *        a consumer that will call methods on {@link MemoryDBInstanceDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #memoryDBInstanceDetails(MemoryDBInstanceDetails)
         */
        default Builder memoryDBInstanceDetails(Consumer<MemoryDBInstanceDetails.Builder> memoryDBInstanceDetails) {
            return memoryDBInstanceDetails(MemoryDBInstanceDetails.builder().applyMutation(memoryDBInstanceDetails).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private EC2InstanceDetails ec2InstanceDetails;

        private RDSInstanceDetails rdsInstanceDetails;

        private RedshiftInstanceDetails redshiftInstanceDetails;

        private ElastiCacheInstanceDetails elastiCacheInstanceDetails;

        private ESInstanceDetails esInstanceDetails;

        private MemoryDBInstanceDetails memoryDBInstanceDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceDetails model) {
            ec2InstanceDetails(model.ec2InstanceDetails);
            rdsInstanceDetails(model.rdsInstanceDetails);
            redshiftInstanceDetails(model.redshiftInstanceDetails);
            elastiCacheInstanceDetails(model.elastiCacheInstanceDetails);
            esInstanceDetails(model.esInstanceDetails);
            memoryDBInstanceDetails(model.memoryDBInstanceDetails);
        }

        public final EC2InstanceDetails.Builder getEc2InstanceDetails() {
            return ec2InstanceDetails != null ? ec2InstanceDetails.toBuilder() : null;
        }

        public final void setEc2InstanceDetails(EC2InstanceDetails.BuilderImpl ec2InstanceDetails) {
            this.ec2InstanceDetails = ec2InstanceDetails != null ? ec2InstanceDetails.build() : null;
        }

        @Override
        public final Builder ec2InstanceDetails(EC2InstanceDetails ec2InstanceDetails) {
            this.ec2InstanceDetails = ec2InstanceDetails;
            return this;
        }

        public final RDSInstanceDetails.Builder getRdsInstanceDetails() {
            return rdsInstanceDetails != null ? rdsInstanceDetails.toBuilder() : null;
        }

        public final void setRdsInstanceDetails(RDSInstanceDetails.BuilderImpl rdsInstanceDetails) {
            this.rdsInstanceDetails = rdsInstanceDetails != null ? rdsInstanceDetails.build() : null;
        }

        @Override
        public final Builder rdsInstanceDetails(RDSInstanceDetails rdsInstanceDetails) {
            this.rdsInstanceDetails = rdsInstanceDetails;
            return this;
        }

        public final RedshiftInstanceDetails.Builder getRedshiftInstanceDetails() {
            return redshiftInstanceDetails != null ? redshiftInstanceDetails.toBuilder() : null;
        }

        public final void setRedshiftInstanceDetails(RedshiftInstanceDetails.BuilderImpl redshiftInstanceDetails) {
            this.redshiftInstanceDetails = redshiftInstanceDetails != null ? redshiftInstanceDetails.build() : null;
        }

        @Override
        public final Builder redshiftInstanceDetails(RedshiftInstanceDetails redshiftInstanceDetails) {
            this.redshiftInstanceDetails = redshiftInstanceDetails;
            return this;
        }

        public final ElastiCacheInstanceDetails.Builder getElastiCacheInstanceDetails() {
            return elastiCacheInstanceDetails != null ? elastiCacheInstanceDetails.toBuilder() : null;
        }

        public final void setElastiCacheInstanceDetails(ElastiCacheInstanceDetails.BuilderImpl elastiCacheInstanceDetails) {
            this.elastiCacheInstanceDetails = elastiCacheInstanceDetails != null ? elastiCacheInstanceDetails.build() : null;
        }

        @Override
        public final Builder elastiCacheInstanceDetails(ElastiCacheInstanceDetails elastiCacheInstanceDetails) {
            this.elastiCacheInstanceDetails = elastiCacheInstanceDetails;
            return this;
        }

        public final ESInstanceDetails.Builder getEsInstanceDetails() {
            return esInstanceDetails != null ? esInstanceDetails.toBuilder() : null;
        }

        public final void setEsInstanceDetails(ESInstanceDetails.BuilderImpl esInstanceDetails) {
            this.esInstanceDetails = esInstanceDetails != null ? esInstanceDetails.build() : null;
        }

        @Override
        public final Builder esInstanceDetails(ESInstanceDetails esInstanceDetails) {
            this.esInstanceDetails = esInstanceDetails;
            return this;
        }

        public final MemoryDBInstanceDetails.Builder getMemoryDBInstanceDetails() {
            return memoryDBInstanceDetails != null ? memoryDBInstanceDetails.toBuilder() : null;
        }

        public final void setMemoryDBInstanceDetails(MemoryDBInstanceDetails.BuilderImpl memoryDBInstanceDetails) {
            this.memoryDBInstanceDetails = memoryDBInstanceDetails != null ? memoryDBInstanceDetails.build() : null;
        }

        @Override
        public final Builder memoryDBInstanceDetails(MemoryDBInstanceDetails memoryDBInstanceDetails) {
            this.memoryDBInstanceDetails = memoryDBInstanceDetails;
            return this;
        }

        @Override
        public InstanceDetails build() {
            return new InstanceDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
