/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.costexplorer.model.AnomalyDateInterval;
import software.amazon.awssdk.services.costexplorer.model.AnomalyFeedbackType;
import software.amazon.awssdk.services.costexplorer.model.CostExplorerRequest;
import software.amazon.awssdk.services.costexplorer.model.TotalImpactFilter;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetAnomaliesRequest
extends CostExplorerRequest
implements ToCopyableBuilder<Builder, GetAnomaliesRequest> {
    private static final SdkField<String> MONITOR_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MonitorArn").getter(GetAnomaliesRequest.getter(GetAnomaliesRequest::monitorArn)).setter(GetAnomaliesRequest.setter(Builder::monitorArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitorArn").build()}).build();
    private static final SdkField<AnomalyDateInterval> DATE_INTERVAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DateInterval").getter(GetAnomaliesRequest.getter(GetAnomaliesRequest::dateInterval)).setter(GetAnomaliesRequest.setter(Builder::dateInterval)).constructor(AnomalyDateInterval::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DateInterval").build()}).build();
    private static final SdkField<String> FEEDBACK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Feedback").getter(GetAnomaliesRequest.getter(GetAnomaliesRequest::feedbackAsString)).setter(GetAnomaliesRequest.setter(Builder::feedback)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Feedback").build()}).build();
    private static final SdkField<TotalImpactFilter> TOTAL_IMPACT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TotalImpact").getter(GetAnomaliesRequest.getter(GetAnomaliesRequest::totalImpact)).setter(GetAnomaliesRequest.setter(Builder::totalImpact)).constructor(TotalImpactFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalImpact").build()}).build();
    private static final SdkField<String> NEXT_PAGE_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextPageToken").getter(GetAnomaliesRequest.getter(GetAnomaliesRequest::nextPageToken)).setter(GetAnomaliesRequest.setter(Builder::nextPageToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextPageToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(GetAnomaliesRequest.getter(GetAnomaliesRequest::maxResults)).setter(GetAnomaliesRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MONITOR_ARN_FIELD, DATE_INTERVAL_FIELD, FEEDBACK_FIELD, TOTAL_IMPACT_FIELD, NEXT_PAGE_TOKEN_FIELD, MAX_RESULTS_FIELD));
    private final String monitorArn;
    private final AnomalyDateInterval dateInterval;
    private final String feedback;
    private final TotalImpactFilter totalImpact;
    private final String nextPageToken;
    private final Integer maxResults;

    private GetAnomaliesRequest(BuilderImpl builder) {
        super(builder);
        this.monitorArn = builder.monitorArn;
        this.dateInterval = builder.dateInterval;
        this.feedback = builder.feedback;
        this.totalImpact = builder.totalImpact;
        this.nextPageToken = builder.nextPageToken;
        this.maxResults = builder.maxResults;
    }

    public final String monitorArn() {
        return this.monitorArn;
    }

    public final AnomalyDateInterval dateInterval() {
        return this.dateInterval;
    }

    public final AnomalyFeedbackType feedback() {
        return AnomalyFeedbackType.fromValue(this.feedback);
    }

    public final String feedbackAsString() {
        return this.feedback;
    }

    public final TotalImpactFilter totalImpact() {
        return this.totalImpact;
    }

    public final String nextPageToken() {
        return this.nextPageToken;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.monitorArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.dateInterval());
        hashCode = 31 * hashCode + Objects.hashCode(this.feedbackAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalImpact());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextPageToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAnomaliesRequest)) {
            return false;
        }
        GetAnomaliesRequest other = (GetAnomaliesRequest)((Object)obj);
        return Objects.equals(this.monitorArn(), other.monitorArn()) && Objects.equals(this.dateInterval(), other.dateInterval()) && Objects.equals(this.feedbackAsString(), other.feedbackAsString()) && Objects.equals(this.totalImpact(), other.totalImpact()) && Objects.equals(this.nextPageToken(), other.nextPageToken()) && Objects.equals(this.maxResults(), other.maxResults());
    }

    public final String toString() {
        return ToString.builder((String)"GetAnomaliesRequest").add("MonitorArn", (Object)this.monitorArn()).add("DateInterval", (Object)this.dateInterval()).add("Feedback", (Object)this.feedbackAsString()).add("TotalImpact", (Object)this.totalImpact()).add("NextPageToken", (Object)this.nextPageToken()).add("MaxResults", (Object)this.maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MonitorArn": {
                return Optional.ofNullable(clazz.cast(this.monitorArn()));
            }
            case "DateInterval": {
                return Optional.ofNullable(clazz.cast(this.dateInterval()));
            }
            case "Feedback": {
                return Optional.ofNullable(clazz.cast(this.feedbackAsString()));
            }
            case "TotalImpact": {
                return Optional.ofNullable(clazz.cast(this.totalImpact()));
            }
            case "NextPageToken": {
                return Optional.ofNullable(clazz.cast(this.nextPageToken()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetAnomaliesRequest, T> g) {
        return obj -> g.apply((GetAnomaliesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CostExplorerRequest.BuilderImpl
    implements Builder {
        private String monitorArn;
        private AnomalyDateInterval dateInterval;
        private String feedback;
        private TotalImpactFilter totalImpact;
        private String nextPageToken;
        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAnomaliesRequest model) {
            super(model);
            this.monitorArn(model.monitorArn);
            this.dateInterval(model.dateInterval);
            this.feedback(model.feedback);
            this.totalImpact(model.totalImpact);
            this.nextPageToken(model.nextPageToken);
            this.maxResults(model.maxResults);
        }

        public final String getMonitorArn() {
            return this.monitorArn;
        }

        public final void setMonitorArn(String monitorArn) {
            this.monitorArn = monitorArn;
        }

        @Override
        public final Builder monitorArn(String monitorArn) {
            this.monitorArn = monitorArn;
            return this;
        }

        public final AnomalyDateInterval.Builder getDateInterval() {
            return this.dateInterval != null ? this.dateInterval.toBuilder() : null;
        }

        public final void setDateInterval(AnomalyDateInterval.BuilderImpl dateInterval) {
            this.dateInterval = dateInterval != null ? dateInterval.build() : null;
        }

        @Override
        public final Builder dateInterval(AnomalyDateInterval dateInterval) {
            this.dateInterval = dateInterval;
            return this;
        }

        public final String getFeedback() {
            return this.feedback;
        }

        public final void setFeedback(String feedback) {
            this.feedback = feedback;
        }

        @Override
        public final Builder feedback(String feedback) {
            this.feedback = feedback;
            return this;
        }

        @Override
        public final Builder feedback(AnomalyFeedbackType feedback) {
            this.feedback(feedback == null ? null : feedback.toString());
            return this;
        }

        public final TotalImpactFilter.Builder getTotalImpact() {
            return this.totalImpact != null ? this.totalImpact.toBuilder() : null;
        }

        public final void setTotalImpact(TotalImpactFilter.BuilderImpl totalImpact) {
            this.totalImpact = totalImpact != null ? totalImpact.build() : null;
        }

        @Override
        public final Builder totalImpact(TotalImpactFilter totalImpact) {
            this.totalImpact = totalImpact;
            return this;
        }

        public final String getNextPageToken() {
            return this.nextPageToken;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetAnomaliesRequest build() {
            return new GetAnomaliesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CostExplorerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetAnomaliesRequest> {
        public Builder monitorArn(String var1);

        public Builder dateInterval(AnomalyDateInterval var1);

        default public Builder dateInterval(Consumer<AnomalyDateInterval.Builder> dateInterval) {
            return this.dateInterval((AnomalyDateInterval)((AnomalyDateInterval.Builder)AnomalyDateInterval.builder().applyMutation(dateInterval)).build());
        }

        public Builder feedback(String var1);

        public Builder feedback(AnomalyFeedbackType var1);

        public Builder totalImpact(TotalImpactFilter var1);

        default public Builder totalImpact(Consumer<TotalImpactFilter.Builder> totalImpact) {
            return this.totalImpact((TotalImpactFilter)((TotalImpactFilter.Builder)TotalImpactFilter.builder().applyMutation(totalImpact)).build());
        }

        public Builder nextPageToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

