/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costexplorer.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateAnomalySubscriptionRequest extends CostExplorerRequest implements
        ToCopyableBuilder<CreateAnomalySubscriptionRequest.Builder, CreateAnomalySubscriptionRequest> {
    private static final SdkField<AnomalySubscription> ANOMALY_SUBSCRIPTION_FIELD = SdkField
            .<AnomalySubscription> builder(MarshallingType.SDK_POJO).memberName("AnomalySubscription")
            .getter(getter(CreateAnomalySubscriptionRequest::anomalySubscription)).setter(setter(Builder::anomalySubscription))
            .constructor(AnomalySubscription::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnomalySubscription").build())
            .build();

    private static final SdkField<List<ResourceTag>> RESOURCE_TAGS_FIELD = SdkField
            .<List<ResourceTag>> builder(MarshallingType.LIST)
            .memberName("ResourceTags")
            .getter(getter(CreateAnomalySubscriptionRequest::resourceTags))
            .setter(setter(Builder::resourceTags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceTags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ResourceTag> builder(MarshallingType.SDK_POJO)
                                            .constructor(ResourceTag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ANOMALY_SUBSCRIPTION_FIELD,
            RESOURCE_TAGS_FIELD));

    private final AnomalySubscription anomalySubscription;

    private final List<ResourceTag> resourceTags;

    private CreateAnomalySubscriptionRequest(BuilderImpl builder) {
        super(builder);
        this.anomalySubscription = builder.anomalySubscription;
        this.resourceTags = builder.resourceTags;
    }

    /**
     * <p>
     * The cost anomaly subscription object that you want to create.
     * </p>
     * 
     * @return The cost anomaly subscription object that you want to create.
     */
    public final AnomalySubscription anomalySubscription() {
        return anomalySubscription;
    }

    /**
     * For responses, this returns true if the service returned a value for the ResourceTags property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasResourceTags() {
        return resourceTags != null && !(resourceTags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An optional list of tags to associate with the specified <a
     * href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_AnomalySubscription.html">
     * <code>AnomalySubscription</code> </a>. You can use resource tags to control access to your
     * <code>subscription</code> using IAM policies.
     * </p>
     * <p>
     * Each tag consists of a key and a value, and each key must be unique for the resource. The following restrictions
     * apply to resource tags:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Although the maximum number of array members is 200, you can assign a maximum of 50 user-tags to one resource.
     * The remaining are reserved for Amazon Web Services use
     * </p>
     * </li>
     * <li>
     * <p>
     * The maximum length of a key is 128 characters
     * </p>
     * </li>
     * <li>
     * <p>
     * The maximum length of a value is 256 characters
     * </p>
     * </li>
     * <li>
     * <p>
     * Keys and values can only contain alphanumeric characters, spaces, and any of the following: <code>_.:/=+@-</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * Keys and values are case sensitive
     * </p>
     * </li>
     * <li>
     * <p>
     * Keys and values are trimmed for any leading or trailing whitespaces
     * </p>
     * </li>
     * <li>
     * <p>
     * Don’t use <code>aws:</code> as a prefix for your keys. This prefix is reserved for Amazon Web Services use
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResourceTags} method.
     * </p>
     * 
     * @return An optional list of tags to associate with the specified <a
     *         href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_AnomalySubscription.html">
     *         <code>AnomalySubscription</code> </a>. You can use resource tags to control access to your
     *         <code>subscription</code> using IAM policies.</p>
     *         <p>
     *         Each tag consists of a key and a value, and each key must be unique for the resource. The following
     *         restrictions apply to resource tags:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Although the maximum number of array members is 200, you can assign a maximum of 50 user-tags to one
     *         resource. The remaining are reserved for Amazon Web Services use
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The maximum length of a key is 128 characters
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The maximum length of a value is 256 characters
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Keys and values can only contain alphanumeric characters, spaces, and any of the following:
     *         <code>_.:/=+@-</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Keys and values are case sensitive
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Keys and values are trimmed for any leading or trailing whitespaces
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Don’t use <code>aws:</code> as a prefix for your keys. This prefix is reserved for Amazon Web Services
     *         use
     *         </p>
     *         </li>
     */
    public final List<ResourceTag> resourceTags() {
        return resourceTags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(anomalySubscription());
        hashCode = 31 * hashCode + Objects.hashCode(hasResourceTags() ? resourceTags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAnomalySubscriptionRequest)) {
            return false;
        }
        CreateAnomalySubscriptionRequest other = (CreateAnomalySubscriptionRequest) obj;
        return Objects.equals(anomalySubscription(), other.anomalySubscription()) && hasResourceTags() == other.hasResourceTags()
                && Objects.equals(resourceTags(), other.resourceTags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateAnomalySubscriptionRequest").add("AnomalySubscription", anomalySubscription())
                .add("ResourceTags", hasResourceTags() ? resourceTags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AnomalySubscription":
            return Optional.ofNullable(clazz.cast(anomalySubscription()));
        case "ResourceTags":
            return Optional.ofNullable(clazz.cast(resourceTags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateAnomalySubscriptionRequest, T> g) {
        return obj -> g.apply((CreateAnomalySubscriptionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CostExplorerRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateAnomalySubscriptionRequest> {
        /**
         * <p>
         * The cost anomaly subscription object that you want to create.
         * </p>
         * 
         * @param anomalySubscription
         *        The cost anomaly subscription object that you want to create.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder anomalySubscription(AnomalySubscription anomalySubscription);

        /**
         * <p>
         * The cost anomaly subscription object that you want to create.
         * </p>
         * This is a convenience method that creates an instance of the {@link AnomalySubscription.Builder} avoiding the
         * need to create one manually via {@link AnomalySubscription#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AnomalySubscription.Builder#build()} is called immediately and
         * its result is passed to {@link #anomalySubscription(AnomalySubscription)}.
         * 
         * @param anomalySubscription
         *        a consumer that will call methods on {@link AnomalySubscription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #anomalySubscription(AnomalySubscription)
         */
        default Builder anomalySubscription(Consumer<AnomalySubscription.Builder> anomalySubscription) {
            return anomalySubscription(AnomalySubscription.builder().applyMutation(anomalySubscription).build());
        }

        /**
         * <p>
         * An optional list of tags to associate with the specified <a
         * href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_AnomalySubscription.html">
         * <code>AnomalySubscription</code> </a>. You can use resource tags to control access to your
         * <code>subscription</code> using IAM policies.
         * </p>
         * <p>
         * Each tag consists of a key and a value, and each key must be unique for the resource. The following
         * restrictions apply to resource tags:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Although the maximum number of array members is 200, you can assign a maximum of 50 user-tags to one
         * resource. The remaining are reserved for Amazon Web Services use
         * </p>
         * </li>
         * <li>
         * <p>
         * The maximum length of a key is 128 characters
         * </p>
         * </li>
         * <li>
         * <p>
         * The maximum length of a value is 256 characters
         * </p>
         * </li>
         * <li>
         * <p>
         * Keys and values can only contain alphanumeric characters, spaces, and any of the following:
         * <code>_.:/=+@-</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * Keys and values are case sensitive
         * </p>
         * </li>
         * <li>
         * <p>
         * Keys and values are trimmed for any leading or trailing whitespaces
         * </p>
         * </li>
         * <li>
         * <p>
         * Don’t use <code>aws:</code> as a prefix for your keys. This prefix is reserved for Amazon Web Services use
         * </p>
         * </li>
         * </ul>
         * 
         * @param resourceTags
         *        An optional list of tags to associate with the specified <a href=
         *        "https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_AnomalySubscription.html">
         *        <code>AnomalySubscription</code> </a>. You can use resource tags to control access to your
         *        <code>subscription</code> using IAM policies.</p>
         *        <p>
         *        Each tag consists of a key and a value, and each key must be unique for the resource. The following
         *        restrictions apply to resource tags:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Although the maximum number of array members is 200, you can assign a maximum of 50 user-tags to one
         *        resource. The remaining are reserved for Amazon Web Services use
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The maximum length of a key is 128 characters
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The maximum length of a value is 256 characters
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Keys and values can only contain alphanumeric characters, spaces, and any of the following:
         *        <code>_.:/=+@-</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Keys and values are case sensitive
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Keys and values are trimmed for any leading or trailing whitespaces
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Don’t use <code>aws:</code> as a prefix for your keys. This prefix is reserved for Amazon Web Services
         *        use
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceTags(Collection<ResourceTag> resourceTags);

        /**
         * <p>
         * An optional list of tags to associate with the specified <a
         * href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_AnomalySubscription.html">
         * <code>AnomalySubscription</code> </a>. You can use resource tags to control access to your
         * <code>subscription</code> using IAM policies.
         * </p>
         * <p>
         * Each tag consists of a key and a value, and each key must be unique for the resource. The following
         * restrictions apply to resource tags:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Although the maximum number of array members is 200, you can assign a maximum of 50 user-tags to one
         * resource. The remaining are reserved for Amazon Web Services use
         * </p>
         * </li>
         * <li>
         * <p>
         * The maximum length of a key is 128 characters
         * </p>
         * </li>
         * <li>
         * <p>
         * The maximum length of a value is 256 characters
         * </p>
         * </li>
         * <li>
         * <p>
         * Keys and values can only contain alphanumeric characters, spaces, and any of the following:
         * <code>_.:/=+@-</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * Keys and values are case sensitive
         * </p>
         * </li>
         * <li>
         * <p>
         * Keys and values are trimmed for any leading or trailing whitespaces
         * </p>
         * </li>
         * <li>
         * <p>
         * Don’t use <code>aws:</code> as a prefix for your keys. This prefix is reserved for Amazon Web Services use
         * </p>
         * </li>
         * </ul>
         * 
         * @param resourceTags
         *        An optional list of tags to associate with the specified <a href=
         *        "https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_AnomalySubscription.html">
         *        <code>AnomalySubscription</code> </a>. You can use resource tags to control access to your
         *        <code>subscription</code> using IAM policies.</p>
         *        <p>
         *        Each tag consists of a key and a value, and each key must be unique for the resource. The following
         *        restrictions apply to resource tags:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Although the maximum number of array members is 200, you can assign a maximum of 50 user-tags to one
         *        resource. The remaining are reserved for Amazon Web Services use
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The maximum length of a key is 128 characters
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The maximum length of a value is 256 characters
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Keys and values can only contain alphanumeric characters, spaces, and any of the following:
         *        <code>_.:/=+@-</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Keys and values are case sensitive
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Keys and values are trimmed for any leading or trailing whitespaces
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Don’t use <code>aws:</code> as a prefix for your keys. This prefix is reserved for Amazon Web Services
         *        use
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceTags(ResourceTag... resourceTags);

        /**
         * <p>
         * An optional list of tags to associate with the specified <a
         * href="https://docs.aws.amazon.com/aws-cost-management/latest/APIReference/API_AnomalySubscription.html">
         * <code>AnomalySubscription</code> </a>. You can use resource tags to control access to your
         * <code>subscription</code> using IAM policies.
         * </p>
         * <p>
         * Each tag consists of a key and a value, and each key must be unique for the resource. The following
         * restrictions apply to resource tags:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Although the maximum number of array members is 200, you can assign a maximum of 50 user-tags to one
         * resource. The remaining are reserved for Amazon Web Services use
         * </p>
         * </li>
         * <li>
         * <p>
         * The maximum length of a key is 128 characters
         * </p>
         * </li>
         * <li>
         * <p>
         * The maximum length of a value is 256 characters
         * </p>
         * </li>
         * <li>
         * <p>
         * Keys and values can only contain alphanumeric characters, spaces, and any of the following:
         * <code>_.:/=+@-</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * Keys and values are case sensitive
         * </p>
         * </li>
         * <li>
         * <p>
         * Keys and values are trimmed for any leading or trailing whitespaces
         * </p>
         * </li>
         * <li>
         * <p>
         * Don’t use <code>aws:</code> as a prefix for your keys. This prefix is reserved for Amazon Web Services use
         * </p>
         * </li>
         * </ul>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.costexplorer.model.ResourceTag.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.costexplorer.model.ResourceTag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.costexplorer.model.ResourceTag.Builder#build()} is called immediately
         * and its result is passed to {@link #resourceTags(List<ResourceTag>)}.
         * 
         * @param resourceTags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.costexplorer.model.ResourceTag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceTags(java.util.Collection<ResourceTag>)
         */
        Builder resourceTags(Consumer<ResourceTag.Builder>... resourceTags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CostExplorerRequest.BuilderImpl implements Builder {
        private AnomalySubscription anomalySubscription;

        private List<ResourceTag> resourceTags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAnomalySubscriptionRequest model) {
            super(model);
            anomalySubscription(model.anomalySubscription);
            resourceTags(model.resourceTags);
        }

        public final AnomalySubscription.Builder getAnomalySubscription() {
            return anomalySubscription != null ? anomalySubscription.toBuilder() : null;
        }

        public final void setAnomalySubscription(AnomalySubscription.BuilderImpl anomalySubscription) {
            this.anomalySubscription = anomalySubscription != null ? anomalySubscription.build() : null;
        }

        @Override
        public final Builder anomalySubscription(AnomalySubscription anomalySubscription) {
            this.anomalySubscription = anomalySubscription;
            return this;
        }

        public final List<ResourceTag.Builder> getResourceTags() {
            List<ResourceTag.Builder> result = ResourceTagListCopier.copyToBuilder(this.resourceTags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResourceTags(Collection<ResourceTag.BuilderImpl> resourceTags) {
            this.resourceTags = ResourceTagListCopier.copyFromBuilder(resourceTags);
        }

        @Override
        public final Builder resourceTags(Collection<ResourceTag> resourceTags) {
            this.resourceTags = ResourceTagListCopier.copy(resourceTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTags(ResourceTag... resourceTags) {
            resourceTags(Arrays.asList(resourceTags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTags(Consumer<ResourceTag.Builder>... resourceTags) {
            resourceTags(Stream.of(resourceTags).map(c -> ResourceTag.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateAnomalySubscriptionRequest build() {
            return new CreateAnomalySubscriptionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
