/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.costexplorer.model.TargetInstance;
import software.amazon.awssdk.services.costexplorer.model.TargetInstancesListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModifyRecommendationDetail
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ModifyRecommendationDetail> {
    private static final SdkField<List<TargetInstance>> TARGET_INSTANCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TargetInstances").getter(ModifyRecommendationDetail.getter(ModifyRecommendationDetail::targetInstances)).setter(ModifyRecommendationDetail.setter(Builder::targetInstances)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetInstances").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TargetInstance::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TARGET_INSTANCES_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<TargetInstance> targetInstances;

    private ModifyRecommendationDetail(BuilderImpl builder) {
        this.targetInstances = builder.targetInstances;
    }

    public final boolean hasTargetInstances() {
        return this.targetInstances != null && !(this.targetInstances instanceof SdkAutoConstructList);
    }

    public final List<TargetInstance> targetInstances() {
        return this.targetInstances;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTargetInstances() ? this.targetInstances() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyRecommendationDetail)) {
            return false;
        }
        ModifyRecommendationDetail other = (ModifyRecommendationDetail)obj;
        return this.hasTargetInstances() == other.hasTargetInstances() && Objects.equals(this.targetInstances(), other.targetInstances());
    }

    public final String toString() {
        return ToString.builder((String)"ModifyRecommendationDetail").add("TargetInstances", this.hasTargetInstances() ? this.targetInstances() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TargetInstances": {
                return Optional.ofNullable(clazz.cast(this.targetInstances()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyRecommendationDetail, T> g) {
        return obj -> g.apply((ModifyRecommendationDetail)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<TargetInstance> targetInstances = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyRecommendationDetail model) {
            this.targetInstances(model.targetInstances);
        }

        public final List<TargetInstance.Builder> getTargetInstances() {
            List<TargetInstance.Builder> result = TargetInstancesListCopier.copyToBuilder(this.targetInstances);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTargetInstances(Collection<TargetInstance.BuilderImpl> targetInstances) {
            this.targetInstances = TargetInstancesListCopier.copyFromBuilder(targetInstances);
        }

        @Override
        public final Builder targetInstances(Collection<TargetInstance> targetInstances) {
            this.targetInstances = TargetInstancesListCopier.copy(targetInstances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetInstances(TargetInstance ... targetInstances) {
            this.targetInstances(Arrays.asList(targetInstances));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetInstances(Consumer<TargetInstance.Builder> ... targetInstances) {
            this.targetInstances(Stream.of(targetInstances).map(c -> (TargetInstance)((TargetInstance.Builder)TargetInstance.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public ModifyRecommendationDetail build() {
            return new ModifyRecommendationDetail(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ModifyRecommendationDetail> {
        public Builder targetInstances(Collection<TargetInstance> var1);

        public Builder targetInstances(TargetInstance ... var1);

        public Builder targetInstances(Consumer<TargetInstance.Builder> ... var1);
    }
}

