/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum MonitorType {
    DIMENSIONAL("DIMENSIONAL"),
    CUSTOM("CUSTOM"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, MonitorType> VALUE_MAP;
    private final String value;

    private MonitorType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static MonitorType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<MonitorType> knownValues() {
        EnumSet<MonitorType> knownValues = EnumSet.allOf(MonitorType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(MonitorType.class, MonitorType::toString);
    }
}

