/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.costexplorer.model.CostCategoryInheritedValueDimension;
import software.amazon.awssdk.services.costexplorer.model.CostCategoryRuleType;
import software.amazon.awssdk.services.costexplorer.model.Expression;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CostCategoryRule
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CostCategoryRule> {
    private static final SdkField<String> VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Value").getter(CostCategoryRule.getter(CostCategoryRule::value)).setter(CostCategoryRule.setter(Builder::value)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()}).build();
    private static final SdkField<Expression> RULE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Rule").getter(CostCategoryRule.getter(CostCategoryRule::rule)).setter(CostCategoryRule.setter(Builder::rule)).constructor(Expression::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Rule").build()}).build();
    private static final SdkField<CostCategoryInheritedValueDimension> INHERITED_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("InheritedValue").getter(CostCategoryRule.getter(CostCategoryRule::inheritedValue)).setter(CostCategoryRule.setter(Builder::inheritedValue)).constructor(CostCategoryInheritedValueDimension::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InheritedValue").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(CostCategoryRule.getter(CostCategoryRule::typeAsString)).setter(CostCategoryRule.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VALUE_FIELD, RULE_FIELD, INHERITED_VALUE_FIELD, TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String value;
    private final Expression rule;
    private final CostCategoryInheritedValueDimension inheritedValue;
    private final String type;

    private CostCategoryRule(BuilderImpl builder) {
        this.value = builder.value;
        this.rule = builder.rule;
        this.inheritedValue = builder.inheritedValue;
        this.type = builder.type;
    }

    public final String value() {
        return this.value;
    }

    public final Expression rule() {
        return this.rule;
    }

    public final CostCategoryInheritedValueDimension inheritedValue() {
        return this.inheritedValue;
    }

    public final CostCategoryRuleType type() {
        return CostCategoryRuleType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.value());
        hashCode = 31 * hashCode + Objects.hashCode(this.rule());
        hashCode = 31 * hashCode + Objects.hashCode(this.inheritedValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CostCategoryRule)) {
            return false;
        }
        CostCategoryRule other = (CostCategoryRule)obj;
        return Objects.equals(this.value(), other.value()) && Objects.equals(this.rule(), other.rule()) && Objects.equals(this.inheritedValue(), other.inheritedValue()) && Objects.equals(this.typeAsString(), other.typeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"CostCategoryRule").add("Value", (Object)this.value()).add("Rule", (Object)this.rule()).add("InheritedValue", (Object)this.inheritedValue()).add("Type", (Object)this.typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Value": {
                return Optional.ofNullable(clazz.cast(this.value()));
            }
            case "Rule": {
                return Optional.ofNullable(clazz.cast(this.rule()));
            }
            case "InheritedValue": {
                return Optional.ofNullable(clazz.cast(this.inheritedValue()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CostCategoryRule, T> g) {
        return obj -> g.apply((CostCategoryRule)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String value;
        private Expression rule;
        private CostCategoryInheritedValueDimension inheritedValue;
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(CostCategoryRule model) {
            this.value(model.value);
            this.rule(model.rule);
            this.inheritedValue(model.inheritedValue);
            this.type(model.type);
        }

        public final String getValue() {
            return this.value;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final Expression.Builder getRule() {
            return this.rule != null ? this.rule.toBuilder() : null;
        }

        public final void setRule(Expression.BuilderImpl rule) {
            this.rule = rule != null ? rule.build() : null;
        }

        @Override
        public final Builder rule(Expression rule) {
            this.rule = rule;
            return this;
        }

        public final CostCategoryInheritedValueDimension.Builder getInheritedValue() {
            return this.inheritedValue != null ? this.inheritedValue.toBuilder() : null;
        }

        public final void setInheritedValue(CostCategoryInheritedValueDimension.BuilderImpl inheritedValue) {
            this.inheritedValue = inheritedValue != null ? inheritedValue.build() : null;
        }

        @Override
        public final Builder inheritedValue(CostCategoryInheritedValueDimension inheritedValue) {
            this.inheritedValue = inheritedValue;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(CostCategoryRuleType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public CostCategoryRule build() {
            return new CostCategoryRule(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CostCategoryRule> {
        public Builder value(String var1);

        public Builder rule(Expression var1);

        default public Builder rule(Consumer<Expression.Builder> rule) {
            return this.rule((Expression)((Expression.Builder)Expression.builder().applyMutation(rule)).build());
        }

        public Builder inheritedValue(CostCategoryInheritedValueDimension var1);

        default public Builder inheritedValue(Consumer<CostCategoryInheritedValueDimension.Builder> inheritedValue) {
            return this.inheritedValue((CostCategoryInheritedValueDimension)((CostCategoryInheritedValueDimension.Builder)CostCategoryInheritedValueDimension.builder().applyMutation(inheritedValue)).build());
        }

        public Builder type(String var1);

        public Builder type(CostCategoryRuleType var1);
    }
}

