/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.costexplorer.model.CostExplorerResponse;
import software.amazon.awssdk.services.costexplorer.model.ReservationAggregates;
import software.amazon.awssdk.services.costexplorer.model.UtilizationByTime;
import software.amazon.awssdk.services.costexplorer.model.UtilizationsByTimeCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetReservationUtilizationResponse
extends CostExplorerResponse
implements ToCopyableBuilder<Builder, GetReservationUtilizationResponse> {
    private static final SdkField<List<UtilizationByTime>> UTILIZATIONS_BY_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("UtilizationsByTime").getter(GetReservationUtilizationResponse.getter(GetReservationUtilizationResponse::utilizationsByTime)).setter(GetReservationUtilizationResponse.setter(Builder::utilizationsByTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UtilizationsByTime").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(UtilizationByTime::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ReservationAggregates> TOTAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Total").getter(GetReservationUtilizationResponse.getter(GetReservationUtilizationResponse::total)).setter(GetReservationUtilizationResponse.setter(Builder::total)).constructor(ReservationAggregates::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Total").build()}).build();
    private static final SdkField<String> NEXT_PAGE_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextPageToken").getter(GetReservationUtilizationResponse.getter(GetReservationUtilizationResponse::nextPageToken)).setter(GetReservationUtilizationResponse.setter(Builder::nextPageToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextPageToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(UTILIZATIONS_BY_TIME_FIELD, TOTAL_FIELD, NEXT_PAGE_TOKEN_FIELD));
    private final List<UtilizationByTime> utilizationsByTime;
    private final ReservationAggregates total;
    private final String nextPageToken;

    private GetReservationUtilizationResponse(BuilderImpl builder) {
        super(builder);
        this.utilizationsByTime = builder.utilizationsByTime;
        this.total = builder.total;
        this.nextPageToken = builder.nextPageToken;
    }

    public final boolean hasUtilizationsByTime() {
        return this.utilizationsByTime != null && !(this.utilizationsByTime instanceof SdkAutoConstructList);
    }

    public final List<UtilizationByTime> utilizationsByTime() {
        return this.utilizationsByTime;
    }

    public final ReservationAggregates total() {
        return this.total;
    }

    public final String nextPageToken() {
        return this.nextPageToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUtilizationsByTime() ? this.utilizationsByTime() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.total());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextPageToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetReservationUtilizationResponse)) {
            return false;
        }
        GetReservationUtilizationResponse other = (GetReservationUtilizationResponse)((Object)obj);
        return this.hasUtilizationsByTime() == other.hasUtilizationsByTime() && Objects.equals(this.utilizationsByTime(), other.utilizationsByTime()) && Objects.equals(this.total(), other.total()) && Objects.equals(this.nextPageToken(), other.nextPageToken());
    }

    public final String toString() {
        return ToString.builder((String)"GetReservationUtilizationResponse").add("UtilizationsByTime", this.hasUtilizationsByTime() ? this.utilizationsByTime() : null).add("Total", (Object)this.total()).add("NextPageToken", (Object)this.nextPageToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UtilizationsByTime": {
                return Optional.ofNullable(clazz.cast(this.utilizationsByTime()));
            }
            case "Total": {
                return Optional.ofNullable(clazz.cast(this.total()));
            }
            case "NextPageToken": {
                return Optional.ofNullable(clazz.cast(this.nextPageToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetReservationUtilizationResponse, T> g) {
        return obj -> g.apply((GetReservationUtilizationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CostExplorerResponse.BuilderImpl
    implements Builder {
        private List<UtilizationByTime> utilizationsByTime = DefaultSdkAutoConstructList.getInstance();
        private ReservationAggregates total;
        private String nextPageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetReservationUtilizationResponse model) {
            super(model);
            this.utilizationsByTime(model.utilizationsByTime);
            this.total(model.total);
            this.nextPageToken(model.nextPageToken);
        }

        public final List<UtilizationByTime.Builder> getUtilizationsByTime() {
            List<UtilizationByTime.Builder> result = UtilizationsByTimeCopier.copyToBuilder(this.utilizationsByTime);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder utilizationsByTime(Collection<UtilizationByTime> utilizationsByTime) {
            this.utilizationsByTime = UtilizationsByTimeCopier.copy(utilizationsByTime);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder utilizationsByTime(UtilizationByTime ... utilizationsByTime) {
            this.utilizationsByTime(Arrays.asList(utilizationsByTime));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder utilizationsByTime(Consumer<UtilizationByTime.Builder> ... utilizationsByTime) {
            this.utilizationsByTime(Stream.of(utilizationsByTime).map(c -> (UtilizationByTime)((UtilizationByTime.Builder)UtilizationByTime.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setUtilizationsByTime(Collection<UtilizationByTime.BuilderImpl> utilizationsByTime) {
            this.utilizationsByTime = UtilizationsByTimeCopier.copyFromBuilder(utilizationsByTime);
        }

        public final ReservationAggregates.Builder getTotal() {
            return this.total != null ? this.total.toBuilder() : null;
        }

        @Override
        public final Builder total(ReservationAggregates total) {
            this.total = total;
            return this;
        }

        public final void setTotal(ReservationAggregates.BuilderImpl total) {
            this.total = total != null ? total.build() : null;
        }

        public final String getNextPageToken() {
            return this.nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        @Override
        public GetReservationUtilizationResponse build() {
            return new GetReservationUtilizationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CostExplorerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetReservationUtilizationResponse> {
        public Builder utilizationsByTime(Collection<UtilizationByTime> var1);

        public Builder utilizationsByTime(UtilizationByTime ... var1);

        public Builder utilizationsByTime(Consumer<UtilizationByTime.Builder> ... var1);

        public Builder total(ReservationAggregates var1);

        default public Builder total(Consumer<ReservationAggregates.Builder> total) {
            return this.total((ReservationAggregates)((ReservationAggregates.Builder)ReservationAggregates.builder().applyMutation(total)).build());
        }

        public Builder nextPageToken(String var1);
    }
}

