/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costexplorer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Metadata about your Savings Plans Purchase Recommendations.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SavingsPlansPurchaseRecommendationMetadata implements SdkPojo, Serializable,
        ToCopyableBuilder<SavingsPlansPurchaseRecommendationMetadata.Builder, SavingsPlansPurchaseRecommendationMetadata> {
    private static final SdkField<String> RECOMMENDATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RecommendationId").getter(getter(SavingsPlansPurchaseRecommendationMetadata::recommendationId))
            .setter(setter(Builder::recommendationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecommendationId").build()).build();

    private static final SdkField<String> GENERATION_TIMESTAMP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("GenerationTimestamp").getter(getter(SavingsPlansPurchaseRecommendationMetadata::generationTimestamp))
            .setter(setter(Builder::generationTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GenerationTimestamp").build())
            .build();

    private static final SdkField<String> ADDITIONAL_METADATA_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AdditionalMetadata").getter(getter(SavingsPlansPurchaseRecommendationMetadata::additionalMetadata))
            .setter(setter(Builder::additionalMetadata))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalMetadata").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RECOMMENDATION_ID_FIELD,
            GENERATION_TIMESTAMP_FIELD, ADDITIONAL_METADATA_FIELD));

    private static final long serialVersionUID = 1L;

    private final String recommendationId;

    private final String generationTimestamp;

    private final String additionalMetadata;

    private SavingsPlansPurchaseRecommendationMetadata(BuilderImpl builder) {
        this.recommendationId = builder.recommendationId;
        this.generationTimestamp = builder.generationTimestamp;
        this.additionalMetadata = builder.additionalMetadata;
    }

    /**
     * <p>
     * The unique identifier for the recommendation set.
     * </p>
     * 
     * @return The unique identifier for the recommendation set.
     */
    public final String recommendationId() {
        return recommendationId;
    }

    /**
     * <p>
     * The timestamp showing when the recommendations were generated.
     * </p>
     * 
     * @return The timestamp showing when the recommendations were generated.
     */
    public final String generationTimestamp() {
        return generationTimestamp;
    }

    /**
     * <p>
     * Additional metadata that may be applicable to the recommendation.
     * </p>
     * 
     * @return Additional metadata that may be applicable to the recommendation.
     */
    public final String additionalMetadata() {
        return additionalMetadata;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(recommendationId());
        hashCode = 31 * hashCode + Objects.hashCode(generationTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(additionalMetadata());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SavingsPlansPurchaseRecommendationMetadata)) {
            return false;
        }
        SavingsPlansPurchaseRecommendationMetadata other = (SavingsPlansPurchaseRecommendationMetadata) obj;
        return Objects.equals(recommendationId(), other.recommendationId())
                && Objects.equals(generationTimestamp(), other.generationTimestamp())
                && Objects.equals(additionalMetadata(), other.additionalMetadata());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SavingsPlansPurchaseRecommendationMetadata").add("RecommendationId", recommendationId())
                .add("GenerationTimestamp", generationTimestamp()).add("AdditionalMetadata", additionalMetadata()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RecommendationId":
            return Optional.ofNullable(clazz.cast(recommendationId()));
        case "GenerationTimestamp":
            return Optional.ofNullable(clazz.cast(generationTimestamp()));
        case "AdditionalMetadata":
            return Optional.ofNullable(clazz.cast(additionalMetadata()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SavingsPlansPurchaseRecommendationMetadata, T> g) {
        return obj -> g.apply((SavingsPlansPurchaseRecommendationMetadata) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SavingsPlansPurchaseRecommendationMetadata> {
        /**
         * <p>
         * The unique identifier for the recommendation set.
         * </p>
         * 
         * @param recommendationId
         *        The unique identifier for the recommendation set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recommendationId(String recommendationId);

        /**
         * <p>
         * The timestamp showing when the recommendations were generated.
         * </p>
         * 
         * @param generationTimestamp
         *        The timestamp showing when the recommendations were generated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder generationTimestamp(String generationTimestamp);

        /**
         * <p>
         * Additional metadata that may be applicable to the recommendation.
         * </p>
         * 
         * @param additionalMetadata
         *        Additional metadata that may be applicable to the recommendation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalMetadata(String additionalMetadata);
    }

    static final class BuilderImpl implements Builder {
        private String recommendationId;

        private String generationTimestamp;

        private String additionalMetadata;

        private BuilderImpl() {
        }

        private BuilderImpl(SavingsPlansPurchaseRecommendationMetadata model) {
            recommendationId(model.recommendationId);
            generationTimestamp(model.generationTimestamp);
            additionalMetadata(model.additionalMetadata);
        }

        public final String getRecommendationId() {
            return recommendationId;
        }

        @Override
        public final Builder recommendationId(String recommendationId) {
            this.recommendationId = recommendationId;
            return this;
        }

        public final void setRecommendationId(String recommendationId) {
            this.recommendationId = recommendationId;
        }

        public final String getGenerationTimestamp() {
            return generationTimestamp;
        }

        @Override
        public final Builder generationTimestamp(String generationTimestamp) {
            this.generationTimestamp = generationTimestamp;
            return this;
        }

        public final void setGenerationTimestamp(String generationTimestamp) {
            this.generationTimestamp = generationTimestamp;
        }

        public final String getAdditionalMetadata() {
            return additionalMetadata;
        }

        @Override
        public final Builder additionalMetadata(String additionalMetadata) {
            this.additionalMetadata = additionalMetadata;
            return this;
        }

        public final void setAdditionalMetadata(String additionalMetadata) {
            this.additionalMetadata = additionalMetadata;
        }

        @Override
        public SavingsPlansPurchaseRecommendationMetadata build() {
            return new SavingsPlansPurchaseRecommendationMetadata(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
