/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costexplorer.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateAnomalyMonitorRequest extends CostExplorerRequest implements
        ToCopyableBuilder<CreateAnomalyMonitorRequest.Builder, CreateAnomalyMonitorRequest> {
    private static final SdkField<AnomalyMonitor> ANOMALY_MONITOR_FIELD = SdkField
            .<AnomalyMonitor> builder(MarshallingType.SDK_POJO).memberName("AnomalyMonitor")
            .getter(getter(CreateAnomalyMonitorRequest::anomalyMonitor)).setter(setter(Builder::anomalyMonitor))
            .constructor(AnomalyMonitor::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnomalyMonitor").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ANOMALY_MONITOR_FIELD));

    private final AnomalyMonitor anomalyMonitor;

    private CreateAnomalyMonitorRequest(BuilderImpl builder) {
        super(builder);
        this.anomalyMonitor = builder.anomalyMonitor;
    }

    /**
     * <p>
     * The cost anomaly detection monitor object that you want to create.
     * </p>
     * 
     * @return The cost anomaly detection monitor object that you want to create.
     */
    public final AnomalyMonitor anomalyMonitor() {
        return anomalyMonitor;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(anomalyMonitor());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAnomalyMonitorRequest)) {
            return false;
        }
        CreateAnomalyMonitorRequest other = (CreateAnomalyMonitorRequest) obj;
        return Objects.equals(anomalyMonitor(), other.anomalyMonitor());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateAnomalyMonitorRequest").add("AnomalyMonitor", anomalyMonitor()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AnomalyMonitor":
            return Optional.ofNullable(clazz.cast(anomalyMonitor()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateAnomalyMonitorRequest, T> g) {
        return obj -> g.apply((CreateAnomalyMonitorRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CostExplorerRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateAnomalyMonitorRequest> {
        /**
         * <p>
         * The cost anomaly detection monitor object that you want to create.
         * </p>
         * 
         * @param anomalyMonitor
         *        The cost anomaly detection monitor object that you want to create.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder anomalyMonitor(AnomalyMonitor anomalyMonitor);

        /**
         * <p>
         * The cost anomaly detection monitor object that you want to create.
         * </p>
         * This is a convenience that creates an instance of the {@link AnomalyMonitor.Builder} avoiding the need to
         * create one manually via {@link AnomalyMonitor#builder()}.
         *
         * When the {@link Consumer} completes, {@link AnomalyMonitor.Builder#build()} is called immediately and its
         * result is passed to {@link #anomalyMonitor(AnomalyMonitor)}.
         * 
         * @param anomalyMonitor
         *        a consumer that will call methods on {@link AnomalyMonitor.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #anomalyMonitor(AnomalyMonitor)
         */
        default Builder anomalyMonitor(Consumer<AnomalyMonitor.Builder> anomalyMonitor) {
            return anomalyMonitor(AnomalyMonitor.builder().applyMutation(anomalyMonitor).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CostExplorerRequest.BuilderImpl implements Builder {
        private AnomalyMonitor anomalyMonitor;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAnomalyMonitorRequest model) {
            super(model);
            anomalyMonitor(model.anomalyMonitor);
        }

        public final AnomalyMonitor.Builder getAnomalyMonitor() {
            return anomalyMonitor != null ? anomalyMonitor.toBuilder() : null;
        }

        @Override
        public final Builder anomalyMonitor(AnomalyMonitor anomalyMonitor) {
            this.anomalyMonitor = anomalyMonitor;
            return this;
        }

        public final void setAnomalyMonitor(AnomalyMonitor.BuilderImpl anomalyMonitor) {
            this.anomalyMonitor = anomalyMonitor != null ? anomalyMonitor.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateAnomalyMonitorRequest build() {
            return new CreateAnomalyMonitorRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
