/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costexplorer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The Cost Categories values used for filtering the costs.
 * </p>
 * <p>
 * If <code>Values</code> and <code>Key</code> are not specified, the <code>ABSENT</code> <code>MatchOption</code> is
 * applied to all Cost Categories. That is, filtering on resources that are not mapped to any Cost Categories.
 * </p>
 * <p>
 * If <code>Values</code> is provided and <code>Key</code> is not specified, the <code>ABSENT</code>
 * <code>MatchOption</code> is applied to the Cost Categories <code>Key</code> only. That is, filtering on resources
 * without the given Cost Categories key.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CostCategoryValues implements SdkPojo, Serializable,
        ToCopyableBuilder<CostCategoryValues.Builder, CostCategoryValues> {
    private static final SdkField<String> KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Key")
            .getter(getter(CostCategoryValues::key)).setter(setter(Builder::key))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Key").build()).build();

    private static final SdkField<List<String>> VALUES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Values")
            .getter(getter(CostCategoryValues::values))
            .setter(setter(Builder::values))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Values").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> MATCH_OPTIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("MatchOptions")
            .getter(getter(CostCategoryValues::matchOptionsAsStrings))
            .setter(setter(Builder::matchOptionsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MatchOptions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_FIELD, VALUES_FIELD,
            MATCH_OPTIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String key;

    private final List<String> values;

    private final List<String> matchOptions;

    private CostCategoryValues(BuilderImpl builder) {
        this.key = builder.key;
        this.values = builder.values;
        this.matchOptions = builder.matchOptions;
    }

    /**
     * Returns the value of the Key property for this object.
     * 
     * @return The value of the Key property for this object.
     */
    public final String key() {
        return key;
    }

    /**
     * Returns true if the Values property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasValues() {
        return values != null && !(values instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The specific value of the Cost Category.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasValues()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The specific value of the Cost Category.
     */
    public final List<String> values() {
        return values;
    }

    /**
     * <p>
     * The match options that you can use to filter your results. MatchOptions is only applicable for actions related to
     * cost category. The default values for <code>MatchOptions</code> is <code>EQUALS</code> and
     * <code>CASE_SENSITIVE</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasMatchOptions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The match options that you can use to filter your results. MatchOptions is only applicable for actions
     *         related to cost category. The default values for <code>MatchOptions</code> is <code>EQUALS</code> and
     *         <code>CASE_SENSITIVE</code>.
     */
    public final List<MatchOption> matchOptions() {
        return MatchOptionsCopier.copyStringToEnum(matchOptions);
    }

    /**
     * Returns true if the MatchOptions property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasMatchOptions() {
        return matchOptions != null && !(matchOptions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The match options that you can use to filter your results. MatchOptions is only applicable for actions related to
     * cost category. The default values for <code>MatchOptions</code> is <code>EQUALS</code> and
     * <code>CASE_SENSITIVE</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasMatchOptions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The match options that you can use to filter your results. MatchOptions is only applicable for actions
     *         related to cost category. The default values for <code>MatchOptions</code> is <code>EQUALS</code> and
     *         <code>CASE_SENSITIVE</code>.
     */
    public final List<String> matchOptionsAsStrings() {
        return matchOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(key());
        hashCode = 31 * hashCode + Objects.hashCode(hasValues() ? values() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasMatchOptions() ? matchOptionsAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CostCategoryValues)) {
            return false;
        }
        CostCategoryValues other = (CostCategoryValues) obj;
        return Objects.equals(key(), other.key()) && hasValues() == other.hasValues() && Objects.equals(values(), other.values())
                && hasMatchOptions() == other.hasMatchOptions()
                && Objects.equals(matchOptionsAsStrings(), other.matchOptionsAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CostCategoryValues").add("Key", key()).add("Values", hasValues() ? values() : null)
                .add("MatchOptions", hasMatchOptions() ? matchOptionsAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Key":
            return Optional.ofNullable(clazz.cast(key()));
        case "Values":
            return Optional.ofNullable(clazz.cast(values()));
        case "MatchOptions":
            return Optional.ofNullable(clazz.cast(matchOptionsAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CostCategoryValues, T> g) {
        return obj -> g.apply((CostCategoryValues) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CostCategoryValues> {
        /**
         * Sets the value of the Key property for this object.
         *
         * @param key
         *        The new value for the Key property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder key(String key);

        /**
         * <p>
         * The specific value of the Cost Category.
         * </p>
         * 
         * @param values
         *        The specific value of the Cost Category.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder values(Collection<String> values);

        /**
         * <p>
         * The specific value of the Cost Category.
         * </p>
         * 
         * @param values
         *        The specific value of the Cost Category.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder values(String... values);

        /**
         * <p>
         * The match options that you can use to filter your results. MatchOptions is only applicable for actions
         * related to cost category. The default values for <code>MatchOptions</code> is <code>EQUALS</code> and
         * <code>CASE_SENSITIVE</code>.
         * </p>
         * 
         * @param matchOptions
         *        The match options that you can use to filter your results. MatchOptions is only applicable for actions
         *        related to cost category. The default values for <code>MatchOptions</code> is <code>EQUALS</code> and
         *        <code>CASE_SENSITIVE</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder matchOptionsWithStrings(Collection<String> matchOptions);

        /**
         * <p>
         * The match options that you can use to filter your results. MatchOptions is only applicable for actions
         * related to cost category. The default values for <code>MatchOptions</code> is <code>EQUALS</code> and
         * <code>CASE_SENSITIVE</code>.
         * </p>
         * 
         * @param matchOptions
         *        The match options that you can use to filter your results. MatchOptions is only applicable for actions
         *        related to cost category. The default values for <code>MatchOptions</code> is <code>EQUALS</code> and
         *        <code>CASE_SENSITIVE</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder matchOptionsWithStrings(String... matchOptions);

        /**
         * <p>
         * The match options that you can use to filter your results. MatchOptions is only applicable for actions
         * related to cost category. The default values for <code>MatchOptions</code> is <code>EQUALS</code> and
         * <code>CASE_SENSITIVE</code>.
         * </p>
         * 
         * @param matchOptions
         *        The match options that you can use to filter your results. MatchOptions is only applicable for actions
         *        related to cost category. The default values for <code>MatchOptions</code> is <code>EQUALS</code> and
         *        <code>CASE_SENSITIVE</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder matchOptions(Collection<MatchOption> matchOptions);

        /**
         * <p>
         * The match options that you can use to filter your results. MatchOptions is only applicable for actions
         * related to cost category. The default values for <code>MatchOptions</code> is <code>EQUALS</code> and
         * <code>CASE_SENSITIVE</code>.
         * </p>
         * 
         * @param matchOptions
         *        The match options that you can use to filter your results. MatchOptions is only applicable for actions
         *        related to cost category. The default values for <code>MatchOptions</code> is <code>EQUALS</code> and
         *        <code>CASE_SENSITIVE</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder matchOptions(MatchOption... matchOptions);
    }

    static final class BuilderImpl implements Builder {
        private String key;

        private List<String> values = DefaultSdkAutoConstructList.getInstance();

        private List<String> matchOptions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CostCategoryValues model) {
            key(model.key);
            values(model.values);
            matchOptionsWithStrings(model.matchOptions);
        }

        public final String getKey() {
            return key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        public final Collection<String> getValues() {
            if (values instanceof SdkAutoConstructList) {
                return null;
            }
            return values;
        }

        @Override
        public final Builder values(Collection<String> values) {
            this.values = ValuesCopier.copy(values);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder values(String... values) {
            values(Arrays.asList(values));
            return this;
        }

        public final void setValues(Collection<String> values) {
            this.values = ValuesCopier.copy(values);
        }

        public final Collection<String> getMatchOptions() {
            if (matchOptions instanceof SdkAutoConstructList) {
                return null;
            }
            return matchOptions;
        }

        @Override
        public final Builder matchOptionsWithStrings(Collection<String> matchOptions) {
            this.matchOptions = MatchOptionsCopier.copy(matchOptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder matchOptionsWithStrings(String... matchOptions) {
            matchOptionsWithStrings(Arrays.asList(matchOptions));
            return this;
        }

        @Override
        public final Builder matchOptions(Collection<MatchOption> matchOptions) {
            this.matchOptions = MatchOptionsCopier.copyEnumToString(matchOptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder matchOptions(MatchOption... matchOptions) {
            matchOptions(Arrays.asList(matchOptions));
            return this;
        }

        public final void setMatchOptions(Collection<String> matchOptions) {
            this.matchOptions = MatchOptionsCopier.copy(matchOptions);
        }

        @Override
        public CostCategoryValues build() {
            return new CostCategoryValues(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
