/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum NumericOperator {
    EQUAL("EQUAL"),
    GREATER_THAN_OR_EQUAL("GREATER_THAN_OR_EQUAL"),
    LESS_THAN_OR_EQUAL("LESS_THAN_OR_EQUAL"),
    GREATER_THAN("GREATER_THAN"),
    LESS_THAN("LESS_THAN"),
    BETWEEN("BETWEEN"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private NumericOperator(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static NumericOperator fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(NumericOperator.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<NumericOperator> knownValues() {
        return Stream.of(NumericOperator.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

