/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.costexplorer.model.AnomalyMonitor;
import software.amazon.awssdk.services.costexplorer.model.AnomalyMonitorsCopier;
import software.amazon.awssdk.services.costexplorer.model.CostExplorerResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetAnomalyMonitorsResponse
extends CostExplorerResponse
implements ToCopyableBuilder<Builder, GetAnomalyMonitorsResponse> {
    private static final SdkField<List<AnomalyMonitor>> ANOMALY_MONITORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AnomalyMonitors").getter(GetAnomalyMonitorsResponse.getter(GetAnomalyMonitorsResponse::anomalyMonitors)).setter(GetAnomalyMonitorsResponse.setter(Builder::anomalyMonitors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnomalyMonitors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AnomalyMonitor::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_PAGE_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextPageToken").getter(GetAnomalyMonitorsResponse.getter(GetAnomalyMonitorsResponse::nextPageToken)).setter(GetAnomalyMonitorsResponse.setter(Builder::nextPageToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextPageToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ANOMALY_MONITORS_FIELD, NEXT_PAGE_TOKEN_FIELD));
    private final List<AnomalyMonitor> anomalyMonitors;
    private final String nextPageToken;

    private GetAnomalyMonitorsResponse(BuilderImpl builder) {
        super(builder);
        this.anomalyMonitors = builder.anomalyMonitors;
        this.nextPageToken = builder.nextPageToken;
    }

    public boolean hasAnomalyMonitors() {
        return this.anomalyMonitors != null && !(this.anomalyMonitors instanceof SdkAutoConstructList);
    }

    public List<AnomalyMonitor> anomalyMonitors() {
        return this.anomalyMonitors;
    }

    public String nextPageToken() {
        return this.nextPageToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAnomalyMonitors() ? this.anomalyMonitors() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextPageToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAnomalyMonitorsResponse)) {
            return false;
        }
        GetAnomalyMonitorsResponse other = (GetAnomalyMonitorsResponse)((Object)obj);
        return this.hasAnomalyMonitors() == other.hasAnomalyMonitors() && Objects.equals(this.anomalyMonitors(), other.anomalyMonitors()) && Objects.equals(this.nextPageToken(), other.nextPageToken());
    }

    public String toString() {
        return ToString.builder((String)"GetAnomalyMonitorsResponse").add("AnomalyMonitors", this.hasAnomalyMonitors() ? this.anomalyMonitors() : null).add("NextPageToken", (Object)this.nextPageToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AnomalyMonitors": {
                return Optional.ofNullable(clazz.cast(this.anomalyMonitors()));
            }
            case "NextPageToken": {
                return Optional.ofNullable(clazz.cast(this.nextPageToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetAnomalyMonitorsResponse, T> g) {
        return obj -> g.apply((GetAnomalyMonitorsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CostExplorerResponse.BuilderImpl
    implements Builder {
        private List<AnomalyMonitor> anomalyMonitors = DefaultSdkAutoConstructList.getInstance();
        private String nextPageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAnomalyMonitorsResponse model) {
            super(model);
            this.anomalyMonitors(model.anomalyMonitors);
            this.nextPageToken(model.nextPageToken);
        }

        public final Collection<AnomalyMonitor.Builder> getAnomalyMonitors() {
            if (this.anomalyMonitors instanceof SdkAutoConstructList) {
                return null;
            }
            return this.anomalyMonitors != null ? (Collection)this.anomalyMonitors.stream().map(AnomalyMonitor::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder anomalyMonitors(Collection<AnomalyMonitor> anomalyMonitors) {
            this.anomalyMonitors = AnomalyMonitorsCopier.copy(anomalyMonitors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder anomalyMonitors(AnomalyMonitor ... anomalyMonitors) {
            this.anomalyMonitors(Arrays.asList(anomalyMonitors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder anomalyMonitors(Consumer<AnomalyMonitor.Builder> ... anomalyMonitors) {
            this.anomalyMonitors(Stream.of(anomalyMonitors).map(c -> (AnomalyMonitor)((AnomalyMonitor.Builder)AnomalyMonitor.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAnomalyMonitors(Collection<AnomalyMonitor.BuilderImpl> anomalyMonitors) {
            this.anomalyMonitors = AnomalyMonitorsCopier.copyFromBuilder(anomalyMonitors);
        }

        public final String getNextPageToken() {
            return this.nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        @Override
        public GetAnomalyMonitorsResponse build() {
            return new GetAnomalyMonitorsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CostExplorerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetAnomalyMonitorsResponse> {
        public Builder anomalyMonitors(Collection<AnomalyMonitor> var1);

        public Builder anomalyMonitors(AnomalyMonitor ... var1);

        public Builder anomalyMonitors(Consumer<AnomalyMonitor.Builder> ... var1);

        public Builder nextPageToken(String var1);
    }
}

