/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MetricValue
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MetricValue> {
    private static final SdkField<String> AMOUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Amount").getter(MetricValue.getter(MetricValue::amount)).setter(MetricValue.setter(Builder::amount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Amount").build()}).build();
    private static final SdkField<String> UNIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Unit").getter(MetricValue.getter(MetricValue::unit)).setter(MetricValue.setter(Builder::unit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Unit").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AMOUNT_FIELD, UNIT_FIELD));
    private static final long serialVersionUID = 1L;
    private final String amount;
    private final String unit;

    private MetricValue(BuilderImpl builder) {
        this.amount = builder.amount;
        this.unit = builder.unit;
    }

    public String amount() {
        return this.amount;
    }

    public String unit() {
        return this.unit;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.amount());
        hashCode = 31 * hashCode + Objects.hashCode(this.unit());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetricValue)) {
            return false;
        }
        MetricValue other = (MetricValue)obj;
        return Objects.equals(this.amount(), other.amount()) && Objects.equals(this.unit(), other.unit());
    }

    public String toString() {
        return ToString.builder((String)"MetricValue").add("Amount", (Object)this.amount()).add("Unit", (Object)this.unit()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Amount": {
                return Optional.ofNullable(clazz.cast(this.amount()));
            }
            case "Unit": {
                return Optional.ofNullable(clazz.cast(this.unit()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MetricValue, T> g) {
        return obj -> g.apply((MetricValue)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String amount;
        private String unit;

        private BuilderImpl() {
        }

        private BuilderImpl(MetricValue model) {
            this.amount(model.amount);
            this.unit(model.unit);
        }

        public final String getAmount() {
            return this.amount;
        }

        @Override
        public final Builder amount(String amount) {
            this.amount = amount;
            return this;
        }

        public final void setAmount(String amount) {
            this.amount = amount;
        }

        public final String getUnit() {
            return this.unit;
        }

        @Override
        public final Builder unit(String unit) {
            this.unit = unit;
            return this;
        }

        public final void setUnit(String unit) {
            this.unit = unit;
        }

        public MetricValue build() {
            return new MetricValue(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MetricValue> {
        public Builder amount(String var1);

        public Builder unit(String var1);
    }
}

