/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.costexplorer.model.CostCategoryReference;
import software.amazon.awssdk.services.costexplorer.model.CostCategoryReferencesListCopier;
import software.amazon.awssdk.services.costexplorer.model.CostExplorerResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListCostCategoryDefinitionsResponse
extends CostExplorerResponse
implements ToCopyableBuilder<Builder, ListCostCategoryDefinitionsResponse> {
    private static final SdkField<List<CostCategoryReference>> COST_CATEGORY_REFERENCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CostCategoryReferences").getter(ListCostCategoryDefinitionsResponse.getter(ListCostCategoryDefinitionsResponse::costCategoryReferences)).setter(ListCostCategoryDefinitionsResponse.setter(Builder::costCategoryReferences)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CostCategoryReferences").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CostCategoryReference::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListCostCategoryDefinitionsResponse.getter(ListCostCategoryDefinitionsResponse::nextToken)).setter(ListCostCategoryDefinitionsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COST_CATEGORY_REFERENCES_FIELD, NEXT_TOKEN_FIELD));
    private final List<CostCategoryReference> costCategoryReferences;
    private final String nextToken;

    private ListCostCategoryDefinitionsResponse(BuilderImpl builder) {
        super(builder);
        this.costCategoryReferences = builder.costCategoryReferences;
        this.nextToken = builder.nextToken;
    }

    public boolean hasCostCategoryReferences() {
        return this.costCategoryReferences != null && !(this.costCategoryReferences instanceof SdkAutoConstructList);
    }

    public List<CostCategoryReference> costCategoryReferences() {
        return this.costCategoryReferences;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.costCategoryReferences());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCostCategoryDefinitionsResponse)) {
            return false;
        }
        ListCostCategoryDefinitionsResponse other = (ListCostCategoryDefinitionsResponse)((Object)obj);
        return Objects.equals(this.costCategoryReferences(), other.costCategoryReferences()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListCostCategoryDefinitionsResponse").add("CostCategoryReferences", this.costCategoryReferences()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CostCategoryReferences": {
                return Optional.ofNullable(clazz.cast(this.costCategoryReferences()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListCostCategoryDefinitionsResponse, T> g) {
        return obj -> g.apply((ListCostCategoryDefinitionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CostExplorerResponse.BuilderImpl
    implements Builder {
        private List<CostCategoryReference> costCategoryReferences = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCostCategoryDefinitionsResponse model) {
            super(model);
            this.costCategoryReferences(model.costCategoryReferences);
            this.nextToken(model.nextToken);
        }

        public final Collection<CostCategoryReference.Builder> getCostCategoryReferences() {
            return this.costCategoryReferences != null ? (Collection)this.costCategoryReferences.stream().map(CostCategoryReference::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder costCategoryReferences(Collection<CostCategoryReference> costCategoryReferences) {
            this.costCategoryReferences = CostCategoryReferencesListCopier.copy(costCategoryReferences);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder costCategoryReferences(CostCategoryReference ... costCategoryReferences) {
            this.costCategoryReferences(Arrays.asList(costCategoryReferences));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder costCategoryReferences(Consumer<CostCategoryReference.Builder> ... costCategoryReferences) {
            this.costCategoryReferences(Stream.of(costCategoryReferences).map(c -> (CostCategoryReference)((CostCategoryReference.Builder)CostCategoryReference.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setCostCategoryReferences(Collection<CostCategoryReference.BuilderImpl> costCategoryReferences) {
            this.costCategoryReferences = CostCategoryReferencesListCopier.copyFromBuilder(costCategoryReferences);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListCostCategoryDefinitionsResponse build() {
            return new ListCostCategoryDefinitionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CostExplorerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListCostCategoryDefinitionsResponse> {
        public Builder costCategoryReferences(Collection<CostCategoryReference> var1);

        public Builder costCategoryReferences(CostCategoryReference ... var1);

        public Builder costCategoryReferences(Consumer<CostCategoryReference.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

