/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.costexplorer.model.AttributesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DimensionValuesWithAttributes
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DimensionValuesWithAttributes> {
    private static final SdkField<String> VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Value").getter(DimensionValuesWithAttributes.getter(DimensionValuesWithAttributes::value)).setter(DimensionValuesWithAttributes.setter(Builder::value)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()}).build();
    private static final SdkField<Map<String, String>> ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Attributes").getter(DimensionValuesWithAttributes.getter(DimensionValuesWithAttributes::attributes)).setter(DimensionValuesWithAttributes.setter(Builder::attributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attributes").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VALUE_FIELD, ATTRIBUTES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String value;
    private final Map<String, String> attributes;

    private DimensionValuesWithAttributes(BuilderImpl builder) {
        this.value = builder.value;
        this.attributes = builder.attributes;
    }

    public String value() {
        return this.value;
    }

    public boolean hasAttributes() {
        return this.attributes != null && !(this.attributes instanceof SdkAutoConstructMap);
    }

    public Map<String, String> attributes() {
        return this.attributes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.value());
        hashCode = 31 * hashCode + Objects.hashCode(this.attributes());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DimensionValuesWithAttributes)) {
            return false;
        }
        DimensionValuesWithAttributes other = (DimensionValuesWithAttributes)obj;
        return Objects.equals(this.value(), other.value()) && Objects.equals(this.attributes(), other.attributes());
    }

    public String toString() {
        return ToString.builder((String)"DimensionValuesWithAttributes").add("Value", (Object)this.value()).add("Attributes", this.attributes()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Value": {
                return Optional.ofNullable(clazz.cast(this.value()));
            }
            case "Attributes": {
                return Optional.ofNullable(clazz.cast(this.attributes()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DimensionValuesWithAttributes, T> g) {
        return obj -> g.apply((DimensionValuesWithAttributes)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String value;
        private Map<String, String> attributes = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DimensionValuesWithAttributes model) {
            this.value(model.value);
            this.attributes(model.attributes);
        }

        public final String getValue() {
            return this.value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        public final Map<String, String> getAttributes() {
            return this.attributes;
        }

        @Override
        public final Builder attributes(Map<String, String> attributes) {
            this.attributes = AttributesCopier.copy(attributes);
            return this;
        }

        public final void setAttributes(Map<String, String> attributes) {
            this.attributes = AttributesCopier.copy(attributes);
        }

        public DimensionValuesWithAttributes build() {
            return new DimensionValuesWithAttributes(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DimensionValuesWithAttributes> {
        public Builder value(String var1);

        public Builder attributes(Map<String, String> var1);
    }
}

