/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.costexplorer.model.CostExplorerResponse;
import software.amazon.awssdk.services.costexplorer.model.ReservationPurchaseRecommendation;
import software.amazon.awssdk.services.costexplorer.model.ReservationPurchaseRecommendationMetadata;
import software.amazon.awssdk.services.costexplorer.model.ReservationPurchaseRecommendationsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetReservationPurchaseRecommendationResponse
extends CostExplorerResponse
implements ToCopyableBuilder<Builder, GetReservationPurchaseRecommendationResponse> {
    private static final SdkField<ReservationPurchaseRecommendationMetadata> METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Metadata").getter(GetReservationPurchaseRecommendationResponse.getter(GetReservationPurchaseRecommendationResponse::metadata)).setter(GetReservationPurchaseRecommendationResponse.setter(Builder::metadata)).constructor(ReservationPurchaseRecommendationMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Metadata").build()}).build();
    private static final SdkField<List<ReservationPurchaseRecommendation>> RECOMMENDATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Recommendations").getter(GetReservationPurchaseRecommendationResponse.getter(GetReservationPurchaseRecommendationResponse::recommendations)).setter(GetReservationPurchaseRecommendationResponse.setter(Builder::recommendations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Recommendations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ReservationPurchaseRecommendation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_PAGE_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextPageToken").getter(GetReservationPurchaseRecommendationResponse.getter(GetReservationPurchaseRecommendationResponse::nextPageToken)).setter(GetReservationPurchaseRecommendationResponse.setter(Builder::nextPageToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextPageToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METADATA_FIELD, RECOMMENDATIONS_FIELD, NEXT_PAGE_TOKEN_FIELD));
    private final ReservationPurchaseRecommendationMetadata metadata;
    private final List<ReservationPurchaseRecommendation> recommendations;
    private final String nextPageToken;

    private GetReservationPurchaseRecommendationResponse(BuilderImpl builder) {
        super(builder);
        this.metadata = builder.metadata;
        this.recommendations = builder.recommendations;
        this.nextPageToken = builder.nextPageToken;
    }

    public ReservationPurchaseRecommendationMetadata metadata() {
        return this.metadata;
    }

    public boolean hasRecommendations() {
        return this.recommendations != null && !(this.recommendations instanceof SdkAutoConstructList);
    }

    public List<ReservationPurchaseRecommendation> recommendations() {
        return this.recommendations;
    }

    public String nextPageToken() {
        return this.nextPageToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.metadata());
        hashCode = 31 * hashCode + Objects.hashCode(this.recommendations());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextPageToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetReservationPurchaseRecommendationResponse)) {
            return false;
        }
        GetReservationPurchaseRecommendationResponse other = (GetReservationPurchaseRecommendationResponse)((Object)obj);
        return Objects.equals(this.metadata(), other.metadata()) && Objects.equals(this.recommendations(), other.recommendations()) && Objects.equals(this.nextPageToken(), other.nextPageToken());
    }

    public String toString() {
        return ToString.builder((String)"GetReservationPurchaseRecommendationResponse").add("Metadata", (Object)this.metadata()).add("Recommendations", this.recommendations()).add("NextPageToken", (Object)this.nextPageToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Metadata": {
                return Optional.ofNullable(clazz.cast(this.metadata()));
            }
            case "Recommendations": {
                return Optional.ofNullable(clazz.cast(this.recommendations()));
            }
            case "NextPageToken": {
                return Optional.ofNullable(clazz.cast(this.nextPageToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetReservationPurchaseRecommendationResponse, T> g) {
        return obj -> g.apply((GetReservationPurchaseRecommendationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CostExplorerResponse.BuilderImpl
    implements Builder {
        private ReservationPurchaseRecommendationMetadata metadata;
        private List<ReservationPurchaseRecommendation> recommendations = DefaultSdkAutoConstructList.getInstance();
        private String nextPageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetReservationPurchaseRecommendationResponse model) {
            super(model);
            this.metadata(model.metadata);
            this.recommendations(model.recommendations);
            this.nextPageToken(model.nextPageToken);
        }

        public final ReservationPurchaseRecommendationMetadata.Builder getMetadata() {
            return this.metadata != null ? this.metadata.toBuilder() : null;
        }

        @Override
        public final Builder metadata(ReservationPurchaseRecommendationMetadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public final void setMetadata(ReservationPurchaseRecommendationMetadata.BuilderImpl metadata) {
            this.metadata = metadata != null ? metadata.build() : null;
        }

        public final Collection<ReservationPurchaseRecommendation.Builder> getRecommendations() {
            return this.recommendations != null ? (Collection)this.recommendations.stream().map(ReservationPurchaseRecommendation::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder recommendations(Collection<ReservationPurchaseRecommendation> recommendations) {
            this.recommendations = ReservationPurchaseRecommendationsCopier.copy(recommendations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recommendations(ReservationPurchaseRecommendation ... recommendations) {
            this.recommendations(Arrays.asList(recommendations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recommendations(Consumer<ReservationPurchaseRecommendation.Builder> ... recommendations) {
            this.recommendations(Stream.of(recommendations).map(c -> (ReservationPurchaseRecommendation)((ReservationPurchaseRecommendation.Builder)ReservationPurchaseRecommendation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRecommendations(Collection<ReservationPurchaseRecommendation.BuilderImpl> recommendations) {
            this.recommendations = ReservationPurchaseRecommendationsCopier.copyFromBuilder(recommendations);
        }

        public final String getNextPageToken() {
            return this.nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        @Override
        public GetReservationPurchaseRecommendationResponse build() {
            return new GetReservationPurchaseRecommendationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CostExplorerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetReservationPurchaseRecommendationResponse> {
        public Builder metadata(ReservationPurchaseRecommendationMetadata var1);

        default public Builder metadata(Consumer<ReservationPurchaseRecommendationMetadata.Builder> metadata) {
            return this.metadata((ReservationPurchaseRecommendationMetadata)((ReservationPurchaseRecommendationMetadata.Builder)ReservationPurchaseRecommendationMetadata.builder().applyMutation(metadata)).build());
        }

        public Builder recommendations(Collection<ReservationPurchaseRecommendation> var1);

        public Builder recommendations(ReservationPurchaseRecommendation ... var1);

        public Builder recommendations(Consumer<ReservationPurchaseRecommendation.Builder> ... var1);

        public Builder nextPageToken(String var1);
    }
}

