/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.costexplorer.model.CostExplorerRequest;
import software.amazon.awssdk.services.costexplorer.model.ValuesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetAnomalyMonitorsRequest
extends CostExplorerRequest
implements ToCopyableBuilder<Builder, GetAnomalyMonitorsRequest> {
    private static final SdkField<List<String>> MONITOR_ARN_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(GetAnomalyMonitorsRequest.getter(GetAnomalyMonitorsRequest::monitorArnList)).setter(GetAnomalyMonitorsRequest.setter(Builder::monitorArnList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitorArnList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_PAGE_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetAnomalyMonitorsRequest.getter(GetAnomalyMonitorsRequest::nextPageToken)).setter(GetAnomalyMonitorsRequest.setter(Builder::nextPageToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextPageToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(GetAnomalyMonitorsRequest.getter(GetAnomalyMonitorsRequest::maxResults)).setter(GetAnomalyMonitorsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MONITOR_ARN_LIST_FIELD, NEXT_PAGE_TOKEN_FIELD, MAX_RESULTS_FIELD));
    private final List<String> monitorArnList;
    private final String nextPageToken;
    private final Integer maxResults;

    private GetAnomalyMonitorsRequest(BuilderImpl builder) {
        super(builder);
        this.monitorArnList = builder.monitorArnList;
        this.nextPageToken = builder.nextPageToken;
        this.maxResults = builder.maxResults;
    }

    public boolean hasMonitorArnList() {
        return this.monitorArnList != null && !(this.monitorArnList instanceof SdkAutoConstructList);
    }

    public List<String> monitorArnList() {
        return this.monitorArnList;
    }

    public String nextPageToken() {
        return this.nextPageToken;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.monitorArnList());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextPageToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAnomalyMonitorsRequest)) {
            return false;
        }
        GetAnomalyMonitorsRequest other = (GetAnomalyMonitorsRequest)((Object)obj);
        return Objects.equals(this.monitorArnList(), other.monitorArnList()) && Objects.equals(this.nextPageToken(), other.nextPageToken()) && Objects.equals(this.maxResults(), other.maxResults());
    }

    public String toString() {
        return ToString.builder((String)"GetAnomalyMonitorsRequest").add("MonitorArnList", this.monitorArnList()).add("NextPageToken", (Object)this.nextPageToken()).add("MaxResults", (Object)this.maxResults()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MonitorArnList": {
                return Optional.ofNullable(clazz.cast(this.monitorArnList()));
            }
            case "NextPageToken": {
                return Optional.ofNullable(clazz.cast(this.nextPageToken()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetAnomalyMonitorsRequest, T> g) {
        return obj -> g.apply((GetAnomalyMonitorsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CostExplorerRequest.BuilderImpl
    implements Builder {
        private List<String> monitorArnList = DefaultSdkAutoConstructList.getInstance();
        private String nextPageToken;
        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAnomalyMonitorsRequest model) {
            super(model);
            this.monitorArnList(model.monitorArnList);
            this.nextPageToken(model.nextPageToken);
            this.maxResults(model.maxResults);
        }

        public final Collection<String> getMonitorArnList() {
            return this.monitorArnList;
        }

        @Override
        public final Builder monitorArnList(Collection<String> monitorArnList) {
            this.monitorArnList = ValuesCopier.copy(monitorArnList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder monitorArnList(String ... monitorArnList) {
            this.monitorArnList(Arrays.asList(monitorArnList));
            return this;
        }

        public final void setMonitorArnList(Collection<String> monitorArnList) {
            this.monitorArnList = ValuesCopier.copy(monitorArnList);
        }

        public final String getNextPageToken() {
            return this.nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetAnomalyMonitorsRequest build() {
            return new GetAnomalyMonitorsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CostExplorerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetAnomalyMonitorsRequest> {
        public Builder monitorArnList(Collection<String> var1);

        public Builder monitorArnList(String ... var1);

        public Builder nextPageToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

