/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.costexplorer.model.CostExplorerResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ProvideAnomalyFeedbackResponse
extends CostExplorerResponse
implements ToCopyableBuilder<Builder, ProvideAnomalyFeedbackResponse> {
    private static final SdkField<String> ANOMALY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ProvideAnomalyFeedbackResponse.getter(ProvideAnomalyFeedbackResponse::anomalyId)).setter(ProvideAnomalyFeedbackResponse.setter(Builder::anomalyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnomalyId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ANOMALY_ID_FIELD));
    private final String anomalyId;

    private ProvideAnomalyFeedbackResponse(BuilderImpl builder) {
        super(builder);
        this.anomalyId = builder.anomalyId;
    }

    public String anomalyId() {
        return this.anomalyId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.anomalyId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProvideAnomalyFeedbackResponse)) {
            return false;
        }
        ProvideAnomalyFeedbackResponse other = (ProvideAnomalyFeedbackResponse)((Object)obj);
        return Objects.equals(this.anomalyId(), other.anomalyId());
    }

    public String toString() {
        return ToString.builder((String)"ProvideAnomalyFeedbackResponse").add("AnomalyId", (Object)this.anomalyId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AnomalyId": {
                return Optional.ofNullable(clazz.cast(this.anomalyId()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ProvideAnomalyFeedbackResponse, T> g) {
        return obj -> g.apply((ProvideAnomalyFeedbackResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CostExplorerResponse.BuilderImpl
    implements Builder {
        private String anomalyId;

        private BuilderImpl() {
        }

        private BuilderImpl(ProvideAnomalyFeedbackResponse model) {
            super(model);
            this.anomalyId(model.anomalyId);
        }

        public final String getAnomalyId() {
            return this.anomalyId;
        }

        @Override
        public final Builder anomalyId(String anomalyId) {
            this.anomalyId = anomalyId;
            return this;
        }

        public final void setAnomalyId(String anomalyId) {
            this.anomalyId = anomalyId;
        }

        @Override
        public ProvideAnomalyFeedbackResponse build() {
            return new ProvideAnomalyFeedbackResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CostExplorerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ProvideAnomalyFeedbackResponse> {
        public Builder anomalyId(String var1);
    }
}

