/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.costexplorer.model.CostExplorerRequest;
import software.amazon.awssdk.services.costexplorer.model.DateInterval;
import software.amazon.awssdk.services.costexplorer.model.Expression;
import software.amazon.awssdk.services.costexplorer.model.Granularity;
import software.amazon.awssdk.services.costexplorer.model.Metric;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetCostForecastRequest
extends CostExplorerRequest
implements ToCopyableBuilder<Builder, GetCostForecastRequest> {
    private static final SdkField<DateInterval> TIME_PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(GetCostForecastRequest.getter(GetCostForecastRequest::timePeriod)).setter(GetCostForecastRequest.setter(Builder::timePeriod)).constructor(DateInterval::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimePeriod").build()}).build();
    private static final SdkField<String> METRIC_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetCostForecastRequest.getter(GetCostForecastRequest::metricAsString)).setter(GetCostForecastRequest.setter(Builder::metric)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Metric").build()}).build();
    private static final SdkField<String> GRANULARITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetCostForecastRequest.getter(GetCostForecastRequest::granularityAsString)).setter(GetCostForecastRequest.setter(Builder::granularity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Granularity").build()}).build();
    private static final SdkField<Expression> FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(GetCostForecastRequest.getter(GetCostForecastRequest::filter)).setter(GetCostForecastRequest.setter(Builder::filter)).constructor(Expression::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter").build()}).build();
    private static final SdkField<Integer> PREDICTION_INTERVAL_LEVEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(GetCostForecastRequest.getter(GetCostForecastRequest::predictionIntervalLevel)).setter(GetCostForecastRequest.setter(Builder::predictionIntervalLevel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PredictionIntervalLevel").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TIME_PERIOD_FIELD, METRIC_FIELD, GRANULARITY_FIELD, FILTER_FIELD, PREDICTION_INTERVAL_LEVEL_FIELD));
    private final DateInterval timePeriod;
    private final String metric;
    private final String granularity;
    private final Expression filter;
    private final Integer predictionIntervalLevel;

    private GetCostForecastRequest(BuilderImpl builder) {
        super(builder);
        this.timePeriod = builder.timePeriod;
        this.metric = builder.metric;
        this.granularity = builder.granularity;
        this.filter = builder.filter;
        this.predictionIntervalLevel = builder.predictionIntervalLevel;
    }

    public DateInterval timePeriod() {
        return this.timePeriod;
    }

    public Metric metric() {
        return Metric.fromValue(this.metric);
    }

    public String metricAsString() {
        return this.metric;
    }

    public Granularity granularity() {
        return Granularity.fromValue(this.granularity);
    }

    public String granularityAsString() {
        return this.granularity;
    }

    public Expression filter() {
        return this.filter;
    }

    public Integer predictionIntervalLevel() {
        return this.predictionIntervalLevel;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.timePeriod());
        hashCode = 31 * hashCode + Objects.hashCode(this.metricAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.granularityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.filter());
        hashCode = 31 * hashCode + Objects.hashCode(this.predictionIntervalLevel());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCostForecastRequest)) {
            return false;
        }
        GetCostForecastRequest other = (GetCostForecastRequest)((Object)obj);
        return Objects.equals(this.timePeriod(), other.timePeriod()) && Objects.equals(this.metricAsString(), other.metricAsString()) && Objects.equals(this.granularityAsString(), other.granularityAsString()) && Objects.equals(this.filter(), other.filter()) && Objects.equals(this.predictionIntervalLevel(), other.predictionIntervalLevel());
    }

    public String toString() {
        return ToString.builder((String)"GetCostForecastRequest").add("TimePeriod", (Object)this.timePeriod()).add("Metric", (Object)this.metricAsString()).add("Granularity", (Object)this.granularityAsString()).add("Filter", (Object)this.filter()).add("PredictionIntervalLevel", (Object)this.predictionIntervalLevel()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TimePeriod": {
                return Optional.ofNullable(clazz.cast(this.timePeriod()));
            }
            case "Metric": {
                return Optional.ofNullable(clazz.cast(this.metricAsString()));
            }
            case "Granularity": {
                return Optional.ofNullable(clazz.cast(this.granularityAsString()));
            }
            case "Filter": {
                return Optional.ofNullable(clazz.cast(this.filter()));
            }
            case "PredictionIntervalLevel": {
                return Optional.ofNullable(clazz.cast(this.predictionIntervalLevel()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetCostForecastRequest, T> g) {
        return obj -> g.apply((GetCostForecastRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CostExplorerRequest.BuilderImpl
    implements Builder {
        private DateInterval timePeriod;
        private String metric;
        private String granularity;
        private Expression filter;
        private Integer predictionIntervalLevel;

        private BuilderImpl() {
        }

        private BuilderImpl(GetCostForecastRequest model) {
            super(model);
            this.timePeriod(model.timePeriod);
            this.metric(model.metric);
            this.granularity(model.granularity);
            this.filter(model.filter);
            this.predictionIntervalLevel(model.predictionIntervalLevel);
        }

        public final DateInterval.Builder getTimePeriod() {
            return this.timePeriod != null ? this.timePeriod.toBuilder() : null;
        }

        @Override
        public final Builder timePeriod(DateInterval timePeriod) {
            this.timePeriod = timePeriod;
            return this;
        }

        public final void setTimePeriod(DateInterval.BuilderImpl timePeriod) {
            this.timePeriod = timePeriod != null ? timePeriod.build() : null;
        }

        public final String getMetric() {
            return this.metric;
        }

        @Override
        public final Builder metric(String metric) {
            this.metric = metric;
            return this;
        }

        @Override
        public final Builder metric(Metric metric) {
            this.metric(metric == null ? null : metric.toString());
            return this;
        }

        public final void setMetric(String metric) {
            this.metric = metric;
        }

        public final String getGranularity() {
            return this.granularity;
        }

        @Override
        public final Builder granularity(String granularity) {
            this.granularity = granularity;
            return this;
        }

        @Override
        public final Builder granularity(Granularity granularity) {
            this.granularity(granularity == null ? null : granularity.toString());
            return this;
        }

        public final void setGranularity(String granularity) {
            this.granularity = granularity;
        }

        public final Expression.Builder getFilter() {
            return this.filter != null ? this.filter.toBuilder() : null;
        }

        @Override
        public final Builder filter(Expression filter) {
            this.filter = filter;
            return this;
        }

        public final void setFilter(Expression.BuilderImpl filter) {
            this.filter = filter != null ? filter.build() : null;
        }

        public final Integer getPredictionIntervalLevel() {
            return this.predictionIntervalLevel;
        }

        @Override
        public final Builder predictionIntervalLevel(Integer predictionIntervalLevel) {
            this.predictionIntervalLevel = predictionIntervalLevel;
            return this;
        }

        public final void setPredictionIntervalLevel(Integer predictionIntervalLevel) {
            this.predictionIntervalLevel = predictionIntervalLevel;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetCostForecastRequest build() {
            return new GetCostForecastRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CostExplorerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetCostForecastRequest> {
        public Builder timePeriod(DateInterval var1);

        default public Builder timePeriod(Consumer<DateInterval.Builder> timePeriod) {
            return this.timePeriod((DateInterval)((DateInterval.Builder)DateInterval.builder().applyMutation(timePeriod)).build());
        }

        public Builder metric(String var1);

        public Builder metric(Metric var1);

        public Builder granularity(String var1);

        public Builder granularity(Granularity var1);

        public Builder filter(Expression var1);

        default public Builder filter(Consumer<Expression.Builder> filter) {
            return this.filter((Expression)((Expression.Builder)Expression.builder().applyMutation(filter)).build());
        }

        public Builder predictionIntervalLevel(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

