/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costexplorer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The amount of Savings Plans eligible usage that is covered by Savings Plans. All calculations consider the On-Demand
 * equivalent of your Savings Plans usage.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SavingsPlansCoverage implements SdkPojo, Serializable,
        ToCopyableBuilder<SavingsPlansCoverage.Builder, SavingsPlansCoverage> {
    private static final SdkField<Map<String, String>> ATTRIBUTES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(SavingsPlansCoverage::attributes))
            .setter(setter(Builder::attributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attributes").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<SavingsPlansCoverageData> COVERAGE_FIELD = SdkField
            .<SavingsPlansCoverageData> builder(MarshallingType.SDK_POJO).getter(getter(SavingsPlansCoverage::coverage))
            .setter(setter(Builder::coverage)).constructor(SavingsPlansCoverageData::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Coverage").build()).build();

    private static final SdkField<DateInterval> TIME_PERIOD_FIELD = SdkField.<DateInterval> builder(MarshallingType.SDK_POJO)
            .getter(getter(SavingsPlansCoverage::timePeriod)).setter(setter(Builder::timePeriod))
            .constructor(DateInterval::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimePeriod").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTRIBUTES_FIELD,
            COVERAGE_FIELD, TIME_PERIOD_FIELD));

    private static final long serialVersionUID = 1L;

    private final Map<String, String> attributes;

    private final SavingsPlansCoverageData coverage;

    private final DateInterval timePeriod;

    private SavingsPlansCoverage(BuilderImpl builder) {
        this.attributes = builder.attributes;
        this.coverage = builder.coverage;
        this.timePeriod = builder.timePeriod;
    }

    /**
     * Returns true if the Attributes property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasAttributes() {
        return attributes != null && !(attributes instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The attribute that applies to a specific <code>Dimension</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAttributes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The attribute that applies to a specific <code>Dimension</code>.
     */
    public Map<String, String> attributes() {
        return attributes;
    }

    /**
     * <p>
     * The amount of Savings Plans eligible usage that the Savings Plans covered.
     * </p>
     * 
     * @return The amount of Savings Plans eligible usage that the Savings Plans covered.
     */
    public SavingsPlansCoverageData coverage() {
        return coverage;
    }

    /**
     * Returns the value of the TimePeriod property for this object.
     * 
     * @return The value of the TimePeriod property for this object.
     */
    public DateInterval timePeriod() {
        return timePeriod;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(attributes());
        hashCode = 31 * hashCode + Objects.hashCode(coverage());
        hashCode = 31 * hashCode + Objects.hashCode(timePeriod());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SavingsPlansCoverage)) {
            return false;
        }
        SavingsPlansCoverage other = (SavingsPlansCoverage) obj;
        return Objects.equals(attributes(), other.attributes()) && Objects.equals(coverage(), other.coverage())
                && Objects.equals(timePeriod(), other.timePeriod());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("SavingsPlansCoverage").add("Attributes", attributes()).add("Coverage", coverage())
                .add("TimePeriod", timePeriod()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Attributes":
            return Optional.ofNullable(clazz.cast(attributes()));
        case "Coverage":
            return Optional.ofNullable(clazz.cast(coverage()));
        case "TimePeriod":
            return Optional.ofNullable(clazz.cast(timePeriod()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SavingsPlansCoverage, T> g) {
        return obj -> g.apply((SavingsPlansCoverage) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SavingsPlansCoverage> {
        /**
         * <p>
         * The attribute that applies to a specific <code>Dimension</code>.
         * </p>
         * 
         * @param attributes
         *        The attribute that applies to a specific <code>Dimension</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(Map<String, String> attributes);

        /**
         * <p>
         * The amount of Savings Plans eligible usage that the Savings Plans covered.
         * </p>
         * 
         * @param coverage
         *        The amount of Savings Plans eligible usage that the Savings Plans covered.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder coverage(SavingsPlansCoverageData coverage);

        /**
         * <p>
         * The amount of Savings Plans eligible usage that the Savings Plans covered.
         * </p>
         * This is a convenience that creates an instance of the {@link SavingsPlansCoverageData.Builder} avoiding the
         * need to create one manually via {@link SavingsPlansCoverageData#builder()}.
         *
         * When the {@link Consumer} completes, {@link SavingsPlansCoverageData.Builder#build()} is called immediately
         * and its result is passed to {@link #coverage(SavingsPlansCoverageData)}.
         * 
         * @param coverage
         *        a consumer that will call methods on {@link SavingsPlansCoverageData.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #coverage(SavingsPlansCoverageData)
         */
        default Builder coverage(Consumer<SavingsPlansCoverageData.Builder> coverage) {
            return coverage(SavingsPlansCoverageData.builder().applyMutation(coverage).build());
        }

        /**
         * Sets the value of the TimePeriod property for this object.
         *
         * @param timePeriod
         *        The new value for the TimePeriod property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timePeriod(DateInterval timePeriod);

        /**
         * Sets the value of the TimePeriod property for this object.
         *
         * This is a convenience that creates an instance of the {@link DateInterval.Builder} avoiding the need to
         * create one manually via {@link DateInterval#builder()}.
         *
         * When the {@link Consumer} completes, {@link DateInterval.Builder#build()} is called immediately and its
         * result is passed to {@link #timePeriod(DateInterval)}.
         * 
         * @param timePeriod
         *        a consumer that will call methods on {@link DateInterval.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #timePeriod(DateInterval)
         */
        default Builder timePeriod(Consumer<DateInterval.Builder> timePeriod) {
            return timePeriod(DateInterval.builder().applyMutation(timePeriod).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Map<String, String> attributes = DefaultSdkAutoConstructMap.getInstance();

        private SavingsPlansCoverageData coverage;

        private DateInterval timePeriod;

        private BuilderImpl() {
        }

        private BuilderImpl(SavingsPlansCoverage model) {
            attributes(model.attributes);
            coverage(model.coverage);
            timePeriod(model.timePeriod);
        }

        public final Map<String, String> getAttributes() {
            return attributes;
        }

        @Override
        public final Builder attributes(Map<String, String> attributes) {
            this.attributes = AttributesCopier.copy(attributes);
            return this;
        }

        public final void setAttributes(Map<String, String> attributes) {
            this.attributes = AttributesCopier.copy(attributes);
        }

        public final SavingsPlansCoverageData.Builder getCoverage() {
            return coverage != null ? coverage.toBuilder() : null;
        }

        @Override
        public final Builder coverage(SavingsPlansCoverageData coverage) {
            this.coverage = coverage;
            return this;
        }

        public final void setCoverage(SavingsPlansCoverageData.BuilderImpl coverage) {
            this.coverage = coverage != null ? coverage.build() : null;
        }

        public final DateInterval.Builder getTimePeriod() {
            return timePeriod != null ? timePeriod.toBuilder() : null;
        }

        @Override
        public final Builder timePeriod(DateInterval timePeriod) {
            this.timePeriod = timePeriod;
            return this;
        }

        public final void setTimePeriod(DateInterval.BuilderImpl timePeriod) {
            this.timePeriod = timePeriod != null ? timePeriod.build() : null;
        }

        @Override
        public SavingsPlansCoverage build() {
            return new SavingsPlansCoverage(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
