/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costexplorer.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeCostCategoryDefinitionResponse extends CostExplorerResponse implements
        ToCopyableBuilder<DescribeCostCategoryDefinitionResponse.Builder, DescribeCostCategoryDefinitionResponse> {
    private static final SdkField<CostCategory> COST_CATEGORY_FIELD = SdkField.<CostCategory> builder(MarshallingType.SDK_POJO)
            .getter(getter(DescribeCostCategoryDefinitionResponse::costCategory)).setter(setter(Builder::costCategory))
            .constructor(CostCategory::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CostCategory").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COST_CATEGORY_FIELD));

    private final CostCategory costCategory;

    private DescribeCostCategoryDefinitionResponse(BuilderImpl builder) {
        super(builder);
        this.costCategory = builder.costCategory;
    }

    /**
     * Returns the value of the CostCategory property for this object.
     * 
     * @return The value of the CostCategory property for this object.
     */
    public CostCategory costCategory() {
        return costCategory;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(costCategory());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeCostCategoryDefinitionResponse)) {
            return false;
        }
        DescribeCostCategoryDefinitionResponse other = (DescribeCostCategoryDefinitionResponse) obj;
        return Objects.equals(costCategory(), other.costCategory());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeCostCategoryDefinitionResponse").add("CostCategory", costCategory()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CostCategory":
            return Optional.ofNullable(clazz.cast(costCategory()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeCostCategoryDefinitionResponse, T> g) {
        return obj -> g.apply((DescribeCostCategoryDefinitionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CostExplorerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeCostCategoryDefinitionResponse> {
        /**
         * Sets the value of the CostCategory property for this object.
         *
         * @param costCategory
         *        The new value for the CostCategory property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder costCategory(CostCategory costCategory);

        /**
         * Sets the value of the CostCategory property for this object.
         *
         * This is a convenience that creates an instance of the {@link CostCategory.Builder} avoiding the need to
         * create one manually via {@link CostCategory#builder()}.
         *
         * When the {@link Consumer} completes, {@link CostCategory.Builder#build()} is called immediately and its
         * result is passed to {@link #costCategory(CostCategory)}.
         * 
         * @param costCategory
         *        a consumer that will call methods on {@link CostCategory.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #costCategory(CostCategory)
         */
        default Builder costCategory(Consumer<CostCategory.Builder> costCategory) {
            return costCategory(CostCategory.builder().applyMutation(costCategory).build());
        }
    }

    static final class BuilderImpl extends CostExplorerResponse.BuilderImpl implements Builder {
        private CostCategory costCategory;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeCostCategoryDefinitionResponse model) {
            super(model);
            costCategory(model.costCategory);
        }

        public final CostCategory.Builder getCostCategory() {
            return costCategory != null ? costCategory.toBuilder() : null;
        }

        @Override
        public final Builder costCategory(CostCategory costCategory) {
            this.costCategory = costCategory;
            return this;
        }

        public final void setCostCategory(CostCategory.BuilderImpl costCategory) {
            this.costCategory = costCategory != null ? costCategory.build() : null;
        }

        @Override
        public DescribeCostCategoryDefinitionResponse build() {
            return new DescribeCostCategoryDefinitionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
