/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.costexplorer.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.costexplorer.model.AccountScope;
import software.amazon.awssdk.services.costexplorer.model.CostExplorerRequest;
import software.amazon.awssdk.services.costexplorer.model.Expression;
import software.amazon.awssdk.services.costexplorer.model.LookbackPeriodInDays;
import software.amazon.awssdk.services.costexplorer.model.PaymentOption;
import software.amazon.awssdk.services.costexplorer.model.SupportedSavingsPlansType;
import software.amazon.awssdk.services.costexplorer.model.TermInYears;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetSavingsPlansPurchaseRecommendationRequest
extends CostExplorerRequest
implements ToCopyableBuilder<Builder, GetSavingsPlansPurchaseRecommendationRequest> {
    private static final SdkField<String> SAVINGS_PLANS_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetSavingsPlansPurchaseRecommendationRequest.getter(GetSavingsPlansPurchaseRecommendationRequest::savingsPlansTypeAsString)).setter(GetSavingsPlansPurchaseRecommendationRequest.setter(Builder::savingsPlansType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SavingsPlansType").build()}).build();
    private static final SdkField<String> TERM_IN_YEARS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetSavingsPlansPurchaseRecommendationRequest.getter(GetSavingsPlansPurchaseRecommendationRequest::termInYearsAsString)).setter(GetSavingsPlansPurchaseRecommendationRequest.setter(Builder::termInYears)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TermInYears").build()}).build();
    private static final SdkField<String> PAYMENT_OPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetSavingsPlansPurchaseRecommendationRequest.getter(GetSavingsPlansPurchaseRecommendationRequest::paymentOptionAsString)).setter(GetSavingsPlansPurchaseRecommendationRequest.setter(Builder::paymentOption)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PaymentOption").build()}).build();
    private static final SdkField<String> ACCOUNT_SCOPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetSavingsPlansPurchaseRecommendationRequest.getter(GetSavingsPlansPurchaseRecommendationRequest::accountScopeAsString)).setter(GetSavingsPlansPurchaseRecommendationRequest.setter(Builder::accountScope)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountScope").build()}).build();
    private static final SdkField<String> NEXT_PAGE_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetSavingsPlansPurchaseRecommendationRequest.getter(GetSavingsPlansPurchaseRecommendationRequest::nextPageToken)).setter(GetSavingsPlansPurchaseRecommendationRequest.setter(Builder::nextPageToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextPageToken").build()}).build();
    private static final SdkField<Integer> PAGE_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(GetSavingsPlansPurchaseRecommendationRequest.getter(GetSavingsPlansPurchaseRecommendationRequest::pageSize)).setter(GetSavingsPlansPurchaseRecommendationRequest.setter(Builder::pageSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PageSize").build()}).build();
    private static final SdkField<String> LOOKBACK_PERIOD_IN_DAYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetSavingsPlansPurchaseRecommendationRequest.getter(GetSavingsPlansPurchaseRecommendationRequest::lookbackPeriodInDaysAsString)).setter(GetSavingsPlansPurchaseRecommendationRequest.setter(Builder::lookbackPeriodInDays)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LookbackPeriodInDays").build()}).build();
    private static final SdkField<Expression> FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(GetSavingsPlansPurchaseRecommendationRequest.getter(GetSavingsPlansPurchaseRecommendationRequest::filter)).setter(GetSavingsPlansPurchaseRecommendationRequest.setter(Builder::filter)).constructor(Expression::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SAVINGS_PLANS_TYPE_FIELD, TERM_IN_YEARS_FIELD, PAYMENT_OPTION_FIELD, ACCOUNT_SCOPE_FIELD, NEXT_PAGE_TOKEN_FIELD, PAGE_SIZE_FIELD, LOOKBACK_PERIOD_IN_DAYS_FIELD, FILTER_FIELD));
    private final String savingsPlansType;
    private final String termInYears;
    private final String paymentOption;
    private final String accountScope;
    private final String nextPageToken;
    private final Integer pageSize;
    private final String lookbackPeriodInDays;
    private final Expression filter;

    private GetSavingsPlansPurchaseRecommendationRequest(BuilderImpl builder) {
        super(builder);
        this.savingsPlansType = builder.savingsPlansType;
        this.termInYears = builder.termInYears;
        this.paymentOption = builder.paymentOption;
        this.accountScope = builder.accountScope;
        this.nextPageToken = builder.nextPageToken;
        this.pageSize = builder.pageSize;
        this.lookbackPeriodInDays = builder.lookbackPeriodInDays;
        this.filter = builder.filter;
    }

    public SupportedSavingsPlansType savingsPlansType() {
        return SupportedSavingsPlansType.fromValue(this.savingsPlansType);
    }

    public String savingsPlansTypeAsString() {
        return this.savingsPlansType;
    }

    public TermInYears termInYears() {
        return TermInYears.fromValue(this.termInYears);
    }

    public String termInYearsAsString() {
        return this.termInYears;
    }

    public PaymentOption paymentOption() {
        return PaymentOption.fromValue(this.paymentOption);
    }

    public String paymentOptionAsString() {
        return this.paymentOption;
    }

    public AccountScope accountScope() {
        return AccountScope.fromValue(this.accountScope);
    }

    public String accountScopeAsString() {
        return this.accountScope;
    }

    public String nextPageToken() {
        return this.nextPageToken;
    }

    public Integer pageSize() {
        return this.pageSize;
    }

    public LookbackPeriodInDays lookbackPeriodInDays() {
        return LookbackPeriodInDays.fromValue(this.lookbackPeriodInDays);
    }

    public String lookbackPeriodInDaysAsString() {
        return this.lookbackPeriodInDays;
    }

    public Expression filter() {
        return this.filter;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.savingsPlansTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.termInYearsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.paymentOptionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.accountScopeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextPageToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.pageSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.lookbackPeriodInDaysAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.filter());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSavingsPlansPurchaseRecommendationRequest)) {
            return false;
        }
        GetSavingsPlansPurchaseRecommendationRequest other = (GetSavingsPlansPurchaseRecommendationRequest)((Object)obj);
        return Objects.equals(this.savingsPlansTypeAsString(), other.savingsPlansTypeAsString()) && Objects.equals(this.termInYearsAsString(), other.termInYearsAsString()) && Objects.equals(this.paymentOptionAsString(), other.paymentOptionAsString()) && Objects.equals(this.accountScopeAsString(), other.accountScopeAsString()) && Objects.equals(this.nextPageToken(), other.nextPageToken()) && Objects.equals(this.pageSize(), other.pageSize()) && Objects.equals(this.lookbackPeriodInDaysAsString(), other.lookbackPeriodInDaysAsString()) && Objects.equals(this.filter(), other.filter());
    }

    public String toString() {
        return ToString.builder((String)"GetSavingsPlansPurchaseRecommendationRequest").add("SavingsPlansType", (Object)this.savingsPlansTypeAsString()).add("TermInYears", (Object)this.termInYearsAsString()).add("PaymentOption", (Object)this.paymentOptionAsString()).add("AccountScope", (Object)this.accountScopeAsString()).add("NextPageToken", (Object)this.nextPageToken()).add("PageSize", (Object)this.pageSize()).add("LookbackPeriodInDays", (Object)this.lookbackPeriodInDaysAsString()).add("Filter", (Object)this.filter()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SavingsPlansType": {
                return Optional.ofNullable(clazz.cast(this.savingsPlansTypeAsString()));
            }
            case "TermInYears": {
                return Optional.ofNullable(clazz.cast(this.termInYearsAsString()));
            }
            case "PaymentOption": {
                return Optional.ofNullable(clazz.cast(this.paymentOptionAsString()));
            }
            case "AccountScope": {
                return Optional.ofNullable(clazz.cast(this.accountScopeAsString()));
            }
            case "NextPageToken": {
                return Optional.ofNullable(clazz.cast(this.nextPageToken()));
            }
            case "PageSize": {
                return Optional.ofNullable(clazz.cast(this.pageSize()));
            }
            case "LookbackPeriodInDays": {
                return Optional.ofNullable(clazz.cast(this.lookbackPeriodInDaysAsString()));
            }
            case "Filter": {
                return Optional.ofNullable(clazz.cast(this.filter()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetSavingsPlansPurchaseRecommendationRequest, T> g) {
        return obj -> g.apply((GetSavingsPlansPurchaseRecommendationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CostExplorerRequest.BuilderImpl
    implements Builder {
        private String savingsPlansType;
        private String termInYears;
        private String paymentOption;
        private String accountScope;
        private String nextPageToken;
        private Integer pageSize;
        private String lookbackPeriodInDays;
        private Expression filter;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSavingsPlansPurchaseRecommendationRequest model) {
            super(model);
            this.savingsPlansType(model.savingsPlansType);
            this.termInYears(model.termInYears);
            this.paymentOption(model.paymentOption);
            this.accountScope(model.accountScope);
            this.nextPageToken(model.nextPageToken);
            this.pageSize(model.pageSize);
            this.lookbackPeriodInDays(model.lookbackPeriodInDays);
            this.filter(model.filter);
        }

        public final String getSavingsPlansTypeAsString() {
            return this.savingsPlansType;
        }

        @Override
        public final Builder savingsPlansType(String savingsPlansType) {
            this.savingsPlansType = savingsPlansType;
            return this;
        }

        @Override
        public final Builder savingsPlansType(SupportedSavingsPlansType savingsPlansType) {
            this.savingsPlansType(savingsPlansType == null ? null : savingsPlansType.toString());
            return this;
        }

        public final void setSavingsPlansType(String savingsPlansType) {
            this.savingsPlansType = savingsPlansType;
        }

        public final String getTermInYearsAsString() {
            return this.termInYears;
        }

        @Override
        public final Builder termInYears(String termInYears) {
            this.termInYears = termInYears;
            return this;
        }

        @Override
        public final Builder termInYears(TermInYears termInYears) {
            this.termInYears(termInYears == null ? null : termInYears.toString());
            return this;
        }

        public final void setTermInYears(String termInYears) {
            this.termInYears = termInYears;
        }

        public final String getPaymentOptionAsString() {
            return this.paymentOption;
        }

        @Override
        public final Builder paymentOption(String paymentOption) {
            this.paymentOption = paymentOption;
            return this;
        }

        @Override
        public final Builder paymentOption(PaymentOption paymentOption) {
            this.paymentOption(paymentOption == null ? null : paymentOption.toString());
            return this;
        }

        public final void setPaymentOption(String paymentOption) {
            this.paymentOption = paymentOption;
        }

        public final String getAccountScopeAsString() {
            return this.accountScope;
        }

        @Override
        public final Builder accountScope(String accountScope) {
            this.accountScope = accountScope;
            return this;
        }

        @Override
        public final Builder accountScope(AccountScope accountScope) {
            this.accountScope(accountScope == null ? null : accountScope.toString());
            return this;
        }

        public final void setAccountScope(String accountScope) {
            this.accountScope = accountScope;
        }

        public final String getNextPageToken() {
            return this.nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        public final Integer getPageSize() {
            return this.pageSize;
        }

        @Override
        public final Builder pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public final void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }

        public final String getLookbackPeriodInDaysAsString() {
            return this.lookbackPeriodInDays;
        }

        @Override
        public final Builder lookbackPeriodInDays(String lookbackPeriodInDays) {
            this.lookbackPeriodInDays = lookbackPeriodInDays;
            return this;
        }

        @Override
        public final Builder lookbackPeriodInDays(LookbackPeriodInDays lookbackPeriodInDays) {
            this.lookbackPeriodInDays(lookbackPeriodInDays == null ? null : lookbackPeriodInDays.toString());
            return this;
        }

        public final void setLookbackPeriodInDays(String lookbackPeriodInDays) {
            this.lookbackPeriodInDays = lookbackPeriodInDays;
        }

        public final Expression.Builder getFilter() {
            return this.filter != null ? this.filter.toBuilder() : null;
        }

        @Override
        public final Builder filter(Expression filter) {
            this.filter = filter;
            return this;
        }

        public final void setFilter(Expression.BuilderImpl filter) {
            this.filter = filter != null ? filter.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetSavingsPlansPurchaseRecommendationRequest build() {
            return new GetSavingsPlansPurchaseRecommendationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CostExplorerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetSavingsPlansPurchaseRecommendationRequest> {
        public Builder savingsPlansType(String var1);

        public Builder savingsPlansType(SupportedSavingsPlansType var1);

        public Builder termInYears(String var1);

        public Builder termInYears(TermInYears var1);

        public Builder paymentOption(String var1);

        public Builder paymentOption(PaymentOption var1);

        public Builder accountScope(String var1);

        public Builder accountScope(AccountScope var1);

        public Builder nextPageToken(String var1);

        public Builder pageSize(Integer var1);

        public Builder lookbackPeriodInDays(String var1);

        public Builder lookbackPeriodInDays(LookbackPeriodInDays var1);

        public Builder filter(Expression var1);

        default public Builder filter(Consumer<Expression.Builder> filter) {
            return this.filter((Expression)((Expression.Builder)Expression.builder().applyMutation(filter)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

