/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costexplorer.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateCostCategoryDefinitionRequest extends CostExplorerRequest implements
        ToCopyableBuilder<UpdateCostCategoryDefinitionRequest.Builder, UpdateCostCategoryDefinitionRequest> {
    private static final SdkField<String> COST_CATEGORY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateCostCategoryDefinitionRequest::costCategoryArn)).setter(setter(Builder::costCategoryArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CostCategoryArn").build()).build();

    private static final SdkField<String> RULE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateCostCategoryDefinitionRequest::ruleVersionAsString)).setter(setter(Builder::ruleVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleVersion").build()).build();

    private static final SdkField<List<CostCategoryRule>> RULES_FIELD = SdkField
            .<List<CostCategoryRule>> builder(MarshallingType.LIST)
            .getter(getter(UpdateCostCategoryDefinitionRequest::rules))
            .setter(setter(Builder::rules))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Rules").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CostCategoryRule> builder(MarshallingType.SDK_POJO)
                                            .constructor(CostCategoryRule::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COST_CATEGORY_ARN_FIELD,
            RULE_VERSION_FIELD, RULES_FIELD));

    private final String costCategoryArn;

    private final String ruleVersion;

    private final List<CostCategoryRule> rules;

    private UpdateCostCategoryDefinitionRequest(BuilderImpl builder) {
        super(builder);
        this.costCategoryArn = builder.costCategoryArn;
        this.ruleVersion = builder.ruleVersion;
        this.rules = builder.rules;
    }

    /**
     * <p>
     * The unique identifier for your Cost Category.
     * </p>
     * 
     * @return The unique identifier for your Cost Category.
     */
    public String costCategoryArn() {
        return costCategoryArn;
    }

    /**
     * Returns the value of the RuleVersion property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ruleVersion} will
     * return {@link CostCategoryRuleVersion#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #ruleVersionAsString}.
     * </p>
     * 
     * @return The value of the RuleVersion property for this object.
     * @see CostCategoryRuleVersion
     */
    public CostCategoryRuleVersion ruleVersion() {
        return CostCategoryRuleVersion.fromValue(ruleVersion);
    }

    /**
     * Returns the value of the RuleVersion property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #ruleVersion} will
     * return {@link CostCategoryRuleVersion#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #ruleVersionAsString}.
     * </p>
     * 
     * @return The value of the RuleVersion property for this object.
     * @see CostCategoryRuleVersion
     */
    public String ruleVersionAsString() {
        return ruleVersion;
    }

    /**
     * Returns true if the Rules property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasRules() {
        return rules != null && !(rules instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * <code>UpdateCostCategoryDefinition</code> supports dimensions, Tags, and nested expressions. Currently the only
     * dimensions supported is <code>LINKED_ACCOUNT</code>.
     * </p>
     * <p>
     * Root level <code>OR</code> is not supported. We recommend you create a separate rule instead.
     * </p>
     * <p>
     * Rules are processed in order. If there are multiple rules that match the line item, then the first rule to match
     * is used to determine that Cost Category value.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasRules()} to see if a value was sent in this field.
     * </p>
     * 
     * @return <code>UpdateCostCategoryDefinition</code> supports dimensions, Tags, and nested expressions. Currently
     *         the only dimensions supported is <code>LINKED_ACCOUNT</code>.</p>
     *         <p>
     *         Root level <code>OR</code> is not supported. We recommend you create a separate rule instead.
     *         </p>
     *         <p>
     *         Rules are processed in order. If there are multiple rules that match the line item, then the first rule
     *         to match is used to determine that Cost Category value.
     */
    public List<CostCategoryRule> rules() {
        return rules;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(costCategoryArn());
        hashCode = 31 * hashCode + Objects.hashCode(ruleVersionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(rules());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateCostCategoryDefinitionRequest)) {
            return false;
        }
        UpdateCostCategoryDefinitionRequest other = (UpdateCostCategoryDefinitionRequest) obj;
        return Objects.equals(costCategoryArn(), other.costCategoryArn())
                && Objects.equals(ruleVersionAsString(), other.ruleVersionAsString()) && Objects.equals(rules(), other.rules());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdateCostCategoryDefinitionRequest").add("CostCategoryArn", costCategoryArn())
                .add("RuleVersion", ruleVersionAsString()).add("Rules", rules()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CostCategoryArn":
            return Optional.ofNullable(clazz.cast(costCategoryArn()));
        case "RuleVersion":
            return Optional.ofNullable(clazz.cast(ruleVersionAsString()));
        case "Rules":
            return Optional.ofNullable(clazz.cast(rules()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateCostCategoryDefinitionRequest, T> g) {
        return obj -> g.apply((UpdateCostCategoryDefinitionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CostExplorerRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateCostCategoryDefinitionRequest> {
        /**
         * <p>
         * The unique identifier for your Cost Category.
         * </p>
         * 
         * @param costCategoryArn
         *        The unique identifier for your Cost Category.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder costCategoryArn(String costCategoryArn);

        /**
         * Sets the value of the RuleVersion property for this object.
         *
         * @param ruleVersion
         *        The new value for the RuleVersion property for this object.
         * @see CostCategoryRuleVersion
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CostCategoryRuleVersion
         */
        Builder ruleVersion(String ruleVersion);

        /**
         * Sets the value of the RuleVersion property for this object.
         *
         * @param ruleVersion
         *        The new value for the RuleVersion property for this object.
         * @see CostCategoryRuleVersion
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CostCategoryRuleVersion
         */
        Builder ruleVersion(CostCategoryRuleVersion ruleVersion);

        /**
         * <p>
         * <code>UpdateCostCategoryDefinition</code> supports dimensions, Tags, and nested expressions. Currently the
         * only dimensions supported is <code>LINKED_ACCOUNT</code>.
         * </p>
         * <p>
         * Root level <code>OR</code> is not supported. We recommend you create a separate rule instead.
         * </p>
         * <p>
         * Rules are processed in order. If there are multiple rules that match the line item, then the first rule to
         * match is used to determine that Cost Category value.
         * </p>
         * 
         * @param rules
         *        <code>UpdateCostCategoryDefinition</code> supports dimensions, Tags, and nested expressions. Currently
         *        the only dimensions supported is <code>LINKED_ACCOUNT</code>.</p>
         *        <p>
         *        Root level <code>OR</code> is not supported. We recommend you create a separate rule instead.
         *        </p>
         *        <p>
         *        Rules are processed in order. If there are multiple rules that match the line item, then the first
         *        rule to match is used to determine that Cost Category value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rules(Collection<CostCategoryRule> rules);

        /**
         * <p>
         * <code>UpdateCostCategoryDefinition</code> supports dimensions, Tags, and nested expressions. Currently the
         * only dimensions supported is <code>LINKED_ACCOUNT</code>.
         * </p>
         * <p>
         * Root level <code>OR</code> is not supported. We recommend you create a separate rule instead.
         * </p>
         * <p>
         * Rules are processed in order. If there are multiple rules that match the line item, then the first rule to
         * match is used to determine that Cost Category value.
         * </p>
         * 
         * @param rules
         *        <code>UpdateCostCategoryDefinition</code> supports dimensions, Tags, and nested expressions. Currently
         *        the only dimensions supported is <code>LINKED_ACCOUNT</code>.</p>
         *        <p>
         *        Root level <code>OR</code> is not supported. We recommend you create a separate rule instead.
         *        </p>
         *        <p>
         *        Rules are processed in order. If there are multiple rules that match the line item, then the first
         *        rule to match is used to determine that Cost Category value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rules(CostCategoryRule... rules);

        /**
         * <p>
         * <code>UpdateCostCategoryDefinition</code> supports dimensions, Tags, and nested expressions. Currently the
         * only dimensions supported is <code>LINKED_ACCOUNT</code>.
         * </p>
         * <p>
         * Root level <code>OR</code> is not supported. We recommend you create a separate rule instead.
         * </p>
         * <p>
         * Rules are processed in order. If there are multiple rules that match the line item, then the first rule to
         * match is used to determine that Cost Category value.
         * </p>
         * This is a convenience that creates an instance of the {@link List<CostCategoryRule>.Builder} avoiding the
         * need to create one manually via {@link List<CostCategoryRule>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<CostCategoryRule>.Builder#build()} is called immediately and
         * its result is passed to {@link #rules(List<CostCategoryRule>)}.
         * 
         * @param rules
         *        a consumer that will call methods on {@link List<CostCategoryRule>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rules(List<CostCategoryRule>)
         */
        Builder rules(Consumer<CostCategoryRule.Builder>... rules);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CostExplorerRequest.BuilderImpl implements Builder {
        private String costCategoryArn;

        private String ruleVersion;

        private List<CostCategoryRule> rules = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateCostCategoryDefinitionRequest model) {
            super(model);
            costCategoryArn(model.costCategoryArn);
            ruleVersion(model.ruleVersion);
            rules(model.rules);
        }

        public final String getCostCategoryArn() {
            return costCategoryArn;
        }

        @Override
        public final Builder costCategoryArn(String costCategoryArn) {
            this.costCategoryArn = costCategoryArn;
            return this;
        }

        public final void setCostCategoryArn(String costCategoryArn) {
            this.costCategoryArn = costCategoryArn;
        }

        public final String getRuleVersionAsString() {
            return ruleVersion;
        }

        @Override
        public final Builder ruleVersion(String ruleVersion) {
            this.ruleVersion = ruleVersion;
            return this;
        }

        @Override
        public final Builder ruleVersion(CostCategoryRuleVersion ruleVersion) {
            this.ruleVersion(ruleVersion == null ? null : ruleVersion.toString());
            return this;
        }

        public final void setRuleVersion(String ruleVersion) {
            this.ruleVersion = ruleVersion;
        }

        public final Collection<CostCategoryRule.Builder> getRules() {
            return rules != null ? rules.stream().map(CostCategoryRule::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder rules(Collection<CostCategoryRule> rules) {
            this.rules = CostCategoryRulesListCopier.copy(rules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(CostCategoryRule... rules) {
            rules(Arrays.asList(rules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(Consumer<CostCategoryRule.Builder>... rules) {
            rules(Stream.of(rules).map(c -> CostCategoryRule.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRules(Collection<CostCategoryRule.BuilderImpl> rules) {
            this.rules = CostCategoryRulesListCopier.copyFromBuilder(rules);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateCostCategoryDefinitionRequest build() {
            return new UpdateCostCategoryDefinitionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
