/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costexplorer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details for your recommended Savings Plans.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SavingsPlansPurchaseRecommendationDetail implements SdkPojo, Serializable,
        ToCopyableBuilder<SavingsPlansPurchaseRecommendationDetail.Builder, SavingsPlansPurchaseRecommendationDetail> {
    private static final SdkField<SavingsPlansDetails> SAVINGS_PLANS_DETAILS_FIELD = SdkField
            .<SavingsPlansDetails> builder(MarshallingType.SDK_POJO)
            .getter(getter(SavingsPlansPurchaseRecommendationDetail::savingsPlansDetails))
            .setter(setter(Builder::savingsPlansDetails)).constructor(SavingsPlansDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SavingsPlansDetails").build())
            .build();

    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SavingsPlansPurchaseRecommendationDetail::accountId)).setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountId").build()).build();

    private static final SdkField<String> UPFRONT_COST_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SavingsPlansPurchaseRecommendationDetail::upfrontCost)).setter(setter(Builder::upfrontCost))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpfrontCost").build()).build();

    private static final SdkField<String> ESTIMATED_ROI_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SavingsPlansPurchaseRecommendationDetail::estimatedROI)).setter(setter(Builder::estimatedROI))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EstimatedROI").build()).build();

    private static final SdkField<String> CURRENCY_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SavingsPlansPurchaseRecommendationDetail::currencyCode)).setter(setter(Builder::currencyCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrencyCode").build()).build();

    private static final SdkField<String> ESTIMATED_SP_COST_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SavingsPlansPurchaseRecommendationDetail::estimatedSPCost)).setter(setter(Builder::estimatedSPCost))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EstimatedSPCost").build()).build();

    private static final SdkField<String> ESTIMATED_ON_DEMAND_COST_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SavingsPlansPurchaseRecommendationDetail::estimatedOnDemandCost))
            .setter(setter(Builder::estimatedOnDemandCost))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EstimatedOnDemandCost").build())
            .build();

    private static final SdkField<String> ESTIMATED_ON_DEMAND_COST_WITH_CURRENT_COMMITMENT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(SavingsPlansPurchaseRecommendationDetail::estimatedOnDemandCostWithCurrentCommitment))
            .setter(setter(Builder::estimatedOnDemandCostWithCurrentCommitment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("EstimatedOnDemandCostWithCurrentCommitment").build()).build();

    private static final SdkField<String> ESTIMATED_SAVINGS_AMOUNT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SavingsPlansPurchaseRecommendationDetail::estimatedSavingsAmount))
            .setter(setter(Builder::estimatedSavingsAmount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EstimatedSavingsAmount").build())
            .build();

    private static final SdkField<String> ESTIMATED_SAVINGS_PERCENTAGE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(SavingsPlansPurchaseRecommendationDetail::estimatedSavingsPercentage))
            .setter(setter(Builder::estimatedSavingsPercentage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EstimatedSavingsPercentage").build())
            .build();

    private static final SdkField<String> HOURLY_COMMITMENT_TO_PURCHASE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(SavingsPlansPurchaseRecommendationDetail::hourlyCommitmentToPurchase))
            .setter(setter(Builder::hourlyCommitmentToPurchase))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HourlyCommitmentToPurchase").build())
            .build();

    private static final SdkField<String> ESTIMATED_AVERAGE_UTILIZATION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(SavingsPlansPurchaseRecommendationDetail::estimatedAverageUtilization))
            .setter(setter(Builder::estimatedAverageUtilization))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EstimatedAverageUtilization")
                    .build()).build();

    private static final SdkField<String> ESTIMATED_MONTHLY_SAVINGS_AMOUNT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(SavingsPlansPurchaseRecommendationDetail::estimatedMonthlySavingsAmount))
            .setter(setter(Builder::estimatedMonthlySavingsAmount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EstimatedMonthlySavingsAmount")
                    .build()).build();

    private static final SdkField<String> CURRENT_MINIMUM_HOURLY_ON_DEMAND_SPEND_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(SavingsPlansPurchaseRecommendationDetail::currentMinimumHourlyOnDemandSpend))
            .setter(setter(Builder::currentMinimumHourlyOnDemandSpend))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentMinimumHourlyOnDemandSpend")
                    .build()).build();

    private static final SdkField<String> CURRENT_MAXIMUM_HOURLY_ON_DEMAND_SPEND_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(SavingsPlansPurchaseRecommendationDetail::currentMaximumHourlyOnDemandSpend))
            .setter(setter(Builder::currentMaximumHourlyOnDemandSpend))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentMaximumHourlyOnDemandSpend")
                    .build()).build();

    private static final SdkField<String> CURRENT_AVERAGE_HOURLY_ON_DEMAND_SPEND_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(SavingsPlansPurchaseRecommendationDetail::currentAverageHourlyOnDemandSpend))
            .setter(setter(Builder::currentAverageHourlyOnDemandSpend))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentAverageHourlyOnDemandSpend")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SAVINGS_PLANS_DETAILS_FIELD,
            ACCOUNT_ID_FIELD, UPFRONT_COST_FIELD, ESTIMATED_ROI_FIELD, CURRENCY_CODE_FIELD, ESTIMATED_SP_COST_FIELD,
            ESTIMATED_ON_DEMAND_COST_FIELD, ESTIMATED_ON_DEMAND_COST_WITH_CURRENT_COMMITMENT_FIELD,
            ESTIMATED_SAVINGS_AMOUNT_FIELD, ESTIMATED_SAVINGS_PERCENTAGE_FIELD, HOURLY_COMMITMENT_TO_PURCHASE_FIELD,
            ESTIMATED_AVERAGE_UTILIZATION_FIELD, ESTIMATED_MONTHLY_SAVINGS_AMOUNT_FIELD,
            CURRENT_MINIMUM_HOURLY_ON_DEMAND_SPEND_FIELD, CURRENT_MAXIMUM_HOURLY_ON_DEMAND_SPEND_FIELD,
            CURRENT_AVERAGE_HOURLY_ON_DEMAND_SPEND_FIELD));

    private static final long serialVersionUID = 1L;

    private final SavingsPlansDetails savingsPlansDetails;

    private final String accountId;

    private final String upfrontCost;

    private final String estimatedROI;

    private final String currencyCode;

    private final String estimatedSPCost;

    private final String estimatedOnDemandCost;

    private final String estimatedOnDemandCostWithCurrentCommitment;

    private final String estimatedSavingsAmount;

    private final String estimatedSavingsPercentage;

    private final String hourlyCommitmentToPurchase;

    private final String estimatedAverageUtilization;

    private final String estimatedMonthlySavingsAmount;

    private final String currentMinimumHourlyOnDemandSpend;

    private final String currentMaximumHourlyOnDemandSpend;

    private final String currentAverageHourlyOnDemandSpend;

    private SavingsPlansPurchaseRecommendationDetail(BuilderImpl builder) {
        this.savingsPlansDetails = builder.savingsPlansDetails;
        this.accountId = builder.accountId;
        this.upfrontCost = builder.upfrontCost;
        this.estimatedROI = builder.estimatedROI;
        this.currencyCode = builder.currencyCode;
        this.estimatedSPCost = builder.estimatedSPCost;
        this.estimatedOnDemandCost = builder.estimatedOnDemandCost;
        this.estimatedOnDemandCostWithCurrentCommitment = builder.estimatedOnDemandCostWithCurrentCommitment;
        this.estimatedSavingsAmount = builder.estimatedSavingsAmount;
        this.estimatedSavingsPercentage = builder.estimatedSavingsPercentage;
        this.hourlyCommitmentToPurchase = builder.hourlyCommitmentToPurchase;
        this.estimatedAverageUtilization = builder.estimatedAverageUtilization;
        this.estimatedMonthlySavingsAmount = builder.estimatedMonthlySavingsAmount;
        this.currentMinimumHourlyOnDemandSpend = builder.currentMinimumHourlyOnDemandSpend;
        this.currentMaximumHourlyOnDemandSpend = builder.currentMaximumHourlyOnDemandSpend;
        this.currentAverageHourlyOnDemandSpend = builder.currentAverageHourlyOnDemandSpend;
    }

    /**
     * <p>
     * Details for your recommended Savings Plans.
     * </p>
     * 
     * @return Details for your recommended Savings Plans.
     */
    public SavingsPlansDetails savingsPlansDetails() {
        return savingsPlansDetails;
    }

    /**
     * <p>
     * The <code>AccountID</code> the recommendation is generated for.
     * </p>
     * 
     * @return The <code>AccountID</code> the recommendation is generated for.
     */
    public String accountId() {
        return accountId;
    }

    /**
     * <p>
     * The upfront cost of the recommended Savings Plans, based on the selected payment option.
     * </p>
     * 
     * @return The upfront cost of the recommended Savings Plans, based on the selected payment option.
     */
    public String upfrontCost() {
        return upfrontCost;
    }

    /**
     * <p>
     * The estimated return on investment based on the recommended Savings Plans purchased. This is calculated as
     * <code>estimatedSavingsAmount</code>/ <code>estimatedSPCost</code>*100.
     * </p>
     * 
     * @return The estimated return on investment based on the recommended Savings Plans purchased. This is calculated
     *         as <code>estimatedSavingsAmount</code>/ <code>estimatedSPCost</code>*100.
     */
    public String estimatedROI() {
        return estimatedROI;
    }

    /**
     * <p>
     * The currency code Amazon Web Services used to generate the recommendations and present potential savings.
     * </p>
     * 
     * @return The currency code Amazon Web Services used to generate the recommendations and present potential savings.
     */
    public String currencyCode() {
        return currencyCode;
    }

    /**
     * <p>
     * The cost of the recommended Savings Plans over the length of the lookback period.
     * </p>
     * 
     * @return The cost of the recommended Savings Plans over the length of the lookback period.
     */
    public String estimatedSPCost() {
        return estimatedSPCost;
    }

    /**
     * <p>
     * The remaining On-Demand cost estimated to not be covered by the recommended Savings Plans, over the length of the
     * lookback period.
     * </p>
     * 
     * @return The remaining On-Demand cost estimated to not be covered by the recommended Savings Plans, over the
     *         length of the lookback period.
     */
    public String estimatedOnDemandCost() {
        return estimatedOnDemandCost;
    }

    /**
     * <p>
     * The estimated On-Demand costs you would expect with no additional commitment, based on your usage of the selected
     * time period and the Savings Plans you own.
     * </p>
     * 
     * @return The estimated On-Demand costs you would expect with no additional commitment, based on your usage of the
     *         selected time period and the Savings Plans you own.
     */
    public String estimatedOnDemandCostWithCurrentCommitment() {
        return estimatedOnDemandCostWithCurrentCommitment;
    }

    /**
     * <p>
     * The estimated savings amount based on the recommended Savings Plans over the length of the lookback period.
     * </p>
     * 
     * @return The estimated savings amount based on the recommended Savings Plans over the length of the lookback
     *         period.
     */
    public String estimatedSavingsAmount() {
        return estimatedSavingsAmount;
    }

    /**
     * <p>
     * The estimated savings percentage relative to the total cost of applicable On-Demand usage over the lookback
     * period.
     * </p>
     * 
     * @return The estimated savings percentage relative to the total cost of applicable On-Demand usage over the
     *         lookback period.
     */
    public String estimatedSavingsPercentage() {
        return estimatedSavingsPercentage;
    }

    /**
     * <p>
     * The recommended hourly commitment level for the Savings Plans type, and configuration based on the usage during
     * the lookback period.
     * </p>
     * 
     * @return The recommended hourly commitment level for the Savings Plans type, and configuration based on the usage
     *         during the lookback period.
     */
    public String hourlyCommitmentToPurchase() {
        return hourlyCommitmentToPurchase;
    }

    /**
     * <p>
     * The estimated utilization of the recommended Savings Plans.
     * </p>
     * 
     * @return The estimated utilization of the recommended Savings Plans.
     */
    public String estimatedAverageUtilization() {
        return estimatedAverageUtilization;
    }

    /**
     * <p>
     * The estimated monthly savings amount, based on the recommended Savings Plans.
     * </p>
     * 
     * @return The estimated monthly savings amount, based on the recommended Savings Plans.
     */
    public String estimatedMonthlySavingsAmount() {
        return estimatedMonthlySavingsAmount;
    }

    /**
     * <p>
     * The lowest value of hourly On-Demand spend over the lookback period of the applicable usage type.
     * </p>
     * 
     * @return The lowest value of hourly On-Demand spend over the lookback period of the applicable usage type.
     */
    public String currentMinimumHourlyOnDemandSpend() {
        return currentMinimumHourlyOnDemandSpend;
    }

    /**
     * <p>
     * The highest value of hourly On-Demand spend over the lookback period of the applicable usage type.
     * </p>
     * 
     * @return The highest value of hourly On-Demand spend over the lookback period of the applicable usage type.
     */
    public String currentMaximumHourlyOnDemandSpend() {
        return currentMaximumHourlyOnDemandSpend;
    }

    /**
     * <p>
     * The average value of hourly On-Demand spend over the lookback period of the applicable usage type.
     * </p>
     * 
     * @return The average value of hourly On-Demand spend over the lookback period of the applicable usage type.
     */
    public String currentAverageHourlyOnDemandSpend() {
        return currentAverageHourlyOnDemandSpend;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(savingsPlansDetails());
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(upfrontCost());
        hashCode = 31 * hashCode + Objects.hashCode(estimatedROI());
        hashCode = 31 * hashCode + Objects.hashCode(currencyCode());
        hashCode = 31 * hashCode + Objects.hashCode(estimatedSPCost());
        hashCode = 31 * hashCode + Objects.hashCode(estimatedOnDemandCost());
        hashCode = 31 * hashCode + Objects.hashCode(estimatedOnDemandCostWithCurrentCommitment());
        hashCode = 31 * hashCode + Objects.hashCode(estimatedSavingsAmount());
        hashCode = 31 * hashCode + Objects.hashCode(estimatedSavingsPercentage());
        hashCode = 31 * hashCode + Objects.hashCode(hourlyCommitmentToPurchase());
        hashCode = 31 * hashCode + Objects.hashCode(estimatedAverageUtilization());
        hashCode = 31 * hashCode + Objects.hashCode(estimatedMonthlySavingsAmount());
        hashCode = 31 * hashCode + Objects.hashCode(currentMinimumHourlyOnDemandSpend());
        hashCode = 31 * hashCode + Objects.hashCode(currentMaximumHourlyOnDemandSpend());
        hashCode = 31 * hashCode + Objects.hashCode(currentAverageHourlyOnDemandSpend());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SavingsPlansPurchaseRecommendationDetail)) {
            return false;
        }
        SavingsPlansPurchaseRecommendationDetail other = (SavingsPlansPurchaseRecommendationDetail) obj;
        return Objects.equals(savingsPlansDetails(), other.savingsPlansDetails())
                && Objects.equals(accountId(), other.accountId())
                && Objects.equals(upfrontCost(), other.upfrontCost())
                && Objects.equals(estimatedROI(), other.estimatedROI())
                && Objects.equals(currencyCode(), other.currencyCode())
                && Objects.equals(estimatedSPCost(), other.estimatedSPCost())
                && Objects.equals(estimatedOnDemandCost(), other.estimatedOnDemandCost())
                && Objects.equals(estimatedOnDemandCostWithCurrentCommitment(),
                        other.estimatedOnDemandCostWithCurrentCommitment())
                && Objects.equals(estimatedSavingsAmount(), other.estimatedSavingsAmount())
                && Objects.equals(estimatedSavingsPercentage(), other.estimatedSavingsPercentage())
                && Objects.equals(hourlyCommitmentToPurchase(), other.hourlyCommitmentToPurchase())
                && Objects.equals(estimatedAverageUtilization(), other.estimatedAverageUtilization())
                && Objects.equals(estimatedMonthlySavingsAmount(), other.estimatedMonthlySavingsAmount())
                && Objects.equals(currentMinimumHourlyOnDemandSpend(), other.currentMinimumHourlyOnDemandSpend())
                && Objects.equals(currentMaximumHourlyOnDemandSpend(), other.currentMaximumHourlyOnDemandSpend())
                && Objects.equals(currentAverageHourlyOnDemandSpend(), other.currentAverageHourlyOnDemandSpend());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("SavingsPlansPurchaseRecommendationDetail").add("SavingsPlansDetails", savingsPlansDetails())
                .add("AccountId", accountId()).add("UpfrontCost", upfrontCost()).add("EstimatedROI", estimatedROI())
                .add("CurrencyCode", currencyCode()).add("EstimatedSPCost", estimatedSPCost())
                .add("EstimatedOnDemandCost", estimatedOnDemandCost())
                .add("EstimatedOnDemandCostWithCurrentCommitment", estimatedOnDemandCostWithCurrentCommitment())
                .add("EstimatedSavingsAmount", estimatedSavingsAmount())
                .add("EstimatedSavingsPercentage", estimatedSavingsPercentage())
                .add("HourlyCommitmentToPurchase", hourlyCommitmentToPurchase())
                .add("EstimatedAverageUtilization", estimatedAverageUtilization())
                .add("EstimatedMonthlySavingsAmount", estimatedMonthlySavingsAmount())
                .add("CurrentMinimumHourlyOnDemandSpend", currentMinimumHourlyOnDemandSpend())
                .add("CurrentMaximumHourlyOnDemandSpend", currentMaximumHourlyOnDemandSpend())
                .add("CurrentAverageHourlyOnDemandSpend", currentAverageHourlyOnDemandSpend()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SavingsPlansDetails":
            return Optional.ofNullable(clazz.cast(savingsPlansDetails()));
        case "AccountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "UpfrontCost":
            return Optional.ofNullable(clazz.cast(upfrontCost()));
        case "EstimatedROI":
            return Optional.ofNullable(clazz.cast(estimatedROI()));
        case "CurrencyCode":
            return Optional.ofNullable(clazz.cast(currencyCode()));
        case "EstimatedSPCost":
            return Optional.ofNullable(clazz.cast(estimatedSPCost()));
        case "EstimatedOnDemandCost":
            return Optional.ofNullable(clazz.cast(estimatedOnDemandCost()));
        case "EstimatedOnDemandCostWithCurrentCommitment":
            return Optional.ofNullable(clazz.cast(estimatedOnDemandCostWithCurrentCommitment()));
        case "EstimatedSavingsAmount":
            return Optional.ofNullable(clazz.cast(estimatedSavingsAmount()));
        case "EstimatedSavingsPercentage":
            return Optional.ofNullable(clazz.cast(estimatedSavingsPercentage()));
        case "HourlyCommitmentToPurchase":
            return Optional.ofNullable(clazz.cast(hourlyCommitmentToPurchase()));
        case "EstimatedAverageUtilization":
            return Optional.ofNullable(clazz.cast(estimatedAverageUtilization()));
        case "EstimatedMonthlySavingsAmount":
            return Optional.ofNullable(clazz.cast(estimatedMonthlySavingsAmount()));
        case "CurrentMinimumHourlyOnDemandSpend":
            return Optional.ofNullable(clazz.cast(currentMinimumHourlyOnDemandSpend()));
        case "CurrentMaximumHourlyOnDemandSpend":
            return Optional.ofNullable(clazz.cast(currentMaximumHourlyOnDemandSpend()));
        case "CurrentAverageHourlyOnDemandSpend":
            return Optional.ofNullable(clazz.cast(currentAverageHourlyOnDemandSpend()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SavingsPlansPurchaseRecommendationDetail, T> g) {
        return obj -> g.apply((SavingsPlansPurchaseRecommendationDetail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SavingsPlansPurchaseRecommendationDetail> {
        /**
         * <p>
         * Details for your recommended Savings Plans.
         * </p>
         * 
         * @param savingsPlansDetails
         *        Details for your recommended Savings Plans.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder savingsPlansDetails(SavingsPlansDetails savingsPlansDetails);

        /**
         * <p>
         * Details for your recommended Savings Plans.
         * </p>
         * This is a convenience that creates an instance of the {@link SavingsPlansDetails.Builder} avoiding the need
         * to create one manually via {@link SavingsPlansDetails#builder()}.
         *
         * When the {@link Consumer} completes, {@link SavingsPlansDetails.Builder#build()} is called immediately and
         * its result is passed to {@link #savingsPlansDetails(SavingsPlansDetails)}.
         * 
         * @param savingsPlansDetails
         *        a consumer that will call methods on {@link SavingsPlansDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #savingsPlansDetails(SavingsPlansDetails)
         */
        default Builder savingsPlansDetails(Consumer<SavingsPlansDetails.Builder> savingsPlansDetails) {
            return savingsPlansDetails(SavingsPlansDetails.builder().applyMutation(savingsPlansDetails).build());
        }

        /**
         * <p>
         * The <code>AccountID</code> the recommendation is generated for.
         * </p>
         * 
         * @param accountId
         *        The <code>AccountID</code> the recommendation is generated for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * The upfront cost of the recommended Savings Plans, based on the selected payment option.
         * </p>
         * 
         * @param upfrontCost
         *        The upfront cost of the recommended Savings Plans, based on the selected payment option.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder upfrontCost(String upfrontCost);

        /**
         * <p>
         * The estimated return on investment based on the recommended Savings Plans purchased. This is calculated as
         * <code>estimatedSavingsAmount</code>/ <code>estimatedSPCost</code>*100.
         * </p>
         * 
         * @param estimatedROI
         *        The estimated return on investment based on the recommended Savings Plans purchased. This is
         *        calculated as <code>estimatedSavingsAmount</code>/ <code>estimatedSPCost</code>*100.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder estimatedROI(String estimatedROI);

        /**
         * <p>
         * The currency code Amazon Web Services used to generate the recommendations and present potential savings.
         * </p>
         * 
         * @param currencyCode
         *        The currency code Amazon Web Services used to generate the recommendations and present potential
         *        savings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currencyCode(String currencyCode);

        /**
         * <p>
         * The cost of the recommended Savings Plans over the length of the lookback period.
         * </p>
         * 
         * @param estimatedSPCost
         *        The cost of the recommended Savings Plans over the length of the lookback period.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder estimatedSPCost(String estimatedSPCost);

        /**
         * <p>
         * The remaining On-Demand cost estimated to not be covered by the recommended Savings Plans, over the length of
         * the lookback period.
         * </p>
         * 
         * @param estimatedOnDemandCost
         *        The remaining On-Demand cost estimated to not be covered by the recommended Savings Plans, over the
         *        length of the lookback period.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder estimatedOnDemandCost(String estimatedOnDemandCost);

        /**
         * <p>
         * The estimated On-Demand costs you would expect with no additional commitment, based on your usage of the
         * selected time period and the Savings Plans you own.
         * </p>
         * 
         * @param estimatedOnDemandCostWithCurrentCommitment
         *        The estimated On-Demand costs you would expect with no additional commitment, based on your usage of
         *        the selected time period and the Savings Plans you own.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder estimatedOnDemandCostWithCurrentCommitment(String estimatedOnDemandCostWithCurrentCommitment);

        /**
         * <p>
         * The estimated savings amount based on the recommended Savings Plans over the length of the lookback period.
         * </p>
         * 
         * @param estimatedSavingsAmount
         *        The estimated savings amount based on the recommended Savings Plans over the length of the lookback
         *        period.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder estimatedSavingsAmount(String estimatedSavingsAmount);

        /**
         * <p>
         * The estimated savings percentage relative to the total cost of applicable On-Demand usage over the lookback
         * period.
         * </p>
         * 
         * @param estimatedSavingsPercentage
         *        The estimated savings percentage relative to the total cost of applicable On-Demand usage over the
         *        lookback period.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder estimatedSavingsPercentage(String estimatedSavingsPercentage);

        /**
         * <p>
         * The recommended hourly commitment level for the Savings Plans type, and configuration based on the usage
         * during the lookback period.
         * </p>
         * 
         * @param hourlyCommitmentToPurchase
         *        The recommended hourly commitment level for the Savings Plans type, and configuration based on the
         *        usage during the lookback period.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hourlyCommitmentToPurchase(String hourlyCommitmentToPurchase);

        /**
         * <p>
         * The estimated utilization of the recommended Savings Plans.
         * </p>
         * 
         * @param estimatedAverageUtilization
         *        The estimated utilization of the recommended Savings Plans.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder estimatedAverageUtilization(String estimatedAverageUtilization);

        /**
         * <p>
         * The estimated monthly savings amount, based on the recommended Savings Plans.
         * </p>
         * 
         * @param estimatedMonthlySavingsAmount
         *        The estimated monthly savings amount, based on the recommended Savings Plans.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder estimatedMonthlySavingsAmount(String estimatedMonthlySavingsAmount);

        /**
         * <p>
         * The lowest value of hourly On-Demand spend over the lookback period of the applicable usage type.
         * </p>
         * 
         * @param currentMinimumHourlyOnDemandSpend
         *        The lowest value of hourly On-Demand spend over the lookback period of the applicable usage type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentMinimumHourlyOnDemandSpend(String currentMinimumHourlyOnDemandSpend);

        /**
         * <p>
         * The highest value of hourly On-Demand spend over the lookback period of the applicable usage type.
         * </p>
         * 
         * @param currentMaximumHourlyOnDemandSpend
         *        The highest value of hourly On-Demand spend over the lookback period of the applicable usage type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentMaximumHourlyOnDemandSpend(String currentMaximumHourlyOnDemandSpend);

        /**
         * <p>
         * The average value of hourly On-Demand spend over the lookback period of the applicable usage type.
         * </p>
         * 
         * @param currentAverageHourlyOnDemandSpend
         *        The average value of hourly On-Demand spend over the lookback period of the applicable usage type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentAverageHourlyOnDemandSpend(String currentAverageHourlyOnDemandSpend);
    }

    static final class BuilderImpl implements Builder {
        private SavingsPlansDetails savingsPlansDetails;

        private String accountId;

        private String upfrontCost;

        private String estimatedROI;

        private String currencyCode;

        private String estimatedSPCost;

        private String estimatedOnDemandCost;

        private String estimatedOnDemandCostWithCurrentCommitment;

        private String estimatedSavingsAmount;

        private String estimatedSavingsPercentage;

        private String hourlyCommitmentToPurchase;

        private String estimatedAverageUtilization;

        private String estimatedMonthlySavingsAmount;

        private String currentMinimumHourlyOnDemandSpend;

        private String currentMaximumHourlyOnDemandSpend;

        private String currentAverageHourlyOnDemandSpend;

        private BuilderImpl() {
        }

        private BuilderImpl(SavingsPlansPurchaseRecommendationDetail model) {
            savingsPlansDetails(model.savingsPlansDetails);
            accountId(model.accountId);
            upfrontCost(model.upfrontCost);
            estimatedROI(model.estimatedROI);
            currencyCode(model.currencyCode);
            estimatedSPCost(model.estimatedSPCost);
            estimatedOnDemandCost(model.estimatedOnDemandCost);
            estimatedOnDemandCostWithCurrentCommitment(model.estimatedOnDemandCostWithCurrentCommitment);
            estimatedSavingsAmount(model.estimatedSavingsAmount);
            estimatedSavingsPercentage(model.estimatedSavingsPercentage);
            hourlyCommitmentToPurchase(model.hourlyCommitmentToPurchase);
            estimatedAverageUtilization(model.estimatedAverageUtilization);
            estimatedMonthlySavingsAmount(model.estimatedMonthlySavingsAmount);
            currentMinimumHourlyOnDemandSpend(model.currentMinimumHourlyOnDemandSpend);
            currentMaximumHourlyOnDemandSpend(model.currentMaximumHourlyOnDemandSpend);
            currentAverageHourlyOnDemandSpend(model.currentAverageHourlyOnDemandSpend);
        }

        public final SavingsPlansDetails.Builder getSavingsPlansDetails() {
            return savingsPlansDetails != null ? savingsPlansDetails.toBuilder() : null;
        }

        @Override
        public final Builder savingsPlansDetails(SavingsPlansDetails savingsPlansDetails) {
            this.savingsPlansDetails = savingsPlansDetails;
            return this;
        }

        public final void setSavingsPlansDetails(SavingsPlansDetails.BuilderImpl savingsPlansDetails) {
            this.savingsPlansDetails = savingsPlansDetails != null ? savingsPlansDetails.build() : null;
        }

        public final String getAccountId() {
            return accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        public final String getUpfrontCost() {
            return upfrontCost;
        }

        @Override
        public final Builder upfrontCost(String upfrontCost) {
            this.upfrontCost = upfrontCost;
            return this;
        }

        public final void setUpfrontCost(String upfrontCost) {
            this.upfrontCost = upfrontCost;
        }

        public final String getEstimatedROI() {
            return estimatedROI;
        }

        @Override
        public final Builder estimatedROI(String estimatedROI) {
            this.estimatedROI = estimatedROI;
            return this;
        }

        public final void setEstimatedROI(String estimatedROI) {
            this.estimatedROI = estimatedROI;
        }

        public final String getCurrencyCode() {
            return currencyCode;
        }

        @Override
        public final Builder currencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
            return this;
        }

        public final void setCurrencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
        }

        public final String getEstimatedSPCost() {
            return estimatedSPCost;
        }

        @Override
        public final Builder estimatedSPCost(String estimatedSPCost) {
            this.estimatedSPCost = estimatedSPCost;
            return this;
        }

        public final void setEstimatedSPCost(String estimatedSPCost) {
            this.estimatedSPCost = estimatedSPCost;
        }

        public final String getEstimatedOnDemandCost() {
            return estimatedOnDemandCost;
        }

        @Override
        public final Builder estimatedOnDemandCost(String estimatedOnDemandCost) {
            this.estimatedOnDemandCost = estimatedOnDemandCost;
            return this;
        }

        public final void setEstimatedOnDemandCost(String estimatedOnDemandCost) {
            this.estimatedOnDemandCost = estimatedOnDemandCost;
        }

        public final String getEstimatedOnDemandCostWithCurrentCommitment() {
            return estimatedOnDemandCostWithCurrentCommitment;
        }

        @Override
        public final Builder estimatedOnDemandCostWithCurrentCommitment(String estimatedOnDemandCostWithCurrentCommitment) {
            this.estimatedOnDemandCostWithCurrentCommitment = estimatedOnDemandCostWithCurrentCommitment;
            return this;
        }

        public final void setEstimatedOnDemandCostWithCurrentCommitment(String estimatedOnDemandCostWithCurrentCommitment) {
            this.estimatedOnDemandCostWithCurrentCommitment = estimatedOnDemandCostWithCurrentCommitment;
        }

        public final String getEstimatedSavingsAmount() {
            return estimatedSavingsAmount;
        }

        @Override
        public final Builder estimatedSavingsAmount(String estimatedSavingsAmount) {
            this.estimatedSavingsAmount = estimatedSavingsAmount;
            return this;
        }

        public final void setEstimatedSavingsAmount(String estimatedSavingsAmount) {
            this.estimatedSavingsAmount = estimatedSavingsAmount;
        }

        public final String getEstimatedSavingsPercentage() {
            return estimatedSavingsPercentage;
        }

        @Override
        public final Builder estimatedSavingsPercentage(String estimatedSavingsPercentage) {
            this.estimatedSavingsPercentage = estimatedSavingsPercentage;
            return this;
        }

        public final void setEstimatedSavingsPercentage(String estimatedSavingsPercentage) {
            this.estimatedSavingsPercentage = estimatedSavingsPercentage;
        }

        public final String getHourlyCommitmentToPurchase() {
            return hourlyCommitmentToPurchase;
        }

        @Override
        public final Builder hourlyCommitmentToPurchase(String hourlyCommitmentToPurchase) {
            this.hourlyCommitmentToPurchase = hourlyCommitmentToPurchase;
            return this;
        }

        public final void setHourlyCommitmentToPurchase(String hourlyCommitmentToPurchase) {
            this.hourlyCommitmentToPurchase = hourlyCommitmentToPurchase;
        }

        public final String getEstimatedAverageUtilization() {
            return estimatedAverageUtilization;
        }

        @Override
        public final Builder estimatedAverageUtilization(String estimatedAverageUtilization) {
            this.estimatedAverageUtilization = estimatedAverageUtilization;
            return this;
        }

        public final void setEstimatedAverageUtilization(String estimatedAverageUtilization) {
            this.estimatedAverageUtilization = estimatedAverageUtilization;
        }

        public final String getEstimatedMonthlySavingsAmount() {
            return estimatedMonthlySavingsAmount;
        }

        @Override
        public final Builder estimatedMonthlySavingsAmount(String estimatedMonthlySavingsAmount) {
            this.estimatedMonthlySavingsAmount = estimatedMonthlySavingsAmount;
            return this;
        }

        public final void setEstimatedMonthlySavingsAmount(String estimatedMonthlySavingsAmount) {
            this.estimatedMonthlySavingsAmount = estimatedMonthlySavingsAmount;
        }

        public final String getCurrentMinimumHourlyOnDemandSpend() {
            return currentMinimumHourlyOnDemandSpend;
        }

        @Override
        public final Builder currentMinimumHourlyOnDemandSpend(String currentMinimumHourlyOnDemandSpend) {
            this.currentMinimumHourlyOnDemandSpend = currentMinimumHourlyOnDemandSpend;
            return this;
        }

        public final void setCurrentMinimumHourlyOnDemandSpend(String currentMinimumHourlyOnDemandSpend) {
            this.currentMinimumHourlyOnDemandSpend = currentMinimumHourlyOnDemandSpend;
        }

        public final String getCurrentMaximumHourlyOnDemandSpend() {
            return currentMaximumHourlyOnDemandSpend;
        }

        @Override
        public final Builder currentMaximumHourlyOnDemandSpend(String currentMaximumHourlyOnDemandSpend) {
            this.currentMaximumHourlyOnDemandSpend = currentMaximumHourlyOnDemandSpend;
            return this;
        }

        public final void setCurrentMaximumHourlyOnDemandSpend(String currentMaximumHourlyOnDemandSpend) {
            this.currentMaximumHourlyOnDemandSpend = currentMaximumHourlyOnDemandSpend;
        }

        public final String getCurrentAverageHourlyOnDemandSpend() {
            return currentAverageHourlyOnDemandSpend;
        }

        @Override
        public final Builder currentAverageHourlyOnDemandSpend(String currentAverageHourlyOnDemandSpend) {
            this.currentAverageHourlyOnDemandSpend = currentAverageHourlyOnDemandSpend;
            return this;
        }

        public final void setCurrentAverageHourlyOnDemandSpend(String currentAverageHourlyOnDemandSpend) {
            this.currentAverageHourlyOnDemandSpend = currentAverageHourlyOnDemandSpend;
        }

        @Override
        public SavingsPlansPurchaseRecommendationDetail build() {
            return new SavingsPlansPurchaseRecommendationDetail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
