/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costexplorer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains your request parameters, Savings Plan Recommendations Summary, and Details.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SavingsPlansPurchaseRecommendation implements SdkPojo, Serializable,
        ToCopyableBuilder<SavingsPlansPurchaseRecommendation.Builder, SavingsPlansPurchaseRecommendation> {
    private static final SdkField<String> SAVINGS_PLANS_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SavingsPlansPurchaseRecommendation::savingsPlansTypeAsString))
            .setter(setter(Builder::savingsPlansType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SavingsPlansType").build()).build();

    private static final SdkField<String> TERM_IN_YEARS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SavingsPlansPurchaseRecommendation::termInYearsAsString)).setter(setter(Builder::termInYears))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TermInYears").build()).build();

    private static final SdkField<String> PAYMENT_OPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SavingsPlansPurchaseRecommendation::paymentOptionAsString)).setter(setter(Builder::paymentOption))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PaymentOption").build()).build();

    private static final SdkField<String> LOOKBACK_PERIOD_IN_DAYS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SavingsPlansPurchaseRecommendation::lookbackPeriodInDaysAsString))
            .setter(setter(Builder::lookbackPeriodInDays))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LookbackPeriodInDays").build())
            .build();

    private static final SdkField<List<SavingsPlansPurchaseRecommendationDetail>> SAVINGS_PLANS_PURCHASE_RECOMMENDATION_DETAILS_FIELD = SdkField
            .<List<SavingsPlansPurchaseRecommendationDetail>> builder(MarshallingType.LIST)
            .getter(getter(SavingsPlansPurchaseRecommendation::savingsPlansPurchaseRecommendationDetails))
            .setter(setter(Builder::savingsPlansPurchaseRecommendationDetails))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("SavingsPlansPurchaseRecommendationDetails").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SavingsPlansPurchaseRecommendationDetail> builder(MarshallingType.SDK_POJO)
                                            .constructor(SavingsPlansPurchaseRecommendationDetail::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<SavingsPlansPurchaseRecommendationSummary> SAVINGS_PLANS_PURCHASE_RECOMMENDATION_SUMMARY_FIELD = SdkField
            .<SavingsPlansPurchaseRecommendationSummary> builder(MarshallingType.SDK_POJO)
            .getter(getter(SavingsPlansPurchaseRecommendation::savingsPlansPurchaseRecommendationSummary))
            .setter(setter(Builder::savingsPlansPurchaseRecommendationSummary))
            .constructor(SavingsPlansPurchaseRecommendationSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("SavingsPlansPurchaseRecommendationSummary").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SAVINGS_PLANS_TYPE_FIELD,
            TERM_IN_YEARS_FIELD, PAYMENT_OPTION_FIELD, LOOKBACK_PERIOD_IN_DAYS_FIELD,
            SAVINGS_PLANS_PURCHASE_RECOMMENDATION_DETAILS_FIELD, SAVINGS_PLANS_PURCHASE_RECOMMENDATION_SUMMARY_FIELD));

    private static final long serialVersionUID = 1L;

    private final String savingsPlansType;

    private final String termInYears;

    private final String paymentOption;

    private final String lookbackPeriodInDays;

    private final List<SavingsPlansPurchaseRecommendationDetail> savingsPlansPurchaseRecommendationDetails;

    private final SavingsPlansPurchaseRecommendationSummary savingsPlansPurchaseRecommendationSummary;

    private SavingsPlansPurchaseRecommendation(BuilderImpl builder) {
        this.savingsPlansType = builder.savingsPlansType;
        this.termInYears = builder.termInYears;
        this.paymentOption = builder.paymentOption;
        this.lookbackPeriodInDays = builder.lookbackPeriodInDays;
        this.savingsPlansPurchaseRecommendationDetails = builder.savingsPlansPurchaseRecommendationDetails;
        this.savingsPlansPurchaseRecommendationSummary = builder.savingsPlansPurchaseRecommendationSummary;
    }

    /**
     * <p>
     * The requested Savings Plans recommendation type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #savingsPlansType}
     * will return {@link SupportedSavingsPlansType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #savingsPlansTypeAsString}.
     * </p>
     * 
     * @return The requested Savings Plans recommendation type.
     * @see SupportedSavingsPlansType
     */
    public SupportedSavingsPlansType savingsPlansType() {
        return SupportedSavingsPlansType.fromValue(savingsPlansType);
    }

    /**
     * <p>
     * The requested Savings Plans recommendation type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #savingsPlansType}
     * will return {@link SupportedSavingsPlansType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #savingsPlansTypeAsString}.
     * </p>
     * 
     * @return The requested Savings Plans recommendation type.
     * @see SupportedSavingsPlansType
     */
    public String savingsPlansTypeAsString() {
        return savingsPlansType;
    }

    /**
     * <p>
     * The Savings Plans recommendation term in years, used to generate the recommendation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #termInYears} will
     * return {@link TermInYears#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #termInYearsAsString}.
     * </p>
     * 
     * @return The Savings Plans recommendation term in years, used to generate the recommendation.
     * @see TermInYears
     */
    public TermInYears termInYears() {
        return TermInYears.fromValue(termInYears);
    }

    /**
     * <p>
     * The Savings Plans recommendation term in years, used to generate the recommendation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #termInYears} will
     * return {@link TermInYears#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #termInYearsAsString}.
     * </p>
     * 
     * @return The Savings Plans recommendation term in years, used to generate the recommendation.
     * @see TermInYears
     */
    public String termInYearsAsString() {
        return termInYears;
    }

    /**
     * <p>
     * The payment option used to generate the recommendation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #paymentOption}
     * will return {@link PaymentOption#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #paymentOptionAsString}.
     * </p>
     * 
     * @return The payment option used to generate the recommendation.
     * @see PaymentOption
     */
    public PaymentOption paymentOption() {
        return PaymentOption.fromValue(paymentOption);
    }

    /**
     * <p>
     * The payment option used to generate the recommendation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #paymentOption}
     * will return {@link PaymentOption#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #paymentOptionAsString}.
     * </p>
     * 
     * @return The payment option used to generate the recommendation.
     * @see PaymentOption
     */
    public String paymentOptionAsString() {
        return paymentOption;
    }

    /**
     * <p>
     * The lookback period in days, used to generate the recommendation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #lookbackPeriodInDays} will return {@link LookbackPeriodInDays#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #lookbackPeriodInDaysAsString}.
     * </p>
     * 
     * @return The lookback period in days, used to generate the recommendation.
     * @see LookbackPeriodInDays
     */
    public LookbackPeriodInDays lookbackPeriodInDays() {
        return LookbackPeriodInDays.fromValue(lookbackPeriodInDays);
    }

    /**
     * <p>
     * The lookback period in days, used to generate the recommendation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #lookbackPeriodInDays} will return {@link LookbackPeriodInDays#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #lookbackPeriodInDaysAsString}.
     * </p>
     * 
     * @return The lookback period in days, used to generate the recommendation.
     * @see LookbackPeriodInDays
     */
    public String lookbackPeriodInDaysAsString() {
        return lookbackPeriodInDays;
    }

    /**
     * Returns true if the SavingsPlansPurchaseRecommendationDetails property was specified by the sender (it may be
     * empty), or false if the sender did not specify the value (it will be empty). For responses returned by the SDK,
     * the sender is the AWS service.
     */
    public boolean hasSavingsPlansPurchaseRecommendationDetails() {
        return savingsPlansPurchaseRecommendationDetails != null
                && !(savingsPlansPurchaseRecommendationDetails instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Details for the Savings Plans we recommend you to purchase to cover existing, Savings Plans eligible workloads.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSavingsPlansPurchaseRecommendationDetails()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Details for the Savings Plans we recommend you to purchase to cover existing, Savings Plans eligible
     *         workloads.
     */
    public List<SavingsPlansPurchaseRecommendationDetail> savingsPlansPurchaseRecommendationDetails() {
        return savingsPlansPurchaseRecommendationDetails;
    }

    /**
     * <p>
     * Summary metrics for your Savings Plans Recommendations.
     * </p>
     * 
     * @return Summary metrics for your Savings Plans Recommendations.
     */
    public SavingsPlansPurchaseRecommendationSummary savingsPlansPurchaseRecommendationSummary() {
        return savingsPlansPurchaseRecommendationSummary;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(savingsPlansTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(termInYearsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(paymentOptionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(lookbackPeriodInDaysAsString());
        hashCode = 31 * hashCode + Objects.hashCode(savingsPlansPurchaseRecommendationDetails());
        hashCode = 31 * hashCode + Objects.hashCode(savingsPlansPurchaseRecommendationSummary());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SavingsPlansPurchaseRecommendation)) {
            return false;
        }
        SavingsPlansPurchaseRecommendation other = (SavingsPlansPurchaseRecommendation) obj;
        return Objects.equals(savingsPlansTypeAsString(), other.savingsPlansTypeAsString())
                && Objects.equals(termInYearsAsString(), other.termInYearsAsString())
                && Objects.equals(paymentOptionAsString(), other.paymentOptionAsString())
                && Objects.equals(lookbackPeriodInDaysAsString(), other.lookbackPeriodInDaysAsString())
                && Objects.equals(savingsPlansPurchaseRecommendationDetails(), other.savingsPlansPurchaseRecommendationDetails())
                && Objects.equals(savingsPlansPurchaseRecommendationSummary(), other.savingsPlansPurchaseRecommendationSummary());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("SavingsPlansPurchaseRecommendation").add("SavingsPlansType", savingsPlansTypeAsString())
                .add("TermInYears", termInYearsAsString()).add("PaymentOption", paymentOptionAsString())
                .add("LookbackPeriodInDays", lookbackPeriodInDaysAsString())
                .add("SavingsPlansPurchaseRecommendationDetails", savingsPlansPurchaseRecommendationDetails())
                .add("SavingsPlansPurchaseRecommendationSummary", savingsPlansPurchaseRecommendationSummary()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SavingsPlansType":
            return Optional.ofNullable(clazz.cast(savingsPlansTypeAsString()));
        case "TermInYears":
            return Optional.ofNullable(clazz.cast(termInYearsAsString()));
        case "PaymentOption":
            return Optional.ofNullable(clazz.cast(paymentOptionAsString()));
        case "LookbackPeriodInDays":
            return Optional.ofNullable(clazz.cast(lookbackPeriodInDaysAsString()));
        case "SavingsPlansPurchaseRecommendationDetails":
            return Optional.ofNullable(clazz.cast(savingsPlansPurchaseRecommendationDetails()));
        case "SavingsPlansPurchaseRecommendationSummary":
            return Optional.ofNullable(clazz.cast(savingsPlansPurchaseRecommendationSummary()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SavingsPlansPurchaseRecommendation, T> g) {
        return obj -> g.apply((SavingsPlansPurchaseRecommendation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SavingsPlansPurchaseRecommendation> {
        /**
         * <p>
         * The requested Savings Plans recommendation type.
         * </p>
         * 
         * @param savingsPlansType
         *        The requested Savings Plans recommendation type.
         * @see SupportedSavingsPlansType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SupportedSavingsPlansType
         */
        Builder savingsPlansType(String savingsPlansType);

        /**
         * <p>
         * The requested Savings Plans recommendation type.
         * </p>
         * 
         * @param savingsPlansType
         *        The requested Savings Plans recommendation type.
         * @see SupportedSavingsPlansType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SupportedSavingsPlansType
         */
        Builder savingsPlansType(SupportedSavingsPlansType savingsPlansType);

        /**
         * <p>
         * The Savings Plans recommendation term in years, used to generate the recommendation.
         * </p>
         * 
         * @param termInYears
         *        The Savings Plans recommendation term in years, used to generate the recommendation.
         * @see TermInYears
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TermInYears
         */
        Builder termInYears(String termInYears);

        /**
         * <p>
         * The Savings Plans recommendation term in years, used to generate the recommendation.
         * </p>
         * 
         * @param termInYears
         *        The Savings Plans recommendation term in years, used to generate the recommendation.
         * @see TermInYears
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TermInYears
         */
        Builder termInYears(TermInYears termInYears);

        /**
         * <p>
         * The payment option used to generate the recommendation.
         * </p>
         * 
         * @param paymentOption
         *        The payment option used to generate the recommendation.
         * @see PaymentOption
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PaymentOption
         */
        Builder paymentOption(String paymentOption);

        /**
         * <p>
         * The payment option used to generate the recommendation.
         * </p>
         * 
         * @param paymentOption
         *        The payment option used to generate the recommendation.
         * @see PaymentOption
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PaymentOption
         */
        Builder paymentOption(PaymentOption paymentOption);

        /**
         * <p>
         * The lookback period in days, used to generate the recommendation.
         * </p>
         * 
         * @param lookbackPeriodInDays
         *        The lookback period in days, used to generate the recommendation.
         * @see LookbackPeriodInDays
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LookbackPeriodInDays
         */
        Builder lookbackPeriodInDays(String lookbackPeriodInDays);

        /**
         * <p>
         * The lookback period in days, used to generate the recommendation.
         * </p>
         * 
         * @param lookbackPeriodInDays
         *        The lookback period in days, used to generate the recommendation.
         * @see LookbackPeriodInDays
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LookbackPeriodInDays
         */
        Builder lookbackPeriodInDays(LookbackPeriodInDays lookbackPeriodInDays);

        /**
         * <p>
         * Details for the Savings Plans we recommend you to purchase to cover existing, Savings Plans eligible
         * workloads.
         * </p>
         * 
         * @param savingsPlansPurchaseRecommendationDetails
         *        Details for the Savings Plans we recommend you to purchase to cover existing, Savings Plans eligible
         *        workloads.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder savingsPlansPurchaseRecommendationDetails(
                Collection<SavingsPlansPurchaseRecommendationDetail> savingsPlansPurchaseRecommendationDetails);

        /**
         * <p>
         * Details for the Savings Plans we recommend you to purchase to cover existing, Savings Plans eligible
         * workloads.
         * </p>
         * 
         * @param savingsPlansPurchaseRecommendationDetails
         *        Details for the Savings Plans we recommend you to purchase to cover existing, Savings Plans eligible
         *        workloads.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder savingsPlansPurchaseRecommendationDetails(
                SavingsPlansPurchaseRecommendationDetail... savingsPlansPurchaseRecommendationDetails);

        /**
         * <p>
         * Details for the Savings Plans we recommend you to purchase to cover existing, Savings Plans eligible
         * workloads.
         * </p>
         * This is a convenience that creates an instance of the {@link List
         * <SavingsPlansPurchaseRecommendationDetail>.Builder} avoiding the need to create one manually via {@link List
         * <SavingsPlansPurchaseRecommendationDetail>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<SavingsPlansPurchaseRecommendationDetail>.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #savingsPlansPurchaseRecommendationDetails(List<SavingsPlansPurchaseRecommendationDetail>)}.
         * 
         * @param savingsPlansPurchaseRecommendationDetails
         *        a consumer that will call methods on {@link List<SavingsPlansPurchaseRecommendationDetail>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #savingsPlansPurchaseRecommendationDetails(List<SavingsPlansPurchaseRecommendationDetail>)
         */
        Builder savingsPlansPurchaseRecommendationDetails(
                Consumer<SavingsPlansPurchaseRecommendationDetail.Builder>... savingsPlansPurchaseRecommendationDetails);

        /**
         * <p>
         * Summary metrics for your Savings Plans Recommendations.
         * </p>
         * 
         * @param savingsPlansPurchaseRecommendationSummary
         *        Summary metrics for your Savings Plans Recommendations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder savingsPlansPurchaseRecommendationSummary(
                SavingsPlansPurchaseRecommendationSummary savingsPlansPurchaseRecommendationSummary);

        /**
         * <p>
         * Summary metrics for your Savings Plans Recommendations.
         * </p>
         * This is a convenience that creates an instance of the
         * {@link SavingsPlansPurchaseRecommendationSummary.Builder} avoiding the need to create one manually via
         * {@link SavingsPlansPurchaseRecommendationSummary#builder()}.
         *
         * When the {@link Consumer} completes, {@link SavingsPlansPurchaseRecommendationSummary.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #savingsPlansPurchaseRecommendationSummary(SavingsPlansPurchaseRecommendationSummary)}.
         * 
         * @param savingsPlansPurchaseRecommendationSummary
         *        a consumer that will call methods on {@link SavingsPlansPurchaseRecommendationSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #savingsPlansPurchaseRecommendationSummary(SavingsPlansPurchaseRecommendationSummary)
         */
        default Builder savingsPlansPurchaseRecommendationSummary(
                Consumer<SavingsPlansPurchaseRecommendationSummary.Builder> savingsPlansPurchaseRecommendationSummary) {
            return savingsPlansPurchaseRecommendationSummary(SavingsPlansPurchaseRecommendationSummary.builder()
                    .applyMutation(savingsPlansPurchaseRecommendationSummary).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String savingsPlansType;

        private String termInYears;

        private String paymentOption;

        private String lookbackPeriodInDays;

        private List<SavingsPlansPurchaseRecommendationDetail> savingsPlansPurchaseRecommendationDetails = DefaultSdkAutoConstructList
                .getInstance();

        private SavingsPlansPurchaseRecommendationSummary savingsPlansPurchaseRecommendationSummary;

        private BuilderImpl() {
        }

        private BuilderImpl(SavingsPlansPurchaseRecommendation model) {
            savingsPlansType(model.savingsPlansType);
            termInYears(model.termInYears);
            paymentOption(model.paymentOption);
            lookbackPeriodInDays(model.lookbackPeriodInDays);
            savingsPlansPurchaseRecommendationDetails(model.savingsPlansPurchaseRecommendationDetails);
            savingsPlansPurchaseRecommendationSummary(model.savingsPlansPurchaseRecommendationSummary);
        }

        public final String getSavingsPlansTypeAsString() {
            return savingsPlansType;
        }

        @Override
        public final Builder savingsPlansType(String savingsPlansType) {
            this.savingsPlansType = savingsPlansType;
            return this;
        }

        @Override
        public final Builder savingsPlansType(SupportedSavingsPlansType savingsPlansType) {
            this.savingsPlansType(savingsPlansType == null ? null : savingsPlansType.toString());
            return this;
        }

        public final void setSavingsPlansType(String savingsPlansType) {
            this.savingsPlansType = savingsPlansType;
        }

        public final String getTermInYearsAsString() {
            return termInYears;
        }

        @Override
        public final Builder termInYears(String termInYears) {
            this.termInYears = termInYears;
            return this;
        }

        @Override
        public final Builder termInYears(TermInYears termInYears) {
            this.termInYears(termInYears == null ? null : termInYears.toString());
            return this;
        }

        public final void setTermInYears(String termInYears) {
            this.termInYears = termInYears;
        }

        public final String getPaymentOptionAsString() {
            return paymentOption;
        }

        @Override
        public final Builder paymentOption(String paymentOption) {
            this.paymentOption = paymentOption;
            return this;
        }

        @Override
        public final Builder paymentOption(PaymentOption paymentOption) {
            this.paymentOption(paymentOption == null ? null : paymentOption.toString());
            return this;
        }

        public final void setPaymentOption(String paymentOption) {
            this.paymentOption = paymentOption;
        }

        public final String getLookbackPeriodInDaysAsString() {
            return lookbackPeriodInDays;
        }

        @Override
        public final Builder lookbackPeriodInDays(String lookbackPeriodInDays) {
            this.lookbackPeriodInDays = lookbackPeriodInDays;
            return this;
        }

        @Override
        public final Builder lookbackPeriodInDays(LookbackPeriodInDays lookbackPeriodInDays) {
            this.lookbackPeriodInDays(lookbackPeriodInDays == null ? null : lookbackPeriodInDays.toString());
            return this;
        }

        public final void setLookbackPeriodInDays(String lookbackPeriodInDays) {
            this.lookbackPeriodInDays = lookbackPeriodInDays;
        }

        public final Collection<SavingsPlansPurchaseRecommendationDetail.Builder> getSavingsPlansPurchaseRecommendationDetails() {
            return savingsPlansPurchaseRecommendationDetails != null ? savingsPlansPurchaseRecommendationDetails.stream()
                    .map(SavingsPlansPurchaseRecommendationDetail::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder savingsPlansPurchaseRecommendationDetails(
                Collection<SavingsPlansPurchaseRecommendationDetail> savingsPlansPurchaseRecommendationDetails) {
            this.savingsPlansPurchaseRecommendationDetails = SavingsPlansPurchaseRecommendationDetailListCopier
                    .copy(savingsPlansPurchaseRecommendationDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder savingsPlansPurchaseRecommendationDetails(
                SavingsPlansPurchaseRecommendationDetail... savingsPlansPurchaseRecommendationDetails) {
            savingsPlansPurchaseRecommendationDetails(Arrays.asList(savingsPlansPurchaseRecommendationDetails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder savingsPlansPurchaseRecommendationDetails(
                Consumer<SavingsPlansPurchaseRecommendationDetail.Builder>... savingsPlansPurchaseRecommendationDetails) {
            savingsPlansPurchaseRecommendationDetails(Stream.of(savingsPlansPurchaseRecommendationDetails)
                    .map(c -> SavingsPlansPurchaseRecommendationDetail.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setSavingsPlansPurchaseRecommendationDetails(
                Collection<SavingsPlansPurchaseRecommendationDetail.BuilderImpl> savingsPlansPurchaseRecommendationDetails) {
            this.savingsPlansPurchaseRecommendationDetails = SavingsPlansPurchaseRecommendationDetailListCopier
                    .copyFromBuilder(savingsPlansPurchaseRecommendationDetails);
        }

        public final SavingsPlansPurchaseRecommendationSummary.Builder getSavingsPlansPurchaseRecommendationSummary() {
            return savingsPlansPurchaseRecommendationSummary != null ? savingsPlansPurchaseRecommendationSummary.toBuilder()
                    : null;
        }

        @Override
        public final Builder savingsPlansPurchaseRecommendationSummary(
                SavingsPlansPurchaseRecommendationSummary savingsPlansPurchaseRecommendationSummary) {
            this.savingsPlansPurchaseRecommendationSummary = savingsPlansPurchaseRecommendationSummary;
            return this;
        }

        public final void setSavingsPlansPurchaseRecommendationSummary(
                SavingsPlansPurchaseRecommendationSummary.BuilderImpl savingsPlansPurchaseRecommendationSummary) {
            this.savingsPlansPurchaseRecommendationSummary = savingsPlansPurchaseRecommendationSummary != null ? savingsPlansPurchaseRecommendationSummary
                    .build() : null;
        }

        @Override
        public SavingsPlansPurchaseRecommendation build() {
            return new SavingsPlansPurchaseRecommendation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
