/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costexplorer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Attribute details on a specific Savings Plan.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SavingsPlansDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<SavingsPlansDetails.Builder, SavingsPlansDetails> {
    private static final SdkField<String> REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SavingsPlansDetails::region)).setter(setter(Builder::region))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Region").build()).build();

    private static final SdkField<String> INSTANCE_FAMILY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SavingsPlansDetails::instanceFamily)).setter(setter(Builder::instanceFamily))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceFamily").build()).build();

    private static final SdkField<String> OFFERING_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SavingsPlansDetails::offeringId)).setter(setter(Builder::offeringId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OfferingId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGION_FIELD,
            INSTANCE_FAMILY_FIELD, OFFERING_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String region;

    private final String instanceFamily;

    private final String offeringId;

    private SavingsPlansDetails(BuilderImpl builder) {
        this.region = builder.region;
        this.instanceFamily = builder.instanceFamily;
        this.offeringId = builder.offeringId;
    }

    /**
     * <p>
     * A collection of AWS resources in a geographic area. Each AWS Region is isolated and independent of the other
     * Regions.
     * </p>
     * 
     * @return A collection of AWS resources in a geographic area. Each AWS Region is isolated and independent of the
     *         other Regions.
     */
    public String region() {
        return region;
    }

    /**
     * <p>
     * A group of instance types that Savings Plans applies to.
     * </p>
     * 
     * @return A group of instance types that Savings Plans applies to.
     */
    public String instanceFamily() {
        return instanceFamily;
    }

    /**
     * <p>
     * The unique ID used to distinguish Savings Plans from one another.
     * </p>
     * 
     * @return The unique ID used to distinguish Savings Plans from one another.
     */
    public String offeringId() {
        return offeringId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(region());
        hashCode = 31 * hashCode + Objects.hashCode(instanceFamily());
        hashCode = 31 * hashCode + Objects.hashCode(offeringId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SavingsPlansDetails)) {
            return false;
        }
        SavingsPlansDetails other = (SavingsPlansDetails) obj;
        return Objects.equals(region(), other.region()) && Objects.equals(instanceFamily(), other.instanceFamily())
                && Objects.equals(offeringId(), other.offeringId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("SavingsPlansDetails").add("Region", region()).add("InstanceFamily", instanceFamily())
                .add("OfferingId", offeringId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Region":
            return Optional.ofNullable(clazz.cast(region()));
        case "InstanceFamily":
            return Optional.ofNullable(clazz.cast(instanceFamily()));
        case "OfferingId":
            return Optional.ofNullable(clazz.cast(offeringId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SavingsPlansDetails, T> g) {
        return obj -> g.apply((SavingsPlansDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SavingsPlansDetails> {
        /**
         * <p>
         * A collection of AWS resources in a geographic area. Each AWS Region is isolated and independent of the other
         * Regions.
         * </p>
         * 
         * @param region
         *        A collection of AWS resources in a geographic area. Each AWS Region is isolated and independent of the
         *        other Regions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder region(String region);

        /**
         * <p>
         * A group of instance types that Savings Plans applies to.
         * </p>
         * 
         * @param instanceFamily
         *        A group of instance types that Savings Plans applies to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceFamily(String instanceFamily);

        /**
         * <p>
         * The unique ID used to distinguish Savings Plans from one another.
         * </p>
         * 
         * @param offeringId
         *        The unique ID used to distinguish Savings Plans from one another.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder offeringId(String offeringId);
    }

    static final class BuilderImpl implements Builder {
        private String region;

        private String instanceFamily;

        private String offeringId;

        private BuilderImpl() {
        }

        private BuilderImpl(SavingsPlansDetails model) {
            region(model.region);
            instanceFamily(model.instanceFamily);
            offeringId(model.offeringId);
        }

        public final String getRegion() {
            return region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        public final String getInstanceFamily() {
            return instanceFamily;
        }

        @Override
        public final Builder instanceFamily(String instanceFamily) {
            this.instanceFamily = instanceFamily;
            return this;
        }

        public final void setInstanceFamily(String instanceFamily) {
            this.instanceFamily = instanceFamily;
        }

        public final String getOfferingId() {
            return offeringId;
        }

        @Override
        public final Builder offeringId(String offeringId) {
            this.offeringId = offeringId;
            return this;
        }

        public final void setOfferingId(String offeringId) {
            this.offeringId = offeringId;
        }

        @Override
        public SavingsPlansDetails build() {
            return new SavingsPlansDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
