/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costexplorer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Summary of rightsizing recommendations
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RightsizingRecommendationSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<RightsizingRecommendationSummary.Builder, RightsizingRecommendationSummary> {
    private static final SdkField<String> TOTAL_RECOMMENDATION_COUNT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RightsizingRecommendationSummary::totalRecommendationCount))
            .setter(setter(Builder::totalRecommendationCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalRecommendationCount").build())
            .build();

    private static final SdkField<String> ESTIMATED_TOTAL_MONTHLY_SAVINGS_AMOUNT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(RightsizingRecommendationSummary::estimatedTotalMonthlySavingsAmount))
            .setter(setter(Builder::estimatedTotalMonthlySavingsAmount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EstimatedTotalMonthlySavingsAmount")
                    .build()).build();

    private static final SdkField<String> SAVINGS_CURRENCY_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RightsizingRecommendationSummary::savingsCurrencyCode)).setter(setter(Builder::savingsCurrencyCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SavingsCurrencyCode").build())
            .build();

    private static final SdkField<String> SAVINGS_PERCENTAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RightsizingRecommendationSummary::savingsPercentage)).setter(setter(Builder::savingsPercentage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SavingsPercentage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            TOTAL_RECOMMENDATION_COUNT_FIELD, ESTIMATED_TOTAL_MONTHLY_SAVINGS_AMOUNT_FIELD, SAVINGS_CURRENCY_CODE_FIELD,
            SAVINGS_PERCENTAGE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String totalRecommendationCount;

    private final String estimatedTotalMonthlySavingsAmount;

    private final String savingsCurrencyCode;

    private final String savingsPercentage;

    private RightsizingRecommendationSummary(BuilderImpl builder) {
        this.totalRecommendationCount = builder.totalRecommendationCount;
        this.estimatedTotalMonthlySavingsAmount = builder.estimatedTotalMonthlySavingsAmount;
        this.savingsCurrencyCode = builder.savingsCurrencyCode;
        this.savingsPercentage = builder.savingsPercentage;
    }

    /**
     * <p>
     * Total number of instance recommendations.
     * </p>
     * 
     * @return Total number of instance recommendations.
     */
    public String totalRecommendationCount() {
        return totalRecommendationCount;
    }

    /**
     * <p>
     * Estimated total savings resulting from modifications, on a monthly basis.
     * </p>
     * 
     * @return Estimated total savings resulting from modifications, on a monthly basis.
     */
    public String estimatedTotalMonthlySavingsAmount() {
        return estimatedTotalMonthlySavingsAmount;
    }

    /**
     * <p>
     * The currency code that Amazon Web Services used to calculate the savings.
     * </p>
     * 
     * @return The currency code that Amazon Web Services used to calculate the savings.
     */
    public String savingsCurrencyCode() {
        return savingsCurrencyCode;
    }

    /**
     * <p>
     * Savings percentage based on the recommended modifications, relative to the total On Demand costs associated with
     * these instances.
     * </p>
     * 
     * @return Savings percentage based on the recommended modifications, relative to the total On Demand costs
     *         associated with these instances.
     */
    public String savingsPercentage() {
        return savingsPercentage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(totalRecommendationCount());
        hashCode = 31 * hashCode + Objects.hashCode(estimatedTotalMonthlySavingsAmount());
        hashCode = 31 * hashCode + Objects.hashCode(savingsCurrencyCode());
        hashCode = 31 * hashCode + Objects.hashCode(savingsPercentage());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RightsizingRecommendationSummary)) {
            return false;
        }
        RightsizingRecommendationSummary other = (RightsizingRecommendationSummary) obj;
        return Objects.equals(totalRecommendationCount(), other.totalRecommendationCount())
                && Objects.equals(estimatedTotalMonthlySavingsAmount(), other.estimatedTotalMonthlySavingsAmount())
                && Objects.equals(savingsCurrencyCode(), other.savingsCurrencyCode())
                && Objects.equals(savingsPercentage(), other.savingsPercentage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("RightsizingRecommendationSummary").add("TotalRecommendationCount", totalRecommendationCount())
                .add("EstimatedTotalMonthlySavingsAmount", estimatedTotalMonthlySavingsAmount())
                .add("SavingsCurrencyCode", savingsCurrencyCode()).add("SavingsPercentage", savingsPercentage()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TotalRecommendationCount":
            return Optional.ofNullable(clazz.cast(totalRecommendationCount()));
        case "EstimatedTotalMonthlySavingsAmount":
            return Optional.ofNullable(clazz.cast(estimatedTotalMonthlySavingsAmount()));
        case "SavingsCurrencyCode":
            return Optional.ofNullable(clazz.cast(savingsCurrencyCode()));
        case "SavingsPercentage":
            return Optional.ofNullable(clazz.cast(savingsPercentage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RightsizingRecommendationSummary, T> g) {
        return obj -> g.apply((RightsizingRecommendationSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RightsizingRecommendationSummary> {
        /**
         * <p>
         * Total number of instance recommendations.
         * </p>
         * 
         * @param totalRecommendationCount
         *        Total number of instance recommendations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalRecommendationCount(String totalRecommendationCount);

        /**
         * <p>
         * Estimated total savings resulting from modifications, on a monthly basis.
         * </p>
         * 
         * @param estimatedTotalMonthlySavingsAmount
         *        Estimated total savings resulting from modifications, on a monthly basis.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder estimatedTotalMonthlySavingsAmount(String estimatedTotalMonthlySavingsAmount);

        /**
         * <p>
         * The currency code that Amazon Web Services used to calculate the savings.
         * </p>
         * 
         * @param savingsCurrencyCode
         *        The currency code that Amazon Web Services used to calculate the savings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder savingsCurrencyCode(String savingsCurrencyCode);

        /**
         * <p>
         * Savings percentage based on the recommended modifications, relative to the total On Demand costs associated
         * with these instances.
         * </p>
         * 
         * @param savingsPercentage
         *        Savings percentage based on the recommended modifications, relative to the total On Demand costs
         *        associated with these instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder savingsPercentage(String savingsPercentage);
    }

    static final class BuilderImpl implements Builder {
        private String totalRecommendationCount;

        private String estimatedTotalMonthlySavingsAmount;

        private String savingsCurrencyCode;

        private String savingsPercentage;

        private BuilderImpl() {
        }

        private BuilderImpl(RightsizingRecommendationSummary model) {
            totalRecommendationCount(model.totalRecommendationCount);
            estimatedTotalMonthlySavingsAmount(model.estimatedTotalMonthlySavingsAmount);
            savingsCurrencyCode(model.savingsCurrencyCode);
            savingsPercentage(model.savingsPercentage);
        }

        public final String getTotalRecommendationCount() {
            return totalRecommendationCount;
        }

        @Override
        public final Builder totalRecommendationCount(String totalRecommendationCount) {
            this.totalRecommendationCount = totalRecommendationCount;
            return this;
        }

        public final void setTotalRecommendationCount(String totalRecommendationCount) {
            this.totalRecommendationCount = totalRecommendationCount;
        }

        public final String getEstimatedTotalMonthlySavingsAmount() {
            return estimatedTotalMonthlySavingsAmount;
        }

        @Override
        public final Builder estimatedTotalMonthlySavingsAmount(String estimatedTotalMonthlySavingsAmount) {
            this.estimatedTotalMonthlySavingsAmount = estimatedTotalMonthlySavingsAmount;
            return this;
        }

        public final void setEstimatedTotalMonthlySavingsAmount(String estimatedTotalMonthlySavingsAmount) {
            this.estimatedTotalMonthlySavingsAmount = estimatedTotalMonthlySavingsAmount;
        }

        public final String getSavingsCurrencyCode() {
            return savingsCurrencyCode;
        }

        @Override
        public final Builder savingsCurrencyCode(String savingsCurrencyCode) {
            this.savingsCurrencyCode = savingsCurrencyCode;
            return this;
        }

        public final void setSavingsCurrencyCode(String savingsCurrencyCode) {
            this.savingsCurrencyCode = savingsCurrencyCode;
        }

        public final String getSavingsPercentage() {
            return savingsPercentage;
        }

        @Override
        public final Builder savingsPercentage(String savingsPercentage) {
            this.savingsPercentage = savingsPercentage;
            return this;
        }

        public final void setSavingsPercentage(String savingsPercentage) {
            this.savingsPercentage = savingsPercentage;
        }

        @Override
        public RightsizingRecommendationSummary build() {
            return new RightsizingRecommendationSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
