/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costexplorer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details on the resource.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResourceDetails implements SdkPojo, Serializable, ToCopyableBuilder<ResourceDetails.Builder, ResourceDetails> {
    private static final SdkField<EC2ResourceDetails> EC2_RESOURCE_DETAILS_FIELD = SdkField
            .<EC2ResourceDetails> builder(MarshallingType.SDK_POJO).getter(getter(ResourceDetails::ec2ResourceDetails))
            .setter(setter(Builder::ec2ResourceDetails)).constructor(EC2ResourceDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EC2ResourceDetails").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EC2_RESOURCE_DETAILS_FIELD));

    private static final long serialVersionUID = 1L;

    private final EC2ResourceDetails ec2ResourceDetails;

    private ResourceDetails(BuilderImpl builder) {
        this.ec2ResourceDetails = builder.ec2ResourceDetails;
    }

    /**
     * <p>
     * Details on the Amazon EC2 resource.
     * </p>
     * 
     * @return Details on the Amazon EC2 resource.
     */
    public EC2ResourceDetails ec2ResourceDetails() {
        return ec2ResourceDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ec2ResourceDetails());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceDetails)) {
            return false;
        }
        ResourceDetails other = (ResourceDetails) obj;
        return Objects.equals(ec2ResourceDetails(), other.ec2ResourceDetails());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ResourceDetails").add("EC2ResourceDetails", ec2ResourceDetails()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EC2ResourceDetails":
            return Optional.ofNullable(clazz.cast(ec2ResourceDetails()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResourceDetails, T> g) {
        return obj -> g.apply((ResourceDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResourceDetails> {
        /**
         * <p>
         * Details on the Amazon EC2 resource.
         * </p>
         * 
         * @param ec2ResourceDetails
         *        Details on the Amazon EC2 resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ec2ResourceDetails(EC2ResourceDetails ec2ResourceDetails);

        /**
         * <p>
         * Details on the Amazon EC2 resource.
         * </p>
         * This is a convenience that creates an instance of the {@link EC2ResourceDetails.Builder} avoiding the need to
         * create one manually via {@link EC2ResourceDetails#builder()}.
         *
         * When the {@link Consumer} completes, {@link EC2ResourceDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #ec2ResourceDetails(EC2ResourceDetails)}.
         * 
         * @param ec2ResourceDetails
         *        a consumer that will call methods on {@link EC2ResourceDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ec2ResourceDetails(EC2ResourceDetails)
         */
        default Builder ec2ResourceDetails(Consumer<EC2ResourceDetails.Builder> ec2ResourceDetails) {
            return ec2ResourceDetails(EC2ResourceDetails.builder().applyMutation(ec2ResourceDetails).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private EC2ResourceDetails ec2ResourceDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceDetails model) {
            ec2ResourceDetails(model.ec2ResourceDetails);
        }

        public final EC2ResourceDetails.Builder getEc2ResourceDetails() {
            return ec2ResourceDetails != null ? ec2ResourceDetails.toBuilder() : null;
        }

        @Override
        public final Builder ec2ResourceDetails(EC2ResourceDetails ec2ResourceDetails) {
            this.ec2ResourceDetails = ec2ResourceDetails;
            return this;
        }

        public final void setEc2ResourceDetails(EC2ResourceDetails.BuilderImpl ec2ResourceDetails) {
            this.ec2ResourceDetails = ec2ResourceDetails != null ? ec2ResourceDetails.build() : null;
        }

        @Override
        public ResourceDetails build() {
            return new ResourceDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
