/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costexplorer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A group of reservations that share a set of attributes.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReservationUtilizationGroup implements SdkPojo, Serializable,
        ToCopyableBuilder<ReservationUtilizationGroup.Builder, ReservationUtilizationGroup> {
    private static final SdkField<String> KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ReservationUtilizationGroup::key)).setter(setter(Builder::key))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Key").build()).build();

    private static final SdkField<String> VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ReservationUtilizationGroup::value)).setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()).build();

    private static final SdkField<Map<String, String>> ATTRIBUTES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(ReservationUtilizationGroup::attributes))
            .setter(setter(Builder::attributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attributes").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<ReservationAggregates> UTILIZATION_FIELD = SdkField
            .<ReservationAggregates> builder(MarshallingType.SDK_POJO).getter(getter(ReservationUtilizationGroup::utilization))
            .setter(setter(Builder::utilization)).constructor(ReservationAggregates::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Utilization").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_FIELD, VALUE_FIELD,
            ATTRIBUTES_FIELD, UTILIZATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String key;

    private final String value;

    private final Map<String, String> attributes;

    private final ReservationAggregates utilization;

    private ReservationUtilizationGroup(BuilderImpl builder) {
        this.key = builder.key;
        this.value = builder.value;
        this.attributes = builder.attributes;
        this.utilization = builder.utilization;
    }

    /**
     * <p>
     * The key for a specific reservation attribute.
     * </p>
     * 
     * @return The key for a specific reservation attribute.
     */
    public String key() {
        return key;
    }

    /**
     * <p>
     * The value of a specific reservation attribute.
     * </p>
     * 
     * @return The value of a specific reservation attribute.
     */
    public String value() {
        return value;
    }

    /**
     * Returns true if the Attributes property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasAttributes() {
        return attributes != null && !(attributes instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The attributes for this group of reservations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAttributes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The attributes for this group of reservations.
     */
    public Map<String, String> attributes() {
        return attributes;
    }

    /**
     * <p>
     * How much you used this group of reservations.
     * </p>
     * 
     * @return How much you used this group of reservations.
     */
    public ReservationAggregates utilization() {
        return utilization;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(key());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        hashCode = 31 * hashCode + Objects.hashCode(attributes());
        hashCode = 31 * hashCode + Objects.hashCode(utilization());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReservationUtilizationGroup)) {
            return false;
        }
        ReservationUtilizationGroup other = (ReservationUtilizationGroup) obj;
        return Objects.equals(key(), other.key()) && Objects.equals(value(), other.value())
                && Objects.equals(attributes(), other.attributes()) && Objects.equals(utilization(), other.utilization());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ReservationUtilizationGroup").add("Key", key()).add("Value", value())
                .add("Attributes", attributes()).add("Utilization", utilization()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Key":
            return Optional.ofNullable(clazz.cast(key()));
        case "Value":
            return Optional.ofNullable(clazz.cast(value()));
        case "Attributes":
            return Optional.ofNullable(clazz.cast(attributes()));
        case "Utilization":
            return Optional.ofNullable(clazz.cast(utilization()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReservationUtilizationGroup, T> g) {
        return obj -> g.apply((ReservationUtilizationGroup) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReservationUtilizationGroup> {
        /**
         * <p>
         * The key for a specific reservation attribute.
         * </p>
         * 
         * @param key
         *        The key for a specific reservation attribute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder key(String key);

        /**
         * <p>
         * The value of a specific reservation attribute.
         * </p>
         * 
         * @param value
         *        The value of a specific reservation attribute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(String value);

        /**
         * <p>
         * The attributes for this group of reservations.
         * </p>
         * 
         * @param attributes
         *        The attributes for this group of reservations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(Map<String, String> attributes);

        /**
         * <p>
         * How much you used this group of reservations.
         * </p>
         * 
         * @param utilization
         *        How much you used this group of reservations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder utilization(ReservationAggregates utilization);

        /**
         * <p>
         * How much you used this group of reservations.
         * </p>
         * This is a convenience that creates an instance of the {@link ReservationAggregates.Builder} avoiding the need
         * to create one manually via {@link ReservationAggregates#builder()}.
         *
         * When the {@link Consumer} completes, {@link ReservationAggregates.Builder#build()} is called immediately and
         * its result is passed to {@link #utilization(ReservationAggregates)}.
         * 
         * @param utilization
         *        a consumer that will call methods on {@link ReservationAggregates.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #utilization(ReservationAggregates)
         */
        default Builder utilization(Consumer<ReservationAggregates.Builder> utilization) {
            return utilization(ReservationAggregates.builder().applyMutation(utilization).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String key;

        private String value;

        private Map<String, String> attributes = DefaultSdkAutoConstructMap.getInstance();

        private ReservationAggregates utilization;

        private BuilderImpl() {
        }

        private BuilderImpl(ReservationUtilizationGroup model) {
            key(model.key);
            value(model.value);
            attributes(model.attributes);
            utilization(model.utilization);
        }

        public final String getKey() {
            return key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        public final String getValue() {
            return value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        public final Map<String, String> getAttributes() {
            return attributes;
        }

        @Override
        public final Builder attributes(Map<String, String> attributes) {
            this.attributes = AttributesCopier.copy(attributes);
            return this;
        }

        public final void setAttributes(Map<String, String> attributes) {
            this.attributes = AttributesCopier.copy(attributes);
        }

        public final ReservationAggregates.Builder getUtilization() {
            return utilization != null ? utilization.toBuilder() : null;
        }

        @Override
        public final Builder utilization(ReservationAggregates utilization) {
            this.utilization = utilization;
            return this;
        }

        public final void setUtilization(ReservationAggregates.BuilderImpl utilization) {
            this.utilization = utilization != null ? utilization.build() : null;
        }

        @Override
        public ReservationUtilizationGroup build() {
            return new ReservationUtilizationGroup(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
