/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costexplorer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A specific reservation that AWS recommends for purchase.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReservationPurchaseRecommendation implements SdkPojo, Serializable,
        ToCopyableBuilder<ReservationPurchaseRecommendation.Builder, ReservationPurchaseRecommendation> {
    private static final SdkField<String> ACCOUNT_SCOPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ReservationPurchaseRecommendation::accountScopeAsString)).setter(setter(Builder::accountScope))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountScope").build()).build();

    private static final SdkField<String> LOOKBACK_PERIOD_IN_DAYS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ReservationPurchaseRecommendation::lookbackPeriodInDaysAsString))
            .setter(setter(Builder::lookbackPeriodInDays))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LookbackPeriodInDays").build())
            .build();

    private static final SdkField<String> TERM_IN_YEARS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ReservationPurchaseRecommendation::termInYearsAsString)).setter(setter(Builder::termInYears))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TermInYears").build()).build();

    private static final SdkField<String> PAYMENT_OPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ReservationPurchaseRecommendation::paymentOptionAsString)).setter(setter(Builder::paymentOption))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PaymentOption").build()).build();

    private static final SdkField<ServiceSpecification> SERVICE_SPECIFICATION_FIELD = SdkField
            .<ServiceSpecification> builder(MarshallingType.SDK_POJO)
            .getter(getter(ReservationPurchaseRecommendation::serviceSpecification))
            .setter(setter(Builder::serviceSpecification)).constructor(ServiceSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceSpecification").build())
            .build();

    private static final SdkField<List<ReservationPurchaseRecommendationDetail>> RECOMMENDATION_DETAILS_FIELD = SdkField
            .<List<ReservationPurchaseRecommendationDetail>> builder(MarshallingType.LIST)
            .getter(getter(ReservationPurchaseRecommendation::recommendationDetails))
            .setter(setter(Builder::recommendationDetails))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecommendationDetails").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ReservationPurchaseRecommendationDetail> builder(MarshallingType.SDK_POJO)
                                            .constructor(ReservationPurchaseRecommendationDetail::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<ReservationPurchaseRecommendationSummary> RECOMMENDATION_SUMMARY_FIELD = SdkField
            .<ReservationPurchaseRecommendationSummary> builder(MarshallingType.SDK_POJO)
            .getter(getter(ReservationPurchaseRecommendation::recommendationSummary))
            .setter(setter(Builder::recommendationSummary)).constructor(ReservationPurchaseRecommendationSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecommendationSummary").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_SCOPE_FIELD,
            LOOKBACK_PERIOD_IN_DAYS_FIELD, TERM_IN_YEARS_FIELD, PAYMENT_OPTION_FIELD, SERVICE_SPECIFICATION_FIELD,
            RECOMMENDATION_DETAILS_FIELD, RECOMMENDATION_SUMMARY_FIELD));

    private static final long serialVersionUID = 1L;

    private final String accountScope;

    private final String lookbackPeriodInDays;

    private final String termInYears;

    private final String paymentOption;

    private final ServiceSpecification serviceSpecification;

    private final List<ReservationPurchaseRecommendationDetail> recommendationDetails;

    private final ReservationPurchaseRecommendationSummary recommendationSummary;

    private ReservationPurchaseRecommendation(BuilderImpl builder) {
        this.accountScope = builder.accountScope;
        this.lookbackPeriodInDays = builder.lookbackPeriodInDays;
        this.termInYears = builder.termInYears;
        this.paymentOption = builder.paymentOption;
        this.serviceSpecification = builder.serviceSpecification;
        this.recommendationDetails = builder.recommendationDetails;
        this.recommendationSummary = builder.recommendationSummary;
    }

    /**
     * <p>
     * The account scope that AWS recommends that you purchase this instance for. For example, you can purchase this
     * reservation for an entire organization in AWS Organizations.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #accountScope} will
     * return {@link AccountScope#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #accountScopeAsString}.
     * </p>
     * 
     * @return The account scope that AWS recommends that you purchase this instance for. For example, you can purchase
     *         this reservation for an entire organization in AWS Organizations.
     * @see AccountScope
     */
    public AccountScope accountScope() {
        return AccountScope.fromValue(accountScope);
    }

    /**
     * <p>
     * The account scope that AWS recommends that you purchase this instance for. For example, you can purchase this
     * reservation for an entire organization in AWS Organizations.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #accountScope} will
     * return {@link AccountScope#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #accountScopeAsString}.
     * </p>
     * 
     * @return The account scope that AWS recommends that you purchase this instance for. For example, you can purchase
     *         this reservation for an entire organization in AWS Organizations.
     * @see AccountScope
     */
    public String accountScopeAsString() {
        return accountScope;
    }

    /**
     * <p>
     * How many days of previous usage that AWS considers when making this recommendation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #lookbackPeriodInDays} will return {@link LookbackPeriodInDays#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #lookbackPeriodInDaysAsString}.
     * </p>
     * 
     * @return How many days of previous usage that AWS considers when making this recommendation.
     * @see LookbackPeriodInDays
     */
    public LookbackPeriodInDays lookbackPeriodInDays() {
        return LookbackPeriodInDays.fromValue(lookbackPeriodInDays);
    }

    /**
     * <p>
     * How many days of previous usage that AWS considers when making this recommendation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #lookbackPeriodInDays} will return {@link LookbackPeriodInDays#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #lookbackPeriodInDaysAsString}.
     * </p>
     * 
     * @return How many days of previous usage that AWS considers when making this recommendation.
     * @see LookbackPeriodInDays
     */
    public String lookbackPeriodInDaysAsString() {
        return lookbackPeriodInDays;
    }

    /**
     * <p>
     * The term of the reservation that you want recommendations for, in years.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #termInYears} will
     * return {@link TermInYears#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #termInYearsAsString}.
     * </p>
     * 
     * @return The term of the reservation that you want recommendations for, in years.
     * @see TermInYears
     */
    public TermInYears termInYears() {
        return TermInYears.fromValue(termInYears);
    }

    /**
     * <p>
     * The term of the reservation that you want recommendations for, in years.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #termInYears} will
     * return {@link TermInYears#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #termInYearsAsString}.
     * </p>
     * 
     * @return The term of the reservation that you want recommendations for, in years.
     * @see TermInYears
     */
    public String termInYearsAsString() {
        return termInYears;
    }

    /**
     * <p>
     * The payment option for the reservation. For example, <code>AllUpfront</code> or <code>NoUpfront</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #paymentOption}
     * will return {@link PaymentOption#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #paymentOptionAsString}.
     * </p>
     * 
     * @return The payment option for the reservation. For example, <code>AllUpfront</code> or <code>NoUpfront</code>.
     * @see PaymentOption
     */
    public PaymentOption paymentOption() {
        return PaymentOption.fromValue(paymentOption);
    }

    /**
     * <p>
     * The payment option for the reservation. For example, <code>AllUpfront</code> or <code>NoUpfront</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #paymentOption}
     * will return {@link PaymentOption#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #paymentOptionAsString}.
     * </p>
     * 
     * @return The payment option for the reservation. For example, <code>AllUpfront</code> or <code>NoUpfront</code>.
     * @see PaymentOption
     */
    public String paymentOptionAsString() {
        return paymentOption;
    }

    /**
     * <p>
     * Hardware specifications for the service that you want recommendations for.
     * </p>
     * 
     * @return Hardware specifications for the service that you want recommendations for.
     */
    public ServiceSpecification serviceSpecification() {
        return serviceSpecification;
    }

    /**
     * Returns true if the RecommendationDetails property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasRecommendationDetails() {
        return recommendationDetails != null && !(recommendationDetails instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Details about the recommended purchases.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasRecommendationDetails()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Details about the recommended purchases.
     */
    public List<ReservationPurchaseRecommendationDetail> recommendationDetails() {
        return recommendationDetails;
    }

    /**
     * <p>
     * A summary about the recommended purchase.
     * </p>
     * 
     * @return A summary about the recommended purchase.
     */
    public ReservationPurchaseRecommendationSummary recommendationSummary() {
        return recommendationSummary;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(accountScopeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(lookbackPeriodInDaysAsString());
        hashCode = 31 * hashCode + Objects.hashCode(termInYearsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(paymentOptionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(serviceSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(recommendationDetails());
        hashCode = 31 * hashCode + Objects.hashCode(recommendationSummary());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReservationPurchaseRecommendation)) {
            return false;
        }
        ReservationPurchaseRecommendation other = (ReservationPurchaseRecommendation) obj;
        return Objects.equals(accountScopeAsString(), other.accountScopeAsString())
                && Objects.equals(lookbackPeriodInDaysAsString(), other.lookbackPeriodInDaysAsString())
                && Objects.equals(termInYearsAsString(), other.termInYearsAsString())
                && Objects.equals(paymentOptionAsString(), other.paymentOptionAsString())
                && Objects.equals(serviceSpecification(), other.serviceSpecification())
                && Objects.equals(recommendationDetails(), other.recommendationDetails())
                && Objects.equals(recommendationSummary(), other.recommendationSummary());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ReservationPurchaseRecommendation").add("AccountScope", accountScopeAsString())
                .add("LookbackPeriodInDays", lookbackPeriodInDaysAsString()).add("TermInYears", termInYearsAsString())
                .add("PaymentOption", paymentOptionAsString()).add("ServiceSpecification", serviceSpecification())
                .add("RecommendationDetails", recommendationDetails()).add("RecommendationSummary", recommendationSummary())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccountScope":
            return Optional.ofNullable(clazz.cast(accountScopeAsString()));
        case "LookbackPeriodInDays":
            return Optional.ofNullable(clazz.cast(lookbackPeriodInDaysAsString()));
        case "TermInYears":
            return Optional.ofNullable(clazz.cast(termInYearsAsString()));
        case "PaymentOption":
            return Optional.ofNullable(clazz.cast(paymentOptionAsString()));
        case "ServiceSpecification":
            return Optional.ofNullable(clazz.cast(serviceSpecification()));
        case "RecommendationDetails":
            return Optional.ofNullable(clazz.cast(recommendationDetails()));
        case "RecommendationSummary":
            return Optional.ofNullable(clazz.cast(recommendationSummary()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReservationPurchaseRecommendation, T> g) {
        return obj -> g.apply((ReservationPurchaseRecommendation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReservationPurchaseRecommendation> {
        /**
         * <p>
         * The account scope that AWS recommends that you purchase this instance for. For example, you can purchase this
         * reservation for an entire organization in AWS Organizations.
         * </p>
         * 
         * @param accountScope
         *        The account scope that AWS recommends that you purchase this instance for. For example, you can
         *        purchase this reservation for an entire organization in AWS Organizations.
         * @see AccountScope
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AccountScope
         */
        Builder accountScope(String accountScope);

        /**
         * <p>
         * The account scope that AWS recommends that you purchase this instance for. For example, you can purchase this
         * reservation for an entire organization in AWS Organizations.
         * </p>
         * 
         * @param accountScope
         *        The account scope that AWS recommends that you purchase this instance for. For example, you can
         *        purchase this reservation for an entire organization in AWS Organizations.
         * @see AccountScope
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AccountScope
         */
        Builder accountScope(AccountScope accountScope);

        /**
         * <p>
         * How many days of previous usage that AWS considers when making this recommendation.
         * </p>
         * 
         * @param lookbackPeriodInDays
         *        How many days of previous usage that AWS considers when making this recommendation.
         * @see LookbackPeriodInDays
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LookbackPeriodInDays
         */
        Builder lookbackPeriodInDays(String lookbackPeriodInDays);

        /**
         * <p>
         * How many days of previous usage that AWS considers when making this recommendation.
         * </p>
         * 
         * @param lookbackPeriodInDays
         *        How many days of previous usage that AWS considers when making this recommendation.
         * @see LookbackPeriodInDays
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LookbackPeriodInDays
         */
        Builder lookbackPeriodInDays(LookbackPeriodInDays lookbackPeriodInDays);

        /**
         * <p>
         * The term of the reservation that you want recommendations for, in years.
         * </p>
         * 
         * @param termInYears
         *        The term of the reservation that you want recommendations for, in years.
         * @see TermInYears
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TermInYears
         */
        Builder termInYears(String termInYears);

        /**
         * <p>
         * The term of the reservation that you want recommendations for, in years.
         * </p>
         * 
         * @param termInYears
         *        The term of the reservation that you want recommendations for, in years.
         * @see TermInYears
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TermInYears
         */
        Builder termInYears(TermInYears termInYears);

        /**
         * <p>
         * The payment option for the reservation. For example, <code>AllUpfront</code> or <code>NoUpfront</code>.
         * </p>
         * 
         * @param paymentOption
         *        The payment option for the reservation. For example, <code>AllUpfront</code> or <code>NoUpfront</code>
         *        .
         * @see PaymentOption
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PaymentOption
         */
        Builder paymentOption(String paymentOption);

        /**
         * <p>
         * The payment option for the reservation. For example, <code>AllUpfront</code> or <code>NoUpfront</code>.
         * </p>
         * 
         * @param paymentOption
         *        The payment option for the reservation. For example, <code>AllUpfront</code> or <code>NoUpfront</code>
         *        .
         * @see PaymentOption
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PaymentOption
         */
        Builder paymentOption(PaymentOption paymentOption);

        /**
         * <p>
         * Hardware specifications for the service that you want recommendations for.
         * </p>
         * 
         * @param serviceSpecification
         *        Hardware specifications for the service that you want recommendations for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceSpecification(ServiceSpecification serviceSpecification);

        /**
         * <p>
         * Hardware specifications for the service that you want recommendations for.
         * </p>
         * This is a convenience that creates an instance of the {@link ServiceSpecification.Builder} avoiding the need
         * to create one manually via {@link ServiceSpecification#builder()}.
         *
         * When the {@link Consumer} completes, {@link ServiceSpecification.Builder#build()} is called immediately and
         * its result is passed to {@link #serviceSpecification(ServiceSpecification)}.
         * 
         * @param serviceSpecification
         *        a consumer that will call methods on {@link ServiceSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #serviceSpecification(ServiceSpecification)
         */
        default Builder serviceSpecification(Consumer<ServiceSpecification.Builder> serviceSpecification) {
            return serviceSpecification(ServiceSpecification.builder().applyMutation(serviceSpecification).build());
        }

        /**
         * <p>
         * Details about the recommended purchases.
         * </p>
         * 
         * @param recommendationDetails
         *        Details about the recommended purchases.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recommendationDetails(Collection<ReservationPurchaseRecommendationDetail> recommendationDetails);

        /**
         * <p>
         * Details about the recommended purchases.
         * </p>
         * 
         * @param recommendationDetails
         *        Details about the recommended purchases.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recommendationDetails(ReservationPurchaseRecommendationDetail... recommendationDetails);

        /**
         * <p>
         * Details about the recommended purchases.
         * </p>
         * This is a convenience that creates an instance of the {@link List
         * <ReservationPurchaseRecommendationDetail>.Builder} avoiding the need to create one manually via {@link List
         * <ReservationPurchaseRecommendationDetail>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ReservationPurchaseRecommendationDetail>.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #recommendationDetails(List<ReservationPurchaseRecommendationDetail>)}.
         * 
         * @param recommendationDetails
         *        a consumer that will call methods on {@link List<ReservationPurchaseRecommendationDetail>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #recommendationDetails(List<ReservationPurchaseRecommendationDetail>)
         */
        Builder recommendationDetails(Consumer<ReservationPurchaseRecommendationDetail.Builder>... recommendationDetails);

        /**
         * <p>
         * A summary about the recommended purchase.
         * </p>
         * 
         * @param recommendationSummary
         *        A summary about the recommended purchase.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recommendationSummary(ReservationPurchaseRecommendationSummary recommendationSummary);

        /**
         * <p>
         * A summary about the recommended purchase.
         * </p>
         * This is a convenience that creates an instance of the
         * {@link ReservationPurchaseRecommendationSummary.Builder} avoiding the need to create one manually via
         * {@link ReservationPurchaseRecommendationSummary#builder()}.
         *
         * When the {@link Consumer} completes, {@link ReservationPurchaseRecommendationSummary.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #recommendationSummary(ReservationPurchaseRecommendationSummary)}.
         * 
         * @param recommendationSummary
         *        a consumer that will call methods on {@link ReservationPurchaseRecommendationSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #recommendationSummary(ReservationPurchaseRecommendationSummary)
         */
        default Builder recommendationSummary(Consumer<ReservationPurchaseRecommendationSummary.Builder> recommendationSummary) {
            return recommendationSummary(ReservationPurchaseRecommendationSummary.builder().applyMutation(recommendationSummary)
                    .build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String accountScope;

        private String lookbackPeriodInDays;

        private String termInYears;

        private String paymentOption;

        private ServiceSpecification serviceSpecification;

        private List<ReservationPurchaseRecommendationDetail> recommendationDetails = DefaultSdkAutoConstructList.getInstance();

        private ReservationPurchaseRecommendationSummary recommendationSummary;

        private BuilderImpl() {
        }

        private BuilderImpl(ReservationPurchaseRecommendation model) {
            accountScope(model.accountScope);
            lookbackPeriodInDays(model.lookbackPeriodInDays);
            termInYears(model.termInYears);
            paymentOption(model.paymentOption);
            serviceSpecification(model.serviceSpecification);
            recommendationDetails(model.recommendationDetails);
            recommendationSummary(model.recommendationSummary);
        }

        public final String getAccountScopeAsString() {
            return accountScope;
        }

        @Override
        public final Builder accountScope(String accountScope) {
            this.accountScope = accountScope;
            return this;
        }

        @Override
        public final Builder accountScope(AccountScope accountScope) {
            this.accountScope(accountScope == null ? null : accountScope.toString());
            return this;
        }

        public final void setAccountScope(String accountScope) {
            this.accountScope = accountScope;
        }

        public final String getLookbackPeriodInDaysAsString() {
            return lookbackPeriodInDays;
        }

        @Override
        public final Builder lookbackPeriodInDays(String lookbackPeriodInDays) {
            this.lookbackPeriodInDays = lookbackPeriodInDays;
            return this;
        }

        @Override
        public final Builder lookbackPeriodInDays(LookbackPeriodInDays lookbackPeriodInDays) {
            this.lookbackPeriodInDays(lookbackPeriodInDays == null ? null : lookbackPeriodInDays.toString());
            return this;
        }

        public final void setLookbackPeriodInDays(String lookbackPeriodInDays) {
            this.lookbackPeriodInDays = lookbackPeriodInDays;
        }

        public final String getTermInYearsAsString() {
            return termInYears;
        }

        @Override
        public final Builder termInYears(String termInYears) {
            this.termInYears = termInYears;
            return this;
        }

        @Override
        public final Builder termInYears(TermInYears termInYears) {
            this.termInYears(termInYears == null ? null : termInYears.toString());
            return this;
        }

        public final void setTermInYears(String termInYears) {
            this.termInYears = termInYears;
        }

        public final String getPaymentOptionAsString() {
            return paymentOption;
        }

        @Override
        public final Builder paymentOption(String paymentOption) {
            this.paymentOption = paymentOption;
            return this;
        }

        @Override
        public final Builder paymentOption(PaymentOption paymentOption) {
            this.paymentOption(paymentOption == null ? null : paymentOption.toString());
            return this;
        }

        public final void setPaymentOption(String paymentOption) {
            this.paymentOption = paymentOption;
        }

        public final ServiceSpecification.Builder getServiceSpecification() {
            return serviceSpecification != null ? serviceSpecification.toBuilder() : null;
        }

        @Override
        public final Builder serviceSpecification(ServiceSpecification serviceSpecification) {
            this.serviceSpecification = serviceSpecification;
            return this;
        }

        public final void setServiceSpecification(ServiceSpecification.BuilderImpl serviceSpecification) {
            this.serviceSpecification = serviceSpecification != null ? serviceSpecification.build() : null;
        }

        public final Collection<ReservationPurchaseRecommendationDetail.Builder> getRecommendationDetails() {
            return recommendationDetails != null ? recommendationDetails.stream()
                    .map(ReservationPurchaseRecommendationDetail::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder recommendationDetails(Collection<ReservationPurchaseRecommendationDetail> recommendationDetails) {
            this.recommendationDetails = ReservationPurchaseRecommendationDetailsCopier.copy(recommendationDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recommendationDetails(ReservationPurchaseRecommendationDetail... recommendationDetails) {
            recommendationDetails(Arrays.asList(recommendationDetails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recommendationDetails(
                Consumer<ReservationPurchaseRecommendationDetail.Builder>... recommendationDetails) {
            recommendationDetails(Stream.of(recommendationDetails)
                    .map(c -> ReservationPurchaseRecommendationDetail.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setRecommendationDetails(
                Collection<ReservationPurchaseRecommendationDetail.BuilderImpl> recommendationDetails) {
            this.recommendationDetails = ReservationPurchaseRecommendationDetailsCopier.copyFromBuilder(recommendationDetails);
        }

        public final ReservationPurchaseRecommendationSummary.Builder getRecommendationSummary() {
            return recommendationSummary != null ? recommendationSummary.toBuilder() : null;
        }

        @Override
        public final Builder recommendationSummary(ReservationPurchaseRecommendationSummary recommendationSummary) {
            this.recommendationSummary = recommendationSummary;
            return this;
        }

        public final void setRecommendationSummary(ReservationPurchaseRecommendationSummary.BuilderImpl recommendationSummary) {
            this.recommendationSummary = recommendationSummary != null ? recommendationSummary.build() : null;
        }

        @Override
        public ReservationPurchaseRecommendation build() {
            return new ReservationPurchaseRecommendation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
