/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costexplorer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A group of reservations that share a set of attributes.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReservationCoverageGroup implements SdkPojo, Serializable,
        ToCopyableBuilder<ReservationCoverageGroup.Builder, ReservationCoverageGroup> {
    private static final SdkField<Map<String, String>> ATTRIBUTES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(ReservationCoverageGroup::attributes))
            .setter(setter(Builder::attributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attributes").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Coverage> COVERAGE_FIELD = SdkField.<Coverage> builder(MarshallingType.SDK_POJO)
            .getter(getter(ReservationCoverageGroup::coverage)).setter(setter(Builder::coverage)).constructor(Coverage::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Coverage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTRIBUTES_FIELD,
            COVERAGE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Map<String, String> attributes;

    private final Coverage coverage;

    private ReservationCoverageGroup(BuilderImpl builder) {
        this.attributes = builder.attributes;
        this.coverage = builder.coverage;
    }

    /**
     * Returns true if the Attributes property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasAttributes() {
        return attributes != null && !(attributes instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The attributes for this group of reservations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAttributes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The attributes for this group of reservations.
     */
    public Map<String, String> attributes() {
        return attributes;
    }

    /**
     * <p>
     * How much instance usage this group of reservations covered.
     * </p>
     * 
     * @return How much instance usage this group of reservations covered.
     */
    public Coverage coverage() {
        return coverage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(attributes());
        hashCode = 31 * hashCode + Objects.hashCode(coverage());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReservationCoverageGroup)) {
            return false;
        }
        ReservationCoverageGroup other = (ReservationCoverageGroup) obj;
        return Objects.equals(attributes(), other.attributes()) && Objects.equals(coverage(), other.coverage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ReservationCoverageGroup").add("Attributes", attributes()).add("Coverage", coverage()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Attributes":
            return Optional.ofNullable(clazz.cast(attributes()));
        case "Coverage":
            return Optional.ofNullable(clazz.cast(coverage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReservationCoverageGroup, T> g) {
        return obj -> g.apply((ReservationCoverageGroup) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReservationCoverageGroup> {
        /**
         * <p>
         * The attributes for this group of reservations.
         * </p>
         * 
         * @param attributes
         *        The attributes for this group of reservations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(Map<String, String> attributes);

        /**
         * <p>
         * How much instance usage this group of reservations covered.
         * </p>
         * 
         * @param coverage
         *        How much instance usage this group of reservations covered.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder coverage(Coverage coverage);

        /**
         * <p>
         * How much instance usage this group of reservations covered.
         * </p>
         * This is a convenience that creates an instance of the {@link Coverage.Builder} avoiding the need to create
         * one manually via {@link Coverage#builder()}.
         *
         * When the {@link Consumer} completes, {@link Coverage.Builder#build()} is called immediately and its result is
         * passed to {@link #coverage(Coverage)}.
         * 
         * @param coverage
         *        a consumer that will call methods on {@link Coverage.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #coverage(Coverage)
         */
        default Builder coverage(Consumer<Coverage.Builder> coverage) {
            return coverage(Coverage.builder().applyMutation(coverage).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Map<String, String> attributes = DefaultSdkAutoConstructMap.getInstance();

        private Coverage coverage;

        private BuilderImpl() {
        }

        private BuilderImpl(ReservationCoverageGroup model) {
            attributes(model.attributes);
            coverage(model.coverage);
        }

        public final Map<String, String> getAttributes() {
            return attributes;
        }

        @Override
        public final Builder attributes(Map<String, String> attributes) {
            this.attributes = AttributesCopier.copy(attributes);
            return this;
        }

        public final void setAttributes(Map<String, String> attributes) {
            this.attributes = AttributesCopier.copy(attributes);
        }

        public final Coverage.Builder getCoverage() {
            return coverage != null ? coverage.toBuilder() : null;
        }

        @Override
        public final Builder coverage(Coverage coverage) {
            this.coverage = coverage;
            return this;
        }

        public final void setCoverage(Coverage.BuilderImpl coverage) {
            this.coverage = coverage != null ? coverage.build() : null;
        }

        @Override
        public ReservationCoverageGroup build() {
            return new ReservationCoverageGroup(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
