/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costexplorer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details on the modification recommendation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyRecommendationDetail implements SdkPojo, Serializable,
        ToCopyableBuilder<ModifyRecommendationDetail.Builder, ModifyRecommendationDetail> {
    private static final SdkField<List<TargetInstance>> TARGET_INSTANCES_FIELD = SdkField
            .<List<TargetInstance>> builder(MarshallingType.LIST)
            .getter(getter(ModifyRecommendationDetail::targetInstances))
            .setter(setter(Builder::targetInstances))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetInstances").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TargetInstance> builder(MarshallingType.SDK_POJO)
                                            .constructor(TargetInstance::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TARGET_INSTANCES_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<TargetInstance> targetInstances;

    private ModifyRecommendationDetail(BuilderImpl builder) {
        this.targetInstances = builder.targetInstances;
    }

    /**
     * Returns true if the TargetInstances property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasTargetInstances() {
        return targetInstances != null && !(targetInstances instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Identifies whether this instance type is the Amazon Web Services default recommendation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTargetInstances()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Identifies whether this instance type is the Amazon Web Services default recommendation.
     */
    public List<TargetInstance> targetInstances() {
        return targetInstances;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(targetInstances());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyRecommendationDetail)) {
            return false;
        }
        ModifyRecommendationDetail other = (ModifyRecommendationDetail) obj;
        return Objects.equals(targetInstances(), other.targetInstances());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ModifyRecommendationDetail").add("TargetInstances", targetInstances()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TargetInstances":
            return Optional.ofNullable(clazz.cast(targetInstances()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyRecommendationDetail, T> g) {
        return obj -> g.apply((ModifyRecommendationDetail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ModifyRecommendationDetail> {
        /**
         * <p>
         * Identifies whether this instance type is the Amazon Web Services default recommendation.
         * </p>
         * 
         * @param targetInstances
         *        Identifies whether this instance type is the Amazon Web Services default recommendation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetInstances(Collection<TargetInstance> targetInstances);

        /**
         * <p>
         * Identifies whether this instance type is the Amazon Web Services default recommendation.
         * </p>
         * 
         * @param targetInstances
         *        Identifies whether this instance type is the Amazon Web Services default recommendation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetInstances(TargetInstance... targetInstances);

        /**
         * <p>
         * Identifies whether this instance type is the Amazon Web Services default recommendation.
         * </p>
         * This is a convenience that creates an instance of the {@link List<TargetInstance>.Builder} avoiding the need
         * to create one manually via {@link List<TargetInstance>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<TargetInstance>.Builder#build()} is called immediately and
         * its result is passed to {@link #targetInstances(List<TargetInstance>)}.
         * 
         * @param targetInstances
         *        a consumer that will call methods on {@link List<TargetInstance>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #targetInstances(List<TargetInstance>)
         */
        Builder targetInstances(Consumer<TargetInstance.Builder>... targetInstances);
    }

    static final class BuilderImpl implements Builder {
        private List<TargetInstance> targetInstances = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyRecommendationDetail model) {
            targetInstances(model.targetInstances);
        }

        public final Collection<TargetInstance.Builder> getTargetInstances() {
            return targetInstances != null ? targetInstances.stream().map(TargetInstance::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder targetInstances(Collection<TargetInstance> targetInstances) {
            this.targetInstances = TargetInstancesListCopier.copy(targetInstances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetInstances(TargetInstance... targetInstances) {
            targetInstances(Arrays.asList(targetInstances));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetInstances(Consumer<TargetInstance.Builder>... targetInstances) {
            targetInstances(Stream.of(targetInstances).map(c -> TargetInstance.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setTargetInstances(Collection<TargetInstance.BuilderImpl> targetInstances) {
            this.targetInstances = TargetInstancesListCopier.copyFromBuilder(targetInstances);
        }

        @Override
        public ModifyRecommendationDetail build() {
            return new ModifyRecommendationDetail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
