/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costexplorer.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListCostCategoryDefinitionsRequest extends CostExplorerRequest implements
        ToCopyableBuilder<ListCostCategoryDefinitionsRequest.Builder, ListCostCategoryDefinitionsRequest> {
    private static final SdkField<String> EFFECTIVE_ON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListCostCategoryDefinitionsRequest::effectiveOn)).setter(setter(Builder::effectiveOn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EffectiveOn").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListCostCategoryDefinitionsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EFFECTIVE_ON_FIELD,
            NEXT_TOKEN_FIELD));

    private final String effectiveOn;

    private final String nextToken;

    private ListCostCategoryDefinitionsRequest(BuilderImpl builder) {
        super(builder);
        this.effectiveOn = builder.effectiveOn;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The date when the Cost Category was effective.
     * </p>
     * 
     * @return The date when the Cost Category was effective.
     */
    public String effectiveOn() {
        return effectiveOn;
    }

    /**
     * <p>
     * The token to retrieve the next set of results. Amazon Web Services provides the token when the response from a
     * previous call has more results than the maximum page size.
     * </p>
     * <p>
     * You can use this information to retrieve the full Cost Category information using
     * <code>DescribeCostCategory</code>.
     * </p>
     * 
     * @return The token to retrieve the next set of results. Amazon Web Services provides the token when the response
     *         from a previous call has more results than the maximum page size. </p>
     *         <p>
     *         You can use this information to retrieve the full Cost Category information using
     *         <code>DescribeCostCategory</code>.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(effectiveOn());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCostCategoryDefinitionsRequest)) {
            return false;
        }
        ListCostCategoryDefinitionsRequest other = (ListCostCategoryDefinitionsRequest) obj;
        return Objects.equals(effectiveOn(), other.effectiveOn()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListCostCategoryDefinitionsRequest").add("EffectiveOn", effectiveOn())
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EffectiveOn":
            return Optional.ofNullable(clazz.cast(effectiveOn()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListCostCategoryDefinitionsRequest, T> g) {
        return obj -> g.apply((ListCostCategoryDefinitionsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CostExplorerRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ListCostCategoryDefinitionsRequest> {
        /**
         * <p>
         * The date when the Cost Category was effective.
         * </p>
         * 
         * @param effectiveOn
         *        The date when the Cost Category was effective.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder effectiveOn(String effectiveOn);

        /**
         * <p>
         * The token to retrieve the next set of results. Amazon Web Services provides the token when the response from
         * a previous call has more results than the maximum page size.
         * </p>
         * <p>
         * You can use this information to retrieve the full Cost Category information using
         * <code>DescribeCostCategory</code>.
         * </p>
         * 
         * @param nextToken
         *        The token to retrieve the next set of results. Amazon Web Services provides the token when the
         *        response from a previous call has more results than the maximum page size. </p>
         *        <p>
         *        You can use this information to retrieve the full Cost Category information using
         *        <code>DescribeCostCategory</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CostExplorerRequest.BuilderImpl implements Builder {
        private String effectiveOn;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCostCategoryDefinitionsRequest model) {
            super(model);
            effectiveOn(model.effectiveOn);
            nextToken(model.nextToken);
        }

        public final String getEffectiveOn() {
            return effectiveOn;
        }

        @Override
        public final Builder effectiveOn(String effectiveOn) {
            this.effectiveOn = effectiveOn;
            return this;
        }

        public final void setEffectiveOn(String effectiveOn) {
            this.effectiveOn = effectiveOn;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListCostCategoryDefinitionsRequest build() {
            return new ListCostCategoryDefinitionsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
