/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costexplorer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a group when you specify a group by criteria or in the response to a query with a specific grouping.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GroupDefinition implements SdkPojo, Serializable, ToCopyableBuilder<GroupDefinition.Builder, GroupDefinition> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GroupDefinition::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<String> KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GroupDefinition::key)).setter(setter(Builder::key))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Key").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, KEY_FIELD));

    private static final long serialVersionUID = 1L;

    private final String type;

    private final String key;

    private GroupDefinition(BuilderImpl builder) {
        this.type = builder.type;
        this.key = builder.key;
    }

    /**
     * <p>
     * The string that represents the type of group.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link GroupDefinitionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The string that represents the type of group.
     * @see GroupDefinitionType
     */
    public GroupDefinitionType type() {
        return GroupDefinitionType.fromValue(type);
    }

    /**
     * <p>
     * The string that represents the type of group.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link GroupDefinitionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The string that represents the type of group.
     * @see GroupDefinitionType
     */
    public String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The string that represents a key for a specified group.
     * </p>
     * 
     * @return The string that represents a key for a specified group.
     */
    public String key() {
        return key;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(key());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GroupDefinition)) {
            return false;
        }
        GroupDefinition other = (GroupDefinition) obj;
        return Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(key(), other.key());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GroupDefinition").add("Type", typeAsString()).add("Key", key()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "Key":
            return Optional.ofNullable(clazz.cast(key()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GroupDefinition, T> g) {
        return obj -> g.apply((GroupDefinition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GroupDefinition> {
        /**
         * <p>
         * The string that represents the type of group.
         * </p>
         * 
         * @param type
         *        The string that represents the type of group.
         * @see GroupDefinitionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GroupDefinitionType
         */
        Builder type(String type);

        /**
         * <p>
         * The string that represents the type of group.
         * </p>
         * 
         * @param type
         *        The string that represents the type of group.
         * @see GroupDefinitionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GroupDefinitionType
         */
        Builder type(GroupDefinitionType type);

        /**
         * <p>
         * The string that represents a key for a specified group.
         * </p>
         * 
         * @param key
         *        The string that represents a key for a specified group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder key(String key);
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private String key;

        private BuilderImpl() {
        }

        private BuilderImpl(GroupDefinition model) {
            type(model.type);
            key(model.key);
        }

        public final String getTypeAsString() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(GroupDefinitionType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getKey() {
            return key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        @Override
        public GroupDefinition build() {
            return new GroupDefinition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
