/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costexplorer.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetSavingsPlansUtilizationResponse extends CostExplorerResponse implements
        ToCopyableBuilder<GetSavingsPlansUtilizationResponse.Builder, GetSavingsPlansUtilizationResponse> {
    private static final SdkField<List<SavingsPlansUtilizationByTime>> SAVINGS_PLANS_UTILIZATIONS_BY_TIME_FIELD = SdkField
            .<List<SavingsPlansUtilizationByTime>> builder(MarshallingType.LIST)
            .getter(getter(GetSavingsPlansUtilizationResponse::savingsPlansUtilizationsByTime))
            .setter(setter(Builder::savingsPlansUtilizationsByTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SavingsPlansUtilizationsByTime")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SavingsPlansUtilizationByTime> builder(MarshallingType.SDK_POJO)
                                            .constructor(SavingsPlansUtilizationByTime::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<SavingsPlansUtilizationAggregates> TOTAL_FIELD = SdkField
            .<SavingsPlansUtilizationAggregates> builder(MarshallingType.SDK_POJO)
            .getter(getter(GetSavingsPlansUtilizationResponse::total)).setter(setter(Builder::total))
            .constructor(SavingsPlansUtilizationAggregates::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Total").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            SAVINGS_PLANS_UTILIZATIONS_BY_TIME_FIELD, TOTAL_FIELD));

    private final List<SavingsPlansUtilizationByTime> savingsPlansUtilizationsByTime;

    private final SavingsPlansUtilizationAggregates total;

    private GetSavingsPlansUtilizationResponse(BuilderImpl builder) {
        super(builder);
        this.savingsPlansUtilizationsByTime = builder.savingsPlansUtilizationsByTime;
        this.total = builder.total;
    }

    /**
     * Returns true if the SavingsPlansUtilizationsByTime property was specified by the sender (it may be empty), or
     * false if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender
     * is the AWS service.
     */
    public boolean hasSavingsPlansUtilizationsByTime() {
        return savingsPlansUtilizationsByTime != null && !(savingsPlansUtilizationsByTime instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The amount of cost/commitment you used your Savings Plans. This allows you to specify date ranges.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSavingsPlansUtilizationsByTime()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The amount of cost/commitment you used your Savings Plans. This allows you to specify date ranges.
     */
    public List<SavingsPlansUtilizationByTime> savingsPlansUtilizationsByTime() {
        return savingsPlansUtilizationsByTime;
    }

    /**
     * <p>
     * The total amount of cost/commitment that you used your Savings Plans, regardless of date ranges.
     * </p>
     * 
     * @return The total amount of cost/commitment that you used your Savings Plans, regardless of date ranges.
     */
    public SavingsPlansUtilizationAggregates total() {
        return total;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(savingsPlansUtilizationsByTime());
        hashCode = 31 * hashCode + Objects.hashCode(total());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSavingsPlansUtilizationResponse)) {
            return false;
        }
        GetSavingsPlansUtilizationResponse other = (GetSavingsPlansUtilizationResponse) obj;
        return Objects.equals(savingsPlansUtilizationsByTime(), other.savingsPlansUtilizationsByTime())
                && Objects.equals(total(), other.total());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetSavingsPlansUtilizationResponse")
                .add("SavingsPlansUtilizationsByTime", savingsPlansUtilizationsByTime()).add("Total", total()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SavingsPlansUtilizationsByTime":
            return Optional.ofNullable(clazz.cast(savingsPlansUtilizationsByTime()));
        case "Total":
            return Optional.ofNullable(clazz.cast(total()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetSavingsPlansUtilizationResponse, T> g) {
        return obj -> g.apply((GetSavingsPlansUtilizationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CostExplorerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetSavingsPlansUtilizationResponse> {
        /**
         * <p>
         * The amount of cost/commitment you used your Savings Plans. This allows you to specify date ranges.
         * </p>
         * 
         * @param savingsPlansUtilizationsByTime
         *        The amount of cost/commitment you used your Savings Plans. This allows you to specify date ranges.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder savingsPlansUtilizationsByTime(Collection<SavingsPlansUtilizationByTime> savingsPlansUtilizationsByTime);

        /**
         * <p>
         * The amount of cost/commitment you used your Savings Plans. This allows you to specify date ranges.
         * </p>
         * 
         * @param savingsPlansUtilizationsByTime
         *        The amount of cost/commitment you used your Savings Plans. This allows you to specify date ranges.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder savingsPlansUtilizationsByTime(SavingsPlansUtilizationByTime... savingsPlansUtilizationsByTime);

        /**
         * <p>
         * The amount of cost/commitment you used your Savings Plans. This allows you to specify date ranges.
         * </p>
         * This is a convenience that creates an instance of the {@link List<SavingsPlansUtilizationByTime>.Builder}
         * avoiding the need to create one manually via {@link List<SavingsPlansUtilizationByTime>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<SavingsPlansUtilizationByTime>.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #savingsPlansUtilizationsByTime(List<SavingsPlansUtilizationByTime>)}.
         * 
         * @param savingsPlansUtilizationsByTime
         *        a consumer that will call methods on {@link List<SavingsPlansUtilizationByTime>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #savingsPlansUtilizationsByTime(List<SavingsPlansUtilizationByTime>)
         */
        Builder savingsPlansUtilizationsByTime(Consumer<SavingsPlansUtilizationByTime.Builder>... savingsPlansUtilizationsByTime);

        /**
         * <p>
         * The total amount of cost/commitment that you used your Savings Plans, regardless of date ranges.
         * </p>
         * 
         * @param total
         *        The total amount of cost/commitment that you used your Savings Plans, regardless of date ranges.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder total(SavingsPlansUtilizationAggregates total);

        /**
         * <p>
         * The total amount of cost/commitment that you used your Savings Plans, regardless of date ranges.
         * </p>
         * This is a convenience that creates an instance of the {@link SavingsPlansUtilizationAggregates.Builder}
         * avoiding the need to create one manually via {@link SavingsPlansUtilizationAggregates#builder()}.
         *
         * When the {@link Consumer} completes, {@link SavingsPlansUtilizationAggregates.Builder#build()} is called
         * immediately and its result is passed to {@link #total(SavingsPlansUtilizationAggregates)}.
         * 
         * @param total
         *        a consumer that will call methods on {@link SavingsPlansUtilizationAggregates.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #total(SavingsPlansUtilizationAggregates)
         */
        default Builder total(Consumer<SavingsPlansUtilizationAggregates.Builder> total) {
            return total(SavingsPlansUtilizationAggregates.builder().applyMutation(total).build());
        }
    }

    static final class BuilderImpl extends CostExplorerResponse.BuilderImpl implements Builder {
        private List<SavingsPlansUtilizationByTime> savingsPlansUtilizationsByTime = DefaultSdkAutoConstructList.getInstance();

        private SavingsPlansUtilizationAggregates total;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSavingsPlansUtilizationResponse model) {
            super(model);
            savingsPlansUtilizationsByTime(model.savingsPlansUtilizationsByTime);
            total(model.total);
        }

        public final Collection<SavingsPlansUtilizationByTime.Builder> getSavingsPlansUtilizationsByTime() {
            return savingsPlansUtilizationsByTime != null ? savingsPlansUtilizationsByTime.stream()
                    .map(SavingsPlansUtilizationByTime::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder savingsPlansUtilizationsByTime(
                Collection<SavingsPlansUtilizationByTime> savingsPlansUtilizationsByTime) {
            this.savingsPlansUtilizationsByTime = SavingsPlansUtilizationsByTimeCopier.copy(savingsPlansUtilizationsByTime);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder savingsPlansUtilizationsByTime(SavingsPlansUtilizationByTime... savingsPlansUtilizationsByTime) {
            savingsPlansUtilizationsByTime(Arrays.asList(savingsPlansUtilizationsByTime));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder savingsPlansUtilizationsByTime(
                Consumer<SavingsPlansUtilizationByTime.Builder>... savingsPlansUtilizationsByTime) {
            savingsPlansUtilizationsByTime(Stream.of(savingsPlansUtilizationsByTime)
                    .map(c -> SavingsPlansUtilizationByTime.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSavingsPlansUtilizationsByTime(
                Collection<SavingsPlansUtilizationByTime.BuilderImpl> savingsPlansUtilizationsByTime) {
            this.savingsPlansUtilizationsByTime = SavingsPlansUtilizationsByTimeCopier
                    .copyFromBuilder(savingsPlansUtilizationsByTime);
        }

        public final SavingsPlansUtilizationAggregates.Builder getTotal() {
            return total != null ? total.toBuilder() : null;
        }

        @Override
        public final Builder total(SavingsPlansUtilizationAggregates total) {
            this.total = total;
            return this;
        }

        public final void setTotal(SavingsPlansUtilizationAggregates.BuilderImpl total) {
            this.total = total != null ? total.build() : null;
        }

        @Override
        public GetSavingsPlansUtilizationResponse build() {
            return new GetSavingsPlansUtilizationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
