/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costexplorer.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetSavingsPlansUtilizationDetailsResponse extends CostExplorerResponse implements
        ToCopyableBuilder<GetSavingsPlansUtilizationDetailsResponse.Builder, GetSavingsPlansUtilizationDetailsResponse> {
    private static final SdkField<List<SavingsPlansUtilizationDetail>> SAVINGS_PLANS_UTILIZATION_DETAILS_FIELD = SdkField
            .<List<SavingsPlansUtilizationDetail>> builder(MarshallingType.LIST)
            .getter(getter(GetSavingsPlansUtilizationDetailsResponse::savingsPlansUtilizationDetails))
            .setter(setter(Builder::savingsPlansUtilizationDetails))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SavingsPlansUtilizationDetails")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SavingsPlansUtilizationDetail> builder(MarshallingType.SDK_POJO)
                                            .constructor(SavingsPlansUtilizationDetail::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<SavingsPlansUtilizationAggregates> TOTAL_FIELD = SdkField
            .<SavingsPlansUtilizationAggregates> builder(MarshallingType.SDK_POJO)
            .getter(getter(GetSavingsPlansUtilizationDetailsResponse::total)).setter(setter(Builder::total))
            .constructor(SavingsPlansUtilizationAggregates::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Total").build()).build();

    private static final SdkField<DateInterval> TIME_PERIOD_FIELD = SdkField.<DateInterval> builder(MarshallingType.SDK_POJO)
            .getter(getter(GetSavingsPlansUtilizationDetailsResponse::timePeriod)).setter(setter(Builder::timePeriod))
            .constructor(DateInterval::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimePeriod").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetSavingsPlansUtilizationDetailsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            SAVINGS_PLANS_UTILIZATION_DETAILS_FIELD, TOTAL_FIELD, TIME_PERIOD_FIELD, NEXT_TOKEN_FIELD));

    private final List<SavingsPlansUtilizationDetail> savingsPlansUtilizationDetails;

    private final SavingsPlansUtilizationAggregates total;

    private final DateInterval timePeriod;

    private final String nextToken;

    private GetSavingsPlansUtilizationDetailsResponse(BuilderImpl builder) {
        super(builder);
        this.savingsPlansUtilizationDetails = builder.savingsPlansUtilizationDetails;
        this.total = builder.total;
        this.timePeriod = builder.timePeriod;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the SavingsPlansUtilizationDetails property was specified by the sender (it may be empty), or
     * false if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender
     * is the AWS service.
     */
    public boolean hasSavingsPlansUtilizationDetails() {
        return savingsPlansUtilizationDetails != null && !(savingsPlansUtilizationDetails instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Retrieves a single daily or monthly Savings Plans utilization rate and details for your account.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSavingsPlansUtilizationDetails()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Retrieves a single daily or monthly Savings Plans utilization rate and details for your account.
     */
    public List<SavingsPlansUtilizationDetail> savingsPlansUtilizationDetails() {
        return savingsPlansUtilizationDetails;
    }

    /**
     * <p>
     * The total Savings Plans utilization, regardless of time period.
     * </p>
     * 
     * @return The total Savings Plans utilization, regardless of time period.
     */
    public SavingsPlansUtilizationAggregates total() {
        return total;
    }

    /**
     * Returns the value of the TimePeriod property for this object.
     * 
     * @return The value of the TimePeriod property for this object.
     */
    public DateInterval timePeriod() {
        return timePeriod;
    }

    /**
     * <p>
     * The token to retrieve the next set of results. Amazon Web Services provides the token when the response from a
     * previous call has more results than the maximum page size.
     * </p>
     * 
     * @return The token to retrieve the next set of results. Amazon Web Services provides the token when the response
     *         from a previous call has more results than the maximum page size.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(savingsPlansUtilizationDetails());
        hashCode = 31 * hashCode + Objects.hashCode(total());
        hashCode = 31 * hashCode + Objects.hashCode(timePeriod());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSavingsPlansUtilizationDetailsResponse)) {
            return false;
        }
        GetSavingsPlansUtilizationDetailsResponse other = (GetSavingsPlansUtilizationDetailsResponse) obj;
        return Objects.equals(savingsPlansUtilizationDetails(), other.savingsPlansUtilizationDetails())
                && Objects.equals(total(), other.total()) && Objects.equals(timePeriod(), other.timePeriod())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetSavingsPlansUtilizationDetailsResponse")
                .add("SavingsPlansUtilizationDetails", savingsPlansUtilizationDetails()).add("Total", total())
                .add("TimePeriod", timePeriod()).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SavingsPlansUtilizationDetails":
            return Optional.ofNullable(clazz.cast(savingsPlansUtilizationDetails()));
        case "Total":
            return Optional.ofNullable(clazz.cast(total()));
        case "TimePeriod":
            return Optional.ofNullable(clazz.cast(timePeriod()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetSavingsPlansUtilizationDetailsResponse, T> g) {
        return obj -> g.apply((GetSavingsPlansUtilizationDetailsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CostExplorerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetSavingsPlansUtilizationDetailsResponse> {
        /**
         * <p>
         * Retrieves a single daily or monthly Savings Plans utilization rate and details for your account.
         * </p>
         * 
         * @param savingsPlansUtilizationDetails
         *        Retrieves a single daily or monthly Savings Plans utilization rate and details for your account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder savingsPlansUtilizationDetails(Collection<SavingsPlansUtilizationDetail> savingsPlansUtilizationDetails);

        /**
         * <p>
         * Retrieves a single daily or monthly Savings Plans utilization rate and details for your account.
         * </p>
         * 
         * @param savingsPlansUtilizationDetails
         *        Retrieves a single daily or monthly Savings Plans utilization rate and details for your account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder savingsPlansUtilizationDetails(SavingsPlansUtilizationDetail... savingsPlansUtilizationDetails);

        /**
         * <p>
         * Retrieves a single daily or monthly Savings Plans utilization rate and details for your account.
         * </p>
         * This is a convenience that creates an instance of the {@link List<SavingsPlansUtilizationDetail>.Builder}
         * avoiding the need to create one manually via {@link List<SavingsPlansUtilizationDetail>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<SavingsPlansUtilizationDetail>.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #savingsPlansUtilizationDetails(List<SavingsPlansUtilizationDetail>)}.
         * 
         * @param savingsPlansUtilizationDetails
         *        a consumer that will call methods on {@link List<SavingsPlansUtilizationDetail>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #savingsPlansUtilizationDetails(List<SavingsPlansUtilizationDetail>)
         */
        Builder savingsPlansUtilizationDetails(Consumer<SavingsPlansUtilizationDetail.Builder>... savingsPlansUtilizationDetails);

        /**
         * <p>
         * The total Savings Plans utilization, regardless of time period.
         * </p>
         * 
         * @param total
         *        The total Savings Plans utilization, regardless of time period.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder total(SavingsPlansUtilizationAggregates total);

        /**
         * <p>
         * The total Savings Plans utilization, regardless of time period.
         * </p>
         * This is a convenience that creates an instance of the {@link SavingsPlansUtilizationAggregates.Builder}
         * avoiding the need to create one manually via {@link SavingsPlansUtilizationAggregates#builder()}.
         *
         * When the {@link Consumer} completes, {@link SavingsPlansUtilizationAggregates.Builder#build()} is called
         * immediately and its result is passed to {@link #total(SavingsPlansUtilizationAggregates)}.
         * 
         * @param total
         *        a consumer that will call methods on {@link SavingsPlansUtilizationAggregates.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #total(SavingsPlansUtilizationAggregates)
         */
        default Builder total(Consumer<SavingsPlansUtilizationAggregates.Builder> total) {
            return total(SavingsPlansUtilizationAggregates.builder().applyMutation(total).build());
        }

        /**
         * Sets the value of the TimePeriod property for this object.
         *
         * @param timePeriod
         *        The new value for the TimePeriod property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timePeriod(DateInterval timePeriod);

        /**
         * Sets the value of the TimePeriod property for this object.
         *
         * This is a convenience that creates an instance of the {@link DateInterval.Builder} avoiding the need to
         * create one manually via {@link DateInterval#builder()}.
         *
         * When the {@link Consumer} completes, {@link DateInterval.Builder#build()} is called immediately and its
         * result is passed to {@link #timePeriod(DateInterval)}.
         * 
         * @param timePeriod
         *        a consumer that will call methods on {@link DateInterval.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #timePeriod(DateInterval)
         */
        default Builder timePeriod(Consumer<DateInterval.Builder> timePeriod) {
            return timePeriod(DateInterval.builder().applyMutation(timePeriod).build());
        }

        /**
         * <p>
         * The token to retrieve the next set of results. Amazon Web Services provides the token when the response from
         * a previous call has more results than the maximum page size.
         * </p>
         * 
         * @param nextToken
         *        The token to retrieve the next set of results. Amazon Web Services provides the token when the
         *        response from a previous call has more results than the maximum page size.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends CostExplorerResponse.BuilderImpl implements Builder {
        private List<SavingsPlansUtilizationDetail> savingsPlansUtilizationDetails = DefaultSdkAutoConstructList.getInstance();

        private SavingsPlansUtilizationAggregates total;

        private DateInterval timePeriod;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSavingsPlansUtilizationDetailsResponse model) {
            super(model);
            savingsPlansUtilizationDetails(model.savingsPlansUtilizationDetails);
            total(model.total);
            timePeriod(model.timePeriod);
            nextToken(model.nextToken);
        }

        public final Collection<SavingsPlansUtilizationDetail.Builder> getSavingsPlansUtilizationDetails() {
            return savingsPlansUtilizationDetails != null ? savingsPlansUtilizationDetails.stream()
                    .map(SavingsPlansUtilizationDetail::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder savingsPlansUtilizationDetails(
                Collection<SavingsPlansUtilizationDetail> savingsPlansUtilizationDetails) {
            this.savingsPlansUtilizationDetails = SavingsPlansUtilizationDetailsCopier.copy(savingsPlansUtilizationDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder savingsPlansUtilizationDetails(SavingsPlansUtilizationDetail... savingsPlansUtilizationDetails) {
            savingsPlansUtilizationDetails(Arrays.asList(savingsPlansUtilizationDetails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder savingsPlansUtilizationDetails(
                Consumer<SavingsPlansUtilizationDetail.Builder>... savingsPlansUtilizationDetails) {
            savingsPlansUtilizationDetails(Stream.of(savingsPlansUtilizationDetails)
                    .map(c -> SavingsPlansUtilizationDetail.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSavingsPlansUtilizationDetails(
                Collection<SavingsPlansUtilizationDetail.BuilderImpl> savingsPlansUtilizationDetails) {
            this.savingsPlansUtilizationDetails = SavingsPlansUtilizationDetailsCopier
                    .copyFromBuilder(savingsPlansUtilizationDetails);
        }

        public final SavingsPlansUtilizationAggregates.Builder getTotal() {
            return total != null ? total.toBuilder() : null;
        }

        @Override
        public final Builder total(SavingsPlansUtilizationAggregates total) {
            this.total = total;
            return this;
        }

        public final void setTotal(SavingsPlansUtilizationAggregates.BuilderImpl total) {
            this.total = total != null ? total.build() : null;
        }

        public final DateInterval.Builder getTimePeriod() {
            return timePeriod != null ? timePeriod.toBuilder() : null;
        }

        @Override
        public final Builder timePeriod(DateInterval timePeriod) {
            this.timePeriod = timePeriod;
            return this;
        }

        public final void setTimePeriod(DateInterval.BuilderImpl timePeriod) {
            this.timePeriod = timePeriod != null ? timePeriod.build() : null;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public GetSavingsPlansUtilizationDetailsResponse build() {
            return new GetSavingsPlansUtilizationDetailsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
