/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costexplorer.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetSavingsPlansPurchaseRecommendationRequest extends CostExplorerRequest implements
        ToCopyableBuilder<GetSavingsPlansPurchaseRecommendationRequest.Builder, GetSavingsPlansPurchaseRecommendationRequest> {
    private static final SdkField<String> SAVINGS_PLANS_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetSavingsPlansPurchaseRecommendationRequest::savingsPlansTypeAsString))
            .setter(setter(Builder::savingsPlansType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SavingsPlansType").build()).build();

    private static final SdkField<String> TERM_IN_YEARS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetSavingsPlansPurchaseRecommendationRequest::termInYearsAsString))
            .setter(setter(Builder::termInYears))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TermInYears").build()).build();

    private static final SdkField<String> PAYMENT_OPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetSavingsPlansPurchaseRecommendationRequest::paymentOptionAsString))
            .setter(setter(Builder::paymentOption))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PaymentOption").build()).build();

    private static final SdkField<String> NEXT_PAGE_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetSavingsPlansPurchaseRecommendationRequest::nextPageToken)).setter(setter(Builder::nextPageToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextPageToken").build()).build();

    private static final SdkField<Integer> PAGE_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(GetSavingsPlansPurchaseRecommendationRequest::pageSize)).setter(setter(Builder::pageSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PageSize").build()).build();

    private static final SdkField<String> LOOKBACK_PERIOD_IN_DAYS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetSavingsPlansPurchaseRecommendationRequest::lookbackPeriodInDaysAsString))
            .setter(setter(Builder::lookbackPeriodInDays))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LookbackPeriodInDays").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SAVINGS_PLANS_TYPE_FIELD,
            TERM_IN_YEARS_FIELD, PAYMENT_OPTION_FIELD, NEXT_PAGE_TOKEN_FIELD, PAGE_SIZE_FIELD, LOOKBACK_PERIOD_IN_DAYS_FIELD));

    private final String savingsPlansType;

    private final String termInYears;

    private final String paymentOption;

    private final String nextPageToken;

    private final Integer pageSize;

    private final String lookbackPeriodInDays;

    private GetSavingsPlansPurchaseRecommendationRequest(BuilderImpl builder) {
        super(builder);
        this.savingsPlansType = builder.savingsPlansType;
        this.termInYears = builder.termInYears;
        this.paymentOption = builder.paymentOption;
        this.nextPageToken = builder.nextPageToken;
        this.pageSize = builder.pageSize;
        this.lookbackPeriodInDays = builder.lookbackPeriodInDays;
    }

    /**
     * <p>
     * The Savings Plans recommendation type requested.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #savingsPlansType}
     * will return {@link SupportedSavingsPlansType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #savingsPlansTypeAsString}.
     * </p>
     * 
     * @return The Savings Plans recommendation type requested.
     * @see SupportedSavingsPlansType
     */
    public SupportedSavingsPlansType savingsPlansType() {
        return SupportedSavingsPlansType.fromValue(savingsPlansType);
    }

    /**
     * <p>
     * The Savings Plans recommendation type requested.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #savingsPlansType}
     * will return {@link SupportedSavingsPlansType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #savingsPlansTypeAsString}.
     * </p>
     * 
     * @return The Savings Plans recommendation type requested.
     * @see SupportedSavingsPlansType
     */
    public String savingsPlansTypeAsString() {
        return savingsPlansType;
    }

    /**
     * <p>
     * The savings plan recommendation term used to generated these recommendations.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #termInYears} will
     * return {@link TermInYears#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #termInYearsAsString}.
     * </p>
     * 
     * @return The savings plan recommendation term used to generated these recommendations.
     * @see TermInYears
     */
    public TermInYears termInYears() {
        return TermInYears.fromValue(termInYears);
    }

    /**
     * <p>
     * The savings plan recommendation term used to generated these recommendations.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #termInYears} will
     * return {@link TermInYears#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #termInYearsAsString}.
     * </p>
     * 
     * @return The savings plan recommendation term used to generated these recommendations.
     * @see TermInYears
     */
    public String termInYearsAsString() {
        return termInYears;
    }

    /**
     * <p>
     * The payment option used to generate these recommendations.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #paymentOption}
     * will return {@link PaymentOption#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #paymentOptionAsString}.
     * </p>
     * 
     * @return The payment option used to generate these recommendations.
     * @see PaymentOption
     */
    public PaymentOption paymentOption() {
        return PaymentOption.fromValue(paymentOption);
    }

    /**
     * <p>
     * The payment option used to generate these recommendations.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #paymentOption}
     * will return {@link PaymentOption#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #paymentOptionAsString}.
     * </p>
     * 
     * @return The payment option used to generate these recommendations.
     * @see PaymentOption
     */
    public String paymentOptionAsString() {
        return paymentOption;
    }

    /**
     * <p>
     * The token to retrieve the next set of results. Amazon Web Services provides the token when the response from a
     * previous call has more results than the maximum page size.
     * </p>
     * 
     * @return The token to retrieve the next set of results. Amazon Web Services provides the token when the response
     *         from a previous call has more results than the maximum page size.
     */
    public String nextPageToken() {
        return nextPageToken;
    }

    /**
     * <p>
     * The number of recommendations that you want returned in a single response object.
     * </p>
     * 
     * @return The number of recommendations that you want returned in a single response object.
     */
    public Integer pageSize() {
        return pageSize;
    }

    /**
     * <p>
     * The lookback period used to generate the recommendation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #lookbackPeriodInDays} will return {@link LookbackPeriodInDays#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #lookbackPeriodInDaysAsString}.
     * </p>
     * 
     * @return The lookback period used to generate the recommendation.
     * @see LookbackPeriodInDays
     */
    public LookbackPeriodInDays lookbackPeriodInDays() {
        return LookbackPeriodInDays.fromValue(lookbackPeriodInDays);
    }

    /**
     * <p>
     * The lookback period used to generate the recommendation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #lookbackPeriodInDays} will return {@link LookbackPeriodInDays#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #lookbackPeriodInDaysAsString}.
     * </p>
     * 
     * @return The lookback period used to generate the recommendation.
     * @see LookbackPeriodInDays
     */
    public String lookbackPeriodInDaysAsString() {
        return lookbackPeriodInDays;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(savingsPlansTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(termInYearsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(paymentOptionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(nextPageToken());
        hashCode = 31 * hashCode + Objects.hashCode(pageSize());
        hashCode = 31 * hashCode + Objects.hashCode(lookbackPeriodInDaysAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSavingsPlansPurchaseRecommendationRequest)) {
            return false;
        }
        GetSavingsPlansPurchaseRecommendationRequest other = (GetSavingsPlansPurchaseRecommendationRequest) obj;
        return Objects.equals(savingsPlansTypeAsString(), other.savingsPlansTypeAsString())
                && Objects.equals(termInYearsAsString(), other.termInYearsAsString())
                && Objects.equals(paymentOptionAsString(), other.paymentOptionAsString())
                && Objects.equals(nextPageToken(), other.nextPageToken()) && Objects.equals(pageSize(), other.pageSize())
                && Objects.equals(lookbackPeriodInDaysAsString(), other.lookbackPeriodInDaysAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetSavingsPlansPurchaseRecommendationRequest")
                .add("SavingsPlansType", savingsPlansTypeAsString()).add("TermInYears", termInYearsAsString())
                .add("PaymentOption", paymentOptionAsString()).add("NextPageToken", nextPageToken()).add("PageSize", pageSize())
                .add("LookbackPeriodInDays", lookbackPeriodInDaysAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SavingsPlansType":
            return Optional.ofNullable(clazz.cast(savingsPlansTypeAsString()));
        case "TermInYears":
            return Optional.ofNullable(clazz.cast(termInYearsAsString()));
        case "PaymentOption":
            return Optional.ofNullable(clazz.cast(paymentOptionAsString()));
        case "NextPageToken":
            return Optional.ofNullable(clazz.cast(nextPageToken()));
        case "PageSize":
            return Optional.ofNullable(clazz.cast(pageSize()));
        case "LookbackPeriodInDays":
            return Optional.ofNullable(clazz.cast(lookbackPeriodInDaysAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetSavingsPlansPurchaseRecommendationRequest, T> g) {
        return obj -> g.apply((GetSavingsPlansPurchaseRecommendationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CostExplorerRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, GetSavingsPlansPurchaseRecommendationRequest> {
        /**
         * <p>
         * The Savings Plans recommendation type requested.
         * </p>
         * 
         * @param savingsPlansType
         *        The Savings Plans recommendation type requested.
         * @see SupportedSavingsPlansType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SupportedSavingsPlansType
         */
        Builder savingsPlansType(String savingsPlansType);

        /**
         * <p>
         * The Savings Plans recommendation type requested.
         * </p>
         * 
         * @param savingsPlansType
         *        The Savings Plans recommendation type requested.
         * @see SupportedSavingsPlansType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SupportedSavingsPlansType
         */
        Builder savingsPlansType(SupportedSavingsPlansType savingsPlansType);

        /**
         * <p>
         * The savings plan recommendation term used to generated these recommendations.
         * </p>
         * 
         * @param termInYears
         *        The savings plan recommendation term used to generated these recommendations.
         * @see TermInYears
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TermInYears
         */
        Builder termInYears(String termInYears);

        /**
         * <p>
         * The savings plan recommendation term used to generated these recommendations.
         * </p>
         * 
         * @param termInYears
         *        The savings plan recommendation term used to generated these recommendations.
         * @see TermInYears
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TermInYears
         */
        Builder termInYears(TermInYears termInYears);

        /**
         * <p>
         * The payment option used to generate these recommendations.
         * </p>
         * 
         * @param paymentOption
         *        The payment option used to generate these recommendations.
         * @see PaymentOption
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PaymentOption
         */
        Builder paymentOption(String paymentOption);

        /**
         * <p>
         * The payment option used to generate these recommendations.
         * </p>
         * 
         * @param paymentOption
         *        The payment option used to generate these recommendations.
         * @see PaymentOption
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PaymentOption
         */
        Builder paymentOption(PaymentOption paymentOption);

        /**
         * <p>
         * The token to retrieve the next set of results. Amazon Web Services provides the token when the response from
         * a previous call has more results than the maximum page size.
         * </p>
         * 
         * @param nextPageToken
         *        The token to retrieve the next set of results. Amazon Web Services provides the token when the
         *        response from a previous call has more results than the maximum page size.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextPageToken(String nextPageToken);

        /**
         * <p>
         * The number of recommendations that you want returned in a single response object.
         * </p>
         * 
         * @param pageSize
         *        The number of recommendations that you want returned in a single response object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pageSize(Integer pageSize);

        /**
         * <p>
         * The lookback period used to generate the recommendation.
         * </p>
         * 
         * @param lookbackPeriodInDays
         *        The lookback period used to generate the recommendation.
         * @see LookbackPeriodInDays
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LookbackPeriodInDays
         */
        Builder lookbackPeriodInDays(String lookbackPeriodInDays);

        /**
         * <p>
         * The lookback period used to generate the recommendation.
         * </p>
         * 
         * @param lookbackPeriodInDays
         *        The lookback period used to generate the recommendation.
         * @see LookbackPeriodInDays
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LookbackPeriodInDays
         */
        Builder lookbackPeriodInDays(LookbackPeriodInDays lookbackPeriodInDays);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CostExplorerRequest.BuilderImpl implements Builder {
        private String savingsPlansType;

        private String termInYears;

        private String paymentOption;

        private String nextPageToken;

        private Integer pageSize;

        private String lookbackPeriodInDays;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSavingsPlansPurchaseRecommendationRequest model) {
            super(model);
            savingsPlansType(model.savingsPlansType);
            termInYears(model.termInYears);
            paymentOption(model.paymentOption);
            nextPageToken(model.nextPageToken);
            pageSize(model.pageSize);
            lookbackPeriodInDays(model.lookbackPeriodInDays);
        }

        public final String getSavingsPlansTypeAsString() {
            return savingsPlansType;
        }

        @Override
        public final Builder savingsPlansType(String savingsPlansType) {
            this.savingsPlansType = savingsPlansType;
            return this;
        }

        @Override
        public final Builder savingsPlansType(SupportedSavingsPlansType savingsPlansType) {
            this.savingsPlansType(savingsPlansType == null ? null : savingsPlansType.toString());
            return this;
        }

        public final void setSavingsPlansType(String savingsPlansType) {
            this.savingsPlansType = savingsPlansType;
        }

        public final String getTermInYearsAsString() {
            return termInYears;
        }

        @Override
        public final Builder termInYears(String termInYears) {
            this.termInYears = termInYears;
            return this;
        }

        @Override
        public final Builder termInYears(TermInYears termInYears) {
            this.termInYears(termInYears == null ? null : termInYears.toString());
            return this;
        }

        public final void setTermInYears(String termInYears) {
            this.termInYears = termInYears;
        }

        public final String getPaymentOptionAsString() {
            return paymentOption;
        }

        @Override
        public final Builder paymentOption(String paymentOption) {
            this.paymentOption = paymentOption;
            return this;
        }

        @Override
        public final Builder paymentOption(PaymentOption paymentOption) {
            this.paymentOption(paymentOption == null ? null : paymentOption.toString());
            return this;
        }

        public final void setPaymentOption(String paymentOption) {
            this.paymentOption = paymentOption;
        }

        public final String getNextPageToken() {
            return nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        public final Integer getPageSize() {
            return pageSize;
        }

        @Override
        public final Builder pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public final void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }

        public final String getLookbackPeriodInDaysAsString() {
            return lookbackPeriodInDays;
        }

        @Override
        public final Builder lookbackPeriodInDays(String lookbackPeriodInDays) {
            this.lookbackPeriodInDays = lookbackPeriodInDays;
            return this;
        }

        @Override
        public final Builder lookbackPeriodInDays(LookbackPeriodInDays lookbackPeriodInDays) {
            this.lookbackPeriodInDays(lookbackPeriodInDays == null ? null : lookbackPeriodInDays.toString());
            return this;
        }

        public final void setLookbackPeriodInDays(String lookbackPeriodInDays) {
            this.lookbackPeriodInDays = lookbackPeriodInDays;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetSavingsPlansPurchaseRecommendationRequest build() {
            return new GetSavingsPlansPurchaseRecommendationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
