/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costexplorer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Utilization metrics of the instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EC2ResourceUtilization implements SdkPojo, Serializable,
        ToCopyableBuilder<EC2ResourceUtilization.Builder, EC2ResourceUtilization> {
    private static final SdkField<String> MAX_CPU_UTILIZATION_PERCENTAGE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(EC2ResourceUtilization::maxCpuUtilizationPercentage))
            .setter(setter(Builder::maxCpuUtilizationPercentage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxCpuUtilizationPercentage")
                    .build()).build();

    private static final SdkField<String> MAX_MEMORY_UTILIZATION_PERCENTAGE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(EC2ResourceUtilization::maxMemoryUtilizationPercentage))
            .setter(setter(Builder::maxMemoryUtilizationPercentage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxMemoryUtilizationPercentage")
                    .build()).build();

    private static final SdkField<String> MAX_STORAGE_UTILIZATION_PERCENTAGE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(EC2ResourceUtilization::maxStorageUtilizationPercentage))
            .setter(setter(Builder::maxStorageUtilizationPercentage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxStorageUtilizationPercentage")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            MAX_CPU_UTILIZATION_PERCENTAGE_FIELD, MAX_MEMORY_UTILIZATION_PERCENTAGE_FIELD,
            MAX_STORAGE_UTILIZATION_PERCENTAGE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String maxCpuUtilizationPercentage;

    private final String maxMemoryUtilizationPercentage;

    private final String maxStorageUtilizationPercentage;

    private EC2ResourceUtilization(BuilderImpl builder) {
        this.maxCpuUtilizationPercentage = builder.maxCpuUtilizationPercentage;
        this.maxMemoryUtilizationPercentage = builder.maxMemoryUtilizationPercentage;
        this.maxStorageUtilizationPercentage = builder.maxStorageUtilizationPercentage;
    }

    /**
     * <p>
     * Maximum observed or expected CPU utilization of the instance.
     * </p>
     * 
     * @return Maximum observed or expected CPU utilization of the instance.
     */
    public String maxCpuUtilizationPercentage() {
        return maxCpuUtilizationPercentage;
    }

    /**
     * <p>
     * Maximum observed or expected memory utilization of the instance.
     * </p>
     * 
     * @return Maximum observed or expected memory utilization of the instance.
     */
    public String maxMemoryUtilizationPercentage() {
        return maxMemoryUtilizationPercentage;
    }

    /**
     * <p>
     * Maximum observed or expected storage utilization of the instance (does not measure EBS storage).
     * </p>
     * 
     * @return Maximum observed or expected storage utilization of the instance (does not measure EBS storage).
     */
    public String maxStorageUtilizationPercentage() {
        return maxStorageUtilizationPercentage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(maxCpuUtilizationPercentage());
        hashCode = 31 * hashCode + Objects.hashCode(maxMemoryUtilizationPercentage());
        hashCode = 31 * hashCode + Objects.hashCode(maxStorageUtilizationPercentage());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EC2ResourceUtilization)) {
            return false;
        }
        EC2ResourceUtilization other = (EC2ResourceUtilization) obj;
        return Objects.equals(maxCpuUtilizationPercentage(), other.maxCpuUtilizationPercentage())
                && Objects.equals(maxMemoryUtilizationPercentage(), other.maxMemoryUtilizationPercentage())
                && Objects.equals(maxStorageUtilizationPercentage(), other.maxStorageUtilizationPercentage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("EC2ResourceUtilization").add("MaxCpuUtilizationPercentage", maxCpuUtilizationPercentage())
                .add("MaxMemoryUtilizationPercentage", maxMemoryUtilizationPercentage())
                .add("MaxStorageUtilizationPercentage", maxStorageUtilizationPercentage()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MaxCpuUtilizationPercentage":
            return Optional.ofNullable(clazz.cast(maxCpuUtilizationPercentage()));
        case "MaxMemoryUtilizationPercentage":
            return Optional.ofNullable(clazz.cast(maxMemoryUtilizationPercentage()));
        case "MaxStorageUtilizationPercentage":
            return Optional.ofNullable(clazz.cast(maxStorageUtilizationPercentage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EC2ResourceUtilization, T> g) {
        return obj -> g.apply((EC2ResourceUtilization) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EC2ResourceUtilization> {
        /**
         * <p>
         * Maximum observed or expected CPU utilization of the instance.
         * </p>
         * 
         * @param maxCpuUtilizationPercentage
         *        Maximum observed or expected CPU utilization of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxCpuUtilizationPercentage(String maxCpuUtilizationPercentage);

        /**
         * <p>
         * Maximum observed or expected memory utilization of the instance.
         * </p>
         * 
         * @param maxMemoryUtilizationPercentage
         *        Maximum observed or expected memory utilization of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxMemoryUtilizationPercentage(String maxMemoryUtilizationPercentage);

        /**
         * <p>
         * Maximum observed or expected storage utilization of the instance (does not measure EBS storage).
         * </p>
         * 
         * @param maxStorageUtilizationPercentage
         *        Maximum observed or expected storage utilization of the instance (does not measure EBS storage).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxStorageUtilizationPercentage(String maxStorageUtilizationPercentage);
    }

    static final class BuilderImpl implements Builder {
        private String maxCpuUtilizationPercentage;

        private String maxMemoryUtilizationPercentage;

        private String maxStorageUtilizationPercentage;

        private BuilderImpl() {
        }

        private BuilderImpl(EC2ResourceUtilization model) {
            maxCpuUtilizationPercentage(model.maxCpuUtilizationPercentage);
            maxMemoryUtilizationPercentage(model.maxMemoryUtilizationPercentage);
            maxStorageUtilizationPercentage(model.maxStorageUtilizationPercentage);
        }

        public final String getMaxCpuUtilizationPercentage() {
            return maxCpuUtilizationPercentage;
        }

        @Override
        public final Builder maxCpuUtilizationPercentage(String maxCpuUtilizationPercentage) {
            this.maxCpuUtilizationPercentage = maxCpuUtilizationPercentage;
            return this;
        }

        public final void setMaxCpuUtilizationPercentage(String maxCpuUtilizationPercentage) {
            this.maxCpuUtilizationPercentage = maxCpuUtilizationPercentage;
        }

        public final String getMaxMemoryUtilizationPercentage() {
            return maxMemoryUtilizationPercentage;
        }

        @Override
        public final Builder maxMemoryUtilizationPercentage(String maxMemoryUtilizationPercentage) {
            this.maxMemoryUtilizationPercentage = maxMemoryUtilizationPercentage;
            return this;
        }

        public final void setMaxMemoryUtilizationPercentage(String maxMemoryUtilizationPercentage) {
            this.maxMemoryUtilizationPercentage = maxMemoryUtilizationPercentage;
        }

        public final String getMaxStorageUtilizationPercentage() {
            return maxStorageUtilizationPercentage;
        }

        @Override
        public final Builder maxStorageUtilizationPercentage(String maxStorageUtilizationPercentage) {
            this.maxStorageUtilizationPercentage = maxStorageUtilizationPercentage;
            return this;
        }

        public final void setMaxStorageUtilizationPercentage(String maxStorageUtilizationPercentage) {
            this.maxStorageUtilizationPercentage = maxStorageUtilizationPercentage;
        }

        @Override
        public EC2ResourceUtilization build() {
            return new EC2ResourceUtilization(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
