/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costexplorer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details on the Amazon EC2 Resource.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EC2ResourceDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<EC2ResourceDetails.Builder, EC2ResourceDetails> {
    private static final SdkField<String> HOURLY_ON_DEMAND_RATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(EC2ResourceDetails::hourlyOnDemandRate)).setter(setter(Builder::hourlyOnDemandRate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HourlyOnDemandRate").build())
            .build();

    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(EC2ResourceDetails::instanceType)).setter(setter(Builder::instanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType").build()).build();

    private static final SdkField<String> PLATFORM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(EC2ResourceDetails::platform)).setter(setter(Builder::platform))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Platform").build()).build();

    private static final SdkField<String> REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(EC2ResourceDetails::region)).setter(setter(Builder::region))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Region").build()).build();

    private static final SdkField<String> SKU_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(EC2ResourceDetails::sku)).setter(setter(Builder::sku))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sku").build()).build();

    private static final SdkField<String> MEMORY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(EC2ResourceDetails::memory)).setter(setter(Builder::memory))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Memory").build()).build();

    private static final SdkField<String> NETWORK_PERFORMANCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(EC2ResourceDetails::networkPerformance)).setter(setter(Builder::networkPerformance))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkPerformance").build())
            .build();

    private static final SdkField<String> STORAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(EC2ResourceDetails::storage)).setter(setter(Builder::storage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Storage").build()).build();

    private static final SdkField<String> VCPU_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(EC2ResourceDetails::vcpu)).setter(setter(Builder::vcpu))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Vcpu").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HOURLY_ON_DEMAND_RATE_FIELD,
            INSTANCE_TYPE_FIELD, PLATFORM_FIELD, REGION_FIELD, SKU_FIELD, MEMORY_FIELD, NETWORK_PERFORMANCE_FIELD, STORAGE_FIELD,
            VCPU_FIELD));

    private static final long serialVersionUID = 1L;

    private final String hourlyOnDemandRate;

    private final String instanceType;

    private final String platform;

    private final String region;

    private final String sku;

    private final String memory;

    private final String networkPerformance;

    private final String storage;

    private final String vcpu;

    private EC2ResourceDetails(BuilderImpl builder) {
        this.hourlyOnDemandRate = builder.hourlyOnDemandRate;
        this.instanceType = builder.instanceType;
        this.platform = builder.platform;
        this.region = builder.region;
        this.sku = builder.sku;
        this.memory = builder.memory;
        this.networkPerformance = builder.networkPerformance;
        this.storage = builder.storage;
        this.vcpu = builder.vcpu;
    }

    /**
     * <p>
     * Hourly public On Demand rate for the instance type.
     * </p>
     * 
     * @return Hourly public On Demand rate for the instance type.
     */
    public String hourlyOnDemandRate() {
        return hourlyOnDemandRate;
    }

    /**
     * <p>
     * The type of Amazon Web Services instance.
     * </p>
     * 
     * @return The type of Amazon Web Services instance.
     */
    public String instanceType() {
        return instanceType;
    }

    /**
     * <p>
     * The platform of the Amazon Web Services instance. The platform is the specific combination of operating system,
     * license model, and software on an instance.
     * </p>
     * 
     * @return The platform of the Amazon Web Services instance. The platform is the specific combination of operating
     *         system, license model, and software on an instance.
     */
    public String platform() {
        return platform;
    }

    /**
     * <p>
     * The Amazon Web Services Region of the instance.
     * </p>
     * 
     * @return The Amazon Web Services Region of the instance.
     */
    public String region() {
        return region;
    }

    /**
     * <p>
     * The SKU of the product.
     * </p>
     * 
     * @return The SKU of the product.
     */
    public String sku() {
        return sku;
    }

    /**
     * <p>
     * Memory capacity of Amazon Web Services instance.
     * </p>
     * 
     * @return Memory capacity of Amazon Web Services instance.
     */
    public String memory() {
        return memory;
    }

    /**
     * <p>
     * Network performance capacity of the Amazon Web Services instance.
     * </p>
     * 
     * @return Network performance capacity of the Amazon Web Services instance.
     */
    public String networkPerformance() {
        return networkPerformance;
    }

    /**
     * <p>
     * The disk storage of the Amazon Web Services instance (Not EBS storage).
     * </p>
     * 
     * @return The disk storage of the Amazon Web Services instance (Not EBS storage).
     */
    public String storage() {
        return storage;
    }

    /**
     * <p>
     * Number of VCPU cores in the Amazon Web Services instance type.
     * </p>
     * 
     * @return Number of VCPU cores in the Amazon Web Services instance type.
     */
    public String vcpu() {
        return vcpu;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hourlyOnDemandRate());
        hashCode = 31 * hashCode + Objects.hashCode(instanceType());
        hashCode = 31 * hashCode + Objects.hashCode(platform());
        hashCode = 31 * hashCode + Objects.hashCode(region());
        hashCode = 31 * hashCode + Objects.hashCode(sku());
        hashCode = 31 * hashCode + Objects.hashCode(memory());
        hashCode = 31 * hashCode + Objects.hashCode(networkPerformance());
        hashCode = 31 * hashCode + Objects.hashCode(storage());
        hashCode = 31 * hashCode + Objects.hashCode(vcpu());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EC2ResourceDetails)) {
            return false;
        }
        EC2ResourceDetails other = (EC2ResourceDetails) obj;
        return Objects.equals(hourlyOnDemandRate(), other.hourlyOnDemandRate())
                && Objects.equals(instanceType(), other.instanceType()) && Objects.equals(platform(), other.platform())
                && Objects.equals(region(), other.region()) && Objects.equals(sku(), other.sku())
                && Objects.equals(memory(), other.memory()) && Objects.equals(networkPerformance(), other.networkPerformance())
                && Objects.equals(storage(), other.storage()) && Objects.equals(vcpu(), other.vcpu());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("EC2ResourceDetails").add("HourlyOnDemandRate", hourlyOnDemandRate())
                .add("InstanceType", instanceType()).add("Platform", platform()).add("Region", region()).add("Sku", sku())
                .add("Memory", memory()).add("NetworkPerformance", networkPerformance()).add("Storage", storage())
                .add("Vcpu", vcpu()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HourlyOnDemandRate":
            return Optional.ofNullable(clazz.cast(hourlyOnDemandRate()));
        case "InstanceType":
            return Optional.ofNullable(clazz.cast(instanceType()));
        case "Platform":
            return Optional.ofNullable(clazz.cast(platform()));
        case "Region":
            return Optional.ofNullable(clazz.cast(region()));
        case "Sku":
            return Optional.ofNullable(clazz.cast(sku()));
        case "Memory":
            return Optional.ofNullable(clazz.cast(memory()));
        case "NetworkPerformance":
            return Optional.ofNullable(clazz.cast(networkPerformance()));
        case "Storage":
            return Optional.ofNullable(clazz.cast(storage()));
        case "Vcpu":
            return Optional.ofNullable(clazz.cast(vcpu()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EC2ResourceDetails, T> g) {
        return obj -> g.apply((EC2ResourceDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EC2ResourceDetails> {
        /**
         * <p>
         * Hourly public On Demand rate for the instance type.
         * </p>
         * 
         * @param hourlyOnDemandRate
         *        Hourly public On Demand rate for the instance type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hourlyOnDemandRate(String hourlyOnDemandRate);

        /**
         * <p>
         * The type of Amazon Web Services instance.
         * </p>
         * 
         * @param instanceType
         *        The type of Amazon Web Services instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceType(String instanceType);

        /**
         * <p>
         * The platform of the Amazon Web Services instance. The platform is the specific combination of operating
         * system, license model, and software on an instance.
         * </p>
         * 
         * @param platform
         *        The platform of the Amazon Web Services instance. The platform is the specific combination of
         *        operating system, license model, and software on an instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder platform(String platform);

        /**
         * <p>
         * The Amazon Web Services Region of the instance.
         * </p>
         * 
         * @param region
         *        The Amazon Web Services Region of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder region(String region);

        /**
         * <p>
         * The SKU of the product.
         * </p>
         * 
         * @param sku
         *        The SKU of the product.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sku(String sku);

        /**
         * <p>
         * Memory capacity of Amazon Web Services instance.
         * </p>
         * 
         * @param memory
         *        Memory capacity of Amazon Web Services instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memory(String memory);

        /**
         * <p>
         * Network performance capacity of the Amazon Web Services instance.
         * </p>
         * 
         * @param networkPerformance
         *        Network performance capacity of the Amazon Web Services instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkPerformance(String networkPerformance);

        /**
         * <p>
         * The disk storage of the Amazon Web Services instance (Not EBS storage).
         * </p>
         * 
         * @param storage
         *        The disk storage of the Amazon Web Services instance (Not EBS storage).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storage(String storage);

        /**
         * <p>
         * Number of VCPU cores in the Amazon Web Services instance type.
         * </p>
         * 
         * @param vcpu
         *        Number of VCPU cores in the Amazon Web Services instance type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vcpu(String vcpu);
    }

    static final class BuilderImpl implements Builder {
        private String hourlyOnDemandRate;

        private String instanceType;

        private String platform;

        private String region;

        private String sku;

        private String memory;

        private String networkPerformance;

        private String storage;

        private String vcpu;

        private BuilderImpl() {
        }

        private BuilderImpl(EC2ResourceDetails model) {
            hourlyOnDemandRate(model.hourlyOnDemandRate);
            instanceType(model.instanceType);
            platform(model.platform);
            region(model.region);
            sku(model.sku);
            memory(model.memory);
            networkPerformance(model.networkPerformance);
            storage(model.storage);
            vcpu(model.vcpu);
        }

        public final String getHourlyOnDemandRate() {
            return hourlyOnDemandRate;
        }

        @Override
        public final Builder hourlyOnDemandRate(String hourlyOnDemandRate) {
            this.hourlyOnDemandRate = hourlyOnDemandRate;
            return this;
        }

        public final void setHourlyOnDemandRate(String hourlyOnDemandRate) {
            this.hourlyOnDemandRate = hourlyOnDemandRate;
        }

        public final String getInstanceType() {
            return instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final String getPlatform() {
            return platform;
        }

        @Override
        public final Builder platform(String platform) {
            this.platform = platform;
            return this;
        }

        public final void setPlatform(String platform) {
            this.platform = platform;
        }

        public final String getRegion() {
            return region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        public final String getSku() {
            return sku;
        }

        @Override
        public final Builder sku(String sku) {
            this.sku = sku;
            return this;
        }

        public final void setSku(String sku) {
            this.sku = sku;
        }

        public final String getMemory() {
            return memory;
        }

        @Override
        public final Builder memory(String memory) {
            this.memory = memory;
            return this;
        }

        public final void setMemory(String memory) {
            this.memory = memory;
        }

        public final String getNetworkPerformance() {
            return networkPerformance;
        }

        @Override
        public final Builder networkPerformance(String networkPerformance) {
            this.networkPerformance = networkPerformance;
            return this;
        }

        public final void setNetworkPerformance(String networkPerformance) {
            this.networkPerformance = networkPerformance;
        }

        public final String getStorage() {
            return storage;
        }

        @Override
        public final Builder storage(String storage) {
            this.storage = storage;
            return this;
        }

        public final void setStorage(String storage) {
            this.storage = storage;
        }

        public final String getVcpu() {
            return vcpu;
        }

        @Override
        public final Builder vcpu(String vcpu) {
            this.vcpu = vcpu;
            return this;
        }

        public final void setVcpu(String vcpu) {
            this.vcpu = vcpu;
        }

        @Override
        public EC2ResourceDetails build() {
            return new EC2ResourceDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
