/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costexplorer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The metadata that you can use to filter and group your results. You can use <code>GetDimensionValues</code> to find
 * specific values.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DimensionValues implements SdkPojo, Serializable, ToCopyableBuilder<DimensionValues.Builder, DimensionValues> {
    private static final SdkField<String> KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DimensionValues::keyAsString)).setter(setter(Builder::key))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Key").build()).build();

    private static final SdkField<List<String>> VALUES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(DimensionValues::values))
            .setter(setter(Builder::values))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Values").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_FIELD, VALUES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String key;

    private final List<String> values;

    private DimensionValues(BuilderImpl builder) {
        this.key = builder.key;
        this.values = builder.values;
    }

    /**
     * <p>
     * The names of the metadata types that you can use to filter and group your results. For example, <code>AZ</code>
     * returns a list of Availability Zones.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #key} will return
     * {@link Dimension#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #keyAsString}.
     * </p>
     * 
     * @return The names of the metadata types that you can use to filter and group your results. For example,
     *         <code>AZ</code> returns a list of Availability Zones.
     * @see Dimension
     */
    public Dimension key() {
        return Dimension.fromValue(key);
    }

    /**
     * <p>
     * The names of the metadata types that you can use to filter and group your results. For example, <code>AZ</code>
     * returns a list of Availability Zones.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #key} will return
     * {@link Dimension#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #keyAsString}.
     * </p>
     * 
     * @return The names of the metadata types that you can use to filter and group your results. For example,
     *         <code>AZ</code> returns a list of Availability Zones.
     * @see Dimension
     */
    public String keyAsString() {
        return key;
    }

    /**
     * Returns true if the Values property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasValues() {
        return values != null && !(values instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The metadata values that you can use to filter and group your results. You can use
     * <code>GetDimensionValues</code> to find specific values.
     * </p>
     * <p>
     * Valid values for the <code>SERVICE</code> dimension are <code>Amazon Elastic Compute Cloud - Compute</code>,
     * <code>Amazon Elasticsearch Service</code>, <code>Amazon ElastiCache</code>, <code>Amazon Redshift</code>, and
     * <code>Amazon Relational Database Service</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasValues()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The metadata values that you can use to filter and group your results. You can use
     *         <code>GetDimensionValues</code> to find specific values.</p>
     *         <p>
     *         Valid values for the <code>SERVICE</code> dimension are
     *         <code>Amazon Elastic Compute Cloud - Compute</code>, <code>Amazon Elasticsearch Service</code>,
     *         <code>Amazon ElastiCache</code>, <code>Amazon Redshift</code>, and
     *         <code>Amazon Relational Database Service</code>.
     */
    public List<String> values() {
        return values;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(keyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(values());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DimensionValues)) {
            return false;
        }
        DimensionValues other = (DimensionValues) obj;
        return Objects.equals(keyAsString(), other.keyAsString()) && Objects.equals(values(), other.values());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DimensionValues").add("Key", keyAsString()).add("Values", values()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Key":
            return Optional.ofNullable(clazz.cast(keyAsString()));
        case "Values":
            return Optional.ofNullable(clazz.cast(values()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DimensionValues, T> g) {
        return obj -> g.apply((DimensionValues) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DimensionValues> {
        /**
         * <p>
         * The names of the metadata types that you can use to filter and group your results. For example,
         * <code>AZ</code> returns a list of Availability Zones.
         * </p>
         * 
         * @param key
         *        The names of the metadata types that you can use to filter and group your results. For example,
         *        <code>AZ</code> returns a list of Availability Zones.
         * @see Dimension
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Dimension
         */
        Builder key(String key);

        /**
         * <p>
         * The names of the metadata types that you can use to filter and group your results. For example,
         * <code>AZ</code> returns a list of Availability Zones.
         * </p>
         * 
         * @param key
         *        The names of the metadata types that you can use to filter and group your results. For example,
         *        <code>AZ</code> returns a list of Availability Zones.
         * @see Dimension
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Dimension
         */
        Builder key(Dimension key);

        /**
         * <p>
         * The metadata values that you can use to filter and group your results. You can use
         * <code>GetDimensionValues</code> to find specific values.
         * </p>
         * <p>
         * Valid values for the <code>SERVICE</code> dimension are <code>Amazon Elastic Compute Cloud - Compute</code>,
         * <code>Amazon Elasticsearch Service</code>, <code>Amazon ElastiCache</code>, <code>Amazon Redshift</code>, and
         * <code>Amazon Relational Database Service</code>.
         * </p>
         * 
         * @param values
         *        The metadata values that you can use to filter and group your results. You can use
         *        <code>GetDimensionValues</code> to find specific values.</p>
         *        <p>
         *        Valid values for the <code>SERVICE</code> dimension are
         *        <code>Amazon Elastic Compute Cloud - Compute</code>, <code>Amazon Elasticsearch Service</code>,
         *        <code>Amazon ElastiCache</code>, <code>Amazon Redshift</code>, and
         *        <code>Amazon Relational Database Service</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder values(Collection<String> values);

        /**
         * <p>
         * The metadata values that you can use to filter and group your results. You can use
         * <code>GetDimensionValues</code> to find specific values.
         * </p>
         * <p>
         * Valid values for the <code>SERVICE</code> dimension are <code>Amazon Elastic Compute Cloud - Compute</code>,
         * <code>Amazon Elasticsearch Service</code>, <code>Amazon ElastiCache</code>, <code>Amazon Redshift</code>, and
         * <code>Amazon Relational Database Service</code>.
         * </p>
         * 
         * @param values
         *        The metadata values that you can use to filter and group your results. You can use
         *        <code>GetDimensionValues</code> to find specific values.</p>
         *        <p>
         *        Valid values for the <code>SERVICE</code> dimension are
         *        <code>Amazon Elastic Compute Cloud - Compute</code>, <code>Amazon Elasticsearch Service</code>,
         *        <code>Amazon ElastiCache</code>, <code>Amazon Redshift</code>, and
         *        <code>Amazon Relational Database Service</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder values(String... values);
    }

    static final class BuilderImpl implements Builder {
        private String key;

        private List<String> values = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DimensionValues model) {
            key(model.key);
            values(model.values);
        }

        public final String getKeyAsString() {
            return key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        @Override
        public final Builder key(Dimension key) {
            this.key(key == null ? null : key.toString());
            return this;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        public final Collection<String> getValues() {
            return values;
        }

        @Override
        public final Builder values(Collection<String> values) {
            this.values = ValuesCopier.copy(values);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder values(String... values) {
            values(Arrays.asList(values));
            return this;
        }

        public final void setValues(Collection<String> values) {
            this.values = ValuesCopier.copy(values);
        }

        @Override
        public DimensionValues build() {
            return new DimensionValues(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
