/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costexplorer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The amount of instance usage, in normalized units. Normalized units enable you to see your EC2 usage for multiple
 * sizes of instances in a uniform way. For example, suppose you run an xlarge instance and a 2xlarge instance. If you
 * run both instances for the same amount of time, the 2xlarge instance uses twice as much of your reservation as the
 * xlarge instance, even though both instances show only one instance-hour. Using normalized units instead of
 * instance-hours, the xlarge instance used 8 normalized units, and the 2xlarge instance used 16 normalized units.
 * </p>
 * <p>
 * For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ri-modifying.html">Modifying
 * Reserved Instances</a> in the <i>Amazon Elastic Compute Cloud User Guide for Linux Instances</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CoverageNormalizedUnits implements SdkPojo, Serializable,
        ToCopyableBuilder<CoverageNormalizedUnits.Builder, CoverageNormalizedUnits> {
    private static final SdkField<String> ON_DEMAND_NORMALIZED_UNITS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CoverageNormalizedUnits::onDemandNormalizedUnits)).setter(setter(Builder::onDemandNormalizedUnits))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OnDemandNormalizedUnits").build())
            .build();

    private static final SdkField<String> RESERVED_NORMALIZED_UNITS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CoverageNormalizedUnits::reservedNormalizedUnits)).setter(setter(Builder::reservedNormalizedUnits))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservedNormalizedUnits").build())
            .build();

    private static final SdkField<String> TOTAL_RUNNING_NORMALIZED_UNITS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(CoverageNormalizedUnits::totalRunningNormalizedUnits))
            .setter(setter(Builder::totalRunningNormalizedUnits))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalRunningNormalizedUnits")
                    .build()).build();

    private static final SdkField<String> COVERAGE_NORMALIZED_UNITS_PERCENTAGE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(CoverageNormalizedUnits::coverageNormalizedUnitsPercentage))
            .setter(setter(Builder::coverageNormalizedUnitsPercentage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CoverageNormalizedUnitsPercentage")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ON_DEMAND_NORMALIZED_UNITS_FIELD, RESERVED_NORMALIZED_UNITS_FIELD, TOTAL_RUNNING_NORMALIZED_UNITS_FIELD,
            COVERAGE_NORMALIZED_UNITS_PERCENTAGE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String onDemandNormalizedUnits;

    private final String reservedNormalizedUnits;

    private final String totalRunningNormalizedUnits;

    private final String coverageNormalizedUnitsPercentage;

    private CoverageNormalizedUnits(BuilderImpl builder) {
        this.onDemandNormalizedUnits = builder.onDemandNormalizedUnits;
        this.reservedNormalizedUnits = builder.reservedNormalizedUnits;
        this.totalRunningNormalizedUnits = builder.totalRunningNormalizedUnits;
        this.coverageNormalizedUnitsPercentage = builder.coverageNormalizedUnitsPercentage;
    }

    /**
     * <p>
     * The number of normalized units that are covered by On-Demand Instances instead of a reservation.
     * </p>
     * 
     * @return The number of normalized units that are covered by On-Demand Instances instead of a reservation.
     */
    public String onDemandNormalizedUnits() {
        return onDemandNormalizedUnits;
    }

    /**
     * <p>
     * The number of normalized units that a reservation covers.
     * </p>
     * 
     * @return The number of normalized units that a reservation covers.
     */
    public String reservedNormalizedUnits() {
        return reservedNormalizedUnits;
    }

    /**
     * <p>
     * The total number of normalized units that you used.
     * </p>
     * 
     * @return The total number of normalized units that you used.
     */
    public String totalRunningNormalizedUnits() {
        return totalRunningNormalizedUnits;
    }

    /**
     * <p>
     * The percentage of your used instance normalized units that a reservation covers.
     * </p>
     * 
     * @return The percentage of your used instance normalized units that a reservation covers.
     */
    public String coverageNormalizedUnitsPercentage() {
        return coverageNormalizedUnitsPercentage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(onDemandNormalizedUnits());
        hashCode = 31 * hashCode + Objects.hashCode(reservedNormalizedUnits());
        hashCode = 31 * hashCode + Objects.hashCode(totalRunningNormalizedUnits());
        hashCode = 31 * hashCode + Objects.hashCode(coverageNormalizedUnitsPercentage());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CoverageNormalizedUnits)) {
            return false;
        }
        CoverageNormalizedUnits other = (CoverageNormalizedUnits) obj;
        return Objects.equals(onDemandNormalizedUnits(), other.onDemandNormalizedUnits())
                && Objects.equals(reservedNormalizedUnits(), other.reservedNormalizedUnits())
                && Objects.equals(totalRunningNormalizedUnits(), other.totalRunningNormalizedUnits())
                && Objects.equals(coverageNormalizedUnitsPercentage(), other.coverageNormalizedUnitsPercentage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CoverageNormalizedUnits").add("OnDemandNormalizedUnits", onDemandNormalizedUnits())
                .add("ReservedNormalizedUnits", reservedNormalizedUnits())
                .add("TotalRunningNormalizedUnits", totalRunningNormalizedUnits())
                .add("CoverageNormalizedUnitsPercentage", coverageNormalizedUnitsPercentage()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OnDemandNormalizedUnits":
            return Optional.ofNullable(clazz.cast(onDemandNormalizedUnits()));
        case "ReservedNormalizedUnits":
            return Optional.ofNullable(clazz.cast(reservedNormalizedUnits()));
        case "TotalRunningNormalizedUnits":
            return Optional.ofNullable(clazz.cast(totalRunningNormalizedUnits()));
        case "CoverageNormalizedUnitsPercentage":
            return Optional.ofNullable(clazz.cast(coverageNormalizedUnitsPercentage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CoverageNormalizedUnits, T> g) {
        return obj -> g.apply((CoverageNormalizedUnits) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CoverageNormalizedUnits> {
        /**
         * <p>
         * The number of normalized units that are covered by On-Demand Instances instead of a reservation.
         * </p>
         * 
         * @param onDemandNormalizedUnits
         *        The number of normalized units that are covered by On-Demand Instances instead of a reservation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder onDemandNormalizedUnits(String onDemandNormalizedUnits);

        /**
         * <p>
         * The number of normalized units that a reservation covers.
         * </p>
         * 
         * @param reservedNormalizedUnits
         *        The number of normalized units that a reservation covers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservedNormalizedUnits(String reservedNormalizedUnits);

        /**
         * <p>
         * The total number of normalized units that you used.
         * </p>
         * 
         * @param totalRunningNormalizedUnits
         *        The total number of normalized units that you used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalRunningNormalizedUnits(String totalRunningNormalizedUnits);

        /**
         * <p>
         * The percentage of your used instance normalized units that a reservation covers.
         * </p>
         * 
         * @param coverageNormalizedUnitsPercentage
         *        The percentage of your used instance normalized units that a reservation covers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder coverageNormalizedUnitsPercentage(String coverageNormalizedUnitsPercentage);
    }

    static final class BuilderImpl implements Builder {
        private String onDemandNormalizedUnits;

        private String reservedNormalizedUnits;

        private String totalRunningNormalizedUnits;

        private String coverageNormalizedUnitsPercentage;

        private BuilderImpl() {
        }

        private BuilderImpl(CoverageNormalizedUnits model) {
            onDemandNormalizedUnits(model.onDemandNormalizedUnits);
            reservedNormalizedUnits(model.reservedNormalizedUnits);
            totalRunningNormalizedUnits(model.totalRunningNormalizedUnits);
            coverageNormalizedUnitsPercentage(model.coverageNormalizedUnitsPercentage);
        }

        public final String getOnDemandNormalizedUnits() {
            return onDemandNormalizedUnits;
        }

        @Override
        public final Builder onDemandNormalizedUnits(String onDemandNormalizedUnits) {
            this.onDemandNormalizedUnits = onDemandNormalizedUnits;
            return this;
        }

        public final void setOnDemandNormalizedUnits(String onDemandNormalizedUnits) {
            this.onDemandNormalizedUnits = onDemandNormalizedUnits;
        }

        public final String getReservedNormalizedUnits() {
            return reservedNormalizedUnits;
        }

        @Override
        public final Builder reservedNormalizedUnits(String reservedNormalizedUnits) {
            this.reservedNormalizedUnits = reservedNormalizedUnits;
            return this;
        }

        public final void setReservedNormalizedUnits(String reservedNormalizedUnits) {
            this.reservedNormalizedUnits = reservedNormalizedUnits;
        }

        public final String getTotalRunningNormalizedUnits() {
            return totalRunningNormalizedUnits;
        }

        @Override
        public final Builder totalRunningNormalizedUnits(String totalRunningNormalizedUnits) {
            this.totalRunningNormalizedUnits = totalRunningNormalizedUnits;
            return this;
        }

        public final void setTotalRunningNormalizedUnits(String totalRunningNormalizedUnits) {
            this.totalRunningNormalizedUnits = totalRunningNormalizedUnits;
        }

        public final String getCoverageNormalizedUnitsPercentage() {
            return coverageNormalizedUnitsPercentage;
        }

        @Override
        public final Builder coverageNormalizedUnitsPercentage(String coverageNormalizedUnitsPercentage) {
            this.coverageNormalizedUnitsPercentage = coverageNormalizedUnitsPercentage;
            return this;
        }

        public final void setCoverageNormalizedUnitsPercentage(String coverageNormalizedUnitsPercentage) {
            this.coverageNormalizedUnitsPercentage = coverageNormalizedUnitsPercentage;
        }

        @Override
        public CoverageNormalizedUnits build() {
            return new CoverageNormalizedUnits(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
