/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costexplorer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * How long a running instance either used a reservation or was On-Demand.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CoverageHours implements SdkPojo, Serializable, ToCopyableBuilder<CoverageHours.Builder, CoverageHours> {
    private static final SdkField<String> ON_DEMAND_HOURS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CoverageHours::onDemandHours)).setter(setter(Builder::onDemandHours))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OnDemandHours").build()).build();

    private static final SdkField<String> RESERVED_HOURS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CoverageHours::reservedHours)).setter(setter(Builder::reservedHours))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservedHours").build()).build();

    private static final SdkField<String> TOTAL_RUNNING_HOURS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CoverageHours::totalRunningHours)).setter(setter(Builder::totalRunningHours))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalRunningHours").build()).build();

    private static final SdkField<String> COVERAGE_HOURS_PERCENTAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CoverageHours::coverageHoursPercentage)).setter(setter(Builder::coverageHoursPercentage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CoverageHoursPercentage").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ON_DEMAND_HOURS_FIELD,
            RESERVED_HOURS_FIELD, TOTAL_RUNNING_HOURS_FIELD, COVERAGE_HOURS_PERCENTAGE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String onDemandHours;

    private final String reservedHours;

    private final String totalRunningHours;

    private final String coverageHoursPercentage;

    private CoverageHours(BuilderImpl builder) {
        this.onDemandHours = builder.onDemandHours;
        this.reservedHours = builder.reservedHours;
        this.totalRunningHours = builder.totalRunningHours;
        this.coverageHoursPercentage = builder.coverageHoursPercentage;
    }

    /**
     * <p>
     * The number of instance running hours that On-Demand Instances covered.
     * </p>
     * 
     * @return The number of instance running hours that On-Demand Instances covered.
     */
    public String onDemandHours() {
        return onDemandHours;
    }

    /**
     * <p>
     * The number of instance running hours that reservations covered.
     * </p>
     * 
     * @return The number of instance running hours that reservations covered.
     */
    public String reservedHours() {
        return reservedHours;
    }

    /**
     * <p>
     * The total instance usage, in hours.
     * </p>
     * 
     * @return The total instance usage, in hours.
     */
    public String totalRunningHours() {
        return totalRunningHours;
    }

    /**
     * <p>
     * The percentage of instance hours that a reservation covered.
     * </p>
     * 
     * @return The percentage of instance hours that a reservation covered.
     */
    public String coverageHoursPercentage() {
        return coverageHoursPercentage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(onDemandHours());
        hashCode = 31 * hashCode + Objects.hashCode(reservedHours());
        hashCode = 31 * hashCode + Objects.hashCode(totalRunningHours());
        hashCode = 31 * hashCode + Objects.hashCode(coverageHoursPercentage());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CoverageHours)) {
            return false;
        }
        CoverageHours other = (CoverageHours) obj;
        return Objects.equals(onDemandHours(), other.onDemandHours()) && Objects.equals(reservedHours(), other.reservedHours())
                && Objects.equals(totalRunningHours(), other.totalRunningHours())
                && Objects.equals(coverageHoursPercentage(), other.coverageHoursPercentage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CoverageHours").add("OnDemandHours", onDemandHours()).add("ReservedHours", reservedHours())
                .add("TotalRunningHours", totalRunningHours()).add("CoverageHoursPercentage", coverageHoursPercentage()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OnDemandHours":
            return Optional.ofNullable(clazz.cast(onDemandHours()));
        case "ReservedHours":
            return Optional.ofNullable(clazz.cast(reservedHours()));
        case "TotalRunningHours":
            return Optional.ofNullable(clazz.cast(totalRunningHours()));
        case "CoverageHoursPercentage":
            return Optional.ofNullable(clazz.cast(coverageHoursPercentage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CoverageHours, T> g) {
        return obj -> g.apply((CoverageHours) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CoverageHours> {
        /**
         * <p>
         * The number of instance running hours that On-Demand Instances covered.
         * </p>
         * 
         * @param onDemandHours
         *        The number of instance running hours that On-Demand Instances covered.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder onDemandHours(String onDemandHours);

        /**
         * <p>
         * The number of instance running hours that reservations covered.
         * </p>
         * 
         * @param reservedHours
         *        The number of instance running hours that reservations covered.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservedHours(String reservedHours);

        /**
         * <p>
         * The total instance usage, in hours.
         * </p>
         * 
         * @param totalRunningHours
         *        The total instance usage, in hours.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalRunningHours(String totalRunningHours);

        /**
         * <p>
         * The percentage of instance hours that a reservation covered.
         * </p>
         * 
         * @param coverageHoursPercentage
         *        The percentage of instance hours that a reservation covered.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder coverageHoursPercentage(String coverageHoursPercentage);
    }

    static final class BuilderImpl implements Builder {
        private String onDemandHours;

        private String reservedHours;

        private String totalRunningHours;

        private String coverageHoursPercentage;

        private BuilderImpl() {
        }

        private BuilderImpl(CoverageHours model) {
            onDemandHours(model.onDemandHours);
            reservedHours(model.reservedHours);
            totalRunningHours(model.totalRunningHours);
            coverageHoursPercentage(model.coverageHoursPercentage);
        }

        public final String getOnDemandHours() {
            return onDemandHours;
        }

        @Override
        public final Builder onDemandHours(String onDemandHours) {
            this.onDemandHours = onDemandHours;
            return this;
        }

        public final void setOnDemandHours(String onDemandHours) {
            this.onDemandHours = onDemandHours;
        }

        public final String getReservedHours() {
            return reservedHours;
        }

        @Override
        public final Builder reservedHours(String reservedHours) {
            this.reservedHours = reservedHours;
            return this;
        }

        public final void setReservedHours(String reservedHours) {
            this.reservedHours = reservedHours;
        }

        public final String getTotalRunningHours() {
            return totalRunningHours;
        }

        @Override
        public final Builder totalRunningHours(String totalRunningHours) {
            this.totalRunningHours = totalRunningHours;
            return this;
        }

        public final void setTotalRunningHours(String totalRunningHours) {
            this.totalRunningHours = totalRunningHours;
        }

        public final String getCoverageHoursPercentage() {
            return coverageHoursPercentage;
        }

        @Override
        public final Builder coverageHoursPercentage(String coverageHoursPercentage) {
            this.coverageHoursPercentage = coverageHoursPercentage;
            return this;
        }

        public final void setCoverageHoursPercentage(String coverageHoursPercentage) {
            this.coverageHoursPercentage = coverageHoursPercentage;
        }

        @Override
        public CoverageHours build() {
            return new CoverageHours(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
