/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costexplorer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The amount of instance usage that a reservation covered.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Coverage implements SdkPojo, Serializable, ToCopyableBuilder<Coverage.Builder, Coverage> {
    private static final SdkField<CoverageHours> COVERAGE_HOURS_FIELD = SdkField
            .<CoverageHours> builder(MarshallingType.SDK_POJO).getter(getter(Coverage::coverageHours))
            .setter(setter(Builder::coverageHours)).constructor(CoverageHours::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CoverageHours").build()).build();

    private static final SdkField<CoverageNormalizedUnits> COVERAGE_NORMALIZED_UNITS_FIELD = SdkField
            .<CoverageNormalizedUnits> builder(MarshallingType.SDK_POJO).getter(getter(Coverage::coverageNormalizedUnits))
            .setter(setter(Builder::coverageNormalizedUnits)).constructor(CoverageNormalizedUnits::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CoverageNormalizedUnits").build())
            .build();

    private static final SdkField<CoverageCost> COVERAGE_COST_FIELD = SdkField.<CoverageCost> builder(MarshallingType.SDK_POJO)
            .getter(getter(Coverage::coverageCost)).setter(setter(Builder::coverageCost)).constructor(CoverageCost::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CoverageCost").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COVERAGE_HOURS_FIELD,
            COVERAGE_NORMALIZED_UNITS_FIELD, COVERAGE_COST_FIELD));

    private static final long serialVersionUID = 1L;

    private final CoverageHours coverageHours;

    private final CoverageNormalizedUnits coverageNormalizedUnits;

    private final CoverageCost coverageCost;

    private Coverage(BuilderImpl builder) {
        this.coverageHours = builder.coverageHours;
        this.coverageNormalizedUnits = builder.coverageNormalizedUnits;
        this.coverageCost = builder.coverageCost;
    }

    /**
     * <p>
     * The amount of instance usage that the reservation covered, in hours.
     * </p>
     * 
     * @return The amount of instance usage that the reservation covered, in hours.
     */
    public CoverageHours coverageHours() {
        return coverageHours;
    }

    /**
     * <p>
     * The amount of instance usage that the reservation covered, in normalized units.
     * </p>
     * 
     * @return The amount of instance usage that the reservation covered, in normalized units.
     */
    public CoverageNormalizedUnits coverageNormalizedUnits() {
        return coverageNormalizedUnits;
    }

    /**
     * <p>
     * The amount of cost that the reservation covered.
     * </p>
     * 
     * @return The amount of cost that the reservation covered.
     */
    public CoverageCost coverageCost() {
        return coverageCost;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(coverageHours());
        hashCode = 31 * hashCode + Objects.hashCode(coverageNormalizedUnits());
        hashCode = 31 * hashCode + Objects.hashCode(coverageCost());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Coverage)) {
            return false;
        }
        Coverage other = (Coverage) obj;
        return Objects.equals(coverageHours(), other.coverageHours())
                && Objects.equals(coverageNormalizedUnits(), other.coverageNormalizedUnits())
                && Objects.equals(coverageCost(), other.coverageCost());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Coverage").add("CoverageHours", coverageHours())
                .add("CoverageNormalizedUnits", coverageNormalizedUnits()).add("CoverageCost", coverageCost()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CoverageHours":
            return Optional.ofNullable(clazz.cast(coverageHours()));
        case "CoverageNormalizedUnits":
            return Optional.ofNullable(clazz.cast(coverageNormalizedUnits()));
        case "CoverageCost":
            return Optional.ofNullable(clazz.cast(coverageCost()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Coverage, T> g) {
        return obj -> g.apply((Coverage) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Coverage> {
        /**
         * <p>
         * The amount of instance usage that the reservation covered, in hours.
         * </p>
         * 
         * @param coverageHours
         *        The amount of instance usage that the reservation covered, in hours.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder coverageHours(CoverageHours coverageHours);

        /**
         * <p>
         * The amount of instance usage that the reservation covered, in hours.
         * </p>
         * This is a convenience that creates an instance of the {@link CoverageHours.Builder} avoiding the need to
         * create one manually via {@link CoverageHours#builder()}.
         *
         * When the {@link Consumer} completes, {@link CoverageHours.Builder#build()} is called immediately and its
         * result is passed to {@link #coverageHours(CoverageHours)}.
         * 
         * @param coverageHours
         *        a consumer that will call methods on {@link CoverageHours.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #coverageHours(CoverageHours)
         */
        default Builder coverageHours(Consumer<CoverageHours.Builder> coverageHours) {
            return coverageHours(CoverageHours.builder().applyMutation(coverageHours).build());
        }

        /**
         * <p>
         * The amount of instance usage that the reservation covered, in normalized units.
         * </p>
         * 
         * @param coverageNormalizedUnits
         *        The amount of instance usage that the reservation covered, in normalized units.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder coverageNormalizedUnits(CoverageNormalizedUnits coverageNormalizedUnits);

        /**
         * <p>
         * The amount of instance usage that the reservation covered, in normalized units.
         * </p>
         * This is a convenience that creates an instance of the {@link CoverageNormalizedUnits.Builder} avoiding the
         * need to create one manually via {@link CoverageNormalizedUnits#builder()}.
         *
         * When the {@link Consumer} completes, {@link CoverageNormalizedUnits.Builder#build()} is called immediately
         * and its result is passed to {@link #coverageNormalizedUnits(CoverageNormalizedUnits)}.
         * 
         * @param coverageNormalizedUnits
         *        a consumer that will call methods on {@link CoverageNormalizedUnits.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #coverageNormalizedUnits(CoverageNormalizedUnits)
         */
        default Builder coverageNormalizedUnits(Consumer<CoverageNormalizedUnits.Builder> coverageNormalizedUnits) {
            return coverageNormalizedUnits(CoverageNormalizedUnits.builder().applyMutation(coverageNormalizedUnits).build());
        }

        /**
         * <p>
         * The amount of cost that the reservation covered.
         * </p>
         * 
         * @param coverageCost
         *        The amount of cost that the reservation covered.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder coverageCost(CoverageCost coverageCost);

        /**
         * <p>
         * The amount of cost that the reservation covered.
         * </p>
         * This is a convenience that creates an instance of the {@link CoverageCost.Builder} avoiding the need to
         * create one manually via {@link CoverageCost#builder()}.
         *
         * When the {@link Consumer} completes, {@link CoverageCost.Builder#build()} is called immediately and its
         * result is passed to {@link #coverageCost(CoverageCost)}.
         * 
         * @param coverageCost
         *        a consumer that will call methods on {@link CoverageCost.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #coverageCost(CoverageCost)
         */
        default Builder coverageCost(Consumer<CoverageCost.Builder> coverageCost) {
            return coverageCost(CoverageCost.builder().applyMutation(coverageCost).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private CoverageHours coverageHours;

        private CoverageNormalizedUnits coverageNormalizedUnits;

        private CoverageCost coverageCost;

        private BuilderImpl() {
        }

        private BuilderImpl(Coverage model) {
            coverageHours(model.coverageHours);
            coverageNormalizedUnits(model.coverageNormalizedUnits);
            coverageCost(model.coverageCost);
        }

        public final CoverageHours.Builder getCoverageHours() {
            return coverageHours != null ? coverageHours.toBuilder() : null;
        }

        @Override
        public final Builder coverageHours(CoverageHours coverageHours) {
            this.coverageHours = coverageHours;
            return this;
        }

        public final void setCoverageHours(CoverageHours.BuilderImpl coverageHours) {
            this.coverageHours = coverageHours != null ? coverageHours.build() : null;
        }

        public final CoverageNormalizedUnits.Builder getCoverageNormalizedUnits() {
            return coverageNormalizedUnits != null ? coverageNormalizedUnits.toBuilder() : null;
        }

        @Override
        public final Builder coverageNormalizedUnits(CoverageNormalizedUnits coverageNormalizedUnits) {
            this.coverageNormalizedUnits = coverageNormalizedUnits;
            return this;
        }

        public final void setCoverageNormalizedUnits(CoverageNormalizedUnits.BuilderImpl coverageNormalizedUnits) {
            this.coverageNormalizedUnits = coverageNormalizedUnits != null ? coverageNormalizedUnits.build() : null;
        }

        public final CoverageCost.Builder getCoverageCost() {
            return coverageCost != null ? coverageCost.toBuilder() : null;
        }

        @Override
        public final Builder coverageCost(CoverageCost coverageCost) {
            this.coverageCost = coverageCost;
            return this;
        }

        public final void setCoverageCost(CoverageCost.BuilderImpl coverageCost) {
            this.coverageCost = coverageCost != null ? coverageCost.build() : null;
        }

        @Override
        public Coverage build() {
            return new Coverage(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
